# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProjectEnvironmentTypeResult',
    'AwaitableGetProjectEnvironmentTypeResult',
    'get_project_environment_type',
    'get_project_environment_type_output',
]

@pulumi.output_type
class GetProjectEnvironmentTypeResult:
    """
    A collection of values returned by getProjectEnvironmentType.
    """
    def __init__(__self__, creator_role_assignment_roles=None, deployment_target_id=None, dev_center_project_id=None, id=None, identities=None, location=None, name=None, tags=None, user_role_assignments=None):
        if creator_role_assignment_roles and not isinstance(creator_role_assignment_roles, list):
            raise TypeError("Expected argument 'creator_role_assignment_roles' to be a list")
        pulumi.set(__self__, "creator_role_assignment_roles", creator_role_assignment_roles)
        if deployment_target_id and not isinstance(deployment_target_id, str):
            raise TypeError("Expected argument 'deployment_target_id' to be a str")
        pulumi.set(__self__, "deployment_target_id", deployment_target_id)
        if dev_center_project_id and not isinstance(dev_center_project_id, str):
            raise TypeError("Expected argument 'dev_center_project_id' to be a str")
        pulumi.set(__self__, "dev_center_project_id", dev_center_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if user_role_assignments and not isinstance(user_role_assignments, list):
            raise TypeError("Expected argument 'user_role_assignments' to be a list")
        pulumi.set(__self__, "user_role_assignments", user_role_assignments)

    @_builtins.property
    @pulumi.getter(name="creatorRoleAssignmentRoles")
    def creator_role_assignment_roles(self) -> Sequence[_builtins.str]:
        """
        A list of roles assigned to the environment creator.
        """
        return pulumi.get(self, "creator_role_assignment_roles")

    @_builtins.property
    @pulumi.getter(name="deploymentTargetId")
    def deployment_target_id(self) -> _builtins.str:
        """
        The ID of the subscription that the Environment Type is mapped to.
        """
        return pulumi.get(self, "deployment_target_id")

    @_builtins.property
    @pulumi.getter(name="devCenterProjectId")
    def dev_center_project_id(self) -> _builtins.str:
        return pulumi.get(self, "dev_center_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetProjectEnvironmentTypeIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Dev Center Project Environment Type exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Dev Center Project Environment Type.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userRoleAssignments")
    def user_role_assignments(self) -> Sequence['outputs.GetProjectEnvironmentTypeUserRoleAssignmentResult']:
        """
        A `user_role_assignment` block as defined below.
        """
        return pulumi.get(self, "user_role_assignments")


class AwaitableGetProjectEnvironmentTypeResult(GetProjectEnvironmentTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectEnvironmentTypeResult(
            creator_role_assignment_roles=self.creator_role_assignment_roles,
            deployment_target_id=self.deployment_target_id,
            dev_center_project_id=self.dev_center_project_id,
            id=self.id,
            identities=self.identities,
            location=self.location,
            name=self.name,
            tags=self.tags,
            user_role_assignments=self.user_role_assignments)


def get_project_environment_type(dev_center_project_id: Optional[_builtins.str] = None,
                                 name: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectEnvironmentTypeResult:
    """
    Use this data source to access information about an existing Dev Center Project Environment Type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_project_environment_type(name=example_azurerm_dev_center_project_environment_type["name"],
        dev_center_project_id=example_azurerm_dev_center_project_environment_type["devCenterProjectId"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter`: 2025-02-01


    :param _builtins.str dev_center_project_id: The ID of the associated Dev Center Project.
    :param _builtins.str name: The name of this Dev Center Project Environment Type.
    """
    __args__ = dict()
    __args__['devCenterProjectId'] = dev_center_project_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:devcenter/getProjectEnvironmentType:getProjectEnvironmentType', __args__, opts=opts, typ=GetProjectEnvironmentTypeResult).value

    return AwaitableGetProjectEnvironmentTypeResult(
        creator_role_assignment_roles=pulumi.get(__ret__, 'creator_role_assignment_roles'),
        deployment_target_id=pulumi.get(__ret__, 'deployment_target_id'),
        dev_center_project_id=pulumi.get(__ret__, 'dev_center_project_id'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'),
        user_role_assignments=pulumi.get(__ret__, 'user_role_assignments'))
def get_project_environment_type_output(dev_center_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        name: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectEnvironmentTypeResult]:
    """
    Use this data source to access information about an existing Dev Center Project Environment Type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_project_environment_type(name=example_azurerm_dev_center_project_environment_type["name"],
        dev_center_project_id=example_azurerm_dev_center_project_environment_type["devCenterProjectId"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter`: 2025-02-01


    :param _builtins.str dev_center_project_id: The ID of the associated Dev Center Project.
    :param _builtins.str name: The name of this Dev Center Project Environment Type.
    """
    __args__ = dict()
    __args__['devCenterProjectId'] = dev_center_project_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:devcenter/getProjectEnvironmentType:getProjectEnvironmentType', __args__, opts=opts, typ=GetProjectEnvironmentTypeResult)
    return __ret__.apply(lambda __response__: GetProjectEnvironmentTypeResult(
        creator_role_assignment_roles=pulumi.get(__response__, 'creator_role_assignment_roles'),
        deployment_target_id=pulumi.get(__response__, 'deployment_target_id'),
        dev_center_project_id=pulumi.get(__response__, 'dev_center_project_id'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags'),
        user_role_assignments=pulumi.get(__response__, 'user_role_assignments')))
