# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectEnvironmentTypeArgs', 'ProjectEnvironmentType']

@pulumi.input_type
class ProjectEnvironmentTypeArgs:
    def __init__(__self__, *,
                 deployment_target_id: pulumi.Input[_builtins.str],
                 dev_center_project_id: pulumi.Input[_builtins.str],
                 identity: pulumi.Input['ProjectEnvironmentTypeIdentityArgs'],
                 creator_role_assignment_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_role_assignments: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentTypeUserRoleAssignmentArgs']]]] = None):
        """
        The set of arguments for constructing a ProjectEnvironmentType resource.
        :param pulumi.Input[_builtins.str] deployment_target_id: The ID of the subscription that the Environment Type will be mapped to. The environment's resources will be deployed into this subscription.
        :param pulumi.Input[_builtins.str] dev_center_project_id: The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        :param pulumi.Input['ProjectEnvironmentTypeIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creator_role_assignment_roles: A list of roles to assign to the environment creator.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project Environment Type should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project Environment Type. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project Environment Type.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentTypeUserRoleAssignmentArgs']]] user_role_assignments: A `user_role_assignment` block as defined below.
        """
        pulumi.set(__self__, "deployment_target_id", deployment_target_id)
        pulumi.set(__self__, "dev_center_project_id", dev_center_project_id)
        pulumi.set(__self__, "identity", identity)
        if creator_role_assignment_roles is not None:
            pulumi.set(__self__, "creator_role_assignment_roles", creator_role_assignment_roles)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_role_assignments is not None:
            pulumi.set(__self__, "user_role_assignments", user_role_assignments)

    @_builtins.property
    @pulumi.getter(name="deploymentTargetId")
    def deployment_target_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the subscription that the Environment Type will be mapped to. The environment's resources will be deployed into this subscription.
        """
        return pulumi.get(self, "deployment_target_id")

    @deployment_target_id.setter
    def deployment_target_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "deployment_target_id", value)

    @_builtins.property
    @pulumi.getter(name="devCenterProjectId")
    def dev_center_project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dev_center_project_id")

    @dev_center_project_id.setter
    def dev_center_project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dev_center_project_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input['ProjectEnvironmentTypeIdentityArgs']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['ProjectEnvironmentTypeIdentityArgs']):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="creatorRoleAssignmentRoles")
    def creator_role_assignment_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of roles to assign to the environment creator.
        """
        return pulumi.get(self, "creator_role_assignment_roles")

    @creator_role_assignment_roles.setter
    def creator_role_assignment_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "creator_role_assignment_roles", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center Project Environment Type should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Project Environment Type. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Project Environment Type.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userRoleAssignments")
    def user_role_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentTypeUserRoleAssignmentArgs']]]]:
        """
        A `user_role_assignment` block as defined below.
        """
        return pulumi.get(self, "user_role_assignments")

    @user_role_assignments.setter
    def user_role_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentTypeUserRoleAssignmentArgs']]]]):
        pulumi.set(self, "user_role_assignments", value)


@pulumi.input_type
class _ProjectEnvironmentTypeState:
    def __init__(__self__, *,
                 creator_role_assignment_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deployment_target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ProjectEnvironmentTypeIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_role_assignments: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentTypeUserRoleAssignmentArgs']]]] = None):
        """
        Input properties used for looking up and filtering ProjectEnvironmentType resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creator_role_assignment_roles: A list of roles to assign to the environment creator.
        :param pulumi.Input[_builtins.str] deployment_target_id: The ID of the subscription that the Environment Type will be mapped to. The environment's resources will be deployed into this subscription.
        :param pulumi.Input[_builtins.str] dev_center_project_id: The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        :param pulumi.Input['ProjectEnvironmentTypeIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project Environment Type should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project Environment Type. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project Environment Type.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentTypeUserRoleAssignmentArgs']]] user_role_assignments: A `user_role_assignment` block as defined below.
        """
        if creator_role_assignment_roles is not None:
            pulumi.set(__self__, "creator_role_assignment_roles", creator_role_assignment_roles)
        if deployment_target_id is not None:
            pulumi.set(__self__, "deployment_target_id", deployment_target_id)
        if dev_center_project_id is not None:
            pulumi.set(__self__, "dev_center_project_id", dev_center_project_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_role_assignments is not None:
            pulumi.set(__self__, "user_role_assignments", user_role_assignments)

    @_builtins.property
    @pulumi.getter(name="creatorRoleAssignmentRoles")
    def creator_role_assignment_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of roles to assign to the environment creator.
        """
        return pulumi.get(self, "creator_role_assignment_roles")

    @creator_role_assignment_roles.setter
    def creator_role_assignment_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "creator_role_assignment_roles", value)

    @_builtins.property
    @pulumi.getter(name="deploymentTargetId")
    def deployment_target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the subscription that the Environment Type will be mapped to. The environment's resources will be deployed into this subscription.
        """
        return pulumi.get(self, "deployment_target_id")

    @deployment_target_id.setter
    def deployment_target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_target_id", value)

    @_builtins.property
    @pulumi.getter(name="devCenterProjectId")
    def dev_center_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dev_center_project_id")

    @dev_center_project_id.setter
    def dev_center_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dev_center_project_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ProjectEnvironmentTypeIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ProjectEnvironmentTypeIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center Project Environment Type should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Project Environment Type. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Project Environment Type.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userRoleAssignments")
    def user_role_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentTypeUserRoleAssignmentArgs']]]]:
        """
        A `user_role_assignment` block as defined below.
        """
        return pulumi.get(self, "user_role_assignments")

    @user_role_assignments.setter
    def user_role_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentTypeUserRoleAssignmentArgs']]]]):
        pulumi.set(self, "user_role_assignments", value)


@pulumi.type_token("azure:devcenter/projectEnvironmentType:ProjectEnvironmentType")
class ProjectEnvironmentType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 creator_role_assignment_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deployment_target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ProjectEnvironmentTypeIdentityArgs', 'ProjectEnvironmentTypeIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_role_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectEnvironmentTypeUserRoleAssignmentArgs', 'ProjectEnvironmentTypeUserRoleAssignmentArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Dev Center Project Environment Type.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_dev_center = azure.devcenter.DevCenter("example",
            name="example-dc",
            resource_group_name=example.name,
            location=example.location,
            identity={
                "type": "SystemAssigned",
            })
        example_environment_type = azure.devcenter.EnvironmentType("example",
            name="example-et",
            dev_center_id=example_dev_center.id)
        example_project = azure.devcenter.Project("example",
            name="example-dcp",
            resource_group_name=example.name,
            location=example.location,
            dev_center_id=example_dev_center.id,
            opts = pulumi.ResourceOptions(depends_on=[example_environment_type]))
        example_project_environment_type = azure.devcenter.ProjectEnvironmentType("example",
            name="example-et",
            location=example.location,
            dev_center_project_id=example_project.id,
            deployment_target_id=f"/subscriptions/{current.subscription_id}",
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter`: 2025-02-01

        ## Import

        An existing Dev Center Project Environment Type can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/projectEnvironmentType:ProjectEnvironmentType example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DevCenter/projects/project1/environmentTypes/et1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creator_role_assignment_roles: A list of roles to assign to the environment creator.
        :param pulumi.Input[_builtins.str] deployment_target_id: The ID of the subscription that the Environment Type will be mapped to. The environment's resources will be deployed into this subscription.
        :param pulumi.Input[_builtins.str] dev_center_project_id: The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ProjectEnvironmentTypeIdentityArgs', 'ProjectEnvironmentTypeIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project Environment Type should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project Environment Type. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project Environment Type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectEnvironmentTypeUserRoleAssignmentArgs', 'ProjectEnvironmentTypeUserRoleAssignmentArgsDict']]]] user_role_assignments: A `user_role_assignment` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectEnvironmentTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dev Center Project Environment Type.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_dev_center = azure.devcenter.DevCenter("example",
            name="example-dc",
            resource_group_name=example.name,
            location=example.location,
            identity={
                "type": "SystemAssigned",
            })
        example_environment_type = azure.devcenter.EnvironmentType("example",
            name="example-et",
            dev_center_id=example_dev_center.id)
        example_project = azure.devcenter.Project("example",
            name="example-dcp",
            resource_group_name=example.name,
            location=example.location,
            dev_center_id=example_dev_center.id,
            opts = pulumi.ResourceOptions(depends_on=[example_environment_type]))
        example_project_environment_type = azure.devcenter.ProjectEnvironmentType("example",
            name="example-et",
            location=example.location,
            dev_center_project_id=example_project.id,
            deployment_target_id=f"/subscriptions/{current.subscription_id}",
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter`: 2025-02-01

        ## Import

        An existing Dev Center Project Environment Type can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/projectEnvironmentType:ProjectEnvironmentType example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DevCenter/projects/project1/environmentTypes/et1
        ```

        :param str resource_name: The name of the resource.
        :param ProjectEnvironmentTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectEnvironmentTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 creator_role_assignment_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deployment_target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ProjectEnvironmentTypeIdentityArgs', 'ProjectEnvironmentTypeIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_role_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectEnvironmentTypeUserRoleAssignmentArgs', 'ProjectEnvironmentTypeUserRoleAssignmentArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectEnvironmentTypeArgs.__new__(ProjectEnvironmentTypeArgs)

            __props__.__dict__["creator_role_assignment_roles"] = creator_role_assignment_roles
            if deployment_target_id is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_target_id'")
            __props__.__dict__["deployment_target_id"] = deployment_target_id
            if dev_center_project_id is None and not opts.urn:
                raise TypeError("Missing required property 'dev_center_project_id'")
            __props__.__dict__["dev_center_project_id"] = dev_center_project_id
            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_role_assignments"] = user_role_assignments
        super(ProjectEnvironmentType, __self__).__init__(
            'azure:devcenter/projectEnvironmentType:ProjectEnvironmentType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creator_role_assignment_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            deployment_target_id: Optional[pulumi.Input[_builtins.str]] = None,
            dev_center_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ProjectEnvironmentTypeIdentityArgs', 'ProjectEnvironmentTypeIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user_role_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectEnvironmentTypeUserRoleAssignmentArgs', 'ProjectEnvironmentTypeUserRoleAssignmentArgsDict']]]]] = None) -> 'ProjectEnvironmentType':
        """
        Get an existing ProjectEnvironmentType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creator_role_assignment_roles: A list of roles to assign to the environment creator.
        :param pulumi.Input[_builtins.str] deployment_target_id: The ID of the subscription that the Environment Type will be mapped to. The environment's resources will be deployed into this subscription.
        :param pulumi.Input[_builtins.str] dev_center_project_id: The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ProjectEnvironmentTypeIdentityArgs', 'ProjectEnvironmentTypeIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project Environment Type should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project Environment Type. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project Environment Type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectEnvironmentTypeUserRoleAssignmentArgs', 'ProjectEnvironmentTypeUserRoleAssignmentArgsDict']]]] user_role_assignments: A `user_role_assignment` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectEnvironmentTypeState.__new__(_ProjectEnvironmentTypeState)

        __props__.__dict__["creator_role_assignment_roles"] = creator_role_assignment_roles
        __props__.__dict__["deployment_target_id"] = deployment_target_id
        __props__.__dict__["dev_center_project_id"] = dev_center_project_id
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_role_assignments"] = user_role_assignments
        return ProjectEnvironmentType(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creatorRoleAssignmentRoles")
    def creator_role_assignment_roles(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of roles to assign to the environment creator.
        """
        return pulumi.get(self, "creator_role_assignment_roles")

    @_builtins.property
    @pulumi.getter(name="deploymentTargetId")
    def deployment_target_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the subscription that the Environment Type will be mapped to. The environment's resources will be deployed into this subscription.
        """
        return pulumi.get(self, "deployment_target_id")

    @_builtins.property
    @pulumi.getter(name="devCenterProjectId")
    def dev_center_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dev_center_project_id")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.ProjectEnvironmentTypeIdentity']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Dev Center Project Environment Type should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Dev Center Project Environment Type. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Project Environment Type.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userRoleAssignments")
    def user_role_assignments(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectEnvironmentTypeUserRoleAssignment']]]:
        """
        A `user_role_assignment` block as defined below.
        """
        return pulumi.get(self, "user_role_assignments")

