# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCnameRecordResult',
    'AwaitableGetCnameRecordResult',
    'get_cname_record',
    'get_cname_record_output',
]

@pulumi.output_type
class GetCnameRecordResult:
    """
    A collection of values returned by getCnameRecord.
    """
    def __init__(__self__, fqdn=None, id=None, name=None, record=None, resource_group_name=None, tags=None, target_resource_id=None, ttl=None, zone_name=None):
        if fqdn and not isinstance(fqdn, str):
            raise TypeError("Expected argument 'fqdn' to be a str")
        pulumi.set(__self__, "fqdn", fqdn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if record and not isinstance(record, str):
            raise TypeError("Expected argument 'record' to be a str")
        pulumi.set(__self__, "record", record)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if target_resource_id and not isinstance(target_resource_id, str):
            raise TypeError("Expected argument 'target_resource_id' to be a str")
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if ttl and not isinstance(ttl, int):
            raise TypeError("Expected argument 'ttl' to be a int")
        pulumi.set(__self__, "ttl", ttl)
        if zone_name and not isinstance(zone_name, str):
            raise TypeError("Expected argument 'zone_name' to be a str")
        pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        The FQDN of the DNS CName Record.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def record(self) -> _builtins.str:
        """
        The target of the CNAME.
        """
        return pulumi.get(self, "record")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> _builtins.str:
        """
        The Azure resource id of the target object from where the dns resource value is taken.
        """
        return pulumi.get(self, "target_resource_id")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        """
        The Time To Live (TTL) of the DNS record in seconds.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> _builtins.str:
        return pulumi.get(self, "zone_name")


class AwaitableGetCnameRecordResult(GetCnameRecordResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCnameRecordResult(
            fqdn=self.fqdn,
            id=self.id,
            name=self.name,
            record=self.record,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            target_resource_id=self.target_resource_id,
            ttl=self.ttl,
            zone_name=self.zone_name)


def get_cname_record(name: Optional[_builtins.str] = None,
                     resource_group_name: Optional[_builtins.str] = None,
                     zone_name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCnameRecordResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.dns.get_cname_record(name="test",
        zone_name="test-zone",
        resource_group_name="test-rg")
    pulumi.export("dnsCnameRecordId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2018-05-01


    :param _builtins.str name: The name of the DNS CNAME Record.
    :param _builtins.str resource_group_name: Specifies the resource group where the DNS Zone (parent resource) exists.
    :param _builtins.str zone_name: Specifies the DNS Zone where the resource exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['zoneName'] = zone_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:dns/getCnameRecord:getCnameRecord', __args__, opts=opts, typ=GetCnameRecordResult).value

    return AwaitableGetCnameRecordResult(
        fqdn=pulumi.get(__ret__, 'fqdn'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        record=pulumi.get(__ret__, 'record'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        target_resource_id=pulumi.get(__ret__, 'target_resource_id'),
        ttl=pulumi.get(__ret__, 'ttl'),
        zone_name=pulumi.get(__ret__, 'zone_name'))
def get_cname_record_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                            zone_name: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCnameRecordResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.dns.get_cname_record(name="test",
        zone_name="test-zone",
        resource_group_name="test-rg")
    pulumi.export("dnsCnameRecordId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2018-05-01


    :param _builtins.str name: The name of the DNS CNAME Record.
    :param _builtins.str resource_group_name: Specifies the resource group where the DNS Zone (parent resource) exists.
    :param _builtins.str zone_name: Specifies the DNS Zone where the resource exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['zoneName'] = zone_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:dns/getCnameRecord:getCnameRecord', __args__, opts=opts, typ=GetCnameRecordResult)
    return __ret__.apply(lambda __response__: GetCnameRecordResult(
        fqdn=pulumi.get(__response__, 'fqdn'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        record=pulumi.get(__response__, 'record'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        target_resource_id=pulumi.get(__response__, 'target_resource_id'),
        ttl=pulumi.get(__response__, 'ttl'),
        zone_name=pulumi.get(__response__, 'zone_name')))
