# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitorArgs', 'Monitor']

@pulumi.input_type
class MonitorArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input['MonitorIdentityArgs'],
                 marketplace_subscription: pulumi.Input[_builtins.str],
                 plan: pulumi.Input['MonitorPlanArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 user: pulumi.Input['MonitorUserArgs'],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Monitor resource.
        :param pulumi.Input['MonitorIdentityArgs'] identity: The kind of managed identity assigned to this resource.  A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] marketplace_subscription: Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state. Possible values are `Active` and `Suspended`.
        :param pulumi.Input['MonitorPlanArgs'] plan: Billing plan information. A `plan` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['MonitorUserArgs'] user: User's information. A `user` block as defined below. Chainging this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] monitoring_enabled: Flag specifying if the resource monitoring is enabled or disabled. Default is `true`.
        :param pulumi.Input[_builtins.str] name: Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "marketplace_subscription", marketplace_subscription)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "user", user)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if monitoring_enabled is not None:
            pulumi.set(__self__, "monitoring_enabled", monitoring_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input['MonitorIdentityArgs']:
        """
        The kind of managed identity assigned to this resource.  A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['MonitorIdentityArgs']):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="marketplaceSubscription")
    def marketplace_subscription(self) -> pulumi.Input[_builtins.str]:
        """
        Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state. Possible values are `Active` and `Suspended`.
        """
        return pulumi.get(self, "marketplace_subscription")

    @marketplace_subscription.setter
    def marketplace_subscription(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "marketplace_subscription", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Input['MonitorPlanArgs']:
        """
        Billing plan information. A `plan` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input['MonitorPlanArgs']):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input['MonitorUserArgs']:
        """
        User's information. A `user` block as defined below. Chainging this forces a new resource to be created.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input['MonitorUserArgs']):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="monitoringEnabled")
    def monitoring_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag specifying if the resource monitoring is enabled or disabled. Default is `true`.
        """
        return pulumi.get(self, "monitoring_enabled")

    @monitoring_enabled.setter
    def monitoring_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _MonitorState:
    def __init__(__self__, *,
                 identity: Optional[pulumi.Input['MonitorIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 marketplace_subscription: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input['MonitorPlanArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user: Optional[pulumi.Input['MonitorUserArgs']] = None):
        """
        Input properties used for looking up and filtering Monitor resources.
        :param pulumi.Input['MonitorIdentityArgs'] identity: The kind of managed identity assigned to this resource.  A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] marketplace_subscription: Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state. Possible values are `Active` and `Suspended`.
        :param pulumi.Input[_builtins.bool] monitoring_enabled: Flag specifying if the resource monitoring is enabled or disabled. Default is `true`.
        :param pulumi.Input[_builtins.str] name: Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        :param pulumi.Input['MonitorPlanArgs'] plan: Billing plan information. A `plan` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['MonitorUserArgs'] user: User's information. A `user` block as defined below. Chainging this forces a new resource to be created.
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if marketplace_subscription is not None:
            pulumi.set(__self__, "marketplace_subscription", marketplace_subscription)
        if monitoring_enabled is not None:
            pulumi.set(__self__, "monitoring_enabled", monitoring_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['MonitorIdentityArgs']]:
        """
        The kind of managed identity assigned to this resource.  A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['MonitorIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="marketplaceSubscription")
    def marketplace_subscription(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state. Possible values are `Active` and `Suspended`.
        """
        return pulumi.get(self, "marketplace_subscription")

    @marketplace_subscription.setter
    def marketplace_subscription(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "marketplace_subscription", value)

    @_builtins.property
    @pulumi.getter(name="monitoringEnabled")
    def monitoring_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag specifying if the resource monitoring is enabled or disabled. Default is `true`.
        """
        return pulumi.get(self, "monitoring_enabled")

    @monitoring_enabled.setter
    def monitoring_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['MonitorPlanArgs']]:
        """
        Billing plan information. A `plan` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['MonitorPlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['MonitorUserArgs']]:
        """
        User's information. A `user` block as defined below. Chainging this forces a new resource to be created.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['MonitorUserArgs']]):
        pulumi.set(self, "user", value)


@pulumi.type_token("azure:dynatrace/monitor:Monitor")
class Monitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 marketplace_subscription: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[Union['MonitorPlanArgs', 'MonitorPlanArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user: Optional[pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Dynatrace monitor.

        ## Import

        Dynatrace monitor can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dynatrace/monitor:Monitor example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Dynatrace.Observability/monitors/monitor1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']] identity: The kind of managed identity assigned to this resource.  A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] marketplace_subscription: Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state. Possible values are `Active` and `Suspended`.
        :param pulumi.Input[_builtins.bool] monitoring_enabled: Flag specifying if the resource monitoring is enabled or disabled. Default is `true`.
        :param pulumi.Input[_builtins.str] name: Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['MonitorPlanArgs', 'MonitorPlanArgsDict']] plan: Billing plan information. A `plan` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']] user: User's information. A `user` block as defined below. Chainging this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dynatrace monitor.

        ## Import

        Dynatrace monitor can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dynatrace/monitor:Monitor example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Dynatrace.Observability/monitors/monitor1
        ```

        :param str resource_name: The name of the resource.
        :param MonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 marketplace_subscription: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[Union['MonitorPlanArgs', 'MonitorPlanArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user: Optional[pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorArgs.__new__(MonitorArgs)

            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            if marketplace_subscription is None and not opts.urn:
                raise TypeError("Missing required property 'marketplace_subscription'")
            __props__.__dict__["marketplace_subscription"] = marketplace_subscription
            __props__.__dict__["monitoring_enabled"] = monitoring_enabled
            __props__.__dict__["name"] = name
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
        super(Monitor, __self__).__init__(
            'azure:dynatrace/monitor:Monitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identity: Optional[pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            marketplace_subscription: Optional[pulumi.Input[_builtins.str]] = None,
            monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[Union['MonitorPlanArgs', 'MonitorPlanArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user: Optional[pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']]] = None) -> 'Monitor':
        """
        Get an existing Monitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']] identity: The kind of managed identity assigned to this resource.  A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] marketplace_subscription: Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state. Possible values are `Active` and `Suspended`.
        :param pulumi.Input[_builtins.bool] monitoring_enabled: Flag specifying if the resource monitoring is enabled or disabled. Default is `true`.
        :param pulumi.Input[_builtins.str] name: Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['MonitorPlanArgs', 'MonitorPlanArgsDict']] plan: Billing plan information. A `plan` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']] user: User's information. A `user` block as defined below. Chainging this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorState.__new__(_MonitorState)

        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["marketplace_subscription"] = marketplace_subscription
        __props__.__dict__["monitoring_enabled"] = monitoring_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["plan"] = plan
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user"] = user
        return Monitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.MonitorIdentity']:
        """
        The kind of managed identity assigned to this resource.  A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="marketplaceSubscription")
    def marketplace_subscription(self) -> pulumi.Output[_builtins.str]:
        """
        Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state. Possible values are `Active` and `Suspended`.
        """
        return pulumi.get(self, "marketplace_subscription")

    @_builtins.property
    @pulumi.getter(name="monitoringEnabled")
    def monitoring_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag specifying if the resource monitoring is enabled or disabled. Default is `true`.
        """
        return pulumi.get(self, "monitoring_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output['outputs.MonitorPlan']:
        """
        Billing plan information. A `plan` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Dynatrace monitor should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output['outputs.MonitorUser']:
        """
        User's information. A `user` block as defined below. Chainging this forces a new resource to be created.
        """
        return pulumi.get(self, "user")

