# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetElasticsearchResult',
    'AwaitableGetElasticsearchResult',
    'get_elasticsearch',
    'get_elasticsearch_output',
]

@pulumi.output_type
class GetElasticsearchResult:
    """
    A collection of values returned by getElasticsearch.
    """
    def __init__(__self__, elastic_cloud_deployment_id=None, elastic_cloud_email_address=None, elastic_cloud_sso_default_url=None, elastic_cloud_user_id=None, elasticsearch_service_url=None, id=None, kibana_service_url=None, kibana_sso_uri=None, location=None, logs=None, monitoring_enabled=None, name=None, resource_group_name=None, sku_name=None, tags=None):
        if elastic_cloud_deployment_id and not isinstance(elastic_cloud_deployment_id, str):
            raise TypeError("Expected argument 'elastic_cloud_deployment_id' to be a str")
        pulumi.set(__self__, "elastic_cloud_deployment_id", elastic_cloud_deployment_id)
        if elastic_cloud_email_address and not isinstance(elastic_cloud_email_address, str):
            raise TypeError("Expected argument 'elastic_cloud_email_address' to be a str")
        pulumi.set(__self__, "elastic_cloud_email_address", elastic_cloud_email_address)
        if elastic_cloud_sso_default_url and not isinstance(elastic_cloud_sso_default_url, str):
            raise TypeError("Expected argument 'elastic_cloud_sso_default_url' to be a str")
        pulumi.set(__self__, "elastic_cloud_sso_default_url", elastic_cloud_sso_default_url)
        if elastic_cloud_user_id and not isinstance(elastic_cloud_user_id, str):
            raise TypeError("Expected argument 'elastic_cloud_user_id' to be a str")
        pulumi.set(__self__, "elastic_cloud_user_id", elastic_cloud_user_id)
        if elasticsearch_service_url and not isinstance(elasticsearch_service_url, str):
            raise TypeError("Expected argument 'elasticsearch_service_url' to be a str")
        pulumi.set(__self__, "elasticsearch_service_url", elasticsearch_service_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kibana_service_url and not isinstance(kibana_service_url, str):
            raise TypeError("Expected argument 'kibana_service_url' to be a str")
        pulumi.set(__self__, "kibana_service_url", kibana_service_url)
        if kibana_sso_uri and not isinstance(kibana_sso_uri, str):
            raise TypeError("Expected argument 'kibana_sso_uri' to be a str")
        pulumi.set(__self__, "kibana_sso_uri", kibana_sso_uri)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if logs and not isinstance(logs, list):
            raise TypeError("Expected argument 'logs' to be a list")
        pulumi.set(__self__, "logs", logs)
        if monitoring_enabled and not isinstance(monitoring_enabled, bool):
            raise TypeError("Expected argument 'monitoring_enabled' to be a bool")
        pulumi.set(__self__, "monitoring_enabled", monitoring_enabled)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name and not isinstance(sku_name, str):
            raise TypeError("Expected argument 'sku_name' to be a str")
        pulumi.set(__self__, "sku_name", sku_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="elasticCloudDeploymentId")
    def elastic_cloud_deployment_id(self) -> _builtins.str:
        """
        The ID of the Deployment within Elastic Cloud.
        """
        return pulumi.get(self, "elastic_cloud_deployment_id")

    @_builtins.property
    @pulumi.getter(name="elasticCloudEmailAddress")
    def elastic_cloud_email_address(self) -> _builtins.str:
        """
        The Email Address which is associated with this Elasticsearch account.
        """
        return pulumi.get(self, "elastic_cloud_email_address")

    @_builtins.property
    @pulumi.getter(name="elasticCloudSsoDefaultUrl")
    def elastic_cloud_sso_default_url(self) -> _builtins.str:
        """
        The Default URL used for Single Sign On (SSO) to Elastic Cloud.
        """
        return pulumi.get(self, "elastic_cloud_sso_default_url")

    @_builtins.property
    @pulumi.getter(name="elasticCloudUserId")
    def elastic_cloud_user_id(self) -> _builtins.str:
        """
        The ID of the User Account within Elastic Cloud.
        """
        return pulumi.get(self, "elastic_cloud_user_id")

    @_builtins.property
    @pulumi.getter(name="elasticsearchServiceUrl")
    def elasticsearch_service_url(self) -> _builtins.str:
        """
        The URL to the Elasticsearch Service associated with this Elasticsearch.
        """
        return pulumi.get(self, "elasticsearch_service_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kibanaServiceUrl")
    def kibana_service_url(self) -> _builtins.str:
        """
        The URL to the Kibana Dashboard associated with this Elasticsearch.
        """
        return pulumi.get(self, "kibana_service_url")

    @_builtins.property
    @pulumi.getter(name="kibanaSsoUri")
    def kibana_sso_uri(self) -> _builtins.str:
        """
        The URI used for SSO to the Kibana Dashboard associated with this Elasticsearch.
        """
        return pulumi.get(self, "kibana_sso_uri")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region in which this Elasticsearch exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def logs(self) -> Sequence['outputs.GetElasticsearchLogResult']:
        """
        A `logs` block as defined below.
        """
        return pulumi.get(self, "logs")

    @_builtins.property
    @pulumi.getter(name="monitoringEnabled")
    def monitoring_enabled(self) -> _builtins.bool:
        """
        Specifies if monitoring is enabled on this Elasticsearch or not.
        """
        return pulumi.get(self, "monitoring_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name (key) of the Tag which should be filtered.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> _builtins.str:
        """
        The name of the SKU used for this Elasticsearch.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Elasticsearch.
        """
        return pulumi.get(self, "tags")


class AwaitableGetElasticsearchResult(GetElasticsearchResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetElasticsearchResult(
            elastic_cloud_deployment_id=self.elastic_cloud_deployment_id,
            elastic_cloud_email_address=self.elastic_cloud_email_address,
            elastic_cloud_sso_default_url=self.elastic_cloud_sso_default_url,
            elastic_cloud_user_id=self.elastic_cloud_user_id,
            elasticsearch_service_url=self.elasticsearch_service_url,
            id=self.id,
            kibana_service_url=self.kibana_service_url,
            kibana_sso_uri=self.kibana_sso_uri,
            location=self.location,
            logs=self.logs,
            monitoring_enabled=self.monitoring_enabled,
            name=self.name,
            resource_group_name=self.resource_group_name,
            sku_name=self.sku_name,
            tags=self.tags)


def get_elasticsearch(logs: Optional[Sequence[Union['GetElasticsearchLogArgs', 'GetElasticsearchLogArgsDict']]] = None,
                      name: Optional[_builtins.str] = None,
                      resource_group_name: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetElasticsearchResult:
    """
    Use this data source to access information about an existing Elasticsearch resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.elasticcloud.get_elasticsearch(name="my-elastic-search",
        resource_group_name="example-resources")
    pulumi.export("elasticsearchEndpoint", example.elasticsearch_service_url)
    pulumi.export("kibanaEndpoint", example.kibana_service_url)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Elastic`: 2023-06-01


    :param Sequence[Union['GetElasticsearchLogArgs', 'GetElasticsearchLogArgsDict']] logs: A `logs` block as defined below.
    :param _builtins.str name: The name of the Elasticsearch resource.
    :param _builtins.str resource_group_name: The name of the resource group in which the Elasticsearch exists.
    """
    __args__ = dict()
    __args__['logs'] = logs
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:elasticcloud/getElasticsearch:getElasticsearch', __args__, opts=opts, typ=GetElasticsearchResult).value

    return AwaitableGetElasticsearchResult(
        elastic_cloud_deployment_id=pulumi.get(__ret__, 'elastic_cloud_deployment_id'),
        elastic_cloud_email_address=pulumi.get(__ret__, 'elastic_cloud_email_address'),
        elastic_cloud_sso_default_url=pulumi.get(__ret__, 'elastic_cloud_sso_default_url'),
        elastic_cloud_user_id=pulumi.get(__ret__, 'elastic_cloud_user_id'),
        elasticsearch_service_url=pulumi.get(__ret__, 'elasticsearch_service_url'),
        id=pulumi.get(__ret__, 'id'),
        kibana_service_url=pulumi.get(__ret__, 'kibana_service_url'),
        kibana_sso_uri=pulumi.get(__ret__, 'kibana_sso_uri'),
        location=pulumi.get(__ret__, 'location'),
        logs=pulumi.get(__ret__, 'logs'),
        monitoring_enabled=pulumi.get(__ret__, 'monitoring_enabled'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku_name=pulumi.get(__ret__, 'sku_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_elasticsearch_output(logs: Optional[pulumi.Input[Optional[Sequence[Union['GetElasticsearchLogArgs', 'GetElasticsearchLogArgsDict']]]]] = None,
                             name: Optional[pulumi.Input[_builtins.str]] = None,
                             resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetElasticsearchResult]:
    """
    Use this data source to access information about an existing Elasticsearch resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.elasticcloud.get_elasticsearch(name="my-elastic-search",
        resource_group_name="example-resources")
    pulumi.export("elasticsearchEndpoint", example.elasticsearch_service_url)
    pulumi.export("kibanaEndpoint", example.kibana_service_url)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Elastic`: 2023-06-01


    :param Sequence[Union['GetElasticsearchLogArgs', 'GetElasticsearchLogArgsDict']] logs: A `logs` block as defined below.
    :param _builtins.str name: The name of the Elasticsearch resource.
    :param _builtins.str resource_group_name: The name of the resource group in which the Elasticsearch exists.
    """
    __args__ = dict()
    __args__['logs'] = logs
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:elasticcloud/getElasticsearch:getElasticsearch', __args__, opts=opts, typ=GetElasticsearchResult)
    return __ret__.apply(lambda __response__: GetElasticsearchResult(
        elastic_cloud_deployment_id=pulumi.get(__response__, 'elastic_cloud_deployment_id'),
        elastic_cloud_email_address=pulumi.get(__response__, 'elastic_cloud_email_address'),
        elastic_cloud_sso_default_url=pulumi.get(__response__, 'elastic_cloud_sso_default_url'),
        elastic_cloud_user_id=pulumi.get(__response__, 'elastic_cloud_user_id'),
        elasticsearch_service_url=pulumi.get(__response__, 'elasticsearch_service_url'),
        id=pulumi.get(__response__, 'id'),
        kibana_service_url=pulumi.get(__response__, 'kibana_service_url'),
        kibana_sso_uri=pulumi.get(__response__, 'kibana_sso_uri'),
        location=pulumi.get(__response__, 'location'),
        logs=pulumi.get(__response__, 'logs'),
        monitoring_enabled=pulumi.get(__response__, 'monitoring_enabled'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku_name=pulumi.get(__response__, 'sku_name'),
        tags=pulumi.get(__response__, 'tags')))
