# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSystemTopicResult',
    'AwaitableGetSystemTopicResult',
    'get_system_topic',
    'get_system_topic_output',
]

@pulumi.output_type
class GetSystemTopicResult:
    """
    A collection of values returned by getSystemTopic.
    """
    def __init__(__self__, id=None, identities=None, location=None, metric_arm_resource_id=None, name=None, resource_group_name=None, source_arm_resource_id=None, tags=None, topic_type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if metric_arm_resource_id and not isinstance(metric_arm_resource_id, str):
            raise TypeError("Expected argument 'metric_arm_resource_id' to be a str")
        pulumi.set(__self__, "metric_arm_resource_id", metric_arm_resource_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if source_arm_resource_id and not isinstance(source_arm_resource_id, str):
            raise TypeError("Expected argument 'source_arm_resource_id' to be a str")
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if topic_type and not isinstance(topic_type, str):
            raise TypeError("Expected argument 'topic_type' to be a str")
        pulumi.set(__self__, "topic_type", topic_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetSystemTopicIdentityResult']:
        """
        An `identity` block as defined below, which contains the Managed Service Identity information for this Event Grid System Topic.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="metricArmResourceId")
    def metric_arm_resource_id(self) -> _builtins.str:
        """
        The Metric ARM Resource ID of the Event Grid System Topic.
        """
        return pulumi.get(self, "metric_arm_resource_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> _builtins.str:
        """
        The ID of the Event Grid System Topic ARM Source.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags which are assigned to the Event Grid System Topic.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="topicType")
    def topic_type(self) -> _builtins.str:
        """
        The Topic Type of the Event Grid System Topic.
        """
        return pulumi.get(self, "topic_type")


class AwaitableGetSystemTopicResult(GetSystemTopicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSystemTopicResult(
            id=self.id,
            identities=self.identities,
            location=self.location,
            metric_arm_resource_id=self.metric_arm_resource_id,
            name=self.name,
            resource_group_name=self.resource_group_name,
            source_arm_resource_id=self.source_arm_resource_id,
            tags=self.tags,
            topic_type=self.topic_type)


def get_system_topic(name: Optional[_builtins.str] = None,
                     resource_group_name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSystemTopicResult:
    """
    Use this data source to access information about an existing EventGrid System Topic

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.eventgrid.get_system_topic(name="eventgrid-system-topic",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.EventGrid`: 2022-06-15


    :param _builtins.str name: The name of the EventGrid System Topic resource.
    :param _builtins.str resource_group_name: The name of the resource group in which the EventGrid System Topic exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:eventgrid/getSystemTopic:getSystemTopic', __args__, opts=opts, typ=GetSystemTopicResult).value

    return AwaitableGetSystemTopicResult(
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        metric_arm_resource_id=pulumi.get(__ret__, 'metric_arm_resource_id'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        source_arm_resource_id=pulumi.get(__ret__, 'source_arm_resource_id'),
        tags=pulumi.get(__ret__, 'tags'),
        topic_type=pulumi.get(__ret__, 'topic_type'))
def get_system_topic_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSystemTopicResult]:
    """
    Use this data source to access information about an existing EventGrid System Topic

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.eventgrid.get_system_topic(name="eventgrid-system-topic",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.EventGrid`: 2022-06-15


    :param _builtins.str name: The name of the EventGrid System Topic resource.
    :param _builtins.str resource_group_name: The name of the resource group in which the EventGrid System Topic exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:eventgrid/getSystemTopic:getSystemTopic', __args__, opts=opts, typ=GetSystemTopicResult)
    return __ret__.apply(lambda __response__: GetSystemTopicResult(
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        metric_arm_resource_id=pulumi.get(__response__, 'metric_arm_resource_id'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        source_arm_resource_id=pulumi.get(__response__, 'source_arm_resource_id'),
        tags=pulumi.get(__response__, 'tags'),
        topic_type=pulumi.get(__response__, 'topic_type')))
