# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TopicAuthorizationRuleArgs', 'TopicAuthorizationRule']

@pulumi.input_type
class TopicAuthorizationRuleArgs:
    def __init__(__self__, *,
                 topic_id: pulumi.Input[_builtins.str],
                 listen: Optional[pulumi.Input[_builtins.bool]] = None,
                 manage: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 send: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a TopicAuthorizationRule resource.
        :param pulumi.Input[_builtins.str] topic_id: Specifies the ID of the ServiceBus Topic. Changing this forces a new resource to be created.
               
               > **Note:** At least one of the 3 permissions below needs to be set.
        :param pulumi.Input[_builtins.bool] listen: Grants listen access to this this Authorization Rule. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] manage: Grants manage access to this this Authorization Rule. When this property is `true` - both `listen` and `send` must be too. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the ServiceBus Topic Authorization Rule resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] send: Grants send access to this this Authorization Rule. Defaults to `false`.
        """
        pulumi.set(__self__, "topic_id", topic_id)
        if listen is not None:
            pulumi.set(__self__, "listen", listen)
        if manage is not None:
            pulumi.set(__self__, "manage", manage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if send is not None:
            pulumi.set(__self__, "send", send)

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the ServiceBus Topic. Changing this forces a new resource to be created.

        > **Note:** At least one of the 3 permissions below needs to be set.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic_id", value)

    @_builtins.property
    @pulumi.getter
    def listen(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Grants listen access to this this Authorization Rule. Defaults to `false`.
        """
        return pulumi.get(self, "listen")

    @listen.setter
    def listen(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "listen", value)

    @_builtins.property
    @pulumi.getter
    def manage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Grants manage access to this this Authorization Rule. When this property is `true` - both `listen` and `send` must be too. Defaults to `false`.
        """
        return pulumi.get(self, "manage")

    @manage.setter
    def manage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manage", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the ServiceBus Topic Authorization Rule resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def send(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Grants send access to this this Authorization Rule. Defaults to `false`.
        """
        return pulumi.get(self, "send")

    @send.setter
    def send(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send", value)


@pulumi.input_type
class _TopicAuthorizationRuleState:
    def __init__(__self__, *,
                 listen: Optional[pulumi.Input[_builtins.bool]] = None,
                 manage: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_connection_string_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_connection_string_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 send: Optional[pulumi.Input[_builtins.bool]] = None,
                 topic_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TopicAuthorizationRule resources.
        :param pulumi.Input[_builtins.bool] listen: Grants listen access to this this Authorization Rule. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] manage: Grants manage access to this this Authorization Rule. When this property is `true` - both `listen` and `send` must be too. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the ServiceBus Topic Authorization Rule resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] primary_connection_string: The Primary Connection String for the ServiceBus Topic authorization Rule.
        :param pulumi.Input[_builtins.str] primary_connection_string_alias: The alias Primary Connection String for the ServiceBus Namespace, if the namespace is Geo DR paired.
        :param pulumi.Input[_builtins.str] primary_key: The Primary Key for the ServiceBus Topic authorization Rule.
        :param pulumi.Input[_builtins.str] secondary_connection_string: The Secondary Connection String for the ServiceBus Topic authorization Rule.
        :param pulumi.Input[_builtins.str] secondary_connection_string_alias: The alias Secondary Connection String for the ServiceBus Namespace
        :param pulumi.Input[_builtins.str] secondary_key: The Secondary Key for the ServiceBus Topic authorization Rule.
        :param pulumi.Input[_builtins.bool] send: Grants send access to this this Authorization Rule. Defaults to `false`.
        :param pulumi.Input[_builtins.str] topic_id: Specifies the ID of the ServiceBus Topic. Changing this forces a new resource to be created.
               
               > **Note:** At least one of the 3 permissions below needs to be set.
        """
        if listen is not None:
            pulumi.set(__self__, "listen", listen)
        if manage is not None:
            pulumi.set(__self__, "manage", manage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_connection_string is not None:
            pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if primary_connection_string_alias is not None:
            pulumi.set(__self__, "primary_connection_string_alias", primary_connection_string_alias)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_connection_string is not None:
            pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if secondary_connection_string_alias is not None:
            pulumi.set(__self__, "secondary_connection_string_alias", secondary_connection_string_alias)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)
        if send is not None:
            pulumi.set(__self__, "send", send)
        if topic_id is not None:
            pulumi.set(__self__, "topic_id", topic_id)

    @_builtins.property
    @pulumi.getter
    def listen(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Grants listen access to this this Authorization Rule. Defaults to `false`.
        """
        return pulumi.get(self, "listen")

    @listen.setter
    def listen(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "listen", value)

    @_builtins.property
    @pulumi.getter
    def manage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Grants manage access to this this Authorization Rule. When this property is `true` - both `listen` and `send` must be too. Defaults to `false`.
        """
        return pulumi.get(self, "manage")

    @manage.setter
    def manage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manage", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the ServiceBus Topic Authorization Rule resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Primary Connection String for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "primary_connection_string")

    @primary_connection_string.setter
    def primary_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="primaryConnectionStringAlias")
    def primary_connection_string_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alias Primary Connection String for the ServiceBus Namespace, if the namespace is Geo DR paired.
        """
        return pulumi.get(self, "primary_connection_string_alias")

    @primary_connection_string_alias.setter
    def primary_connection_string_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_connection_string_alias", value)

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Primary Key for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_key", value)

    @_builtins.property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Secondary Connection String for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "secondary_connection_string")

    @secondary_connection_string.setter
    def secondary_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="secondaryConnectionStringAlias")
    def secondary_connection_string_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alias Secondary Connection String for the ServiceBus Namespace
        """
        return pulumi.get(self, "secondary_connection_string_alias")

    @secondary_connection_string_alias.setter
    def secondary_connection_string_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_connection_string_alias", value)

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Secondary Key for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_key", value)

    @_builtins.property
    @pulumi.getter
    def send(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Grants send access to this this Authorization Rule. Defaults to `false`.
        """
        return pulumi.get(self, "send")

    @send.setter
    def send(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "send", value)

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the ServiceBus Topic. Changing this forces a new resource to be created.

        > **Note:** At least one of the 3 permissions below needs to be set.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_id", value)


warnings.warn("""azure.eventhub.TopicAuthorizationRule has been deprecated in favor of azure.servicebus.TopicAuthorizationRule""", DeprecationWarning)


@pulumi.type_token("azure:eventhub/topicAuthorizationRule:TopicAuthorizationRule")
class TopicAuthorizationRule(pulumi.CustomResource):
    warnings.warn("""azure.eventhub.TopicAuthorizationRule has been deprecated in favor of azure.servicebus.TopicAuthorizationRule""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 listen: Optional[pulumi.Input[_builtins.bool]] = None,
                 manage: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 send: Optional[pulumi.Input[_builtins.bool]] = None,
                 topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a ServiceBus Topic authorization Rule within a ServiceBus Topic.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-servicebus",
            location="West Europe")
        example_namespace = azure.servicebus.Namespace("example",
            name="tfex-servicebus-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            tags={
                "source": "example",
            })
        example_topic = azure.servicebus.Topic("example",
            name="tfex_servicebus_topic",
            namespace_id=example_namespace.id)
        example_topic_authorization_rule = azure.servicebus.TopicAuthorizationRule("example",
            name="tfex_servicebus_topic_sasPolicy",
            topic_id=example_topic.id,
            listen=True,
            send=False,
            manage=False)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceBus`: 2021-06-01-preview

        ## Import

        ServiceBus Topic authorization rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventhub/topicAuthorizationRule:TopicAuthorizationRule rule1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ServiceBus/namespaces/namespace1/topics/topic1/authorizationRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] listen: Grants listen access to this this Authorization Rule. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] manage: Grants manage access to this this Authorization Rule. When this property is `true` - both `listen` and `send` must be too. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the ServiceBus Topic Authorization Rule resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] send: Grants send access to this this Authorization Rule. Defaults to `false`.
        :param pulumi.Input[_builtins.str] topic_id: Specifies the ID of the ServiceBus Topic. Changing this forces a new resource to be created.
               
               > **Note:** At least one of the 3 permissions below needs to be set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TopicAuthorizationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a ServiceBus Topic authorization Rule within a ServiceBus Topic.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-servicebus",
            location="West Europe")
        example_namespace = azure.servicebus.Namespace("example",
            name="tfex-servicebus-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            tags={
                "source": "example",
            })
        example_topic = azure.servicebus.Topic("example",
            name="tfex_servicebus_topic",
            namespace_id=example_namespace.id)
        example_topic_authorization_rule = azure.servicebus.TopicAuthorizationRule("example",
            name="tfex_servicebus_topic_sasPolicy",
            topic_id=example_topic.id,
            listen=True,
            send=False,
            manage=False)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceBus`: 2021-06-01-preview

        ## Import

        ServiceBus Topic authorization rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventhub/topicAuthorizationRule:TopicAuthorizationRule rule1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ServiceBus/namespaces/namespace1/topics/topic1/authorizationRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param TopicAuthorizationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicAuthorizationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 listen: Optional[pulumi.Input[_builtins.bool]] = None,
                 manage: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 send: Optional[pulumi.Input[_builtins.bool]] = None,
                 topic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""TopicAuthorizationRule is deprecated: azure.eventhub.TopicAuthorizationRule has been deprecated in favor of azure.servicebus.TopicAuthorizationRule""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicAuthorizationRuleArgs.__new__(TopicAuthorizationRuleArgs)

            __props__.__dict__["listen"] = listen
            __props__.__dict__["manage"] = manage
            __props__.__dict__["name"] = name
            __props__.__dict__["send"] = send
            if topic_id is None and not opts.urn:
                raise TypeError("Missing required property 'topic_id'")
            __props__.__dict__["topic_id"] = topic_id
            __props__.__dict__["primary_connection_string"] = None
            __props__.__dict__["primary_connection_string_alias"] = None
            __props__.__dict__["primary_key"] = None
            __props__.__dict__["secondary_connection_string"] = None
            __props__.__dict__["secondary_connection_string_alias"] = None
            __props__.__dict__["secondary_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryConnectionString", "primaryConnectionStringAlias", "primaryKey", "secondaryConnectionString", "secondaryConnectionStringAlias", "secondaryKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(TopicAuthorizationRule, __self__).__init__(
            'azure:eventhub/topicAuthorizationRule:TopicAuthorizationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            listen: Optional[pulumi.Input[_builtins.bool]] = None,
            manage: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            primary_connection_string_alias: Optional[pulumi.Input[_builtins.str]] = None,
            primary_key: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_connection_string_alias: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_key: Optional[pulumi.Input[_builtins.str]] = None,
            send: Optional[pulumi.Input[_builtins.bool]] = None,
            topic_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TopicAuthorizationRule':
        """
        Get an existing TopicAuthorizationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] listen: Grants listen access to this this Authorization Rule. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] manage: Grants manage access to this this Authorization Rule. When this property is `true` - both `listen` and `send` must be too. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the ServiceBus Topic Authorization Rule resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] primary_connection_string: The Primary Connection String for the ServiceBus Topic authorization Rule.
        :param pulumi.Input[_builtins.str] primary_connection_string_alias: The alias Primary Connection String for the ServiceBus Namespace, if the namespace is Geo DR paired.
        :param pulumi.Input[_builtins.str] primary_key: The Primary Key for the ServiceBus Topic authorization Rule.
        :param pulumi.Input[_builtins.str] secondary_connection_string: The Secondary Connection String for the ServiceBus Topic authorization Rule.
        :param pulumi.Input[_builtins.str] secondary_connection_string_alias: The alias Secondary Connection String for the ServiceBus Namespace
        :param pulumi.Input[_builtins.str] secondary_key: The Secondary Key for the ServiceBus Topic authorization Rule.
        :param pulumi.Input[_builtins.bool] send: Grants send access to this this Authorization Rule. Defaults to `false`.
        :param pulumi.Input[_builtins.str] topic_id: Specifies the ID of the ServiceBus Topic. Changing this forces a new resource to be created.
               
               > **Note:** At least one of the 3 permissions below needs to be set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TopicAuthorizationRuleState.__new__(_TopicAuthorizationRuleState)

        __props__.__dict__["listen"] = listen
        __props__.__dict__["manage"] = manage
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_connection_string"] = primary_connection_string
        __props__.__dict__["primary_connection_string_alias"] = primary_connection_string_alias
        __props__.__dict__["primary_key"] = primary_key
        __props__.__dict__["secondary_connection_string"] = secondary_connection_string
        __props__.__dict__["secondary_connection_string_alias"] = secondary_connection_string_alias
        __props__.__dict__["secondary_key"] = secondary_key
        __props__.__dict__["send"] = send
        __props__.__dict__["topic_id"] = topic_id
        return TopicAuthorizationRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def listen(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Grants listen access to this this Authorization Rule. Defaults to `false`.
        """
        return pulumi.get(self, "listen")

    @_builtins.property
    @pulumi.getter
    def manage(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Grants manage access to this this Authorization Rule. When this property is `true` - both `listen` and `send` must be too. Defaults to `false`.
        """
        return pulumi.get(self, "manage")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the ServiceBus Topic Authorization Rule resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The Primary Connection String for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "primary_connection_string")

    @_builtins.property
    @pulumi.getter(name="primaryConnectionStringAlias")
    def primary_connection_string_alias(self) -> pulumi.Output[_builtins.str]:
        """
        The alias Primary Connection String for the ServiceBus Namespace, if the namespace is Geo DR paired.
        """
        return pulumi.get(self, "primary_connection_string_alias")

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Primary Key for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "primary_key")

    @_builtins.property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The Secondary Connection String for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "secondary_connection_string")

    @_builtins.property
    @pulumi.getter(name="secondaryConnectionStringAlias")
    def secondary_connection_string_alias(self) -> pulumi.Output[_builtins.str]:
        """
        The alias Secondary Connection String for the ServiceBus Namespace
        """
        return pulumi.get(self, "secondary_connection_string_alias")

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Secondary Key for the ServiceBus Topic authorization Rule.
        """
        return pulumi.get(self, "secondary_key")

    @_builtins.property
    @pulumi.getter
    def send(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Grants send access to this this Authorization Rule. Defaults to `false`.
        """
        return pulumi.get(self, "send")

    @_builtins.property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the ServiceBus Topic. Changing this forces a new resource to be created.

        > **Note:** At least one of the 3 permissions below needs to be set.
        """
        return pulumi.get(self, "topic_id")

