# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DicomServiceArgs', 'DicomService']

@pulumi.input_type
class DicomServiceArgs:
    def __init__(__self__, *,
                 workspace_id: pulumi.Input[_builtins.str],
                 cors: Optional[pulumi.Input['DicomServiceCorsArgs']] = None,
                 data_partitions_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key_url: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['DicomServiceIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage: Optional[pulumi.Input['DicomServiceStorageArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DicomService resource.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the ID of the Healthcare Workspace where the Healthcare DICOM Service should exist. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input['DicomServiceCorsArgs'] cors: A `cors` block as defined below.
        :param pulumi.Input[_builtins.bool] data_partitions_enabled: If data partitions are enabled or not. Defaults to `false`. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.str] encryption_key_url: The URL of the key to use for encryption as part of the customer-managed key encryption settings. For more details, refer to the [Azure Customer-Managed Keys Overview](https://learn.microsoft.com/en-us/azure/storage/common/customer-managed-keys-overview).
        :param pulumi.Input['DicomServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare DICOM Service should be created. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether to enabled public networks when data plane traffic coming from public networks while private endpoint is enabled. Defaults to `true`.
        :param pulumi.Input['DicomServiceStorageArgs'] storage: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Healthcare DICOM Service.
        """
        pulumi.set(__self__, "workspace_id", workspace_id)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if data_partitions_enabled is not None:
            pulumi.set(__self__, "data_partitions_enabled", data_partitions_enabled)
        if encryption_key_url is not None:
            pulumi.set(__self__, "encryption_key_url", encryption_key_url)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Healthcare Workspace where the Healthcare DICOM Service should exist. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['DicomServiceCorsArgs']]:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['DicomServiceCorsArgs']]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter(name="dataPartitionsEnabled")
    def data_partitions_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If data partitions are enabled or not. Defaults to `false`. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "data_partitions_enabled")

    @data_partitions_enabled.setter
    def data_partitions_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_partitions_enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKeyUrl")
    def encryption_key_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the key to use for encryption as part of the customer-managed key encryption settings. For more details, refer to the [Azure Customer-Managed Keys Overview](https://learn.microsoft.com/en-us/azure/storage/common/customer-managed-keys-overview).
        """
        return pulumi.get(self, "encryption_key_url")

    @encryption_key_url.setter
    def encryption_key_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key_url", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['DicomServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['DicomServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Healthcare DICOM Service should be created. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enabled public networks when data plane traffic coming from public networks while private endpoint is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['DicomServiceStorageArgs']]:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['DicomServiceStorageArgs']]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Healthcare DICOM Service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DicomServiceState:
    def __init__(__self__, *,
                 authentications: Optional[pulumi.Input[Sequence[pulumi.Input['DicomServiceAuthenticationArgs']]]] = None,
                 cors: Optional[pulumi.Input['DicomServiceCorsArgs']] = None,
                 data_partitions_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key_url: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['DicomServiceIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['DicomServicePrivateEndpointArgs']]]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 storage: Optional[pulumi.Input['DicomServiceStorageArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DicomService resources.
        :param pulumi.Input[Sequence[pulumi.Input['DicomServiceAuthenticationArgs']]] authentications: The `authentication` block as defined below.
        :param pulumi.Input['DicomServiceCorsArgs'] cors: A `cors` block as defined below.
        :param pulumi.Input[_builtins.bool] data_partitions_enabled: If data partitions are enabled or not. Defaults to `false`. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.str] encryption_key_url: The URL of the key to use for encryption as part of the customer-managed key encryption settings. For more details, refer to the [Azure Customer-Managed Keys Overview](https://learn.microsoft.com/en-us/azure/storage/common/customer-managed-keys-overview).
        :param pulumi.Input['DicomServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare DICOM Service should be created. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether to enabled public networks when data plane traffic coming from public networks while private endpoint is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] service_url: The url of the Healthcare DICOM Services.
        :param pulumi.Input['DicomServiceStorageArgs'] storage: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Healthcare DICOM Service.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the ID of the Healthcare Workspace where the Healthcare DICOM Service should exist. Changing this forces a new Healthcare DICOM Service to be created.
        """
        if authentications is not None:
            pulumi.set(__self__, "authentications", authentications)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if data_partitions_enabled is not None:
            pulumi.set(__self__, "data_partitions_enabled", data_partitions_enabled)
        if encryption_key_url is not None:
            pulumi.set(__self__, "encryption_key_url", encryption_key_url)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_endpoints is not None:
            pulumi.set(__self__, "private_endpoints", private_endpoints)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if service_url is not None:
            pulumi.set(__self__, "service_url", service_url)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DicomServiceAuthenticationArgs']]]]:
        """
        The `authentication` block as defined below.
        """
        return pulumi.get(self, "authentications")

    @authentications.setter
    def authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DicomServiceAuthenticationArgs']]]]):
        pulumi.set(self, "authentications", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['DicomServiceCorsArgs']]:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['DicomServiceCorsArgs']]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter(name="dataPartitionsEnabled")
    def data_partitions_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If data partitions are enabled or not. Defaults to `false`. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "data_partitions_enabled")

    @data_partitions_enabled.setter
    def data_partitions_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_partitions_enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKeyUrl")
    def encryption_key_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the key to use for encryption as part of the customer-managed key encryption settings. For more details, refer to the [Azure Customer-Managed Keys Overview](https://learn.microsoft.com/en-us/azure/storage/common/customer-managed-keys-overview).
        """
        return pulumi.get(self, "encryption_key_url")

    @encryption_key_url.setter
    def encryption_key_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key_url", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['DicomServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['DicomServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Healthcare DICOM Service should be created. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DicomServicePrivateEndpointArgs']]]]:
        return pulumi.get(self, "private_endpoints")

    @private_endpoints.setter
    def private_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DicomServicePrivateEndpointArgs']]]]):
        pulumi.set(self, "private_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enabled public networks when data plane traffic coming from public networks while private endpoint is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The url of the Healthcare DICOM Services.
        """
        return pulumi.get(self, "service_url")

    @service_url.setter
    def service_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_url", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['DicomServiceStorageArgs']]:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['DicomServiceStorageArgs']]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Healthcare DICOM Service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Healthcare Workspace where the Healthcare DICOM Service should exist. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:healthcare/dicomService:DicomService")
class DicomService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cors: Optional[pulumi.Input[Union['DicomServiceCorsArgs', 'DicomServiceCorsArgsDict']]] = None,
                 data_partitions_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key_url: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['DicomServiceIdentityArgs', 'DicomServiceIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage: Optional[pulumi.Input[Union['DicomServiceStorageArgs', 'DicomServiceStorageArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Healthcare DICOM Service

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        test = azure.healthcare.Workspace("test",
            name="tfexworkspace",
            resource_group_name="tfex-resource_group",
            location="east us")
        test_dicom_service = azure.healthcare.DicomService("test",
            name="tfexDicom",
            workspace_id=test.id,
            location="east us",
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "environment": "None",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HealthcareApis`: 2024-03-31

        ## Import

        Healthcare DICOM Service can be imported using the resource`id`, e.g.

        ```sh
        $ pulumi import azure:healthcare/dicomService:DicomService example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.HealthcareApis/workspaces/workspace1/dicomServices/service1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DicomServiceCorsArgs', 'DicomServiceCorsArgsDict']] cors: A `cors` block as defined below.
        :param pulumi.Input[_builtins.bool] data_partitions_enabled: If data partitions are enabled or not. Defaults to `false`. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.str] encryption_key_url: The URL of the key to use for encryption as part of the customer-managed key encryption settings. For more details, refer to the [Azure Customer-Managed Keys Overview](https://learn.microsoft.com/en-us/azure/storage/common/customer-managed-keys-overview).
        :param pulumi.Input[Union['DicomServiceIdentityArgs', 'DicomServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare DICOM Service should be created. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether to enabled public networks when data plane traffic coming from public networks while private endpoint is enabled. Defaults to `true`.
        :param pulumi.Input[Union['DicomServiceStorageArgs', 'DicomServiceStorageArgsDict']] storage: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Healthcare DICOM Service.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the ID of the Healthcare Workspace where the Healthcare DICOM Service should exist. Changing this forces a new Healthcare DICOM Service to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DicomServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Healthcare DICOM Service

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        test = azure.healthcare.Workspace("test",
            name="tfexworkspace",
            resource_group_name="tfex-resource_group",
            location="east us")
        test_dicom_service = azure.healthcare.DicomService("test",
            name="tfexDicom",
            workspace_id=test.id,
            location="east us",
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "environment": "None",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HealthcareApis`: 2024-03-31

        ## Import

        Healthcare DICOM Service can be imported using the resource`id`, e.g.

        ```sh
        $ pulumi import azure:healthcare/dicomService:DicomService example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.HealthcareApis/workspaces/workspace1/dicomServices/service1
        ```

        :param str resource_name: The name of the resource.
        :param DicomServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DicomServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cors: Optional[pulumi.Input[Union['DicomServiceCorsArgs', 'DicomServiceCorsArgsDict']]] = None,
                 data_partitions_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key_url: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['DicomServiceIdentityArgs', 'DicomServiceIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage: Optional[pulumi.Input[Union['DicomServiceStorageArgs', 'DicomServiceStorageArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DicomServiceArgs.__new__(DicomServiceArgs)

            __props__.__dict__["cors"] = cors
            __props__.__dict__["data_partitions_enabled"] = data_partitions_enabled
            __props__.__dict__["encryption_key_url"] = encryption_key_url
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["storage"] = storage
            __props__.__dict__["tags"] = tags
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["authentications"] = None
            __props__.__dict__["private_endpoints"] = None
            __props__.__dict__["service_url"] = None
        super(DicomService, __self__).__init__(
            'azure:healthcare/dicomService:DicomService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DicomServiceAuthenticationArgs', 'DicomServiceAuthenticationArgsDict']]]]] = None,
            cors: Optional[pulumi.Input[Union['DicomServiceCorsArgs', 'DicomServiceCorsArgsDict']]] = None,
            data_partitions_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_key_url: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['DicomServiceIdentityArgs', 'DicomServiceIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DicomServicePrivateEndpointArgs', 'DicomServicePrivateEndpointArgsDict']]]]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            service_url: Optional[pulumi.Input[_builtins.str]] = None,
            storage: Optional[pulumi.Input[Union['DicomServiceStorageArgs', 'DicomServiceStorageArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DicomService':
        """
        Get an existing DicomService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DicomServiceAuthenticationArgs', 'DicomServiceAuthenticationArgsDict']]]] authentications: The `authentication` block as defined below.
        :param pulumi.Input[Union['DicomServiceCorsArgs', 'DicomServiceCorsArgsDict']] cors: A `cors` block as defined below.
        :param pulumi.Input[_builtins.bool] data_partitions_enabled: If data partitions are enabled or not. Defaults to `false`. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.str] encryption_key_url: The URL of the key to use for encryption as part of the customer-managed key encryption settings. For more details, refer to the [Azure Customer-Managed Keys Overview](https://learn.microsoft.com/en-us/azure/storage/common/customer-managed-keys-overview).
        :param pulumi.Input[Union['DicomServiceIdentityArgs', 'DicomServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare DICOM Service should be created. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether to enabled public networks when data plane traffic coming from public networks while private endpoint is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] service_url: The url of the Healthcare DICOM Services.
        :param pulumi.Input[Union['DicomServiceStorageArgs', 'DicomServiceStorageArgsDict']] storage: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Healthcare DICOM Service.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the ID of the Healthcare Workspace where the Healthcare DICOM Service should exist. Changing this forces a new Healthcare DICOM Service to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DicomServiceState.__new__(_DicomServiceState)

        __props__.__dict__["authentications"] = authentications
        __props__.__dict__["cors"] = cors
        __props__.__dict__["data_partitions_enabled"] = data_partitions_enabled
        __props__.__dict__["encryption_key_url"] = encryption_key_url
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["private_endpoints"] = private_endpoints
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["service_url"] = service_url
        __props__.__dict__["storage"] = storage
        __props__.__dict__["tags"] = tags
        __props__.__dict__["workspace_id"] = workspace_id
        return DicomService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> pulumi.Output[Sequence['outputs.DicomServiceAuthentication']]:
        """
        The `authentication` block as defined below.
        """
        return pulumi.get(self, "authentications")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> pulumi.Output['outputs.DicomServiceCors']:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter(name="dataPartitionsEnabled")
    def data_partitions_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If data partitions are enabled or not. Defaults to `false`. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "data_partitions_enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyUrl")
    def encryption_key_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL of the key to use for encryption as part of the customer-managed key encryption settings. For more details, refer to the [Azure Customer-Managed Keys Overview](https://learn.microsoft.com/en-us/azure/storage/common/customer-managed-keys-overview).
        """
        return pulumi.get(self, "encryption_key_url")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.DicomServiceIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Healthcare DICOM Service should be created. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> pulumi.Output[Sequence['outputs.DicomServicePrivateEndpoint']]:
        return pulumi.get(self, "private_endpoints")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enabled public networks when data plane traffic coming from public networks while private endpoint is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> pulumi.Output[_builtins.str]:
        """
        The url of the Healthcare DICOM Services.
        """
        return pulumi.get(self, "service_url")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> pulumi.Output['outputs.DicomServiceStorage']:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the Healthcare DICOM Service.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Healthcare Workspace where the Healthcare DICOM Service should exist. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "workspace_id")

