# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DicomServiceAuthentication',
    'DicomServiceCors',
    'DicomServiceIdentity',
    'DicomServicePrivateEndpoint',
    'DicomServiceStorage',
    'FhirServiceAuthentication',
    'FhirServiceCors',
    'FhirServiceIdentity',
    'FhirServiceOciArtifact',
    'MedtechServiceIdentity',
    'ServiceAuthenticationConfiguration',
    'ServiceCorsConfiguration',
    'ServiceIdentity',
    'WorkspacePrivateEndpointConnection',
    'GetDicomServiceAuthenticationResult',
    'GetDicomServiceCorResult',
    'GetDicomServiceIdentityResult',
    'GetDicomServicePrivateEndpointResult',
    'GetDicomServiceStorageResult',
    'GetFhirServiceAuthenticationResult',
    'GetFhirServiceCorResult',
    'GetFhirServiceIdentityResult',
    'GetMedtechServiceIdentityResult',
    'GetServiceAuthenticationConfigurationResult',
    'GetServiceCorsConfigurationResult',
]

@pulumi.output_type
class DicomServiceAuthentication(dict):
    def __init__(__self__, *,
                 audiences: Optional[Sequence[_builtins.str]] = None,
                 authority: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] audiences: The intended audience to receive authentication tokens for the service. The default value is <https://dicom.azurehealthcareapis.azure.com>
        """
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if authority is not None:
            pulumi.set(__self__, "authority", authority)

    @_builtins.property
    @pulumi.getter
    def audiences(self) -> Optional[Sequence[_builtins.str]]:
        """
        The intended audience to receive authentication tokens for the service. The default value is <https://dicom.azurehealthcareapis.azure.com>
        """
        return pulumi.get(self, "audiences")

    @_builtins.property
    @pulumi.getter
    def authority(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "authority")


@pulumi.output_type
class DicomServiceCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DicomServiceCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DicomServiceCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DicomServiceCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[_builtins.bool] = None,
                 allowed_headers: Optional[Sequence[_builtins.str]] = None,
                 allowed_methods: Optional[Sequence[_builtins.str]] = None,
                 allowed_origins: Optional[Sequence[_builtins.str]] = None,
                 max_age_in_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.bool allow_credentials: Whether to allow credentials in CORS. Defaults to `false`.
        :param Sequence[_builtins.str] allowed_headers: A list of allowed headers for CORS.
        :param Sequence[_builtins.str] allowed_methods: A list of allowed methods for CORS.
        :param Sequence[_builtins.str] allowed_origins: A list of allowed origins for CORS.
        :param _builtins.int max_age_in_seconds: The maximum age in seconds for the CORS configuration (must be between 0 and 99998 inclusive).
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[_builtins.bool]:
        """
        Whether to allow credentials in CORS. Defaults to `false`.
        """
        return pulumi.get(self, "allow_credentials")

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed headers for CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed methods for CORS.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed origins for CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[_builtins.int]:
        """
        The maximum age in seconds for the CORS configuration (must be between 0 and 99998 inclusive).
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class DicomServiceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DicomServiceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DicomServiceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DicomServiceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of identity used for the Healthcare DICOM service. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`. If `UserAssigned` is set, an `identity_ids` must be set as well.
        :param Sequence[_builtins.str] identity_ids: A list of User Assigned Identity IDs which should be assigned to this Healthcare DICOM service.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of identity used for the Healthcare DICOM service. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`. If `UserAssigned` is set, an `identity_ids` must be set as well.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of User Assigned Identity IDs which should be assigned to this Healthcare DICOM service.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class DicomServicePrivateEndpoint(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the Healthcare DICOM Service.
        :param _builtins.str name: Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the Healthcare DICOM Service.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DicomServiceStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemName":
            suggest = "file_system_name"
        elif key == "storageAccountId":
            suggest = "storage_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DicomServiceStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DicomServiceStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DicomServiceStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_name: _builtins.str,
                 storage_account_id: _builtins.str):
        """
        :param _builtins.str file_system_name: The filesystem name of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.
        :param _builtins.str storage_account_id: The resource ID of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.
               
               > **Note:** The `is_hns_enabled` needs to be set to `true` for the storage account to be used with the Healthcare DICOM Service.
        """
        pulumi.set(__self__, "file_system_name", file_system_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> _builtins.str:
        """
        The filesystem name of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "file_system_name")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> _builtins.str:
        """
        The resource ID of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.

        > **Note:** The `is_hns_enabled` needs to be set to `true` for the storage account to be used with the Healthcare DICOM Service.
        """
        return pulumi.get(self, "storage_account_id")


@pulumi.output_type
class FhirServiceAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "smartProxyEnabled":
            suggest = "smart_proxy_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirServiceAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirServiceAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirServiceAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: _builtins.str,
                 authority: _builtins.str,
                 smart_proxy_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str audience: The intended audience to receive authentication tokens for the service.
        :param _builtins.bool smart_proxy_enabled: Whether smart proxy is enabled.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "authority", authority)
        if smart_proxy_enabled is not None:
            pulumi.set(__self__, "smart_proxy_enabled", smart_proxy_enabled)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> _builtins.str:
        """
        The intended audience to receive authentication tokens for the service.
        """
        return pulumi.get(self, "audience")

    @_builtins.property
    @pulumi.getter
    def authority(self) -> _builtins.str:
        return pulumi.get(self, "authority")

    @_builtins.property
    @pulumi.getter(name="smartProxyEnabled")
    def smart_proxy_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether smart proxy is enabled.
        """
        return pulumi.get(self, "smart_proxy_enabled")


@pulumi.output_type
class FhirServiceCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "credentialsAllowed":
            suggest = "credentials_allowed"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirServiceCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirServiceCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirServiceCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_headers: Sequence[_builtins.str],
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 credentials_allowed: Optional[_builtins.bool] = None,
                 max_age_in_seconds: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] allowed_headers: A set of headers to be allowed via CORS.
        :param Sequence[_builtins.str] allowed_methods: The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        :param Sequence[_builtins.str] allowed_origins: A set of origins to be allowed via CORS.
        :param _builtins.bool credentials_allowed: If credentials are allowed via CORS.
        :param _builtins.int max_age_in_seconds: The max age to be allowed via CORS.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if credentials_allowed is not None:
            pulumi.set(__self__, "credentials_allowed", credentials_allowed)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[_builtins.str]:
        """
        A set of headers to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        A set of origins to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="credentialsAllowed")
    def credentials_allowed(self) -> Optional[_builtins.bool]:
        """
        If credentials are allowed via CORS.
        """
        return pulumi.get(self, "credentials_allowed")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[_builtins.int]:
        """
        The max age to be allowed via CORS.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class FhirServiceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirServiceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirServiceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirServiceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of managed identity to assign. Possible values are `UserAssigned` and `SystemAssigned`.
        :param Sequence[_builtins.str] identity_ids: A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of managed identity to assign. Possible values are `UserAssigned` and `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class FhirServiceOciArtifact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginServer":
            suggest = "login_server"
        elif key == "imageName":
            suggest = "image_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirServiceOciArtifact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirServiceOciArtifact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirServiceOciArtifact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 login_server: _builtins.str,
                 digest: Optional[_builtins.str] = None,
                 image_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str login_server: An Azure container registry used for export operations of the service instance.
        :param _builtins.str digest: A digest of an image within Azure container registry used for export operations of the service instance to narrow the artifacts down.
        :param _builtins.str image_name: An image within Azure container registry used for export operations of the service instance.
        """
        pulumi.set(__self__, "login_server", login_server)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)

    @_builtins.property
    @pulumi.getter(name="loginServer")
    def login_server(self) -> _builtins.str:
        """
        An Azure container registry used for export operations of the service instance.
        """
        return pulumi.get(self, "login_server")

    @_builtins.property
    @pulumi.getter
    def digest(self) -> Optional[_builtins.str]:
        """
        A digest of an image within Azure container registry used for export operations of the service instance to narrow the artifacts down.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[_builtins.str]:
        """
        An image within Azure container registry used for export operations of the service instance.
        """
        return pulumi.get(self, "image_name")


@pulumi.output_type
class MedtechServiceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MedtechServiceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MedtechServiceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MedtechServiceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Healthcare Med Tech Service. Possible values are `SystemAssigned`.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Healthcare Med Tech Service.
        :param _builtins.str principal_id: The Principal ID associated with this System Assigned Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this System Assigned Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Healthcare Med Tech Service. Possible values are `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Healthcare Med Tech Service.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ServiceAuthenticationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "smartProxyEnabled":
            suggest = "smart_proxy_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAuthenticationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAuthenticationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAuthenticationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: Optional[_builtins.str] = None,
                 authority: Optional[_builtins.str] = None,
                 smart_proxy_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str audience: The intended audience to receive authentication tokens for the service. The default value is https://azurehealthcareapis.com
        :param _builtins.str authority: The Azure Active Directory (tenant) that serves as the authentication authority to access the service. The default authority is the Directory defined in the authentication scheme in use when running this provider.
               Authority must be registered to Azure AD and in the following format: https://{Azure-AD-endpoint}/{tenant-id}.
        :param _builtins.bool smart_proxy_enabled: (Boolean) Enables the 'SMART on FHIR' option for mobile and web implementations.
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if smart_proxy_enabled is not None:
            pulumi.set(__self__, "smart_proxy_enabled", smart_proxy_enabled)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> Optional[_builtins.str]:
        """
        The intended audience to receive authentication tokens for the service. The default value is https://azurehealthcareapis.com
        """
        return pulumi.get(self, "audience")

    @_builtins.property
    @pulumi.getter
    def authority(self) -> Optional[_builtins.str]:
        """
        The Azure Active Directory (tenant) that serves as the authentication authority to access the service. The default authority is the Directory defined in the authentication scheme in use when running this provider.
        Authority must be registered to Azure AD and in the following format: https://{Azure-AD-endpoint}/{tenant-id}.
        """
        return pulumi.get(self, "authority")

    @_builtins.property
    @pulumi.getter(name="smartProxyEnabled")
    def smart_proxy_enabled(self) -> Optional[_builtins.bool]:
        """
        (Boolean) Enables the 'SMART on FHIR' option for mobile and web implementations.
        """
        return pulumi.get(self, "smart_proxy_enabled")


@pulumi.output_type
class ServiceCorsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCorsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCorsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCorsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[_builtins.bool] = None,
                 allowed_headers: Optional[Sequence[_builtins.str]] = None,
                 allowed_methods: Optional[Sequence[_builtins.str]] = None,
                 allowed_origins: Optional[Sequence[_builtins.str]] = None,
                 max_age_in_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.bool allow_credentials: (Boolean) If credentials are allowed via CORS.
        :param Sequence[_builtins.str] allowed_headers: A set of headers to be allowed via CORS.
        :param Sequence[_builtins.str] allowed_methods: The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        :param Sequence[_builtins.str] allowed_origins: A set of origins to be allowed via CORS.
        :param _builtins.int max_age_in_seconds: The max age to be allowed via CORS.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[_builtins.bool]:
        """
        (Boolean) If credentials are allowed via CORS.
        """
        return pulumi.get(self, "allow_credentials")

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        A set of headers to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[_builtins.str]]:
        """
        The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[Sequence[_builtins.str]]:
        """
        A set of origins to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[_builtins.int]:
        """
        The max age to be allowed via CORS.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class ServiceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of managed identity to assign. The only possible value is `SystemAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of managed identity to assign. The only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class WorkspacePrivateEndpointConnection(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the Healthcare Workspace.
        :param _builtins.str name: Specifies the name of the Healthcare Workspace. Changing this forces a new Healthcare Workspace to be created.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the Healthcare Workspace.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the Healthcare Workspace. Changing this forces a new Healthcare Workspace to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDicomServiceAuthenticationResult(dict):
    def __init__(__self__, *,
                 audiences: Sequence[_builtins.str],
                 authority: _builtins.str):
        """
        :param Sequence[_builtins.str] audiences: The intended audience to receive authentication tokens for the service. The default value is <https://dicom.azurehealthcareapis.azure.com>
        """
        pulumi.set(__self__, "audiences", audiences)
        pulumi.set(__self__, "authority", authority)

    @_builtins.property
    @pulumi.getter
    def audiences(self) -> Sequence[_builtins.str]:
        """
        The intended audience to receive authentication tokens for the service. The default value is <https://dicom.azurehealthcareapis.azure.com>
        """
        return pulumi.get(self, "audiences")

    @_builtins.property
    @pulumi.getter
    def authority(self) -> _builtins.str:
        return pulumi.get(self, "authority")


@pulumi.output_type
class GetDicomServiceCorResult(dict):
    def __init__(__self__, *,
                 allow_credentials: _builtins.bool,
                 allowed_headers: Sequence[_builtins.str],
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 max_age_in_seconds: _builtins.int):
        """
        :param _builtins.bool allow_credentials: Whether to allow credentials in CORS.
        :param Sequence[_builtins.str] allowed_headers: A list of allowed headers for CORS.
        :param Sequence[_builtins.str] allowed_methods: A list of allowed methods for CORS.
        :param Sequence[_builtins.str] allowed_origins: A list of allowed origins for CORS.
        :param _builtins.int max_age_in_seconds: The maximum age in seconds for the CORS configuration.
        """
        pulumi.set(__self__, "allow_credentials", allow_credentials)
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> _builtins.bool:
        """
        Whether to allow credentials in CORS.
        """
        return pulumi.get(self, "allow_credentials")

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[_builtins.str]:
        """
        A list of allowed headers for CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        A list of allowed methods for CORS.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        A list of allowed origins for CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> _builtins.int:
        """
        The maximum age in seconds for the CORS configuration.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class GetDicomServiceIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDicomServicePrivateEndpointResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: The ID of the Healthcare DICOM Service.
        :param _builtins.str name: The name of the Healthcare DICOM Service
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Healthcare DICOM Service.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Healthcare DICOM Service
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDicomServiceStorageResult(dict):
    def __init__(__self__, *,
                 file_system_name: _builtins.str,
                 storage_account_id: _builtins.str):
        """
        :param _builtins.str file_system_name: The filesystem name of connected storage account.
        :param _builtins.str storage_account_id: The resource ID of connected storage account.
        """
        pulumi.set(__self__, "file_system_name", file_system_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> _builtins.str:
        """
        The filesystem name of connected storage account.
        """
        return pulumi.get(self, "file_system_name")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> _builtins.str:
        """
        The resource ID of connected storage account.
        """
        return pulumi.get(self, "storage_account_id")


@pulumi.output_type
class GetFhirServiceAuthenticationResult(dict):
    def __init__(__self__, *,
                 audience: _builtins.str,
                 authority: _builtins.str,
                 smart_proxy_enabled: _builtins.bool):
        """
        :param _builtins.str audience: The intended audience to receive authentication tokens for the service. The default value is `https://<name>.fhir.azurehealthcareapis.com`.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "authority", authority)
        pulumi.set(__self__, "smart_proxy_enabled", smart_proxy_enabled)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> _builtins.str:
        """
        The intended audience to receive authentication tokens for the service. The default value is `https://<name>.fhir.azurehealthcareapis.com`.
        """
        return pulumi.get(self, "audience")

    @_builtins.property
    @pulumi.getter
    def authority(self) -> _builtins.str:
        return pulumi.get(self, "authority")

    @_builtins.property
    @pulumi.getter(name="smartProxyEnabled")
    def smart_proxy_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "smart_proxy_enabled")


@pulumi.output_type
class GetFhirServiceCorResult(dict):
    def __init__(__self__, *,
                 allowed_headers: Sequence[_builtins.str],
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 credentials_allowed: _builtins.bool,
                 max_age_in_seconds: _builtins.int):
        """
        :param Sequence[_builtins.str] allowed_headers: The set of headers to be allowed via CORS.
        :param Sequence[_builtins.str] allowed_methods: The methods to be allowed via CORS.
        :param Sequence[_builtins.str] allowed_origins: The set of origins to be allowed via CORS.
        :param _builtins.bool credentials_allowed: Are credentials allowed via CORS?
        :param _builtins.int max_age_in_seconds: The max age to be allowed via CORS.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "credentials_allowed", credentials_allowed)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[_builtins.str]:
        """
        The set of headers to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        The methods to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        The set of origins to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="credentialsAllowed")
    def credentials_allowed(self) -> _builtins.bool:
        """
        Are credentials allowed via CORS?
        """
        return pulumi.get(self, "credentials_allowed")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> _builtins.int:
        """
        The max age to be allowed via CORS.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class GetFhirServiceIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str principal_id: The Principal ID associated with this System Assigned Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this System Assigned Managed Service Identity.
        :param _builtins.str type: The type of identity used for the Healthcare FHIR service.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID associated with this System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID associated with this System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of identity used for the Healthcare FHIR service.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMedtechServiceIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Healthcare Med Tech Service.
        :param _builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Healthcare Med Tech Service.
        :param _builtins.str type: The type of identity used for the Healthcare Med Tech Service. Possible values are `SystemAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Healthcare Med Tech Service.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Healthcare Med Tech Service.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of identity used for the Healthcare Med Tech Service. Possible values are `SystemAssigned`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceAuthenticationConfigurationResult(dict):
    def __init__(__self__, *,
                 audience: _builtins.str,
                 authority: _builtins.str,
                 smart_proxy_enabled: _builtins.bool):
        """
        :param _builtins.str audience: The intended audience to receive authentication tokens for the service.
        :param _builtins.str authority: The Azure Active Directory (tenant) that serves as the authentication authority to access the service.
        :param _builtins.bool smart_proxy_enabled: Is the 'SMART on FHIR' option for mobile and web implementations enabled?
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "authority", authority)
        pulumi.set(__self__, "smart_proxy_enabled", smart_proxy_enabled)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> _builtins.str:
        """
        The intended audience to receive authentication tokens for the service.
        """
        return pulumi.get(self, "audience")

    @_builtins.property
    @pulumi.getter
    def authority(self) -> _builtins.str:
        """
        The Azure Active Directory (tenant) that serves as the authentication authority to access the service.
        """
        return pulumi.get(self, "authority")

    @_builtins.property
    @pulumi.getter(name="smartProxyEnabled")
    def smart_proxy_enabled(self) -> _builtins.bool:
        """
        Is the 'SMART on FHIR' option for mobile and web implementations enabled?
        """
        return pulumi.get(self, "smart_proxy_enabled")


@pulumi.output_type
class GetServiceCorsConfigurationResult(dict):
    def __init__(__self__, *,
                 allow_credentials: _builtins.bool,
                 allowed_headers: Sequence[_builtins.str],
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 max_age_in_seconds: _builtins.int):
        """
        :param _builtins.bool allow_credentials: Are credentials are allowed via CORS?
        :param Sequence[_builtins.str] allowed_headers: The set of headers to be allowed via CORS.
        :param Sequence[_builtins.str] allowed_methods: The methods to be allowed via CORS.
        :param Sequence[_builtins.str] allowed_origins: The set of origins to be allowed via CORS.
        :param _builtins.int max_age_in_seconds: The max age to be allowed via CORS.
        """
        pulumi.set(__self__, "allow_credentials", allow_credentials)
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> _builtins.bool:
        """
        Are credentials are allowed via CORS?
        """
        return pulumi.get(self, "allow_credentials")

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[_builtins.str]:
        """
        The set of headers to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        The methods to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        The set of origins to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> _builtins.int:
        """
        The max age to be allowed via CORS.
        """
        return pulumi.get(self, "max_age_in_seconds")


