# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FileUploadArgs', 'FileUpload']

@pulumi.input_type
class FileUploadArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[_builtins.str],
                 container_name: pulumi.Input[_builtins.str],
                 iothub_id: pulumi.Input[_builtins.str],
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 notifications_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sas_ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FileUpload resource.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the Azure Storage account to which files are uploaded.
        :param pulumi.Input[_builtins.str] container_name: The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the `connection_string` specified.
        :param pulumi.Input[_builtins.str] iothub_id: The ID of the IoT Hub. Changing this forces a new IoT Hub to be created.
        :param pulumi.Input[_builtins.str] authentication_type: The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] default_ttl: The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the User Managed Identity used to authenticate against the storage account.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.
        :param pulumi.Input[_builtins.str] lock_duration: The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        :param pulumi.Input[_builtins.int] max_delivery_count: The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        :param pulumi.Input[_builtins.bool] notifications_enabled: Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        :param pulumi.Input[_builtins.str] sas_ttl: The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "iothub_id", iothub_id)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if lock_duration is not None:
            pulumi.set(__self__, "lock_duration", lock_duration)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if notifications_enabled is not None:
            pulumi.set(__self__, "notifications_enabled", notifications_enabled)
        if sas_ttl is not None:
            pulumi.set(__self__, "sas_ttl", sas_ttl)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[_builtins.str]:
        """
        The connection string for the Azure Storage account to which files are uploaded.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the `connection_string` specified.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the IoT Hub. Changing this forces a new IoT Hub to be created.
        """
        return pulumi.get(self, "iothub_id")

    @iothub_id.setter
    def iothub_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "iothub_id", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_ttl", value)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the User Managed Identity used to authenticate against the storage account.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="lockDuration")
    def lock_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        """
        return pulumi.get(self, "lock_duration")

    @lock_duration.setter
    def lock_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_duration", value)

    @_builtins.property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        """
        return pulumi.get(self, "max_delivery_count")

    @max_delivery_count.setter
    def max_delivery_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delivery_count", value)

    @_builtins.property
    @pulumi.getter(name="notificationsEnabled")
    def notifications_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        """
        return pulumi.get(self, "notifications_enabled")

    @notifications_enabled.setter
    def notifications_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "notifications_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sasTtl")
    def sas_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "sas_ttl")

    @sas_ttl.setter
    def sas_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_ttl", value)


@pulumi.input_type
class _FileUploadState:
    def __init__(__self__, *,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 notifications_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sas_ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FileUpload resources.
        :param pulumi.Input[_builtins.str] authentication_type: The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the Azure Storage account to which files are uploaded.
        :param pulumi.Input[_builtins.str] container_name: The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the `connection_string` specified.
        :param pulumi.Input[_builtins.str] default_ttl: The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the User Managed Identity used to authenticate against the storage account.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The ID of the IoT Hub. Changing this forces a new IoT Hub to be created.
        :param pulumi.Input[_builtins.str] lock_duration: The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        :param pulumi.Input[_builtins.int] max_delivery_count: The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        :param pulumi.Input[_builtins.bool] notifications_enabled: Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        :param pulumi.Input[_builtins.str] sas_ttl: The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if iothub_id is not None:
            pulumi.set(__self__, "iothub_id", iothub_id)
        if lock_duration is not None:
            pulumi.set(__self__, "lock_duration", lock_duration)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if notifications_enabled is not None:
            pulumi.set(__self__, "notifications_enabled", notifications_enabled)
        if sas_ttl is not None:
            pulumi.set(__self__, "sas_ttl", sas_ttl)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string for the Azure Storage account to which files are uploaded.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the `connection_string` specified.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_ttl", value)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the User Managed Identity used to authenticate against the storage account.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IoT Hub. Changing this forces a new IoT Hub to be created.
        """
        return pulumi.get(self, "iothub_id")

    @iothub_id.setter
    def iothub_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iothub_id", value)

    @_builtins.property
    @pulumi.getter(name="lockDuration")
    def lock_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        """
        return pulumi.get(self, "lock_duration")

    @lock_duration.setter
    def lock_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_duration", value)

    @_builtins.property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        """
        return pulumi.get(self, "max_delivery_count")

    @max_delivery_count.setter
    def max_delivery_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delivery_count", value)

    @_builtins.property
    @pulumi.getter(name="notificationsEnabled")
    def notifications_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        """
        return pulumi.get(self, "notifications_enabled")

    @notifications_enabled.setter
    def notifications_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "notifications_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sasTtl")
    def sas_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "sas_ttl")

    @sas_ttl.setter
    def sas_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_ttl", value)


@pulumi.type_token("azure:iot/fileUpload:FileUpload")
class FileUpload(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 notifications_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sas_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the File Upload of an IoT Hub.

        > **Note:** File upload can be defined either directly on the `iot.IoTHub` resource, or using the `iot.FileUpload` resource - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="examplecontainer",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_io_t_hub = azure.iot.IoTHub("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            })
        example_file_upload = azure.iot.FileUpload("example",
            iothub_id=example_io_t_hub.id,
            connection_string=example_account.primary_blob_connection_string,
            container_name=example_container.name)
        ```

        ## Import

        IoT Hub File Uploads can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/fileUpload:FileUpload example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_type: The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the Azure Storage account to which files are uploaded.
        :param pulumi.Input[_builtins.str] container_name: The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the `connection_string` specified.
        :param pulumi.Input[_builtins.str] default_ttl: The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the User Managed Identity used to authenticate against the storage account.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The ID of the IoT Hub. Changing this forces a new IoT Hub to be created.
        :param pulumi.Input[_builtins.str] lock_duration: The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        :param pulumi.Input[_builtins.int] max_delivery_count: The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        :param pulumi.Input[_builtins.bool] notifications_enabled: Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        :param pulumi.Input[_builtins.str] sas_ttl: The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileUploadArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the File Upload of an IoT Hub.

        > **Note:** File upload can be defined either directly on the `iot.IoTHub` resource, or using the `iot.FileUpload` resource - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="examplecontainer",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_io_t_hub = azure.iot.IoTHub("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            })
        example_file_upload = azure.iot.FileUpload("example",
            iothub_id=example_io_t_hub.id,
            connection_string=example_account.primary_blob_connection_string,
            container_name=example_container.name)
        ```

        ## Import

        IoT Hub File Uploads can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/fileUpload:FileUpload example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1
        ```

        :param str resource_name: The name of the resource.
        :param FileUploadArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileUploadArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 notifications_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sas_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileUploadArgs.__new__(FileUploadArgs)

            __props__.__dict__["authentication_type"] = authentication_type
            if connection_string is None and not opts.urn:
                raise TypeError("Missing required property 'connection_string'")
            __props__.__dict__["connection_string"] = None if connection_string is None else pulumi.Output.secret(connection_string)
            if container_name is None and not opts.urn:
                raise TypeError("Missing required property 'container_name'")
            __props__.__dict__["container_name"] = container_name
            __props__.__dict__["default_ttl"] = default_ttl
            __props__.__dict__["identity_id"] = identity_id
            if iothub_id is None and not opts.urn:
                raise TypeError("Missing required property 'iothub_id'")
            __props__.__dict__["iothub_id"] = iothub_id
            __props__.__dict__["lock_duration"] = lock_duration
            __props__.__dict__["max_delivery_count"] = max_delivery_count
            __props__.__dict__["notifications_enabled"] = notifications_enabled
            __props__.__dict__["sas_ttl"] = sas_ttl
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["connectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FileUpload, __self__).__init__(
            'azure:iot/fileUpload:FileUpload',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            container_name: Optional[pulumi.Input[_builtins.str]] = None,
            default_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            iothub_id: Optional[pulumi.Input[_builtins.str]] = None,
            lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
            max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
            notifications_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            sas_ttl: Optional[pulumi.Input[_builtins.str]] = None) -> 'FileUpload':
        """
        Get an existing FileUpload resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_type: The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the Azure Storage account to which files are uploaded.
        :param pulumi.Input[_builtins.str] container_name: The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the `connection_string` specified.
        :param pulumi.Input[_builtins.str] default_ttl: The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the User Managed Identity used to authenticate against the storage account.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.
        :param pulumi.Input[_builtins.str] iothub_id: The ID of the IoT Hub. Changing this forces a new IoT Hub to be created.
        :param pulumi.Input[_builtins.str] lock_duration: The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        :param pulumi.Input[_builtins.int] max_delivery_count: The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        :param pulumi.Input[_builtins.bool] notifications_enabled: Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        :param pulumi.Input[_builtins.str] sas_ttl: The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileUploadState.__new__(_FileUploadState)

        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["container_name"] = container_name
        __props__.__dict__["default_ttl"] = default_ttl
        __props__.__dict__["identity_id"] = identity_id
        __props__.__dict__["iothub_id"] = iothub_id
        __props__.__dict__["lock_duration"] = lock_duration
        __props__.__dict__["max_delivery_count"] = max_delivery_count
        __props__.__dict__["notifications_enabled"] = notifications_enabled
        __props__.__dict__["sas_ttl"] = sas_ttl
        return FileUpload(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The connection string for the Azure Storage account to which files are uploaded.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the `connection_string` specified.
        """
        return pulumi.get(self, "container_name")

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "default_ttl")

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the User Managed Identity used to authenticate against the storage account.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.
        """
        return pulumi.get(self, "identity_id")

    @_builtins.property
    @pulumi.getter(name="iothubId")
    def iothub_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the IoT Hub. Changing this forces a new IoT Hub to be created.
        """
        return pulumi.get(self, "iothub_id")

    @_builtins.property
    @pulumi.getter(name="lockDuration")
    def lock_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        """
        return pulumi.get(self, "lock_duration")

    @_builtins.property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        """
        return pulumi.get(self, "max_delivery_count")

    @_builtins.property
    @pulumi.getter(name="notificationsEnabled")
    def notifications_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        """
        return pulumi.get(self, "notifications_enabled")

    @_builtins.property
    @pulumi.getter(name="sasTtl")
    def sas_ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "sas_ttl")

