# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretArgs', 'Secret']

@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 key_vault_id: pulumi.Input[_builtins.str],
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_date: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_date: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 value_wo_version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Secret resource.
        :param pulumi.Input[_builtins.str] key_vault_id: The ID of the Key Vault where the Secret should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] content_type: Specifies the content type for the Key Vault Secret.
        :param pulumi.Input[_builtins.str] expiration_date: Expiration UTC datetime (Y-m-d'T'H:M:S'Z').
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault Secret. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] not_before_date: Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] value: Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        :param pulumi.Input[_builtins.int] value_wo_version: An integer value used to trigger an update for `value_wo`. This property should be incremented when updating `value_wo`.
               
               > **Note:** Key Vault strips newlines. To preserve newlines in multi-line secrets try replacing them with `\\n` or by base 64 encoding them with `replace(file("my_secret_file"), "/\\n/", "\\n")` or `base64encode(file("my_secret_file"))`, respectively.
        """
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if not_before_date is not None:
            pulumi.set(__self__, "not_before_date", not_before_date)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_wo_version is not None:
            pulumi.set(__self__, "value_wo_version", value_wo_version)

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Key Vault where the Secret should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the content type for the Key Vault Secret.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration UTC datetime (Y-m-d'T'H:M:S'Z').
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Key Vault Secret. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notBeforeDate")
    def not_before_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').
        """
        return pulumi.get(self, "not_before_date")

    @not_before_date.setter
    def not_before_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_before_date", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="valueWoVersion")
    def value_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer value used to trigger an update for `value_wo`. This property should be incremented when updating `value_wo`.

        > **Note:** Key Vault strips newlines. To preserve newlines in multi-line secrets try replacing them with `\\n` or by base 64 encoding them with `replace(file("my_secret_file"), "/\\n/", "\\n")` or `base64encode(file("my_secret_file"))`, respectively.
        """
        return pulumi.get(self, "value_wo_version")

    @value_wo_version.setter
    def value_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "value_wo_version", value)


@pulumi.input_type
class _SecretState:
    def __init__(__self__, *,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_date: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_date: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_versionless_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 value_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 versionless_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Secret resources.
        :param pulumi.Input[_builtins.str] content_type: Specifies the content type for the Key Vault Secret.
        :param pulumi.Input[_builtins.str] expiration_date: Expiration UTC datetime (Y-m-d'T'H:M:S'Z').
        :param pulumi.Input[_builtins.str] key_vault_id: The ID of the Key Vault where the Secret should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault Secret. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] not_before_date: Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').
        :param pulumi.Input[_builtins.str] resource_id: The (Versioned) ID for this Key Vault Secret. This property points to a specific version of a Key Vault Secret, as such using this won't auto-rotate values if used in other Azure Services.
        :param pulumi.Input[_builtins.str] resource_versionless_id: The Versionless ID of the Key Vault Secret. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Secret is updated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] value: Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        :param pulumi.Input[_builtins.int] value_wo_version: An integer value used to trigger an update for `value_wo`. This property should be incremented when updating `value_wo`.
               
               > **Note:** Key Vault strips newlines. To preserve newlines in multi-line secrets try replacing them with `\\n` or by base 64 encoding them with `replace(file("my_secret_file"), "/\\n/", "\\n")` or `base64encode(file("my_secret_file"))`, respectively.
        :param pulumi.Input[_builtins.str] version: The current version of the Key Vault Secret.
        :param pulumi.Input[_builtins.str] versionless_id: The Base ID of the Key Vault Secret.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if not_before_date is not None:
            pulumi.set(__self__, "not_before_date", not_before_date)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_versionless_id is not None:
            pulumi.set(__self__, "resource_versionless_id", resource_versionless_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_wo_version is not None:
            pulumi.set(__self__, "value_wo_version", value_wo_version)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if versionless_id is not None:
            pulumi.set(__self__, "versionless_id", versionless_id)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the content type for the Key Vault Secret.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration UTC datetime (Y-m-d'T'H:M:S'Z').
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Vault where the Secret should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Key Vault Secret. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notBeforeDate")
    def not_before_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').
        """
        return pulumi.get(self, "not_before_date")

    @not_before_date.setter
    def not_before_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_before_date", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The (Versioned) ID for this Key Vault Secret. This property points to a specific version of a Key Vault Secret, as such using this won't auto-rotate values if used in other Azure Services.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceVersionlessId")
    def resource_versionless_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Versionless ID of the Key Vault Secret. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Secret is updated.
        """
        return pulumi.get(self, "resource_versionless_id")

    @resource_versionless_id.setter
    def resource_versionless_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_versionless_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="valueWoVersion")
    def value_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer value used to trigger an update for `value_wo`. This property should be incremented when updating `value_wo`.

        > **Note:** Key Vault strips newlines. To preserve newlines in multi-line secrets try replacing them with `\\n` or by base 64 encoding them with `replace(file("my_secret_file"), "/\\n/", "\\n")` or `base64encode(file("my_secret_file"))`, respectively.
        """
        return pulumi.get(self, "value_wo_version")

    @value_wo_version.setter
    def value_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "value_wo_version", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current version of the Key Vault Secret.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="versionlessId")
    def versionless_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base ID of the Key Vault Secret.
        """
        return pulumi.get(self, "versionless_id")

    @versionless_id.setter
    def versionless_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "versionless_id", value)


@pulumi.type_token("azure:keyvault/secret:Secret")
class Secret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_date: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_date: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 value_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Key Vault Secret.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "key_permissions": [
                    "Create",
                    "Get",
                ],
                "secret_permissions": [
                    "Set",
                    "Get",
                    "Delete",
                    "Purge",
                    "Recover",
                ],
            }])
        example_secret = azure.keyvault.Secret("example",
            name="secret-sauce",
            value="szechuan",
            key_vault_id=example_key_vault.id)
        ```

        ## Import

        Key Vault Secrets which are Enabled can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/secret:Secret example "https://example-keyvault.vault.azure.net/secrets/example/fdf067c93bbb4b22bff4d8b7a9a56217"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content_type: Specifies the content type for the Key Vault Secret.
        :param pulumi.Input[_builtins.str] expiration_date: Expiration UTC datetime (Y-m-d'T'H:M:S'Z').
        :param pulumi.Input[_builtins.str] key_vault_id: The ID of the Key Vault where the Secret should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault Secret. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] not_before_date: Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] value: Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        :param pulumi.Input[_builtins.int] value_wo_version: An integer value used to trigger an update for `value_wo`. This property should be incremented when updating `value_wo`.
               
               > **Note:** Key Vault strips newlines. To preserve newlines in multi-line secrets try replacing them with `\\n` or by base 64 encoding them with `replace(file("my_secret_file"), "/\\n/", "\\n")` or `base64encode(file("my_secret_file"))`, respectively.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Key Vault Secret.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "key_permissions": [
                    "Create",
                    "Get",
                ],
                "secret_permissions": [
                    "Set",
                    "Get",
                    "Delete",
                    "Purge",
                    "Recover",
                ],
            }])
        example_secret = azure.keyvault.Secret("example",
            name="secret-sauce",
            value="szechuan",
            key_vault_id=example_key_vault.id)
        ```

        ## Import

        Key Vault Secrets which are Enabled can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/secret:Secret example "https://example-keyvault.vault.azure.net/secrets/example/fdf067c93bbb4b22bff4d8b7a9a56217"
        ```

        :param str resource_name: The name of the resource.
        :param SecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_date: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before_date: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 value_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretArgs.__new__(SecretArgs)

            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["expiration_date"] = expiration_date
            if key_vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_vault_id'")
            __props__.__dict__["key_vault_id"] = key_vault_id
            __props__.__dict__["name"] = name
            __props__.__dict__["not_before_date"] = not_before_date
            __props__.__dict__["tags"] = tags
            __props__.__dict__["value"] = None if value is None else pulumi.Output.secret(value)
            __props__.__dict__["value_wo_version"] = value_wo_version
            __props__.__dict__["resource_id"] = None
            __props__.__dict__["resource_versionless_id"] = None
            __props__.__dict__["version"] = None
            __props__.__dict__["versionless_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["value"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Secret, __self__).__init__(
            'azure:keyvault/secret:Secret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content_type: Optional[pulumi.Input[_builtins.str]] = None,
            expiration_date: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            not_before_date: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_versionless_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None,
            value_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            versionless_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Secret':
        """
        Get an existing Secret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content_type: Specifies the content type for the Key Vault Secret.
        :param pulumi.Input[_builtins.str] expiration_date: Expiration UTC datetime (Y-m-d'T'H:M:S'Z').
        :param pulumi.Input[_builtins.str] key_vault_id: The ID of the Key Vault where the Secret should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault Secret. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] not_before_date: Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').
        :param pulumi.Input[_builtins.str] resource_id: The (Versioned) ID for this Key Vault Secret. This property points to a specific version of a Key Vault Secret, as such using this won't auto-rotate values if used in other Azure Services.
        :param pulumi.Input[_builtins.str] resource_versionless_id: The Versionless ID of the Key Vault Secret. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Secret is updated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] value: Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        :param pulumi.Input[_builtins.int] value_wo_version: An integer value used to trigger an update for `value_wo`. This property should be incremented when updating `value_wo`.
               
               > **Note:** Key Vault strips newlines. To preserve newlines in multi-line secrets try replacing them with `\\n` or by base 64 encoding them with `replace(file("my_secret_file"), "/\\n/", "\\n")` or `base64encode(file("my_secret_file"))`, respectively.
        :param pulumi.Input[_builtins.str] version: The current version of the Key Vault Secret.
        :param pulumi.Input[_builtins.str] versionless_id: The Base ID of the Key Vault Secret.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretState.__new__(_SecretState)

        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["key_vault_id"] = key_vault_id
        __props__.__dict__["name"] = name
        __props__.__dict__["not_before_date"] = not_before_date
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_versionless_id"] = resource_versionless_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["value"] = value
        __props__.__dict__["value_wo_version"] = value_wo_version
        __props__.__dict__["version"] = version
        __props__.__dict__["versionless_id"] = versionless_id
        return Secret(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the content type for the Key Vault Secret.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Expiration UTC datetime (Y-m-d'T'H:M:S'Z').
        """
        return pulumi.get(self, "expiration_date")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Key Vault where the Secret should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Key Vault Secret. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notBeforeDate")
    def not_before_date(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Key not usable before the provided UTC datetime (Y-m-d'T'H:M:S'Z').
        """
        return pulumi.get(self, "not_before_date")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The (Versioned) ID for this Key Vault Secret. This property points to a specific version of a Key Vault Secret, as such using this won't auto-rotate values if used in other Azure Services.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceVersionlessId")
    def resource_versionless_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Versionless ID of the Key Vault Secret. This property allows other Azure Services (that support it) to auto-rotate their value when the Key Vault Secret is updated.
        """
        return pulumi.get(self, "resource_versionless_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the value of the Key Vault Secret. Changing this will create a new version of the Key Vault Secret.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueWoVersion")
    def value_wo_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        An integer value used to trigger an update for `value_wo`. This property should be incremented when updating `value_wo`.

        > **Note:** Key Vault strips newlines. To preserve newlines in multi-line secrets try replacing them with `\\n` or by base 64 encoding them with `replace(file("my_secret_file"), "/\\n/", "\\n")` or `base64encode(file("my_secret_file"))`, respectively.
        """
        return pulumi.get(self, "value_wo_version")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The current version of the Key Vault Secret.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionlessId")
    def versionless_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Base ID of the Key Vault Secret.
        """
        return pulumi.get(self, "versionless_id")

