# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'LoadTestEncryptionArgs',
    'LoadTestEncryptionArgsDict',
    'LoadTestEncryptionIdentityArgs',
    'LoadTestEncryptionIdentityArgsDict',
    'LoadTestIdentityArgs',
    'LoadTestIdentityArgsDict',
]

MYPY = False

if not MYPY:
    class LoadTestEncryptionArgsDict(TypedDict):
        identity: pulumi.Input['LoadTestEncryptionIdentityArgsDict']
        """
        An `identity` block as defined below. Changing this forces a new Load Test to be created.
        """
        key_url: pulumi.Input[_builtins.str]
        """
        The URI specifying the Key vault and key to be used to encrypt data in this resource. The URI should include the key version. Changing this forces a new Load Test to be created.
        """
elif False:
    LoadTestEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadTestEncryptionArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input['LoadTestEncryptionIdentityArgs'],
                 key_url: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input['LoadTestEncryptionIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Load Test to be created.
        :param pulumi.Input[_builtins.str] key_url: The URI specifying the Key vault and key to be used to encrypt data in this resource. The URI should include the key version. Changing this forces a new Load Test to be created.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "key_url", key_url)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input['LoadTestEncryptionIdentityArgs']:
        """
        An `identity` block as defined below. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['LoadTestEncryptionIdentityArgs']):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> pulumi.Input[_builtins.str]:
        """
        The URI specifying the Key vault and key to be used to encrypt data in this resource. The URI should include the key version. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "key_url")

    @key_url.setter
    def key_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_url", value)


if not MYPY:
    class LoadTestEncryptionIdentityArgsDict(TypedDict):
        identity_id: pulumi.Input[_builtins.str]
        """
        The User Assigned Identity ID that should be assigned to this Load Test Encryption. Changing this forces a new Load Test to be created.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Identity that should be assigned to this Load Test Encryption. Possible values are `SystemAssigned` or `UserAssigned`. Changing this forces a new Load Test to be created.
        """
elif False:
    LoadTestEncryptionIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadTestEncryptionIdentityArgs:
    def __init__(__self__, *,
                 identity_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] identity_id: The User Assigned Identity ID that should be assigned to this Load Test Encryption. Changing this forces a new Load Test to be created.
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Identity that should be assigned to this Load Test Encryption. Possible values are `SystemAssigned` or `UserAssigned`. Changing this forces a new Load Test to be created.
        """
        pulumi.set(__self__, "identity_id", identity_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> pulumi.Input[_builtins.str]:
        """
        The User Assigned Identity ID that should be assigned to this Load Test Encryption. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Identity that should be assigned to this Load Test Encryption. Possible values are `SystemAssigned` or `UserAssigned`. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class LoadTestIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Identity that should be assigned to this Load Test Encryption. Possible values are `SystemAssigned` or `UserAssigned`. Changing this forces a new Load Test to be created.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of the User Assigned Identity IDs that should be assigned to this Load Test.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID for the System-Assigned Managed Identity assigned to this Load Test.
        *
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID for the System-Assigned Managed Identity assigned to this Load Test.
        """
elif False:
    LoadTestIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadTestIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Identity that should be assigned to this Load Test Encryption. Possible values are `SystemAssigned` or `UserAssigned`. Changing this forces a new Load Test to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of the User Assigned Identity IDs that should be assigned to this Load Test.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID for the System-Assigned Managed Identity assigned to this Load Test.
               *
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID for the System-Assigned Managed Identity assigned to this Load Test.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Identity that should be assigned to this Load Test Encryption. Possible values are `SystemAssigned` or `UserAssigned`. Changing this forces a new Load Test to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the User Assigned Identity IDs that should be assigned to this Load Test.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID for the System-Assigned Managed Identity assigned to this Load Test.
        *
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID for the System-Assigned Managed Identity assigned to this Load Test.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


