# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationAccountAgreementArgs', 'IntegrationAccountAgreement']

@pulumi.input_type
class IntegrationAccountAgreementArgs:
    def __init__(__self__, *,
                 agreement_type: pulumi.Input[_builtins.str],
                 content: pulumi.Input[_builtins.str],
                 guest_identity: pulumi.Input['IntegrationAccountAgreementGuestIdentityArgs'],
                 guest_partner_name: pulumi.Input[_builtins.str],
                 host_identity: pulumi.Input['IntegrationAccountAgreementHostIdentityArgs'],
                 host_partner_name: pulumi.Input[_builtins.str],
                 integration_account_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IntegrationAccountAgreement resource.
        :param pulumi.Input[_builtins.str] agreement_type: The type of the Logic App Integration Account Agreement. Possible values are `AS2`, `X12` and `Edifact`.
        :param pulumi.Input[_builtins.str] content: The content of the Logic App Integration Account Agreement.
        :param pulumi.Input['IntegrationAccountAgreementGuestIdentityArgs'] guest_identity: A `guest_identity` block as documented below.
        :param pulumi.Input[_builtins.str] guest_partner_name: The name of the guest Logic App Integration Account Partner.
        :param pulumi.Input['IntegrationAccountAgreementHostIdentityArgs'] host_identity: A `host_identity` block as documented below.
        :param pulumi.Input[_builtins.str] host_partner_name: The name of the host Logic App Integration Account Partner.
        :param pulumi.Input[_builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Agreement should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The metadata of the Logic App Integration Account Agreement.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account Agreement. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "agreement_type", agreement_type)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "guest_identity", guest_identity)
        pulumi.set(__self__, "guest_partner_name", guest_partner_name)
        pulumi.set(__self__, "host_identity", host_identity)
        pulumi.set(__self__, "host_partner_name", host_partner_name)
        pulumi.set(__self__, "integration_account_name", integration_account_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="agreementType")
    def agreement_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the Logic App Integration Account Agreement. Possible values are `AS2`, `X12` and `Edifact`.
        """
        return pulumi.get(self, "agreement_type")

    @agreement_type.setter
    def agreement_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agreement_type", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        The content of the Logic App Integration Account Agreement.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="guestIdentity")
    def guest_identity(self) -> pulumi.Input['IntegrationAccountAgreementGuestIdentityArgs']:
        """
        A `guest_identity` block as documented below.
        """
        return pulumi.get(self, "guest_identity")

    @guest_identity.setter
    def guest_identity(self, value: pulumi.Input['IntegrationAccountAgreementGuestIdentityArgs']):
        pulumi.set(self, "guest_identity", value)

    @_builtins.property
    @pulumi.getter(name="guestPartnerName")
    def guest_partner_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the guest Logic App Integration Account Partner.
        """
        return pulumi.get(self, "guest_partner_name")

    @guest_partner_name.setter
    def guest_partner_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "guest_partner_name", value)

    @_builtins.property
    @pulumi.getter(name="hostIdentity")
    def host_identity(self) -> pulumi.Input['IntegrationAccountAgreementHostIdentityArgs']:
        """
        A `host_identity` block as documented below.
        """
        return pulumi.get(self, "host_identity")

    @host_identity.setter
    def host_identity(self, value: pulumi.Input['IntegrationAccountAgreementHostIdentityArgs']):
        pulumi.set(self, "host_identity", value)

    @_builtins.property
    @pulumi.getter(name="hostPartnerName")
    def host_partner_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the host Logic App Integration Account Partner.
        """
        return pulumi.get(self, "host_partner_name")

    @host_partner_name.setter
    def host_partner_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_partner_name", value)

    @_builtins.property
    @pulumi.getter(name="integrationAccountName")
    def integration_account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Logic App Integration Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "integration_account_name")

    @integration_account_name.setter
    def integration_account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "integration_account_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Logic App Integration Account Agreement should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The metadata of the Logic App Integration Account Agreement.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Logic App Integration Account Agreement. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _IntegrationAccountAgreementState:
    def __init__(__self__, *,
                 agreement_type: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_identity: Optional[pulumi.Input['IntegrationAccountAgreementGuestIdentityArgs']] = None,
                 guest_partner_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host_identity: Optional[pulumi.Input['IntegrationAccountAgreementHostIdentityArgs']] = None,
                 host_partner_name: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IntegrationAccountAgreement resources.
        :param pulumi.Input[_builtins.str] agreement_type: The type of the Logic App Integration Account Agreement. Possible values are `AS2`, `X12` and `Edifact`.
        :param pulumi.Input[_builtins.str] content: The content of the Logic App Integration Account Agreement.
        :param pulumi.Input['IntegrationAccountAgreementGuestIdentityArgs'] guest_identity: A `guest_identity` block as documented below.
        :param pulumi.Input[_builtins.str] guest_partner_name: The name of the guest Logic App Integration Account Partner.
        :param pulumi.Input['IntegrationAccountAgreementHostIdentityArgs'] host_identity: A `host_identity` block as documented below.
        :param pulumi.Input[_builtins.str] host_partner_name: The name of the host Logic App Integration Account Partner.
        :param pulumi.Input[_builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The metadata of the Logic App Integration Account Agreement.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account Agreement. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Agreement should exist. Changing this forces a new resource to be created.
        """
        if agreement_type is not None:
            pulumi.set(__self__, "agreement_type", agreement_type)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if guest_identity is not None:
            pulumi.set(__self__, "guest_identity", guest_identity)
        if guest_partner_name is not None:
            pulumi.set(__self__, "guest_partner_name", guest_partner_name)
        if host_identity is not None:
            pulumi.set(__self__, "host_identity", host_identity)
        if host_partner_name is not None:
            pulumi.set(__self__, "host_partner_name", host_partner_name)
        if integration_account_name is not None:
            pulumi.set(__self__, "integration_account_name", integration_account_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="agreementType")
    def agreement_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Logic App Integration Account Agreement. Possible values are `AS2`, `X12` and `Edifact`.
        """
        return pulumi.get(self, "agreement_type")

    @agreement_type.setter
    def agreement_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agreement_type", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the Logic App Integration Account Agreement.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="guestIdentity")
    def guest_identity(self) -> Optional[pulumi.Input['IntegrationAccountAgreementGuestIdentityArgs']]:
        """
        A `guest_identity` block as documented below.
        """
        return pulumi.get(self, "guest_identity")

    @guest_identity.setter
    def guest_identity(self, value: Optional[pulumi.Input['IntegrationAccountAgreementGuestIdentityArgs']]):
        pulumi.set(self, "guest_identity", value)

    @_builtins.property
    @pulumi.getter(name="guestPartnerName")
    def guest_partner_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the guest Logic App Integration Account Partner.
        """
        return pulumi.get(self, "guest_partner_name")

    @guest_partner_name.setter
    def guest_partner_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_partner_name", value)

    @_builtins.property
    @pulumi.getter(name="hostIdentity")
    def host_identity(self) -> Optional[pulumi.Input['IntegrationAccountAgreementHostIdentityArgs']]:
        """
        A `host_identity` block as documented below.
        """
        return pulumi.get(self, "host_identity")

    @host_identity.setter
    def host_identity(self, value: Optional[pulumi.Input['IntegrationAccountAgreementHostIdentityArgs']]):
        pulumi.set(self, "host_identity", value)

    @_builtins.property
    @pulumi.getter(name="hostPartnerName")
    def host_partner_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the host Logic App Integration Account Partner.
        """
        return pulumi.get(self, "host_partner_name")

    @host_partner_name.setter
    def host_partner_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_partner_name", value)

    @_builtins.property
    @pulumi.getter(name="integrationAccountName")
    def integration_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Logic App Integration Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "integration_account_name")

    @integration_account_name.setter
    def integration_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_account_name", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The metadata of the Logic App Integration Account Agreement.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Logic App Integration Account Agreement. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Logic App Integration Account Agreement should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:logicapps/integrationAccountAgreement:IntegrationAccountAgreement")
class IntegrationAccountAgreement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agreement_type: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_identity: Optional[pulumi.Input[Union['IntegrationAccountAgreementGuestIdentityArgs', 'IntegrationAccountAgreementGuestIdentityArgsDict']]] = None,
                 guest_partner_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host_identity: Optional[pulumi.Input[Union['IntegrationAccountAgreementHostIdentityArgs', 'IntegrationAccountAgreementHostIdentityArgsDict']]] = None,
                 host_partner_name: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Logic App Integration Account Agreement.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        test = azure.logicapps.IntegrationAccount("test",
            name="example-ia",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Standard")
        host = azure.logicapps.IntegrationAccountPartner("host",
            name="example-hostpartner",
            resource_group_name=example.name,
            integration_account_name=test.name,
            business_identities=[{
                "qualifier": "AS2Identity",
                "value": "FabrikamNY",
            }])
        guest = azure.logicapps.IntegrationAccountPartner("guest",
            name="example-guestpartner",
            resource_group_name=example.name,
            integration_account_name=test.name,
            business_identities=[{
                "qualifier": "AS2Identity",
                "value": "FabrikamDC",
            }])
        test_integration_account_agreement = azure.logicapps.IntegrationAccountAgreement("test",
            name="example-agreement",
            resource_group_name=example.name,
            integration_account_name=test.name,
            agreement_type="AS2",
            host_partner_name=host.name,
            guest_partner_name=guest.name,
            content=std.file(input="testdata/integration_account_agreement_content_as2.json").result,
            host_identity={
                "qualifier": "AS2Identity",
                "value": "FabrikamNY",
            },
            guest_identity={
                "qualifier": "AS2Identity",
                "value": "FabrikamDC",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Logic`: 2019-05-01

        ## Import

        Logic App Integration Account Agreements can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/integrationAccountAgreement:IntegrationAccountAgreement example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Logic/integrationAccounts/account1/agreements/agreement1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agreement_type: The type of the Logic App Integration Account Agreement. Possible values are `AS2`, `X12` and `Edifact`.
        :param pulumi.Input[_builtins.str] content: The content of the Logic App Integration Account Agreement.
        :param pulumi.Input[Union['IntegrationAccountAgreementGuestIdentityArgs', 'IntegrationAccountAgreementGuestIdentityArgsDict']] guest_identity: A `guest_identity` block as documented below.
        :param pulumi.Input[_builtins.str] guest_partner_name: The name of the guest Logic App Integration Account Partner.
        :param pulumi.Input[Union['IntegrationAccountAgreementHostIdentityArgs', 'IntegrationAccountAgreementHostIdentityArgsDict']] host_identity: A `host_identity` block as documented below.
        :param pulumi.Input[_builtins.str] host_partner_name: The name of the host Logic App Integration Account Partner.
        :param pulumi.Input[_builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The metadata of the Logic App Integration Account Agreement.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account Agreement. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Agreement should exist. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationAccountAgreementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Logic App Integration Account Agreement.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        test = azure.logicapps.IntegrationAccount("test",
            name="example-ia",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Standard")
        host = azure.logicapps.IntegrationAccountPartner("host",
            name="example-hostpartner",
            resource_group_name=example.name,
            integration_account_name=test.name,
            business_identities=[{
                "qualifier": "AS2Identity",
                "value": "FabrikamNY",
            }])
        guest = azure.logicapps.IntegrationAccountPartner("guest",
            name="example-guestpartner",
            resource_group_name=example.name,
            integration_account_name=test.name,
            business_identities=[{
                "qualifier": "AS2Identity",
                "value": "FabrikamDC",
            }])
        test_integration_account_agreement = azure.logicapps.IntegrationAccountAgreement("test",
            name="example-agreement",
            resource_group_name=example.name,
            integration_account_name=test.name,
            agreement_type="AS2",
            host_partner_name=host.name,
            guest_partner_name=guest.name,
            content=std.file(input="testdata/integration_account_agreement_content_as2.json").result,
            host_identity={
                "qualifier": "AS2Identity",
                "value": "FabrikamNY",
            },
            guest_identity={
                "qualifier": "AS2Identity",
                "value": "FabrikamDC",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Logic`: 2019-05-01

        ## Import

        Logic App Integration Account Agreements can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/integrationAccountAgreement:IntegrationAccountAgreement example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Logic/integrationAccounts/account1/agreements/agreement1
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationAccountAgreementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationAccountAgreementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agreement_type: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_identity: Optional[pulumi.Input[Union['IntegrationAccountAgreementGuestIdentityArgs', 'IntegrationAccountAgreementGuestIdentityArgsDict']]] = None,
                 guest_partner_name: Optional[pulumi.Input[_builtins.str]] = None,
                 host_identity: Optional[pulumi.Input[Union['IntegrationAccountAgreementHostIdentityArgs', 'IntegrationAccountAgreementHostIdentityArgsDict']]] = None,
                 host_partner_name: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationAccountAgreementArgs.__new__(IntegrationAccountAgreementArgs)

            if agreement_type is None and not opts.urn:
                raise TypeError("Missing required property 'agreement_type'")
            __props__.__dict__["agreement_type"] = agreement_type
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            if guest_identity is None and not opts.urn:
                raise TypeError("Missing required property 'guest_identity'")
            __props__.__dict__["guest_identity"] = guest_identity
            if guest_partner_name is None and not opts.urn:
                raise TypeError("Missing required property 'guest_partner_name'")
            __props__.__dict__["guest_partner_name"] = guest_partner_name
            if host_identity is None and not opts.urn:
                raise TypeError("Missing required property 'host_identity'")
            __props__.__dict__["host_identity"] = host_identity
            if host_partner_name is None and not opts.urn:
                raise TypeError("Missing required property 'host_partner_name'")
            __props__.__dict__["host_partner_name"] = host_partner_name
            if integration_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'integration_account_name'")
            __props__.__dict__["integration_account_name"] = integration_account_name
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        super(IntegrationAccountAgreement, __self__).__init__(
            'azure:logicapps/integrationAccountAgreement:IntegrationAccountAgreement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agreement_type: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            guest_identity: Optional[pulumi.Input[Union['IntegrationAccountAgreementGuestIdentityArgs', 'IntegrationAccountAgreementGuestIdentityArgsDict']]] = None,
            guest_partner_name: Optional[pulumi.Input[_builtins.str]] = None,
            host_identity: Optional[pulumi.Input[Union['IntegrationAccountAgreementHostIdentityArgs', 'IntegrationAccountAgreementHostIdentityArgsDict']]] = None,
            host_partner_name: Optional[pulumi.Input[_builtins.str]] = None,
            integration_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'IntegrationAccountAgreement':
        """
        Get an existing IntegrationAccountAgreement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agreement_type: The type of the Logic App Integration Account Agreement. Possible values are `AS2`, `X12` and `Edifact`.
        :param pulumi.Input[_builtins.str] content: The content of the Logic App Integration Account Agreement.
        :param pulumi.Input[Union['IntegrationAccountAgreementGuestIdentityArgs', 'IntegrationAccountAgreementGuestIdentityArgsDict']] guest_identity: A `guest_identity` block as documented below.
        :param pulumi.Input[_builtins.str] guest_partner_name: The name of the guest Logic App Integration Account Partner.
        :param pulumi.Input[Union['IntegrationAccountAgreementHostIdentityArgs', 'IntegrationAccountAgreementHostIdentityArgsDict']] host_identity: A `host_identity` block as documented below.
        :param pulumi.Input[_builtins.str] host_partner_name: The name of the host Logic App Integration Account Partner.
        :param pulumi.Input[_builtins.str] integration_account_name: The name of the Logic App Integration Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: The metadata of the Logic App Integration Account Agreement.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account Agreement. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account Agreement should exist. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationAccountAgreementState.__new__(_IntegrationAccountAgreementState)

        __props__.__dict__["agreement_type"] = agreement_type
        __props__.__dict__["content"] = content
        __props__.__dict__["guest_identity"] = guest_identity
        __props__.__dict__["guest_partner_name"] = guest_partner_name
        __props__.__dict__["host_identity"] = host_identity
        __props__.__dict__["host_partner_name"] = host_partner_name
        __props__.__dict__["integration_account_name"] = integration_account_name
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        return IntegrationAccountAgreement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agreementType")
    def agreement_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Logic App Integration Account Agreement. Possible values are `AS2`, `X12` and `Edifact`.
        """
        return pulumi.get(self, "agreement_type")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the Logic App Integration Account Agreement.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="guestIdentity")
    def guest_identity(self) -> pulumi.Output['outputs.IntegrationAccountAgreementGuestIdentity']:
        """
        A `guest_identity` block as documented below.
        """
        return pulumi.get(self, "guest_identity")

    @_builtins.property
    @pulumi.getter(name="guestPartnerName")
    def guest_partner_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the guest Logic App Integration Account Partner.
        """
        return pulumi.get(self, "guest_partner_name")

    @_builtins.property
    @pulumi.getter(name="hostIdentity")
    def host_identity(self) -> pulumi.Output['outputs.IntegrationAccountAgreementHostIdentity']:
        """
        A `host_identity` block as documented below.
        """
        return pulumi.get(self, "host_identity")

    @_builtins.property
    @pulumi.getter(name="hostPartnerName")
    def host_partner_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the host Logic App Integration Account Partner.
        """
        return pulumi.get(self, "host_partner_name")

    @_builtins.property
    @pulumi.getter(name="integrationAccountName")
    def integration_account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Logic App Integration Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "integration_account_name")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The metadata of the Logic App Integration Account Agreement.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Logic App Integration Account Agreement. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Logic App Integration Account Agreement should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

