# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceNetworkOutboundRuleFqdnArgs', 'WorkspaceNetworkOutboundRuleFqdn']

@pulumi.input_type
class WorkspaceNetworkOutboundRuleFqdnArgs:
    def __init__(__self__, *,
                 destination_fqdn: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceNetworkOutboundRuleFqdn resource.
        :param pulumi.Input[_builtins.str] destination_fqdn: Specifies the fully qualified domain name to allow for outbound traffic.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the ID of the Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Machine Learning Workspace FQDN Network Outbound Rule. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "destination_fqdn", destination_fqdn)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="destinationFqdn")
    def destination_fqdn(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the fully qualified domain name to allow for outbound traffic.
        """
        return pulumi.get(self, "destination_fqdn")

    @destination_fqdn.setter
    def destination_fqdn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_fqdn", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Machine Learning Workspace FQDN Network Outbound Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _WorkspaceNetworkOutboundRuleFqdnState:
    def __init__(__self__, *,
                 destination_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceNetworkOutboundRuleFqdn resources.
        :param pulumi.Input[_builtins.str] destination_fqdn: Specifies the fully qualified domain name to allow for outbound traffic.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Machine Learning Workspace FQDN Network Outbound Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the ID of the Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        if destination_fqdn is not None:
            pulumi.set(__self__, "destination_fqdn", destination_fqdn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="destinationFqdn")
    def destination_fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the fully qualified domain name to allow for outbound traffic.
        """
        return pulumi.get(self, "destination_fqdn")

    @destination_fqdn.setter
    def destination_fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_fqdn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Machine Learning Workspace FQDN Network Outbound Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:machinelearning/workspaceNetworkOutboundRuleFqdn:WorkspaceNetworkOutboundRuleFqdn")
class WorkspaceNetworkOutboundRuleFqdn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Machine Learning Workspace FQDN Network Outbound Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="workspace-example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="workspaceexamplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium")
        example_account = azure.storage.Account("example",
            name="workspacestorageaccount",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="GRS")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            managed_network={
                "isolation_mode": "AllowOnlyApprovedOutbound",
            },
            identity={
                "type": "SystemAssigned",
            })
        example_workspace_network_outbound_rule_fqdn = azure.machinelearning.WorkspaceNetworkOutboundRuleFqdn("example",
            name="example-outboundrule",
            workspace_id=example_workspace.id,
            destination_fqdn="example.com")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices`: 2024-04-01

        ## Import

        Machine Learning Workspace FQDN Network Outbound Rule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:machinelearning/workspaceNetworkOutboundRuleFqdn:WorkspaceNetworkOutboundRuleFqdn example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.MachineLearningServices/workspaces/workspace1/outboundRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] destination_fqdn: Specifies the fully qualified domain name to allow for outbound traffic.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Machine Learning Workspace FQDN Network Outbound Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the ID of the Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceNetworkOutboundRuleFqdnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Machine Learning Workspace FQDN Network Outbound Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="workspace-example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="workspaceexamplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium")
        example_account = azure.storage.Account("example",
            name="workspacestorageaccount",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="GRS")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            managed_network={
                "isolation_mode": "AllowOnlyApprovedOutbound",
            },
            identity={
                "type": "SystemAssigned",
            })
        example_workspace_network_outbound_rule_fqdn = azure.machinelearning.WorkspaceNetworkOutboundRuleFqdn("example",
            name="example-outboundrule",
            workspace_id=example_workspace.id,
            destination_fqdn="example.com")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices`: 2024-04-01

        ## Import

        Machine Learning Workspace FQDN Network Outbound Rule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:machinelearning/workspaceNetworkOutboundRuleFqdn:WorkspaceNetworkOutboundRuleFqdn example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.MachineLearningServices/workspaces/workspace1/outboundRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceNetworkOutboundRuleFqdnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceNetworkOutboundRuleFqdnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceNetworkOutboundRuleFqdnArgs.__new__(WorkspaceNetworkOutboundRuleFqdnArgs)

            if destination_fqdn is None and not opts.urn:
                raise TypeError("Missing required property 'destination_fqdn'")
            __props__.__dict__["destination_fqdn"] = destination_fqdn
            __props__.__dict__["name"] = name
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(WorkspaceNetworkOutboundRuleFqdn, __self__).__init__(
            'azure:machinelearning/workspaceNetworkOutboundRuleFqdn:WorkspaceNetworkOutboundRuleFqdn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destination_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceNetworkOutboundRuleFqdn':
        """
        Get an existing WorkspaceNetworkOutboundRuleFqdn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] destination_fqdn: Specifies the fully qualified domain name to allow for outbound traffic.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Machine Learning Workspace FQDN Network Outbound Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workspace_id: Specifies the ID of the Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceNetworkOutboundRuleFqdnState.__new__(_WorkspaceNetworkOutboundRuleFqdnState)

        __props__.__dict__["destination_fqdn"] = destination_fqdn
        __props__.__dict__["name"] = name
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceNetworkOutboundRuleFqdn(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="destinationFqdn")
    def destination_fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the fully qualified domain name to allow for outbound traffic.
        """
        return pulumi.get(self, "destination_fqdn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Machine Learning Workspace FQDN Network Outbound Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workspace_id")

