# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FileSystemArgs', 'FileSystem']

@pulumi.input_type
class FileSystemArgs:
    def __init__(__self__, *,
                 maintenance_window: pulumi.Input['FileSystemMaintenanceWindowArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 storage_capacity_in_tb: pulumi.Input[_builtins.int],
                 subnet_id: pulumi.Input[_builtins.str],
                 zones: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 encryption_key: Optional[pulumi.Input['FileSystemEncryptionKeyArgs']] = None,
                 hsm_setting: Optional[pulumi.Input['FileSystemHsmSettingArgs']] = None,
                 identity: Optional[pulumi.Input['FileSystemIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a FileSystem resource.
        :param pulumi.Input['FileSystemMaintenanceWindowArgs'] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU name for the Azure Managed Lustre File System. Possible values are `AMLFS-Durable-Premium-40`, `AMLFS-Durable-Premium-125`, `AMLFS-Durable-Premium-250` and `AMLFS-Durable-Premium-500`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_capacity_in_tb: The size of the Azure Managed Lustre File System in TiB. The valid values for this field are dependant on which `sku_name` has been defined in the configuration file. For more information on the valid values for this field please see the [product documentation](https://learn.microsoft.com/azure/azure-managed-lustre/create-file-system-resource-manager#file-system-type-and-size-options). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The resource ID of the Subnet that is used for managing the Azure Managed Lustre file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the Virtual Network's address space. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: A list of availability zones for the Azure Managed Lustre File System. Changing this forces a new resource to be created.
        :param pulumi.Input['FileSystemEncryptionKeyArgs'] encryption_key: An `encryption_key` block as defined below.
               
               > **Note:** Removing `encryption_key` forces a new resource to be created.
        :param pulumi.Input['FileSystemHsmSettingArgs'] hsm_setting: A `hsm_setting` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['FileSystemIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Managed Lustre File System. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Managed Lustre File System.
        """
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "storage_capacity_in_tb", storage_capacity_in_tb)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "zones", zones)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if hsm_setting is not None:
            pulumi.set(__self__, "hsm_setting", hsm_setting)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Input['FileSystemMaintenanceWindowArgs']:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: pulumi.Input['FileSystemMaintenanceWindowArgs']):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU name for the Azure Managed Lustre File System. Possible values are `AMLFS-Durable-Premium-40`, `AMLFS-Durable-Premium-125`, `AMLFS-Durable-Premium-250` and `AMLFS-Durable-Premium-500`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="storageCapacityInTb")
    def storage_capacity_in_tb(self) -> pulumi.Input[_builtins.int]:
        """
        The size of the Azure Managed Lustre File System in TiB. The valid values for this field are dependant on which `sku_name` has been defined in the configuration file. For more information on the valid values for this field please see the [product documentation](https://learn.microsoft.com/azure/azure-managed-lustre/create-file-system-resource-manager#file-system-type-and-size-options). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_capacity_in_tb")

    @storage_capacity_in_tb.setter
    def storage_capacity_in_tb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "storage_capacity_in_tb", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Subnet that is used for managing the Azure Managed Lustre file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the Virtual Network's address space. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of availability zones for the Azure Managed Lustre File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "zones", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['FileSystemEncryptionKeyArgs']]:
        """
        An `encryption_key` block as defined below.

        > **Note:** Removing `encryption_key` forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['FileSystemEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="hsmSetting")
    def hsm_setting(self) -> Optional[pulumi.Input['FileSystemHsmSettingArgs']]:
        """
        A `hsm_setting` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hsm_setting")

    @hsm_setting.setter
    def hsm_setting(self, value: Optional[pulumi.Input['FileSystemHsmSettingArgs']]):
        pulumi.set(self, "hsm_setting", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FileSystemIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FileSystemIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Managed Lustre File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Managed Lustre File System.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FileSystemState:
    def __init__(__self__, *,
                 encryption_key: Optional[pulumi.Input['FileSystemEncryptionKeyArgs']] = None,
                 hsm_setting: Optional[pulumi.Input['FileSystemHsmSettingArgs']] = None,
                 identity: Optional[pulumi.Input['FileSystemIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['FileSystemMaintenanceWindowArgs']] = None,
                 mgs_address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_capacity_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering FileSystem resources.
        :param pulumi.Input['FileSystemEncryptionKeyArgs'] encryption_key: An `encryption_key` block as defined below.
               
               > **Note:** Removing `encryption_key` forces a new resource to be created.
        :param pulumi.Input['FileSystemHsmSettingArgs'] hsm_setting: A `hsm_setting` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['FileSystemIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['FileSystemMaintenanceWindowArgs'] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[_builtins.str] mgs_address: IP Address of Managed Lustre File System Services.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Managed Lustre File System. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU name for the Azure Managed Lustre File System. Possible values are `AMLFS-Durable-Premium-40`, `AMLFS-Durable-Premium-125`, `AMLFS-Durable-Premium-250` and `AMLFS-Durable-Premium-500`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_capacity_in_tb: The size of the Azure Managed Lustre File System in TiB. The valid values for this field are dependant on which `sku_name` has been defined in the configuration file. For more information on the valid values for this field please see the [product documentation](https://learn.microsoft.com/azure/azure-managed-lustre/create-file-system-resource-manager#file-system-type-and-size-options). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The resource ID of the Subnet that is used for managing the Azure Managed Lustre file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the Virtual Network's address space. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Managed Lustre File System.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: A list of availability zones for the Azure Managed Lustre File System. Changing this forces a new resource to be created.
        """
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if hsm_setting is not None:
            pulumi.set(__self__, "hsm_setting", hsm_setting)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if mgs_address is not None:
            pulumi.set(__self__, "mgs_address", mgs_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if storage_capacity_in_tb is not None:
            pulumi.set(__self__, "storage_capacity_in_tb", storage_capacity_in_tb)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['FileSystemEncryptionKeyArgs']]:
        """
        An `encryption_key` block as defined below.

        > **Note:** Removing `encryption_key` forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['FileSystemEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="hsmSetting")
    def hsm_setting(self) -> Optional[pulumi.Input['FileSystemHsmSettingArgs']]:
        """
        A `hsm_setting` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hsm_setting")

    @hsm_setting.setter
    def hsm_setting(self, value: Optional[pulumi.Input['FileSystemHsmSettingArgs']]):
        pulumi.set(self, "hsm_setting", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FileSystemIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FileSystemIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['FileSystemMaintenanceWindowArgs']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['FileSystemMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="mgsAddress")
    def mgs_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP Address of Managed Lustre File System Services.
        """
        return pulumi.get(self, "mgs_address")

    @mgs_address.setter
    def mgs_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mgs_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Managed Lustre File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU name for the Azure Managed Lustre File System. Possible values are `AMLFS-Durable-Premium-40`, `AMLFS-Durable-Premium-125`, `AMLFS-Durable-Premium-250` and `AMLFS-Durable-Premium-500`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="storageCapacityInTb")
    def storage_capacity_in_tb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the Azure Managed Lustre File System in TiB. The valid values for this field are dependant on which `sku_name` has been defined in the configuration file. For more information on the valid values for this field please see the [product documentation](https://learn.microsoft.com/azure/azure-managed-lustre/create-file-system-resource-manager#file-system-type-and-size-options). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_capacity_in_tb")

    @storage_capacity_in_tb.setter
    def storage_capacity_in_tb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_capacity_in_tb", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Subnet that is used for managing the Azure Managed Lustre file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the Virtual Network's address space. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Managed Lustre File System.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of availability zones for the Azure Managed Lustre File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:managedlustre/fileSystem:FileSystem")
class FileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption_key: Optional[pulumi.Input[Union['FileSystemEncryptionKeyArgs', 'FileSystemEncryptionKeyArgsDict']]] = None,
                 hsm_setting: Optional[pulumi.Input[Union['FileSystemHsmSettingArgs', 'FileSystemHsmSettingArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['FileSystemIdentityArgs', 'FileSystemIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['FileSystemMaintenanceWindowArgs', 'FileSystemMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_capacity_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Managed Lustre File System.

        ## Import

        Azure Managed Lustre File Systems can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:managedlustre/fileSystem:FileSystem example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.StorageCache/amlFilesystems/amlFilesystem1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FileSystemEncryptionKeyArgs', 'FileSystemEncryptionKeyArgsDict']] encryption_key: An `encryption_key` block as defined below.
               
               > **Note:** Removing `encryption_key` forces a new resource to be created.
        :param pulumi.Input[Union['FileSystemHsmSettingArgs', 'FileSystemHsmSettingArgsDict']] hsm_setting: A `hsm_setting` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['FileSystemIdentityArgs', 'FileSystemIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['FileSystemMaintenanceWindowArgs', 'FileSystemMaintenanceWindowArgsDict']] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Managed Lustre File System. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU name for the Azure Managed Lustre File System. Possible values are `AMLFS-Durable-Premium-40`, `AMLFS-Durable-Premium-125`, `AMLFS-Durable-Premium-250` and `AMLFS-Durable-Premium-500`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_capacity_in_tb: The size of the Azure Managed Lustre File System in TiB. The valid values for this field are dependant on which `sku_name` has been defined in the configuration file. For more information on the valid values for this field please see the [product documentation](https://learn.microsoft.com/azure/azure-managed-lustre/create-file-system-resource-manager#file-system-type-and-size-options). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The resource ID of the Subnet that is used for managing the Azure Managed Lustre file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the Virtual Network's address space. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Managed Lustre File System.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: A list of availability zones for the Azure Managed Lustre File System. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Managed Lustre File System.

        ## Import

        Azure Managed Lustre File Systems can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:managedlustre/fileSystem:FileSystem example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.StorageCache/amlFilesystems/amlFilesystem1
        ```

        :param str resource_name: The name of the resource.
        :param FileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption_key: Optional[pulumi.Input[Union['FileSystemEncryptionKeyArgs', 'FileSystemEncryptionKeyArgsDict']]] = None,
                 hsm_setting: Optional[pulumi.Input[Union['FileSystemHsmSettingArgs', 'FileSystemHsmSettingArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['FileSystemIdentityArgs', 'FileSystemIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['FileSystemMaintenanceWindowArgs', 'FileSystemMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_capacity_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileSystemArgs.__new__(FileSystemArgs)

            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["hsm_setting"] = hsm_setting
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            if maintenance_window is None and not opts.urn:
                raise TypeError("Missing required property 'maintenance_window'")
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            if storage_capacity_in_tb is None and not opts.urn:
                raise TypeError("Missing required property 'storage_capacity_in_tb'")
            __props__.__dict__["storage_capacity_in_tb"] = storage_capacity_in_tb
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if zones is None and not opts.urn:
                raise TypeError("Missing required property 'zones'")
            __props__.__dict__["zones"] = zones
            __props__.__dict__["mgs_address"] = None
        super(FileSystem, __self__).__init__(
            'azure:managedlustre/fileSystem:FileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            encryption_key: Optional[pulumi.Input[Union['FileSystemEncryptionKeyArgs', 'FileSystemEncryptionKeyArgsDict']]] = None,
            hsm_setting: Optional[pulumi.Input[Union['FileSystemHsmSettingArgs', 'FileSystemHsmSettingArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['FileSystemIdentityArgs', 'FileSystemIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['FileSystemMaintenanceWindowArgs', 'FileSystemMaintenanceWindowArgsDict']]] = None,
            mgs_address: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_capacity_in_tb: Optional[pulumi.Input[_builtins.int]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'FileSystem':
        """
        Get an existing FileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FileSystemEncryptionKeyArgs', 'FileSystemEncryptionKeyArgsDict']] encryption_key: An `encryption_key` block as defined below.
               
               > **Note:** Removing `encryption_key` forces a new resource to be created.
        :param pulumi.Input[Union['FileSystemHsmSettingArgs', 'FileSystemHsmSettingArgsDict']] hsm_setting: A `hsm_setting` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['FileSystemIdentityArgs', 'FileSystemIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['FileSystemMaintenanceWindowArgs', 'FileSystemMaintenanceWindowArgsDict']] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[_builtins.str] mgs_address: IP Address of Managed Lustre File System Services.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Managed Lustre File System. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU name for the Azure Managed Lustre File System. Possible values are `AMLFS-Durable-Premium-40`, `AMLFS-Durable-Premium-125`, `AMLFS-Durable-Premium-250` and `AMLFS-Durable-Premium-500`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_capacity_in_tb: The size of the Azure Managed Lustre File System in TiB. The valid values for this field are dependant on which `sku_name` has been defined in the configuration file. For more information on the valid values for this field please see the [product documentation](https://learn.microsoft.com/azure/azure-managed-lustre/create-file-system-resource-manager#file-system-type-and-size-options). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The resource ID of the Subnet that is used for managing the Azure Managed Lustre file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the Virtual Network's address space. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Managed Lustre File System.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: A list of availability zones for the Azure Managed Lustre File System. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileSystemState.__new__(_FileSystemState)

        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["hsm_setting"] = hsm_setting
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["mgs_address"] = mgs_address
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["storage_capacity_in_tb"] = storage_capacity_in_tb
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zones"] = zones
        return FileSystem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[Optional['outputs.FileSystemEncryptionKey']]:
        """
        An `encryption_key` block as defined below.

        > **Note:** Removing `encryption_key` forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="hsmSetting")
    def hsm_setting(self) -> pulumi.Output[Optional['outputs.FileSystemHsmSetting']]:
        """
        A `hsm_setting` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hsm_setting")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.FileSystemIdentity']]:
        """
        An `identity` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.FileSystemMaintenanceWindow']:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="mgsAddress")
    def mgs_address(self) -> pulumi.Output[_builtins.str]:
        """
        IP Address of Managed Lustre File System Services.
        """
        return pulumi.get(self, "mgs_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Azure Managed Lustre File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Azure Managed Lustre File System should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU name for the Azure Managed Lustre File System. Possible values are `AMLFS-Durable-Premium-40`, `AMLFS-Durable-Premium-125`, `AMLFS-Durable-Premium-250` and `AMLFS-Durable-Premium-500`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="storageCapacityInTb")
    def storage_capacity_in_tb(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the Azure Managed Lustre File System in TiB. The valid values for this field are dependant on which `sku_name` has been defined in the configuration file. For more information on the valid values for this field please see the [product documentation](https://learn.microsoft.com/azure/azure-managed-lustre/create-file-system-resource-manager#file-system-type-and-size-options). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_capacity_in_tb")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the Subnet that is used for managing the Azure Managed Lustre file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the Virtual Network's address space. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Azure Managed Lustre File System.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of availability zones for the Azure Managed Lustre File System. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

