# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrivateLinkAssociationArgs', 'PrivateLinkAssociation']

@pulumi.input_type
class PrivateLinkAssociationArgs:
    def __init__(__self__, *,
                 management_group_id: pulumi.Input[_builtins.str],
                 public_network_access_enabled: pulumi.Input[_builtins.bool],
                 resource_management_private_link_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PrivateLinkAssociation resource.
        :param pulumi.Input[_builtins.str] management_group_id: Specifies the Management Group ID within which this Private Link Association should exist. Changing this forces a new Private Link Association to be created.
               
               > **Note:** For now, `management_group_id` must be the ID of [Root Management Group](https://learn.microsoft.com/en-us/azure/governance/management-groups/overview#root-management-group-for-each-directory).
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed. Changing this forces a new Private Link Association to be created.
        :param pulumi.Input[_builtins.str] resource_management_private_link_id: The Resource ID of Resource Management Private Link. Changing this forces a new Private Link Association to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Private Link Association, which should be a UUID. If `name` is not provided, a UUID will be generated, you should use the `ignore_changes` attribute to ignore changes to this field. Changing this forces a new Private Link Association to be created.
               
               ```python
               import pulumi
               import pulumi_azure as azure
               
               example = azure.management.PrivateLinkAssociation("example",
                   management_group_id=example_azurerm_management_group["id"],
                   resource_management_private_link_id=example_azurerm_resource_management_private_link["id"],
                   public_network_access_enabled=True)
               ```
        """
        pulumi.set(__self__, "management_group_id", management_group_id)
        pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        pulumi.set(__self__, "resource_management_private_link_id", resource_management_private_link_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="managementGroupId")
    def management_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Management Group ID within which this Private Link Association should exist. Changing this forces a new Private Link Association to be created.

        > **Note:** For now, `management_group_id` must be the ID of [Root Management Group](https://learn.microsoft.com/en-us/azure/governance/management-groups/overview#root-management-group-for-each-directory).
        """
        return pulumi.get(self, "management_group_id")

    @management_group_id.setter
    def management_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "management_group_id", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether public network access is allowed. Changing this forces a new Private Link Association to be created.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceManagementPrivateLinkId")
    def resource_management_private_link_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Resource ID of Resource Management Private Link. Changing this forces a new Private Link Association to be created.
        """
        return pulumi.get(self, "resource_management_private_link_id")

    @resource_management_private_link_id.setter
    def resource_management_private_link_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_management_private_link_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Private Link Association, which should be a UUID. If `name` is not provided, a UUID will be generated, you should use the `ignore_changes` attribute to ignore changes to this field. Changing this forces a new Private Link Association to be created.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.management.PrivateLinkAssociation("example",
            management_group_id=example_azurerm_management_group["id"],
            resource_management_private_link_id=example_azurerm_resource_management_private_link["id"],
            public_network_access_enabled=True)
        ```
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PrivateLinkAssociationState:
    def __init__(__self__, *,
                 management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_management_private_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrivateLinkAssociation resources.
        :param pulumi.Input[_builtins.str] management_group_id: Specifies the Management Group ID within which this Private Link Association should exist. Changing this forces a new Private Link Association to be created.
               
               > **Note:** For now, `management_group_id` must be the ID of [Root Management Group](https://learn.microsoft.com/en-us/azure/governance/management-groups/overview#root-management-group-for-each-directory).
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Private Link Association, which should be a UUID. If `name` is not provided, a UUID will be generated, you should use the `ignore_changes` attribute to ignore changes to this field. Changing this forces a new Private Link Association to be created.
               
               ```python
               import pulumi
               import pulumi_azure as azure
               
               example = azure.management.PrivateLinkAssociation("example",
                   management_group_id=example_azurerm_management_group["id"],
                   resource_management_private_link_id=example_azurerm_resource_management_private_link["id"],
                   public_network_access_enabled=True)
               ```
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed. Changing this forces a new Private Link Association to be created.
        :param pulumi.Input[_builtins.str] resource_management_private_link_id: The Resource ID of Resource Management Private Link. Changing this forces a new Private Link Association to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID.
        """
        if management_group_id is not None:
            pulumi.set(__self__, "management_group_id", management_group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_management_private_link_id is not None:
            pulumi.set(__self__, "resource_management_private_link_id", resource_management_private_link_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="managementGroupId")
    def management_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Management Group ID within which this Private Link Association should exist. Changing this forces a new Private Link Association to be created.

        > **Note:** For now, `management_group_id` must be the ID of [Root Management Group](https://learn.microsoft.com/en-us/azure/governance/management-groups/overview#root-management-group-for-each-directory).
        """
        return pulumi.get(self, "management_group_id")

    @management_group_id.setter
    def management_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_group_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Private Link Association, which should be a UUID. If `name` is not provided, a UUID will be generated, you should use the `ignore_changes` attribute to ignore changes to this field. Changing this forces a new Private Link Association to be created.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.management.PrivateLinkAssociation("example",
            management_group_id=example_azurerm_management_group["id"],
            resource_management_private_link_id=example_azurerm_resource_management_private_link["id"],
            public_network_access_enabled=True)
        ```
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is allowed. Changing this forces a new Private Link Association to be created.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceManagementPrivateLinkId")
    def resource_management_private_link_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Resource ID of Resource Management Private Link. Changing this forces a new Private Link Association to be created.
        """
        return pulumi.get(self, "resource_management_private_link_id")

    @resource_management_private_link_id.setter
    def resource_management_private_link_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_management_private_link_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("azure:management/privateLinkAssociation:PrivateLinkAssociation")
class PrivateLinkAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_management_private_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Resource Management Private Link Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_random as random

        example = azure.core.get_client_config()
        example_get_group = azure.management.get_group(name=example.tenant_id)
        example_resource_group = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_private_link = azure.management.PrivateLink("example",
            name="example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location)
        example_random_uuid = random.RandomUuid("example")
        example_private_link_association = azure.management.PrivateLinkAssociation("example",
            name=example_random_uuid.result,
            management_group_id=example_azurerm_management_group["id"],
            resource_management_private_link_id=example_private_link.id,
            public_network_access_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Management`: 2020-05-01

        ## Import

        An existing Private Link Association can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:management/privateLinkAssociation:PrivateLinkAssociation example /providers/Microsoft.Management/managementGroups/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/privateLinkAssociations/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] management_group_id: Specifies the Management Group ID within which this Private Link Association should exist. Changing this forces a new Private Link Association to be created.
               
               > **Note:** For now, `management_group_id` must be the ID of [Root Management Group](https://learn.microsoft.com/en-us/azure/governance/management-groups/overview#root-management-group-for-each-directory).
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Private Link Association, which should be a UUID. If `name` is not provided, a UUID will be generated, you should use the `ignore_changes` attribute to ignore changes to this field. Changing this forces a new Private Link Association to be created.
               
               ```python
               import pulumi
               import pulumi_azure as azure
               
               example = azure.management.PrivateLinkAssociation("example",
                   management_group_id=example_azurerm_management_group["id"],
                   resource_management_private_link_id=example_azurerm_resource_management_private_link["id"],
                   public_network_access_enabled=True)
               ```
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed. Changing this forces a new Private Link Association to be created.
        :param pulumi.Input[_builtins.str] resource_management_private_link_id: The Resource ID of Resource Management Private Link. Changing this forces a new Private Link Association to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateLinkAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Resource Management Private Link Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_random as random

        example = azure.core.get_client_config()
        example_get_group = azure.management.get_group(name=example.tenant_id)
        example_resource_group = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_private_link = azure.management.PrivateLink("example",
            name="example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location)
        example_random_uuid = random.RandomUuid("example")
        example_private_link_association = azure.management.PrivateLinkAssociation("example",
            name=example_random_uuid.result,
            management_group_id=example_azurerm_management_group["id"],
            resource_management_private_link_id=example_private_link.id,
            public_network_access_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Management`: 2020-05-01

        ## Import

        An existing Private Link Association can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:management/privateLinkAssociation:PrivateLinkAssociation example /providers/Microsoft.Management/managementGroups/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/privateLinkAssociations/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param PrivateLinkAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateLinkAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_management_private_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateLinkAssociationArgs.__new__(PrivateLinkAssociationArgs)

            if management_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'management_group_id'")
            __props__.__dict__["management_group_id"] = management_group_id
            __props__.__dict__["name"] = name
            if public_network_access_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'public_network_access_enabled'")
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_management_private_link_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_management_private_link_id'")
            __props__.__dict__["resource_management_private_link_id"] = resource_management_private_link_id
            __props__.__dict__["tenant_id"] = None
        super(PrivateLinkAssociation, __self__).__init__(
            'azure:management/privateLinkAssociation:PrivateLinkAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_management_private_link_id: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PrivateLinkAssociation':
        """
        Get an existing PrivateLinkAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] management_group_id: Specifies the Management Group ID within which this Private Link Association should exist. Changing this forces a new Private Link Association to be created.
               
               > **Note:** For now, `management_group_id` must be the ID of [Root Management Group](https://learn.microsoft.com/en-us/azure/governance/management-groups/overview#root-management-group-for-each-directory).
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Private Link Association, which should be a UUID. If `name` is not provided, a UUID will be generated, you should use the `ignore_changes` attribute to ignore changes to this field. Changing this forces a new Private Link Association to be created.
               
               ```python
               import pulumi
               import pulumi_azure as azure
               
               example = azure.management.PrivateLinkAssociation("example",
                   management_group_id=example_azurerm_management_group["id"],
                   resource_management_private_link_id=example_azurerm_resource_management_private_link["id"],
                   public_network_access_enabled=True)
               ```
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed. Changing this forces a new Private Link Association to be created.
        :param pulumi.Input[_builtins.str] resource_management_private_link_id: The Resource ID of Resource Management Private Link. Changing this forces a new Private Link Association to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateLinkAssociationState.__new__(_PrivateLinkAssociationState)

        __props__.__dict__["management_group_id"] = management_group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_management_private_link_id"] = resource_management_private_link_id
        __props__.__dict__["tenant_id"] = tenant_id
        return PrivateLinkAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="managementGroupId")
    def management_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Management Group ID within which this Private Link Association should exist. Changing this forces a new Private Link Association to be created.

        > **Note:** For now, `management_group_id` must be the ID of [Root Management Group](https://learn.microsoft.com/en-us/azure/governance/management-groups/overview#root-management-group-for-each-directory).
        """
        return pulumi.get(self, "management_group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Private Link Association, which should be a UUID. If `name` is not provided, a UUID will be generated, you should use the `ignore_changes` attribute to ignore changes to this field. Changing this forces a new Private Link Association to be created.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.management.PrivateLinkAssociation("example",
            management_group_id=example_azurerm_management_group["id"],
            resource_management_private_link_id=example_azurerm_resource_management_private_link["id"],
            public_network_access_enabled=True)
        ```
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether public network access is allowed. Changing this forces a new Private Link Association to be created.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceManagementPrivateLinkId")
    def resource_management_private_link_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Resource ID of Resource Management Private Link. Changing this forces a new Private Link Association to be created.
        """
        return pulumi.get(self, "resource_management_private_link_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

