# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSpatialAnchorsAccountResult',
    'AwaitableGetSpatialAnchorsAccountResult',
    'get_spatial_anchors_account',
    'get_spatial_anchors_account_output',
]

@pulumi.output_type
class GetSpatialAnchorsAccountResult:
    """
    A collection of values returned by getSpatialAnchorsAccount.
    """
    def __init__(__self__, account_domain=None, account_id=None, id=None, location=None, name=None, resource_group_name=None, tags=None):
        if account_domain and not isinstance(account_domain, str):
            raise TypeError("Expected argument 'account_domain' to be a str")
        pulumi.set(__self__, "account_domain", account_domain)
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accountDomain")
    def account_domain(self) -> _builtins.str:
        """
        The domain of the Spatial Anchors Account.
        """
        return pulumi.get(self, "account_domain")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The account ID of the Spatial Anchors Account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The Tags assigned to this Spatial Anchors Account.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSpatialAnchorsAccountResult(GetSpatialAnchorsAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSpatialAnchorsAccountResult(
            account_domain=self.account_domain,
            account_id=self.account_id,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_spatial_anchors_account(name: Optional[_builtins.str] = None,
                                resource_group_name: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSpatialAnchorsAccountResult:
    """
    Get information about an Azure Spatial Anchors Account.

    > **Note:** The `mixedreality.SpatialAnchorsAccount` data source has been deprecated because the service is retiring from 2024-11-20 and will be removed in v5.0 of the AzureRM Provider.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mixedreality.get_spatial_anchors_account(name="example",
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("accountDomain", account_domain_azurerm_spatial_anchors_account)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MixedReality`: 2021-01-01


    :param _builtins.str name: Specifies the name of the Spatial Anchors Account. Changing this forces a new resource to be created. Must be globally unique.
    :param _builtins.str resource_group_name: The name of the resource group in which to create the Spatial Anchors Account.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:mixedreality/getSpatialAnchorsAccount:getSpatialAnchorsAccount', __args__, opts=opts, typ=GetSpatialAnchorsAccountResult).value

    return AwaitableGetSpatialAnchorsAccountResult(
        account_domain=pulumi.get(__ret__, 'account_domain'),
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_spatial_anchors_account_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSpatialAnchorsAccountResult]:
    """
    Get information about an Azure Spatial Anchors Account.

    > **Note:** The `mixedreality.SpatialAnchorsAccount` data source has been deprecated because the service is retiring from 2024-11-20 and will be removed in v5.0 of the AzureRM Provider.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mixedreality.get_spatial_anchors_account(name="example",
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("accountDomain", account_domain_azurerm_spatial_anchors_account)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MixedReality`: 2021-01-01


    :param _builtins.str name: Specifies the name of the Spatial Anchors Account. Changing this forces a new resource to be created. Must be globally unique.
    :param _builtins.str resource_group_name: The name of the resource group in which to create the Spatial Anchors Account.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:mixedreality/getSpatialAnchorsAccount:getSpatialAnchorsAccount', __args__, opts=opts, typ=GetSpatialAnchorsAccountResult)
    return __ret__.apply(lambda __response__: GetSpatialAnchorsAccountResult(
        account_domain=pulumi.get(__response__, 'account_domain'),
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
