# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkServiceResult',
    'AwaitableGetNetworkServiceResult',
    'get_network_service',
    'get_network_service_output',
]

@pulumi.output_type
class GetNetworkServiceResult:
    """
    A collection of values returned by getNetworkService.
    """
    def __init__(__self__, id=None, location=None, mobile_network_id=None, name=None, pcc_rules=None, service_precedence=None, service_qos_policies=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if mobile_network_id and not isinstance(mobile_network_id, str):
            raise TypeError("Expected argument 'mobile_network_id' to be a str")
        pulumi.set(__self__, "mobile_network_id", mobile_network_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pcc_rules and not isinstance(pcc_rules, list):
            raise TypeError("Expected argument 'pcc_rules' to be a list")
        pulumi.set(__self__, "pcc_rules", pcc_rules)
        if service_precedence and not isinstance(service_precedence, int):
            raise TypeError("Expected argument 'service_precedence' to be a int")
        pulumi.set(__self__, "service_precedence", service_precedence)
        if service_qos_policies and not isinstance(service_qos_policies, list):
            raise TypeError("Expected argument 'service_qos_policies' to be a list")
        pulumi.set(__self__, "service_qos_policies", service_qos_policies)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Mobile Network Service should exist.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mobileNetworkId")
    def mobile_network_id(self) -> _builtins.str:
        return pulumi.get(self, "mobile_network_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the data flow template. This must be unique within the parent data flow policy rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pccRules")
    def pcc_rules(self) -> Sequence['outputs.GetNetworkServicePccRuleResult']:
        """
        A `pcc_rule` block as defined below. The set of PCC Rules that make up this service.
        """
        return pulumi.get(self, "pcc_rules")

    @_builtins.property
    @pulumi.getter(name="servicePrecedence")
    def service_precedence(self) -> _builtins.int:
        """
        A precedence value that is used to decide between services when identifying the QoS values to use for a particular SIM. A lower value means a higher priority.
        """
        return pulumi.get(self, "service_precedence")

    @_builtins.property
    @pulumi.getter(name="serviceQosPolicies")
    def service_qos_policies(self) -> Sequence['outputs.GetNetworkServiceServiceQosPolicyResult']:
        """
        A `service_qos_policy` block as defined below. The QoS policy to use for packets matching this service.
        """
        return pulumi.get(self, "service_qos_policies")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags which should be assigned to the Mobile Network Service.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNetworkServiceResult(GetNetworkServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkServiceResult(
            id=self.id,
            location=self.location,
            mobile_network_id=self.mobile_network_id,
            name=self.name,
            pcc_rules=self.pcc_rules,
            service_precedence=self.service_precedence,
            service_qos_policies=self.service_qos_policies,
            tags=self.tags)


def get_network_service(mobile_network_id: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkServiceResult:
    """
    Get information about a Mobile Network Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mobile.get_network(name="example-mn",
        resource_group_name="example-rg")
    example_network_service = azure.mobile.NetworkService("example",
        name="example-mns",
        mobile_network_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MobileNetwork`: 2022-11-01


    :param _builtins.str mobile_network_id: Specifies the ID of the Mobile Network Service.
    :param _builtins.str name: Specifies the name which should be used for this Mobile Network Service.
    """
    __args__ = dict()
    __args__['mobileNetworkId'] = mobile_network_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:mobile/getNetworkService:getNetworkService', __args__, opts=opts, typ=GetNetworkServiceResult).value

    return AwaitableGetNetworkServiceResult(
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        mobile_network_id=pulumi.get(__ret__, 'mobile_network_id'),
        name=pulumi.get(__ret__, 'name'),
        pcc_rules=pulumi.get(__ret__, 'pcc_rules'),
        service_precedence=pulumi.get(__ret__, 'service_precedence'),
        service_qos_policies=pulumi.get(__ret__, 'service_qos_policies'),
        tags=pulumi.get(__ret__, 'tags'))
def get_network_service_output(mobile_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                               name: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkServiceResult]:
    """
    Get information about a Mobile Network Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mobile.get_network(name="example-mn",
        resource_group_name="example-rg")
    example_network_service = azure.mobile.NetworkService("example",
        name="example-mns",
        mobile_network_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MobileNetwork`: 2022-11-01


    :param _builtins.str mobile_network_id: Specifies the ID of the Mobile Network Service.
    :param _builtins.str name: Specifies the name which should be used for this Mobile Network Service.
    """
    __args__ = dict()
    __args__['mobileNetworkId'] = mobile_network_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:mobile/getNetworkService:getNetworkService', __args__, opts=opts, typ=GetNetworkServiceResult)
    return __ret__.apply(lambda __response__: GetNetworkServiceResult(
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        mobile_network_id=pulumi.get(__response__, 'mobile_network_id'),
        name=pulumi.get(__response__, 'name'),
        pcc_rules=pulumi.get(__response__, 'pcc_rules'),
        service_precedence=pulumi.get(__response__, 'service_precedence'),
        service_qos_policies=pulumi.get(__response__, 'service_qos_policies'),
        tags=pulumi.get(__response__, 'tags')))
