# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetScheduledQueryRulesAlertResult',
    'AwaitableGetScheduledQueryRulesAlertResult',
    'get_scheduled_query_rules_alert',
    'get_scheduled_query_rules_alert_output',
]

@pulumi.output_type
class GetScheduledQueryRulesAlertResult:
    """
    A collection of values returned by getScheduledQueryRulesAlert.
    """
    def __init__(__self__, actions=None, authorized_resource_ids=None, data_source_id=None, description=None, enabled=None, frequency=None, id=None, location=None, name=None, query=None, query_type=None, resource_group_name=None, severity=None, tags=None, throttling=None, time_window=None, triggers=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if authorized_resource_ids and not isinstance(authorized_resource_ids, list):
            raise TypeError("Expected argument 'authorized_resource_ids' to be a list")
        pulumi.set(__self__, "authorized_resource_ids", authorized_resource_ids)
        if data_source_id and not isinstance(data_source_id, str):
            raise TypeError("Expected argument 'data_source_id' to be a str")
        pulumi.set(__self__, "data_source_id", data_source_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if frequency and not isinstance(frequency, int):
            raise TypeError("Expected argument 'frequency' to be a int")
        pulumi.set(__self__, "frequency", frequency)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if query_type and not isinstance(query_type, str):
            raise TypeError("Expected argument 'query_type' to be a str")
        pulumi.set(__self__, "query_type", query_type)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if severity and not isinstance(severity, int):
            raise TypeError("Expected argument 'severity' to be a int")
        pulumi.set(__self__, "severity", severity)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if throttling and not isinstance(throttling, int):
            raise TypeError("Expected argument 'throttling' to be a int")
        pulumi.set(__self__, "throttling", throttling)
        if time_window and not isinstance(time_window, int):
            raise TypeError("Expected argument 'time_window' to be a int")
        pulumi.set(__self__, "time_window", time_window)
        if triggers and not isinstance(triggers, list):
            raise TypeError("Expected argument 'triggers' to be a list")
        pulumi.set(__self__, "triggers", triggers)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetScheduledQueryRulesAlertActionResult']:
        """
        supports the following:
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="authorizedResourceIds")
    def authorized_resource_ids(self) -> Sequence[_builtins.str]:
        """
        The list of Resource IDs referred into query.
        """
        return pulumi.get(self, "authorized_resource_ids")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> _builtins.str:
        """
        The resource URI over which log search query is to be run.
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the scheduled query rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether this scheduled query rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> _builtins.int:
        """
        Frequency at which rule condition should be evaluated.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Specifies the Azure Region where the resource should exist.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        Log search query.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="queryType")
    def query_type(self) -> _builtins.str:
        """
        The type of query results.
        """
        return pulumi.get(self, "query_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.int:
        """
        Severity of the alert.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def throttling(self) -> _builtins.int:
        """
        Time for which alerts should be throttled or suppressed.
        """
        return pulumi.get(self, "throttling")

    @_builtins.property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> _builtins.int:
        """
        Time window for which data needs to be fetched for query.
        """
        return pulumi.get(self, "time_window")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Sequence['outputs.GetScheduledQueryRulesAlertTriggerResult']:
        """
        A `trigger` block as defined below.
        """
        return pulumi.get(self, "triggers")


class AwaitableGetScheduledQueryRulesAlertResult(GetScheduledQueryRulesAlertResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledQueryRulesAlertResult(
            actions=self.actions,
            authorized_resource_ids=self.authorized_resource_ids,
            data_source_id=self.data_source_id,
            description=self.description,
            enabled=self.enabled,
            frequency=self.frequency,
            id=self.id,
            location=self.location,
            name=self.name,
            query=self.query,
            query_type=self.query_type,
            resource_group_name=self.resource_group_name,
            severity=self.severity,
            tags=self.tags,
            throttling=self.throttling,
            time_window=self.time_window,
            triggers=self.triggers)


def get_scheduled_query_rules_alert(name: Optional[_builtins.str] = None,
                                    resource_group_name: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledQueryRulesAlertResult:
    """
    Use this data source to access the properties of an AlertingAction scheduled query rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.monitoring.get_scheduled_query_rules_alert(resource_group_name="example-rg",
        name="tfex-queryrule")
    pulumi.export("queryRuleId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Insights`: 2018-04-16


    :param _builtins.str name: Specifies the name of the scheduled query rule.
    :param _builtins.str resource_group_name: Specifies the name of the resource group where the scheduled query rule is located.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:monitoring/getScheduledQueryRulesAlert:getScheduledQueryRulesAlert', __args__, opts=opts, typ=GetScheduledQueryRulesAlertResult).value

    return AwaitableGetScheduledQueryRulesAlertResult(
        actions=pulumi.get(__ret__, 'actions'),
        authorized_resource_ids=pulumi.get(__ret__, 'authorized_resource_ids'),
        data_source_id=pulumi.get(__ret__, 'data_source_id'),
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        frequency=pulumi.get(__ret__, 'frequency'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        query=pulumi.get(__ret__, 'query'),
        query_type=pulumi.get(__ret__, 'query_type'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        severity=pulumi.get(__ret__, 'severity'),
        tags=pulumi.get(__ret__, 'tags'),
        throttling=pulumi.get(__ret__, 'throttling'),
        time_window=pulumi.get(__ret__, 'time_window'),
        triggers=pulumi.get(__ret__, 'triggers'))
def get_scheduled_query_rules_alert_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                           resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduledQueryRulesAlertResult]:
    """
    Use this data source to access the properties of an AlertingAction scheduled query rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.monitoring.get_scheduled_query_rules_alert(resource_group_name="example-rg",
        name="tfex-queryrule")
    pulumi.export("queryRuleId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Insights`: 2018-04-16


    :param _builtins.str name: Specifies the name of the scheduled query rule.
    :param _builtins.str resource_group_name: Specifies the name of the resource group where the scheduled query rule is located.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:monitoring/getScheduledQueryRulesAlert:getScheduledQueryRulesAlert', __args__, opts=opts, typ=GetScheduledQueryRulesAlertResult)
    return __ret__.apply(lambda __response__: GetScheduledQueryRulesAlertResult(
        actions=pulumi.get(__response__, 'actions'),
        authorized_resource_ids=pulumi.get(__response__, 'authorized_resource_ids'),
        data_source_id=pulumi.get(__response__, 'data_source_id'),
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        frequency=pulumi.get(__response__, 'frequency'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        query=pulumi.get(__response__, 'query'),
        query_type=pulumi.get(__response__, 'query_type'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        severity=pulumi.get(__response__, 'severity'),
        tags=pulumi.get(__response__, 'tags'),
        throttling=pulumi.get(__response__, 'throttling'),
        time_window=pulumi.get(__response__, 'time_window'),
        triggers=pulumi.get(__response__, 'triggers')))
