# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 server_id: pulumi.Input[_builtins.str],
                 auto_pause_delay_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_source_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 elastic_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enclave_type: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['DatabaseIdentityArgs']] = None,
                 import_: Optional[pulumi.Input['DatabaseImportArgs']] = None,
                 ledger_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 long_term_retention_policy: Optional[pulumi.Input['DatabaseLongTermRetentionPolicyArgs']] = None,
                 maintenance_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 min_capacity: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 read_scale: Optional[pulumi.Input[_builtins.bool]] = None,
                 recover_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_dropped_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_long_term_retention_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_point_in_time: Optional[pulumi.Input[_builtins.str]] = None,
                 sample_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_type: Optional[pulumi.Input[_builtins.str]] = None,
                 short_term_retention_policy: Optional[pulumi.Input['DatabaseShortTermRetentionPolicyArgs']] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_detection_policy: Optional[pulumi.Input['DatabaseThreatDetectionPolicyArgs']] = None,
                 transparent_data_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transparent_data_encryption_key_automatic_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transparent_data_encryption_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[_builtins.str] server_id: The id of the MS SQL Server on which to create the database. Changing this forces a new resource to be created.
               
               > **Note:** This setting is still required for "Serverless" SKUs
        :param pulumi.Input[_builtins.int] auto_pause_delay_in_minutes: Time in minutes after which database is automatically paused. A value of `-1` means that automatic pause is disabled. This property is only settable for Serverless databases.
        :param pulumi.Input[_builtins.str] collation: Specifies the collation of the database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] create_mode: The create mode of the database. Possible values are `Copy`, `Default`, `OnlineSecondary`, `PointInTimeRestore`, `Recovery`, `Restore`, `RestoreExternalBackup`, `RestoreExternalBackupSecondary`, `RestoreLongTermRetentionBackup` and `Secondary`. Mutually exclusive with `import`. Changing this forces a new resource to be created. Defaults to `Default`.
        :param pulumi.Input[_builtins.str] creation_source_database_id: The ID of the source database from which to create the new database. This should only be used for databases with `create_mode` values that use another database as reference. Changing this forces a new resource to be created.
               
               > **Note:** When configuring a secondary database, please be aware of the constraints for the `sku_name` property, as noted below, for both the primary and secondary databases. The `sku_name` of the secondary database may be inadvertently changed to match that of the primary when an incompatible combination of SKUs is detected by the provider.
        :param pulumi.Input[_builtins.str] elastic_pool_id: Specifies the ID of the elastic pool containing this database.
        :param pulumi.Input[_builtins.str] enclave_type: Specifies the type of enclave to be used by the elastic pool. When `enclave_type` is not specified (e.g., the default) enclaves are not enabled on the database. Once enabled (e.g., by specifying `Default` or `VBS`) removing the `enclave_type` field from the configuration file will force the creation of a new resource. Possible values are `Default` or `VBS`.
               
               > **Note:** `enclave_type` is currently not supported for DW (e.g, DataWarehouse) and DC-series SKUs.
               
               > **Note:** Geo Replicated and Failover databases must have the same `enclave_type`.
               
               > **Note:** The default value for the `enclave_type` field is unset not `Default`.
        :param pulumi.Input[_builtins.bool] geo_backup_enabled: A boolean that specifies if the Geo Backup Policy is enabled. Defaults to `true`.
               
               > **Note:** `geo_backup_enabled` is only applicable for DataWarehouse SKUs (DW*). This setting is ignored for all other SKUs.
        :param pulumi.Input['DatabaseIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['DatabaseImportArgs'] import_: A `import` block as documented below. Mutually exclusive with `create_mode`.
        :param pulumi.Input[_builtins.bool] ledger_enabled: A boolean that specifies if this is a ledger database. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] license_type: Specifies the license type applied to this database. Possible values are `LicenseIncluded` and `BasePrice`.
        :param pulumi.Input['DatabaseLongTermRetentionPolicyArgs'] long_term_retention_policy: A `long_term_retention_policy` block as defined below.
        :param pulumi.Input[_builtins.str] maintenance_configuration_name: The name of the Public Maintenance Configuration window to apply to the database. Valid values include `SQL_Default`, `SQL_EastUS_DB_1`, `SQL_EastUS2_DB_1`, `SQL_SoutheastAsia_DB_1`, `SQL_AustraliaEast_DB_1`, `SQL_NorthEurope_DB_1`, `SQL_SouthCentralUS_DB_1`, `SQL_WestUS2_DB_1`, `SQL_UKSouth_DB_1`, `SQL_WestEurope_DB_1`, `SQL_EastUS_DB_2`, `SQL_EastUS2_DB_2`, `SQL_WestUS2_DB_2`, `SQL_SoutheastAsia_DB_2`, `SQL_AustraliaEast_DB_2`, `SQL_NorthEurope_DB_2`, `SQL_SouthCentralUS_DB_2`, `SQL_UKSouth_DB_2`, `SQL_WestEurope_DB_2`, `SQL_AustraliaSoutheast_DB_1`, `SQL_BrazilSouth_DB_1`, `SQL_CanadaCentral_DB_1`, `SQL_CanadaEast_DB_1`, `SQL_CentralUS_DB_1`, `SQL_EastAsia_DB_1`, `SQL_FranceCentral_DB_1`, `SQL_GermanyWestCentral_DB_1`, `SQL_CentralIndia_DB_1`, `SQL_SouthIndia_DB_1`, `SQL_JapanEast_DB_1`, `SQL_JapanWest_DB_1`, `SQL_NorthCentralUS_DB_1`, `SQL_UKWest_DB_1`, `SQL_WestUS_DB_1`, `SQL_AustraliaSoutheast_DB_2`, `SQL_BrazilSouth_DB_2`, `SQL_CanadaCentral_DB_2`, `SQL_CanadaEast_DB_2`, `SQL_CentralUS_DB_2`, `SQL_EastAsia_DB_2`, `SQL_FranceCentral_DB_2`, `SQL_GermanyWestCentral_DB_2`, `SQL_CentralIndia_DB_2`, `SQL_SouthIndia_DB_2`, `SQL_JapanEast_DB_2`, `SQL_JapanWest_DB_2`, `SQL_NorthCentralUS_DB_2`, `SQL_UKWest_DB_2`, `SQL_WestUS_DB_2`, `SQL_WestCentralUS_DB_1`, `SQL_FranceSouth_DB_1`, `SQL_WestCentralUS_DB_2`, `SQL_FranceSouth_DB_2`, `SQL_SwitzerlandNorth_DB_1`, `SQL_SwitzerlandNorth_DB_2`, `SQL_BrazilSoutheast_DB_1`, `SQL_UAENorth_DB_1`, `SQL_BrazilSoutheast_DB_2`, `SQL_UAENorth_DB_2`, `SQL_SouthAfricaNorth_DB_1`, `SQL_SouthAfricaNorth_DB_2`, `SQL_WestUS3_DB_1`, `SQL_WestUS3_DB_2`, `SQL_SwedenCentral_DB_1`, `SQL_SwedenCentral_DB_2`. Defaults to `SQL_Default`.
               
               > **Note:** `maintenance_configuration_name` is only applicable if `elastic_pool_id` is not set.
        :param pulumi.Input[_builtins.int] max_size_gb: The max size of the database in gigabytes.
               
               > **Note:** This value should not be configured when the `create_mode` is `Secondary` or `OnlineSecondary`, as the sizing of the primary is then used as per [Azure documentation](https://docs.microsoft.com/azure/azure-sql/database/single-database-scale#geo-replicated-database).
        :param pulumi.Input[_builtins.float] min_capacity: Minimal capacity that database will always have allocated, if not paused. This property is only settable for Serverless databases.
        :param pulumi.Input[_builtins.str] name: The name of the MS SQL Database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] read_replica_count: The number of readonly secondary replicas associated with the database to which readonly application intent connections may be routed. This property is only settable for Hyperscale edition databases.
        :param pulumi.Input[_builtins.bool] read_scale: If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica. This property is only settable for Premium and Business Critical databases.
        :param pulumi.Input[_builtins.str] recover_database_id: The ID of the database to be recovered. This property is only applicable when the `create_mode` is `Recovery`.
        :param pulumi.Input[_builtins.str] recovery_point_id: The ID of the Recovery Services Recovery Point Id to be restored. This property is only applicable when the `create_mode` is `Recovery`.
        :param pulumi.Input[_builtins.str] restore_dropped_database_id: The ID of the database to be restored. This property is only applicable when the `create_mode` is `Restore`.
        :param pulumi.Input[_builtins.str] restore_long_term_retention_backup_id: The ID of the long term retention backup to be restored. This property is only applicable when the `create_mode` is `RestoreLongTermRetentionBackup`.
        :param pulumi.Input[_builtins.str] restore_point_in_time: Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. This property is only settable for `create_mode`= `PointInTimeRestore` databases.
        :param pulumi.Input[_builtins.str] sample_name: Specifies the name of the sample schema to apply when creating this database. Possible value is `AdventureWorksLT`.
        :param pulumi.Input[_builtins.str] secondary_type: How do you want your replica to be made? Valid values include `Geo` and `Named`. Defaults to `Geo`. Changing this forces a new resource to be created.
        :param pulumi.Input['DatabaseShortTermRetentionPolicyArgs'] short_term_retention_policy: A `short_term_retention_policy` block as defined below.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the name of the SKU used by the database. For example, `GP_S_Gen5_2`,`HS_Gen4_1`,`BC_Gen5_2`, `ElasticPool`, `Basic`,`S0`, `P2` ,`DW100c`, `DS100`. Changing this from the HyperScale service tier to another service tier will create a new resource.
               
               > **Note:** A full list of supported SKU names by region can be retrieved using the Azure CLI: `az sql db list-editions -l <region> -o table`
               
               > **Note:** The default `sku_name` value may differ between Azure locations depending on local availability of Gen4/Gen5 capacity. When databases are replicated using the `creation_source_database_id` property, the source (primary) database cannot have a higher SKU service tier than any secondary databases. When changing the `sku_name` of a database having one or more secondary databases, this resource will first update any secondary databases as necessary. In such cases it's recommended to use the same `sku_name` in your configuration for all related databases, as not doing so may cause an unresolvable diff during subsequent plans.
        :param pulumi.Input[_builtins.str] storage_account_type: Specifies the storage account type used to store backups for this database. Possible values are `Geo`, `GeoZone`, `Local` and `Zone`. Defaults to `Geo`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['DatabaseThreatDetectionPolicyArgs'] threat_detection_policy: Threat detection policy configuration. The `threat_detection_policy` block supports fields documented below.
        :param pulumi.Input[_builtins.bool] transparent_data_encryption_enabled: If set to true, Transparent Data Encryption will be enabled on the database. Defaults to `true`.
               
               > **Note:** `transparent_data_encryption_enabled` can only be set to `false` on DW (e.g, DataWarehouse) server SKUs.
        :param pulumi.Input[_builtins.bool] transparent_data_encryption_key_automatic_rotation_enabled: Boolean flag to specify whether TDE automatically rotates the encryption Key to latest version or not. Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** When the `sku_name` is `DW100c`, the `transparent_data_encryption_key_automatic_rotation_enabled` and the `transparent_data_encryption_key_vault_key_id` properties should not be specified, as database-level CMK is not supported for Data Warehouse SKUs.
        :param pulumi.Input[_builtins.str] transparent_data_encryption_key_vault_key_id: The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.
               
               > **Note:** To successfully deploy a `Microsoft SQL Database` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.
        :param pulumi.Input[_builtins.bool] zone_redundant: Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones. This property is only settable for Premium and Business Critical databases.
        """
        pulumi.set(__self__, "server_id", server_id)
        if auto_pause_delay_in_minutes is not None:
            pulumi.set(__self__, "auto_pause_delay_in_minutes", auto_pause_delay_in_minutes)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if creation_source_database_id is not None:
            pulumi.set(__self__, "creation_source_database_id", creation_source_database_id)
        if elastic_pool_id is not None:
            pulumi.set(__self__, "elastic_pool_id", elastic_pool_id)
        if enclave_type is not None:
            pulumi.set(__self__, "enclave_type", enclave_type)
        if geo_backup_enabled is not None:
            pulumi.set(__self__, "geo_backup_enabled", geo_backup_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if import_ is not None:
            pulumi.set(__self__, "import_", import_)
        if ledger_enabled is not None:
            pulumi.set(__self__, "ledger_enabled", ledger_enabled)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if long_term_retention_policy is not None:
            pulumi.set(__self__, "long_term_retention_policy", long_term_retention_policy)
        if maintenance_configuration_name is not None:
            pulumi.set(__self__, "maintenance_configuration_name", maintenance_configuration_name)
        if max_size_gb is not None:
            pulumi.set(__self__, "max_size_gb", max_size_gb)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_replica_count is not None:
            pulumi.set(__self__, "read_replica_count", read_replica_count)
        if read_scale is not None:
            pulumi.set(__self__, "read_scale", read_scale)
        if recover_database_id is not None:
            pulumi.set(__self__, "recover_database_id", recover_database_id)
        if recovery_point_id is not None:
            pulumi.set(__self__, "recovery_point_id", recovery_point_id)
        if restore_dropped_database_id is not None:
            pulumi.set(__self__, "restore_dropped_database_id", restore_dropped_database_id)
        if restore_long_term_retention_backup_id is not None:
            pulumi.set(__self__, "restore_long_term_retention_backup_id", restore_long_term_retention_backup_id)
        if restore_point_in_time is not None:
            pulumi.set(__self__, "restore_point_in_time", restore_point_in_time)
        if sample_name is not None:
            pulumi.set(__self__, "sample_name", sample_name)
        if secondary_type is not None:
            pulumi.set(__self__, "secondary_type", secondary_type)
        if short_term_retention_policy is not None:
            pulumi.set(__self__, "short_term_retention_policy", short_term_retention_policy)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_detection_policy is not None:
            pulumi.set(__self__, "threat_detection_policy", threat_detection_policy)
        if transparent_data_encryption_enabled is not None:
            pulumi.set(__self__, "transparent_data_encryption_enabled", transparent_data_encryption_enabled)
        if transparent_data_encryption_key_automatic_rotation_enabled is not None:
            pulumi.set(__self__, "transparent_data_encryption_key_automatic_rotation_enabled", transparent_data_encryption_key_automatic_rotation_enabled)
        if transparent_data_encryption_key_vault_key_id is not None:
            pulumi.set(__self__, "transparent_data_encryption_key_vault_key_id", transparent_data_encryption_key_vault_key_id)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the MS SQL Server on which to create the database. Changing this forces a new resource to be created.

        > **Note:** This setting is still required for "Serverless" SKUs
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPauseDelayInMinutes")
    def auto_pause_delay_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in minutes after which database is automatically paused. A value of `-1` means that automatic pause is disabled. This property is only settable for Serverless databases.
        """
        return pulumi.get(self, "auto_pause_delay_in_minutes")

    @auto_pause_delay_in_minutes.setter
    def auto_pause_delay_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_pause_delay_in_minutes", value)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the collation of the database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collation", value)

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The create mode of the database. Possible values are `Copy`, `Default`, `OnlineSecondary`, `PointInTimeRestore`, `Recovery`, `Restore`, `RestoreExternalBackup`, `RestoreExternalBackupSecondary`, `RestoreLongTermRetentionBackup` and `Secondary`. Mutually exclusive with `import`. Changing this forces a new resource to be created. Defaults to `Default`.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @_builtins.property
    @pulumi.getter(name="creationSourceDatabaseId")
    def creation_source_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source database from which to create the new database. This should only be used for databases with `create_mode` values that use another database as reference. Changing this forces a new resource to be created.

        > **Note:** When configuring a secondary database, please be aware of the constraints for the `sku_name` property, as noted below, for both the primary and secondary databases. The `sku_name` of the secondary database may be inadvertently changed to match that of the primary when an incompatible combination of SKUs is detected by the provider.
        """
        return pulumi.get(self, "creation_source_database_id")

    @creation_source_database_id.setter
    def creation_source_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_source_database_id", value)

    @_builtins.property
    @pulumi.getter(name="elasticPoolId")
    def elastic_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the elastic pool containing this database.
        """
        return pulumi.get(self, "elastic_pool_id")

    @elastic_pool_id.setter
    def elastic_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "elastic_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="enclaveType")
    def enclave_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of enclave to be used by the elastic pool. When `enclave_type` is not specified (e.g., the default) enclaves are not enabled on the database. Once enabled (e.g., by specifying `Default` or `VBS`) removing the `enclave_type` field from the configuration file will force the creation of a new resource. Possible values are `Default` or `VBS`.

        > **Note:** `enclave_type` is currently not supported for DW (e.g, DataWarehouse) and DC-series SKUs.

        > **Note:** Geo Replicated and Failover databases must have the same `enclave_type`.

        > **Note:** The default value for the `enclave_type` field is unset not `Default`.
        """
        return pulumi.get(self, "enclave_type")

    @enclave_type.setter
    def enclave_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enclave_type", value)

    @_builtins.property
    @pulumi.getter(name="geoBackupEnabled")
    def geo_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean that specifies if the Geo Backup Policy is enabled. Defaults to `true`.

        > **Note:** `geo_backup_enabled` is only applicable for DataWarehouse SKUs (DW*). This setting is ignored for all other SKUs.
        """
        return pulumi.get(self, "geo_backup_enabled")

    @geo_backup_enabled.setter
    def geo_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "geo_backup_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['DatabaseIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['DatabaseIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="import")
    def import_(self) -> Optional[pulumi.Input['DatabaseImportArgs']]:
        """
        A `import` block as documented below. Mutually exclusive with `create_mode`.
        """
        return pulumi.get(self, "import_")

    @import_.setter
    def import_(self, value: Optional[pulumi.Input['DatabaseImportArgs']]):
        pulumi.set(self, "import_", value)

    @_builtins.property
    @pulumi.getter(name="ledgerEnabled")
    def ledger_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean that specifies if this is a ledger database. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ledger_enabled")

    @ledger_enabled.setter
    def ledger_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ledger_enabled", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the license type applied to this database. Possible values are `LicenseIncluded` and `BasePrice`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter(name="longTermRetentionPolicy")
    def long_term_retention_policy(self) -> Optional[pulumi.Input['DatabaseLongTermRetentionPolicyArgs']]:
        """
        A `long_term_retention_policy` block as defined below.
        """
        return pulumi.get(self, "long_term_retention_policy")

    @long_term_retention_policy.setter
    def long_term_retention_policy(self, value: Optional[pulumi.Input['DatabaseLongTermRetentionPolicyArgs']]):
        pulumi.set(self, "long_term_retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceConfigurationName")
    def maintenance_configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Public Maintenance Configuration window to apply to the database. Valid values include `SQL_Default`, `SQL_EastUS_DB_1`, `SQL_EastUS2_DB_1`, `SQL_SoutheastAsia_DB_1`, `SQL_AustraliaEast_DB_1`, `SQL_NorthEurope_DB_1`, `SQL_SouthCentralUS_DB_1`, `SQL_WestUS2_DB_1`, `SQL_UKSouth_DB_1`, `SQL_WestEurope_DB_1`, `SQL_EastUS_DB_2`, `SQL_EastUS2_DB_2`, `SQL_WestUS2_DB_2`, `SQL_SoutheastAsia_DB_2`, `SQL_AustraliaEast_DB_2`, `SQL_NorthEurope_DB_2`, `SQL_SouthCentralUS_DB_2`, `SQL_UKSouth_DB_2`, `SQL_WestEurope_DB_2`, `SQL_AustraliaSoutheast_DB_1`, `SQL_BrazilSouth_DB_1`, `SQL_CanadaCentral_DB_1`, `SQL_CanadaEast_DB_1`, `SQL_CentralUS_DB_1`, `SQL_EastAsia_DB_1`, `SQL_FranceCentral_DB_1`, `SQL_GermanyWestCentral_DB_1`, `SQL_CentralIndia_DB_1`, `SQL_SouthIndia_DB_1`, `SQL_JapanEast_DB_1`, `SQL_JapanWest_DB_1`, `SQL_NorthCentralUS_DB_1`, `SQL_UKWest_DB_1`, `SQL_WestUS_DB_1`, `SQL_AustraliaSoutheast_DB_2`, `SQL_BrazilSouth_DB_2`, `SQL_CanadaCentral_DB_2`, `SQL_CanadaEast_DB_2`, `SQL_CentralUS_DB_2`, `SQL_EastAsia_DB_2`, `SQL_FranceCentral_DB_2`, `SQL_GermanyWestCentral_DB_2`, `SQL_CentralIndia_DB_2`, `SQL_SouthIndia_DB_2`, `SQL_JapanEast_DB_2`, `SQL_JapanWest_DB_2`, `SQL_NorthCentralUS_DB_2`, `SQL_UKWest_DB_2`, `SQL_WestUS_DB_2`, `SQL_WestCentralUS_DB_1`, `SQL_FranceSouth_DB_1`, `SQL_WestCentralUS_DB_2`, `SQL_FranceSouth_DB_2`, `SQL_SwitzerlandNorth_DB_1`, `SQL_SwitzerlandNorth_DB_2`, `SQL_BrazilSoutheast_DB_1`, `SQL_UAENorth_DB_1`, `SQL_BrazilSoutheast_DB_2`, `SQL_UAENorth_DB_2`, `SQL_SouthAfricaNorth_DB_1`, `SQL_SouthAfricaNorth_DB_2`, `SQL_WestUS3_DB_1`, `SQL_WestUS3_DB_2`, `SQL_SwedenCentral_DB_1`, `SQL_SwedenCentral_DB_2`. Defaults to `SQL_Default`.

        > **Note:** `maintenance_configuration_name` is only applicable if `elastic_pool_id` is not set.
        """
        return pulumi.get(self, "maintenance_configuration_name")

    @maintenance_configuration_name.setter
    def maintenance_configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="maxSizeGb")
    def max_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max size of the database in gigabytes.

        > **Note:** This value should not be configured when the `create_mode` is `Secondary` or `OnlineSecondary`, as the sizing of the primary is then used as per [Azure documentation](https://docs.microsoft.com/azure/azure-sql/database/single-database-scale#geo-replicated-database).
        """
        return pulumi.get(self, "max_size_gb")

    @max_size_gb.setter
    def max_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Minimal capacity that database will always have allocated, if not paused. This property is only settable for Serverless databases.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "min_capacity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the MS SQL Database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="readReplicaCount")
    def read_replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of readonly secondary replicas associated with the database to which readonly application intent connections may be routed. This property is only settable for Hyperscale edition databases.
        """
        return pulumi.get(self, "read_replica_count")

    @read_replica_count.setter
    def read_replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_replica_count", value)

    @_builtins.property
    @pulumi.getter(name="readScale")
    def read_scale(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica. This property is only settable for Premium and Business Critical databases.
        """
        return pulumi.get(self, "read_scale")

    @read_scale.setter
    def read_scale(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_scale", value)

    @_builtins.property
    @pulumi.getter(name="recoverDatabaseId")
    def recover_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the database to be recovered. This property is only applicable when the `create_mode` is `Recovery`.
        """
        return pulumi.get(self, "recover_database_id")

    @recover_database_id.setter
    def recover_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recover_database_id", value)

    @_builtins.property
    @pulumi.getter(name="recoveryPointId")
    def recovery_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Recovery Services Recovery Point Id to be restored. This property is only applicable when the `create_mode` is `Recovery`.
        """
        return pulumi.get(self, "recovery_point_id")

    @recovery_point_id.setter
    def recovery_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_point_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreDroppedDatabaseId")
    def restore_dropped_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the database to be restored. This property is only applicable when the `create_mode` is `Restore`.
        """
        return pulumi.get(self, "restore_dropped_database_id")

    @restore_dropped_database_id.setter
    def restore_dropped_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_dropped_database_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreLongTermRetentionBackupId")
    def restore_long_term_retention_backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the long term retention backup to be restored. This property is only applicable when the `create_mode` is `RestoreLongTermRetentionBackup`.
        """
        return pulumi.get(self, "restore_long_term_retention_backup_id")

    @restore_long_term_retention_backup_id.setter
    def restore_long_term_retention_backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_long_term_retention_backup_id", value)

    @_builtins.property
    @pulumi.getter(name="restorePointInTime")
    def restore_point_in_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. This property is only settable for `create_mode`= `PointInTimeRestore` databases.
        """
        return pulumi.get(self, "restore_point_in_time")

    @restore_point_in_time.setter
    def restore_point_in_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_point_in_time", value)

    @_builtins.property
    @pulumi.getter(name="sampleName")
    def sample_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the sample schema to apply when creating this database. Possible value is `AdventureWorksLT`.
        """
        return pulumi.get(self, "sample_name")

    @sample_name.setter
    def sample_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sample_name", value)

    @_builtins.property
    @pulumi.getter(name="secondaryType")
    def secondary_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How do you want your replica to be made? Valid values include `Geo` and `Named`. Defaults to `Geo`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secondary_type")

    @secondary_type.setter
    def secondary_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_type", value)

    @_builtins.property
    @pulumi.getter(name="shortTermRetentionPolicy")
    def short_term_retention_policy(self) -> Optional[pulumi.Input['DatabaseShortTermRetentionPolicyArgs']]:
        """
        A `short_term_retention_policy` block as defined below.
        """
        return pulumi.get(self, "short_term_retention_policy")

    @short_term_retention_policy.setter
    def short_term_retention_policy(self, value: Optional[pulumi.Input['DatabaseShortTermRetentionPolicyArgs']]):
        pulumi.set(self, "short_term_retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the SKU used by the database. For example, `GP_S_Gen5_2`,`HS_Gen4_1`,`BC_Gen5_2`, `ElasticPool`, `Basic`,`S0`, `P2` ,`DW100c`, `DS100`. Changing this from the HyperScale service tier to another service tier will create a new resource.

        > **Note:** A full list of supported SKU names by region can be retrieved using the Azure CLI: `az sql db list-editions -l <region> -o table`

        > **Note:** The default `sku_name` value may differ between Azure locations depending on local availability of Gen4/Gen5 capacity. When databases are replicated using the `creation_source_database_id` property, the source (primary) database cannot have a higher SKU service tier than any secondary databases. When changing the `sku_name` of a database having one or more secondary databases, this resource will first update any secondary databases as necessary. In such cases it's recommended to use the same `sku_name` in your configuration for all related databases, as not doing so may cause an unresolvable diff during subsequent plans.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage account type used to store backups for this database. Possible values are `Geo`, `GeoZone`, `Local` and `Zone`. Defaults to `Geo`.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="threatDetectionPolicy")
    def threat_detection_policy(self) -> Optional[pulumi.Input['DatabaseThreatDetectionPolicyArgs']]:
        """
        Threat detection policy configuration. The `threat_detection_policy` block supports fields documented below.
        """
        return pulumi.get(self, "threat_detection_policy")

    @threat_detection_policy.setter
    def threat_detection_policy(self, value: Optional[pulumi.Input['DatabaseThreatDetectionPolicyArgs']]):
        pulumi.set(self, "threat_detection_policy", value)

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionEnabled")
    def transparent_data_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, Transparent Data Encryption will be enabled on the database. Defaults to `true`.

        > **Note:** `transparent_data_encryption_enabled` can only be set to `false` on DW (e.g, DataWarehouse) server SKUs.
        """
        return pulumi.get(self, "transparent_data_encryption_enabled")

    @transparent_data_encryption_enabled.setter
    def transparent_data_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transparent_data_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyAutomaticRotationEnabled")
    def transparent_data_encryption_key_automatic_rotation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag to specify whether TDE automatically rotates the encryption Key to latest version or not. Possible values are `true` or `false`. Defaults to `false`.

        > **Note:** When the `sku_name` is `DW100c`, the `transparent_data_encryption_key_automatic_rotation_enabled` and the `transparent_data_encryption_key_vault_key_id` properties should not be specified, as database-level CMK is not supported for Data Warehouse SKUs.
        """
        return pulumi.get(self, "transparent_data_encryption_key_automatic_rotation_enabled")

    @transparent_data_encryption_key_automatic_rotation_enabled.setter
    def transparent_data_encryption_key_automatic_rotation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transparent_data_encryption_key_automatic_rotation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyVaultKeyId")
    def transparent_data_encryption_key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.

        > **Note:** To successfully deploy a `Microsoft SQL Database` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.
        """
        return pulumi.get(self, "transparent_data_encryption_key_vault_key_id")

    @transparent_data_encryption_key_vault_key_id.setter
    def transparent_data_encryption_key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transparent_data_encryption_key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones. This property is only settable for Premium and Business Critical databases.
        """
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 auto_pause_delay_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_source_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 elastic_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enclave_type: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['DatabaseIdentityArgs']] = None,
                 import_: Optional[pulumi.Input['DatabaseImportArgs']] = None,
                 ledger_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 long_term_retention_policy: Optional[pulumi.Input['DatabaseLongTermRetentionPolicyArgs']] = None,
                 maintenance_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 min_capacity: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 read_scale: Optional[pulumi.Input[_builtins.bool]] = None,
                 recover_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_dropped_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_long_term_retention_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_point_in_time: Optional[pulumi.Input[_builtins.str]] = None,
                 sample_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_type: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 short_term_retention_policy: Optional[pulumi.Input['DatabaseShortTermRetentionPolicyArgs']] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_detection_policy: Optional[pulumi.Input['DatabaseThreatDetectionPolicyArgs']] = None,
                 transparent_data_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transparent_data_encryption_key_automatic_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transparent_data_encryption_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[_builtins.int] auto_pause_delay_in_minutes: Time in minutes after which database is automatically paused. A value of `-1` means that automatic pause is disabled. This property is only settable for Serverless databases.
        :param pulumi.Input[_builtins.str] collation: Specifies the collation of the database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] create_mode: The create mode of the database. Possible values are `Copy`, `Default`, `OnlineSecondary`, `PointInTimeRestore`, `Recovery`, `Restore`, `RestoreExternalBackup`, `RestoreExternalBackupSecondary`, `RestoreLongTermRetentionBackup` and `Secondary`. Mutually exclusive with `import`. Changing this forces a new resource to be created. Defaults to `Default`.
        :param pulumi.Input[_builtins.str] creation_source_database_id: The ID of the source database from which to create the new database. This should only be used for databases with `create_mode` values that use another database as reference. Changing this forces a new resource to be created.
               
               > **Note:** When configuring a secondary database, please be aware of the constraints for the `sku_name` property, as noted below, for both the primary and secondary databases. The `sku_name` of the secondary database may be inadvertently changed to match that of the primary when an incompatible combination of SKUs is detected by the provider.
        :param pulumi.Input[_builtins.str] elastic_pool_id: Specifies the ID of the elastic pool containing this database.
        :param pulumi.Input[_builtins.str] enclave_type: Specifies the type of enclave to be used by the elastic pool. When `enclave_type` is not specified (e.g., the default) enclaves are not enabled on the database. Once enabled (e.g., by specifying `Default` or `VBS`) removing the `enclave_type` field from the configuration file will force the creation of a new resource. Possible values are `Default` or `VBS`.
               
               > **Note:** `enclave_type` is currently not supported for DW (e.g, DataWarehouse) and DC-series SKUs.
               
               > **Note:** Geo Replicated and Failover databases must have the same `enclave_type`.
               
               > **Note:** The default value for the `enclave_type` field is unset not `Default`.
        :param pulumi.Input[_builtins.bool] geo_backup_enabled: A boolean that specifies if the Geo Backup Policy is enabled. Defaults to `true`.
               
               > **Note:** `geo_backup_enabled` is only applicable for DataWarehouse SKUs (DW*). This setting is ignored for all other SKUs.
        :param pulumi.Input['DatabaseIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['DatabaseImportArgs'] import_: A `import` block as documented below. Mutually exclusive with `create_mode`.
        :param pulumi.Input[_builtins.bool] ledger_enabled: A boolean that specifies if this is a ledger database. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] license_type: Specifies the license type applied to this database. Possible values are `LicenseIncluded` and `BasePrice`.
        :param pulumi.Input['DatabaseLongTermRetentionPolicyArgs'] long_term_retention_policy: A `long_term_retention_policy` block as defined below.
        :param pulumi.Input[_builtins.str] maintenance_configuration_name: The name of the Public Maintenance Configuration window to apply to the database. Valid values include `SQL_Default`, `SQL_EastUS_DB_1`, `SQL_EastUS2_DB_1`, `SQL_SoutheastAsia_DB_1`, `SQL_AustraliaEast_DB_1`, `SQL_NorthEurope_DB_1`, `SQL_SouthCentralUS_DB_1`, `SQL_WestUS2_DB_1`, `SQL_UKSouth_DB_1`, `SQL_WestEurope_DB_1`, `SQL_EastUS_DB_2`, `SQL_EastUS2_DB_2`, `SQL_WestUS2_DB_2`, `SQL_SoutheastAsia_DB_2`, `SQL_AustraliaEast_DB_2`, `SQL_NorthEurope_DB_2`, `SQL_SouthCentralUS_DB_2`, `SQL_UKSouth_DB_2`, `SQL_WestEurope_DB_2`, `SQL_AustraliaSoutheast_DB_1`, `SQL_BrazilSouth_DB_1`, `SQL_CanadaCentral_DB_1`, `SQL_CanadaEast_DB_1`, `SQL_CentralUS_DB_1`, `SQL_EastAsia_DB_1`, `SQL_FranceCentral_DB_1`, `SQL_GermanyWestCentral_DB_1`, `SQL_CentralIndia_DB_1`, `SQL_SouthIndia_DB_1`, `SQL_JapanEast_DB_1`, `SQL_JapanWest_DB_1`, `SQL_NorthCentralUS_DB_1`, `SQL_UKWest_DB_1`, `SQL_WestUS_DB_1`, `SQL_AustraliaSoutheast_DB_2`, `SQL_BrazilSouth_DB_2`, `SQL_CanadaCentral_DB_2`, `SQL_CanadaEast_DB_2`, `SQL_CentralUS_DB_2`, `SQL_EastAsia_DB_2`, `SQL_FranceCentral_DB_2`, `SQL_GermanyWestCentral_DB_2`, `SQL_CentralIndia_DB_2`, `SQL_SouthIndia_DB_2`, `SQL_JapanEast_DB_2`, `SQL_JapanWest_DB_2`, `SQL_NorthCentralUS_DB_2`, `SQL_UKWest_DB_2`, `SQL_WestUS_DB_2`, `SQL_WestCentralUS_DB_1`, `SQL_FranceSouth_DB_1`, `SQL_WestCentralUS_DB_2`, `SQL_FranceSouth_DB_2`, `SQL_SwitzerlandNorth_DB_1`, `SQL_SwitzerlandNorth_DB_2`, `SQL_BrazilSoutheast_DB_1`, `SQL_UAENorth_DB_1`, `SQL_BrazilSoutheast_DB_2`, `SQL_UAENorth_DB_2`, `SQL_SouthAfricaNorth_DB_1`, `SQL_SouthAfricaNorth_DB_2`, `SQL_WestUS3_DB_1`, `SQL_WestUS3_DB_2`, `SQL_SwedenCentral_DB_1`, `SQL_SwedenCentral_DB_2`. Defaults to `SQL_Default`.
               
               > **Note:** `maintenance_configuration_name` is only applicable if `elastic_pool_id` is not set.
        :param pulumi.Input[_builtins.int] max_size_gb: The max size of the database in gigabytes.
               
               > **Note:** This value should not be configured when the `create_mode` is `Secondary` or `OnlineSecondary`, as the sizing of the primary is then used as per [Azure documentation](https://docs.microsoft.com/azure/azure-sql/database/single-database-scale#geo-replicated-database).
        :param pulumi.Input[_builtins.float] min_capacity: Minimal capacity that database will always have allocated, if not paused. This property is only settable for Serverless databases.
        :param pulumi.Input[_builtins.str] name: The name of the MS SQL Database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] read_replica_count: The number of readonly secondary replicas associated with the database to which readonly application intent connections may be routed. This property is only settable for Hyperscale edition databases.
        :param pulumi.Input[_builtins.bool] read_scale: If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica. This property is only settable for Premium and Business Critical databases.
        :param pulumi.Input[_builtins.str] recover_database_id: The ID of the database to be recovered. This property is only applicable when the `create_mode` is `Recovery`.
        :param pulumi.Input[_builtins.str] recovery_point_id: The ID of the Recovery Services Recovery Point Id to be restored. This property is only applicable when the `create_mode` is `Recovery`.
        :param pulumi.Input[_builtins.str] restore_dropped_database_id: The ID of the database to be restored. This property is only applicable when the `create_mode` is `Restore`.
        :param pulumi.Input[_builtins.str] restore_long_term_retention_backup_id: The ID of the long term retention backup to be restored. This property is only applicable when the `create_mode` is `RestoreLongTermRetentionBackup`.
        :param pulumi.Input[_builtins.str] restore_point_in_time: Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. This property is only settable for `create_mode`= `PointInTimeRestore` databases.
        :param pulumi.Input[_builtins.str] sample_name: Specifies the name of the sample schema to apply when creating this database. Possible value is `AdventureWorksLT`.
        :param pulumi.Input[_builtins.str] secondary_type: How do you want your replica to be made? Valid values include `Geo` and `Named`. Defaults to `Geo`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] server_id: The id of the MS SQL Server on which to create the database. Changing this forces a new resource to be created.
               
               > **Note:** This setting is still required for "Serverless" SKUs
        :param pulumi.Input['DatabaseShortTermRetentionPolicyArgs'] short_term_retention_policy: A `short_term_retention_policy` block as defined below.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the name of the SKU used by the database. For example, `GP_S_Gen5_2`,`HS_Gen4_1`,`BC_Gen5_2`, `ElasticPool`, `Basic`,`S0`, `P2` ,`DW100c`, `DS100`. Changing this from the HyperScale service tier to another service tier will create a new resource.
               
               > **Note:** A full list of supported SKU names by region can be retrieved using the Azure CLI: `az sql db list-editions -l <region> -o table`
               
               > **Note:** The default `sku_name` value may differ between Azure locations depending on local availability of Gen4/Gen5 capacity. When databases are replicated using the `creation_source_database_id` property, the source (primary) database cannot have a higher SKU service tier than any secondary databases. When changing the `sku_name` of a database having one or more secondary databases, this resource will first update any secondary databases as necessary. In such cases it's recommended to use the same `sku_name` in your configuration for all related databases, as not doing so may cause an unresolvable diff during subsequent plans.
        :param pulumi.Input[_builtins.str] storage_account_type: Specifies the storage account type used to store backups for this database. Possible values are `Geo`, `GeoZone`, `Local` and `Zone`. Defaults to `Geo`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['DatabaseThreatDetectionPolicyArgs'] threat_detection_policy: Threat detection policy configuration. The `threat_detection_policy` block supports fields documented below.
        :param pulumi.Input[_builtins.bool] transparent_data_encryption_enabled: If set to true, Transparent Data Encryption will be enabled on the database. Defaults to `true`.
               
               > **Note:** `transparent_data_encryption_enabled` can only be set to `false` on DW (e.g, DataWarehouse) server SKUs.
        :param pulumi.Input[_builtins.bool] transparent_data_encryption_key_automatic_rotation_enabled: Boolean flag to specify whether TDE automatically rotates the encryption Key to latest version or not. Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** When the `sku_name` is `DW100c`, the `transparent_data_encryption_key_automatic_rotation_enabled` and the `transparent_data_encryption_key_vault_key_id` properties should not be specified, as database-level CMK is not supported for Data Warehouse SKUs.
        :param pulumi.Input[_builtins.str] transparent_data_encryption_key_vault_key_id: The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.
               
               > **Note:** To successfully deploy a `Microsoft SQL Database` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.
        :param pulumi.Input[_builtins.bool] zone_redundant: Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones. This property is only settable for Premium and Business Critical databases.
        """
        if auto_pause_delay_in_minutes is not None:
            pulumi.set(__self__, "auto_pause_delay_in_minutes", auto_pause_delay_in_minutes)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if creation_source_database_id is not None:
            pulumi.set(__self__, "creation_source_database_id", creation_source_database_id)
        if elastic_pool_id is not None:
            pulumi.set(__self__, "elastic_pool_id", elastic_pool_id)
        if enclave_type is not None:
            pulumi.set(__self__, "enclave_type", enclave_type)
        if geo_backup_enabled is not None:
            pulumi.set(__self__, "geo_backup_enabled", geo_backup_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if import_ is not None:
            pulumi.set(__self__, "import_", import_)
        if ledger_enabled is not None:
            pulumi.set(__self__, "ledger_enabled", ledger_enabled)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if long_term_retention_policy is not None:
            pulumi.set(__self__, "long_term_retention_policy", long_term_retention_policy)
        if maintenance_configuration_name is not None:
            pulumi.set(__self__, "maintenance_configuration_name", maintenance_configuration_name)
        if max_size_gb is not None:
            pulumi.set(__self__, "max_size_gb", max_size_gb)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_replica_count is not None:
            pulumi.set(__self__, "read_replica_count", read_replica_count)
        if read_scale is not None:
            pulumi.set(__self__, "read_scale", read_scale)
        if recover_database_id is not None:
            pulumi.set(__self__, "recover_database_id", recover_database_id)
        if recovery_point_id is not None:
            pulumi.set(__self__, "recovery_point_id", recovery_point_id)
        if restore_dropped_database_id is not None:
            pulumi.set(__self__, "restore_dropped_database_id", restore_dropped_database_id)
        if restore_long_term_retention_backup_id is not None:
            pulumi.set(__self__, "restore_long_term_retention_backup_id", restore_long_term_retention_backup_id)
        if restore_point_in_time is not None:
            pulumi.set(__self__, "restore_point_in_time", restore_point_in_time)
        if sample_name is not None:
            pulumi.set(__self__, "sample_name", sample_name)
        if secondary_type is not None:
            pulumi.set(__self__, "secondary_type", secondary_type)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if short_term_retention_policy is not None:
            pulumi.set(__self__, "short_term_retention_policy", short_term_retention_policy)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_detection_policy is not None:
            pulumi.set(__self__, "threat_detection_policy", threat_detection_policy)
        if transparent_data_encryption_enabled is not None:
            pulumi.set(__self__, "transparent_data_encryption_enabled", transparent_data_encryption_enabled)
        if transparent_data_encryption_key_automatic_rotation_enabled is not None:
            pulumi.set(__self__, "transparent_data_encryption_key_automatic_rotation_enabled", transparent_data_encryption_key_automatic_rotation_enabled)
        if transparent_data_encryption_key_vault_key_id is not None:
            pulumi.set(__self__, "transparent_data_encryption_key_vault_key_id", transparent_data_encryption_key_vault_key_id)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @_builtins.property
    @pulumi.getter(name="autoPauseDelayInMinutes")
    def auto_pause_delay_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in minutes after which database is automatically paused. A value of `-1` means that automatic pause is disabled. This property is only settable for Serverless databases.
        """
        return pulumi.get(self, "auto_pause_delay_in_minutes")

    @auto_pause_delay_in_minutes.setter
    def auto_pause_delay_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_pause_delay_in_minutes", value)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the collation of the database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collation", value)

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The create mode of the database. Possible values are `Copy`, `Default`, `OnlineSecondary`, `PointInTimeRestore`, `Recovery`, `Restore`, `RestoreExternalBackup`, `RestoreExternalBackupSecondary`, `RestoreLongTermRetentionBackup` and `Secondary`. Mutually exclusive with `import`. Changing this forces a new resource to be created. Defaults to `Default`.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @_builtins.property
    @pulumi.getter(name="creationSourceDatabaseId")
    def creation_source_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source database from which to create the new database. This should only be used for databases with `create_mode` values that use another database as reference. Changing this forces a new resource to be created.

        > **Note:** When configuring a secondary database, please be aware of the constraints for the `sku_name` property, as noted below, for both the primary and secondary databases. The `sku_name` of the secondary database may be inadvertently changed to match that of the primary when an incompatible combination of SKUs is detected by the provider.
        """
        return pulumi.get(self, "creation_source_database_id")

    @creation_source_database_id.setter
    def creation_source_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_source_database_id", value)

    @_builtins.property
    @pulumi.getter(name="elasticPoolId")
    def elastic_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the elastic pool containing this database.
        """
        return pulumi.get(self, "elastic_pool_id")

    @elastic_pool_id.setter
    def elastic_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "elastic_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="enclaveType")
    def enclave_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of enclave to be used by the elastic pool. When `enclave_type` is not specified (e.g., the default) enclaves are not enabled on the database. Once enabled (e.g., by specifying `Default` or `VBS`) removing the `enclave_type` field from the configuration file will force the creation of a new resource. Possible values are `Default` or `VBS`.

        > **Note:** `enclave_type` is currently not supported for DW (e.g, DataWarehouse) and DC-series SKUs.

        > **Note:** Geo Replicated and Failover databases must have the same `enclave_type`.

        > **Note:** The default value for the `enclave_type` field is unset not `Default`.
        """
        return pulumi.get(self, "enclave_type")

    @enclave_type.setter
    def enclave_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enclave_type", value)

    @_builtins.property
    @pulumi.getter(name="geoBackupEnabled")
    def geo_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean that specifies if the Geo Backup Policy is enabled. Defaults to `true`.

        > **Note:** `geo_backup_enabled` is only applicable for DataWarehouse SKUs (DW*). This setting is ignored for all other SKUs.
        """
        return pulumi.get(self, "geo_backup_enabled")

    @geo_backup_enabled.setter
    def geo_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "geo_backup_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['DatabaseIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['DatabaseIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="import")
    def import_(self) -> Optional[pulumi.Input['DatabaseImportArgs']]:
        """
        A `import` block as documented below. Mutually exclusive with `create_mode`.
        """
        return pulumi.get(self, "import_")

    @import_.setter
    def import_(self, value: Optional[pulumi.Input['DatabaseImportArgs']]):
        pulumi.set(self, "import_", value)

    @_builtins.property
    @pulumi.getter(name="ledgerEnabled")
    def ledger_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean that specifies if this is a ledger database. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ledger_enabled")

    @ledger_enabled.setter
    def ledger_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ledger_enabled", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the license type applied to this database. Possible values are `LicenseIncluded` and `BasePrice`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter(name="longTermRetentionPolicy")
    def long_term_retention_policy(self) -> Optional[pulumi.Input['DatabaseLongTermRetentionPolicyArgs']]:
        """
        A `long_term_retention_policy` block as defined below.
        """
        return pulumi.get(self, "long_term_retention_policy")

    @long_term_retention_policy.setter
    def long_term_retention_policy(self, value: Optional[pulumi.Input['DatabaseLongTermRetentionPolicyArgs']]):
        pulumi.set(self, "long_term_retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceConfigurationName")
    def maintenance_configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Public Maintenance Configuration window to apply to the database. Valid values include `SQL_Default`, `SQL_EastUS_DB_1`, `SQL_EastUS2_DB_1`, `SQL_SoutheastAsia_DB_1`, `SQL_AustraliaEast_DB_1`, `SQL_NorthEurope_DB_1`, `SQL_SouthCentralUS_DB_1`, `SQL_WestUS2_DB_1`, `SQL_UKSouth_DB_1`, `SQL_WestEurope_DB_1`, `SQL_EastUS_DB_2`, `SQL_EastUS2_DB_2`, `SQL_WestUS2_DB_2`, `SQL_SoutheastAsia_DB_2`, `SQL_AustraliaEast_DB_2`, `SQL_NorthEurope_DB_2`, `SQL_SouthCentralUS_DB_2`, `SQL_UKSouth_DB_2`, `SQL_WestEurope_DB_2`, `SQL_AustraliaSoutheast_DB_1`, `SQL_BrazilSouth_DB_1`, `SQL_CanadaCentral_DB_1`, `SQL_CanadaEast_DB_1`, `SQL_CentralUS_DB_1`, `SQL_EastAsia_DB_1`, `SQL_FranceCentral_DB_1`, `SQL_GermanyWestCentral_DB_1`, `SQL_CentralIndia_DB_1`, `SQL_SouthIndia_DB_1`, `SQL_JapanEast_DB_1`, `SQL_JapanWest_DB_1`, `SQL_NorthCentralUS_DB_1`, `SQL_UKWest_DB_1`, `SQL_WestUS_DB_1`, `SQL_AustraliaSoutheast_DB_2`, `SQL_BrazilSouth_DB_2`, `SQL_CanadaCentral_DB_2`, `SQL_CanadaEast_DB_2`, `SQL_CentralUS_DB_2`, `SQL_EastAsia_DB_2`, `SQL_FranceCentral_DB_2`, `SQL_GermanyWestCentral_DB_2`, `SQL_CentralIndia_DB_2`, `SQL_SouthIndia_DB_2`, `SQL_JapanEast_DB_2`, `SQL_JapanWest_DB_2`, `SQL_NorthCentralUS_DB_2`, `SQL_UKWest_DB_2`, `SQL_WestUS_DB_2`, `SQL_WestCentralUS_DB_1`, `SQL_FranceSouth_DB_1`, `SQL_WestCentralUS_DB_2`, `SQL_FranceSouth_DB_2`, `SQL_SwitzerlandNorth_DB_1`, `SQL_SwitzerlandNorth_DB_2`, `SQL_BrazilSoutheast_DB_1`, `SQL_UAENorth_DB_1`, `SQL_BrazilSoutheast_DB_2`, `SQL_UAENorth_DB_2`, `SQL_SouthAfricaNorth_DB_1`, `SQL_SouthAfricaNorth_DB_2`, `SQL_WestUS3_DB_1`, `SQL_WestUS3_DB_2`, `SQL_SwedenCentral_DB_1`, `SQL_SwedenCentral_DB_2`. Defaults to `SQL_Default`.

        > **Note:** `maintenance_configuration_name` is only applicable if `elastic_pool_id` is not set.
        """
        return pulumi.get(self, "maintenance_configuration_name")

    @maintenance_configuration_name.setter
    def maintenance_configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="maxSizeGb")
    def max_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max size of the database in gigabytes.

        > **Note:** This value should not be configured when the `create_mode` is `Secondary` or `OnlineSecondary`, as the sizing of the primary is then used as per [Azure documentation](https://docs.microsoft.com/azure/azure-sql/database/single-database-scale#geo-replicated-database).
        """
        return pulumi.get(self, "max_size_gb")

    @max_size_gb.setter
    def max_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Minimal capacity that database will always have allocated, if not paused. This property is only settable for Serverless databases.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "min_capacity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the MS SQL Database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="readReplicaCount")
    def read_replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of readonly secondary replicas associated with the database to which readonly application intent connections may be routed. This property is only settable for Hyperscale edition databases.
        """
        return pulumi.get(self, "read_replica_count")

    @read_replica_count.setter
    def read_replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_replica_count", value)

    @_builtins.property
    @pulumi.getter(name="readScale")
    def read_scale(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica. This property is only settable for Premium and Business Critical databases.
        """
        return pulumi.get(self, "read_scale")

    @read_scale.setter
    def read_scale(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_scale", value)

    @_builtins.property
    @pulumi.getter(name="recoverDatabaseId")
    def recover_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the database to be recovered. This property is only applicable when the `create_mode` is `Recovery`.
        """
        return pulumi.get(self, "recover_database_id")

    @recover_database_id.setter
    def recover_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recover_database_id", value)

    @_builtins.property
    @pulumi.getter(name="recoveryPointId")
    def recovery_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Recovery Services Recovery Point Id to be restored. This property is only applicable when the `create_mode` is `Recovery`.
        """
        return pulumi.get(self, "recovery_point_id")

    @recovery_point_id.setter
    def recovery_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_point_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreDroppedDatabaseId")
    def restore_dropped_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the database to be restored. This property is only applicable when the `create_mode` is `Restore`.
        """
        return pulumi.get(self, "restore_dropped_database_id")

    @restore_dropped_database_id.setter
    def restore_dropped_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_dropped_database_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreLongTermRetentionBackupId")
    def restore_long_term_retention_backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the long term retention backup to be restored. This property is only applicable when the `create_mode` is `RestoreLongTermRetentionBackup`.
        """
        return pulumi.get(self, "restore_long_term_retention_backup_id")

    @restore_long_term_retention_backup_id.setter
    def restore_long_term_retention_backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_long_term_retention_backup_id", value)

    @_builtins.property
    @pulumi.getter(name="restorePointInTime")
    def restore_point_in_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. This property is only settable for `create_mode`= `PointInTimeRestore` databases.
        """
        return pulumi.get(self, "restore_point_in_time")

    @restore_point_in_time.setter
    def restore_point_in_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_point_in_time", value)

    @_builtins.property
    @pulumi.getter(name="sampleName")
    def sample_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the sample schema to apply when creating this database. Possible value is `AdventureWorksLT`.
        """
        return pulumi.get(self, "sample_name")

    @sample_name.setter
    def sample_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sample_name", value)

    @_builtins.property
    @pulumi.getter(name="secondaryType")
    def secondary_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How do you want your replica to be made? Valid values include `Geo` and `Named`. Defaults to `Geo`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secondary_type")

    @secondary_type.setter
    def secondary_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_type", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the MS SQL Server on which to create the database. Changing this forces a new resource to be created.

        > **Note:** This setting is still required for "Serverless" SKUs
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="shortTermRetentionPolicy")
    def short_term_retention_policy(self) -> Optional[pulumi.Input['DatabaseShortTermRetentionPolicyArgs']]:
        """
        A `short_term_retention_policy` block as defined below.
        """
        return pulumi.get(self, "short_term_retention_policy")

    @short_term_retention_policy.setter
    def short_term_retention_policy(self, value: Optional[pulumi.Input['DatabaseShortTermRetentionPolicyArgs']]):
        pulumi.set(self, "short_term_retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the SKU used by the database. For example, `GP_S_Gen5_2`,`HS_Gen4_1`,`BC_Gen5_2`, `ElasticPool`, `Basic`,`S0`, `P2` ,`DW100c`, `DS100`. Changing this from the HyperScale service tier to another service tier will create a new resource.

        > **Note:** A full list of supported SKU names by region can be retrieved using the Azure CLI: `az sql db list-editions -l <region> -o table`

        > **Note:** The default `sku_name` value may differ between Azure locations depending on local availability of Gen4/Gen5 capacity. When databases are replicated using the `creation_source_database_id` property, the source (primary) database cannot have a higher SKU service tier than any secondary databases. When changing the `sku_name` of a database having one or more secondary databases, this resource will first update any secondary databases as necessary. In such cases it's recommended to use the same `sku_name` in your configuration for all related databases, as not doing so may cause an unresolvable diff during subsequent plans.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage account type used to store backups for this database. Possible values are `Geo`, `GeoZone`, `Local` and `Zone`. Defaults to `Geo`.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="threatDetectionPolicy")
    def threat_detection_policy(self) -> Optional[pulumi.Input['DatabaseThreatDetectionPolicyArgs']]:
        """
        Threat detection policy configuration. The `threat_detection_policy` block supports fields documented below.
        """
        return pulumi.get(self, "threat_detection_policy")

    @threat_detection_policy.setter
    def threat_detection_policy(self, value: Optional[pulumi.Input['DatabaseThreatDetectionPolicyArgs']]):
        pulumi.set(self, "threat_detection_policy", value)

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionEnabled")
    def transparent_data_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, Transparent Data Encryption will be enabled on the database. Defaults to `true`.

        > **Note:** `transparent_data_encryption_enabled` can only be set to `false` on DW (e.g, DataWarehouse) server SKUs.
        """
        return pulumi.get(self, "transparent_data_encryption_enabled")

    @transparent_data_encryption_enabled.setter
    def transparent_data_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transparent_data_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyAutomaticRotationEnabled")
    def transparent_data_encryption_key_automatic_rotation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag to specify whether TDE automatically rotates the encryption Key to latest version or not. Possible values are `true` or `false`. Defaults to `false`.

        > **Note:** When the `sku_name` is `DW100c`, the `transparent_data_encryption_key_automatic_rotation_enabled` and the `transparent_data_encryption_key_vault_key_id` properties should not be specified, as database-level CMK is not supported for Data Warehouse SKUs.
        """
        return pulumi.get(self, "transparent_data_encryption_key_automatic_rotation_enabled")

    @transparent_data_encryption_key_automatic_rotation_enabled.setter
    def transparent_data_encryption_key_automatic_rotation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transparent_data_encryption_key_automatic_rotation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyVaultKeyId")
    def transparent_data_encryption_key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.

        > **Note:** To successfully deploy a `Microsoft SQL Database` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.
        """
        return pulumi.get(self, "transparent_data_encryption_key_vault_key_id")

    @transparent_data_encryption_key_vault_key_id.setter
    def transparent_data_encryption_key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transparent_data_encryption_key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones. This property is only settable for Premium and Business Critical databases.
        """
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.type_token("azure:mssql/database:Database")
class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pause_delay_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_source_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 elastic_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enclave_type: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['DatabaseIdentityArgs', 'DatabaseIdentityArgsDict']]] = None,
                 import_: Optional[pulumi.Input[Union['DatabaseImportArgs', 'DatabaseImportArgsDict']]] = None,
                 ledger_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 long_term_retention_policy: Optional[pulumi.Input[Union['DatabaseLongTermRetentionPolicyArgs', 'DatabaseLongTermRetentionPolicyArgsDict']]] = None,
                 maintenance_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 min_capacity: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 read_scale: Optional[pulumi.Input[_builtins.bool]] = None,
                 recover_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_dropped_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_long_term_retention_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_point_in_time: Optional[pulumi.Input[_builtins.str]] = None,
                 sample_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_type: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 short_term_retention_policy: Optional[pulumi.Input[Union['DatabaseShortTermRetentionPolicyArgs', 'DatabaseShortTermRetentionPolicyArgsDict']]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_detection_policy: Optional[pulumi.Input[Union['DatabaseThreatDetectionPolicyArgs', 'DatabaseThreatDetectionPolicyArgsDict']]] = None,
                 transparent_data_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transparent_data_encryption_key_automatic_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transparent_data_encryption_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_server = azure.mssql.Server("example",
            name="example-sqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        example_database = azure.mssql.Database("example",
            name="example-db",
            server_id=example_server.id,
            collation="SQL_Latin1_General_CP1_CI_AS",
            license_type="LicenseIncluded",
            max_size_gb=2,
            sku_name="S0",
            enclave_type="VBS",
            tags={
                "foo": "bar",
            })
        ```

        ### Transparent Data Encryption(TDE) With A Customer Managed Key(CMK) During Create
        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-admin",
            location=example.location,
            resource_group_name=example.name)
        example_account = azure.storage.Account("example",
            name="examplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_server = azure.mssql.Server("example",
            name="example-sqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        # Create a key vault with access policies which allow for the current user to get, list, create, delete, update, recover, purge and getRotationPolicy for the key vault key and also add a key vault access policy for the Microsoft Sql Server instance User Managed Identity to get, wrap, and unwrap key(s)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="mssqltdeexample",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=example_user_assigned_identity.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=True,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current["tenantId"],
                    "object_id": current["objectId"],
                    "key_permissions": [
                        "Get",
                        "List",
                        "Create",
                        "Delete",
                        "Update",
                        "Recover",
                        "Purge",
                        "GetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": example_user_assigned_identity.tenant_id,
                    "object_id": example_user_assigned_identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "WrapKey",
                        "UnwrapKey",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_key_vault]))
        example_database = azure.mssql.Database("example",
            name="example-db",
            server_id=example_server.id,
            collation="SQL_Latin1_General_CP1_CI_AS",
            license_type="LicenseIncluded",
            max_size_gb=4,
            read_scale=True,
            sku_name="S0",
            zone_redundant=True,
            enclave_type="VBS",
            tags={
                "foo": "bar",
            },
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            transparent_data_encryption_key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        SQL Database can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/database:Database example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/databases/example1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] auto_pause_delay_in_minutes: Time in minutes after which database is automatically paused. A value of `-1` means that automatic pause is disabled. This property is only settable for Serverless databases.
        :param pulumi.Input[_builtins.str] collation: Specifies the collation of the database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] create_mode: The create mode of the database. Possible values are `Copy`, `Default`, `OnlineSecondary`, `PointInTimeRestore`, `Recovery`, `Restore`, `RestoreExternalBackup`, `RestoreExternalBackupSecondary`, `RestoreLongTermRetentionBackup` and `Secondary`. Mutually exclusive with `import`. Changing this forces a new resource to be created. Defaults to `Default`.
        :param pulumi.Input[_builtins.str] creation_source_database_id: The ID of the source database from which to create the new database. This should only be used for databases with `create_mode` values that use another database as reference. Changing this forces a new resource to be created.
               
               > **Note:** When configuring a secondary database, please be aware of the constraints for the `sku_name` property, as noted below, for both the primary and secondary databases. The `sku_name` of the secondary database may be inadvertently changed to match that of the primary when an incompatible combination of SKUs is detected by the provider.
        :param pulumi.Input[_builtins.str] elastic_pool_id: Specifies the ID of the elastic pool containing this database.
        :param pulumi.Input[_builtins.str] enclave_type: Specifies the type of enclave to be used by the elastic pool. When `enclave_type` is not specified (e.g., the default) enclaves are not enabled on the database. Once enabled (e.g., by specifying `Default` or `VBS`) removing the `enclave_type` field from the configuration file will force the creation of a new resource. Possible values are `Default` or `VBS`.
               
               > **Note:** `enclave_type` is currently not supported for DW (e.g, DataWarehouse) and DC-series SKUs.
               
               > **Note:** Geo Replicated and Failover databases must have the same `enclave_type`.
               
               > **Note:** The default value for the `enclave_type` field is unset not `Default`.
        :param pulumi.Input[_builtins.bool] geo_backup_enabled: A boolean that specifies if the Geo Backup Policy is enabled. Defaults to `true`.
               
               > **Note:** `geo_backup_enabled` is only applicable for DataWarehouse SKUs (DW*). This setting is ignored for all other SKUs.
        :param pulumi.Input[Union['DatabaseIdentityArgs', 'DatabaseIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['DatabaseImportArgs', 'DatabaseImportArgsDict']] import_: A `import` block as documented below. Mutually exclusive with `create_mode`.
        :param pulumi.Input[_builtins.bool] ledger_enabled: A boolean that specifies if this is a ledger database. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] license_type: Specifies the license type applied to this database. Possible values are `LicenseIncluded` and `BasePrice`.
        :param pulumi.Input[Union['DatabaseLongTermRetentionPolicyArgs', 'DatabaseLongTermRetentionPolicyArgsDict']] long_term_retention_policy: A `long_term_retention_policy` block as defined below.
        :param pulumi.Input[_builtins.str] maintenance_configuration_name: The name of the Public Maintenance Configuration window to apply to the database. Valid values include `SQL_Default`, `SQL_EastUS_DB_1`, `SQL_EastUS2_DB_1`, `SQL_SoutheastAsia_DB_1`, `SQL_AustraliaEast_DB_1`, `SQL_NorthEurope_DB_1`, `SQL_SouthCentralUS_DB_1`, `SQL_WestUS2_DB_1`, `SQL_UKSouth_DB_1`, `SQL_WestEurope_DB_1`, `SQL_EastUS_DB_2`, `SQL_EastUS2_DB_2`, `SQL_WestUS2_DB_2`, `SQL_SoutheastAsia_DB_2`, `SQL_AustraliaEast_DB_2`, `SQL_NorthEurope_DB_2`, `SQL_SouthCentralUS_DB_2`, `SQL_UKSouth_DB_2`, `SQL_WestEurope_DB_2`, `SQL_AustraliaSoutheast_DB_1`, `SQL_BrazilSouth_DB_1`, `SQL_CanadaCentral_DB_1`, `SQL_CanadaEast_DB_1`, `SQL_CentralUS_DB_1`, `SQL_EastAsia_DB_1`, `SQL_FranceCentral_DB_1`, `SQL_GermanyWestCentral_DB_1`, `SQL_CentralIndia_DB_1`, `SQL_SouthIndia_DB_1`, `SQL_JapanEast_DB_1`, `SQL_JapanWest_DB_1`, `SQL_NorthCentralUS_DB_1`, `SQL_UKWest_DB_1`, `SQL_WestUS_DB_1`, `SQL_AustraliaSoutheast_DB_2`, `SQL_BrazilSouth_DB_2`, `SQL_CanadaCentral_DB_2`, `SQL_CanadaEast_DB_2`, `SQL_CentralUS_DB_2`, `SQL_EastAsia_DB_2`, `SQL_FranceCentral_DB_2`, `SQL_GermanyWestCentral_DB_2`, `SQL_CentralIndia_DB_2`, `SQL_SouthIndia_DB_2`, `SQL_JapanEast_DB_2`, `SQL_JapanWest_DB_2`, `SQL_NorthCentralUS_DB_2`, `SQL_UKWest_DB_2`, `SQL_WestUS_DB_2`, `SQL_WestCentralUS_DB_1`, `SQL_FranceSouth_DB_1`, `SQL_WestCentralUS_DB_2`, `SQL_FranceSouth_DB_2`, `SQL_SwitzerlandNorth_DB_1`, `SQL_SwitzerlandNorth_DB_2`, `SQL_BrazilSoutheast_DB_1`, `SQL_UAENorth_DB_1`, `SQL_BrazilSoutheast_DB_2`, `SQL_UAENorth_DB_2`, `SQL_SouthAfricaNorth_DB_1`, `SQL_SouthAfricaNorth_DB_2`, `SQL_WestUS3_DB_1`, `SQL_WestUS3_DB_2`, `SQL_SwedenCentral_DB_1`, `SQL_SwedenCentral_DB_2`. Defaults to `SQL_Default`.
               
               > **Note:** `maintenance_configuration_name` is only applicable if `elastic_pool_id` is not set.
        :param pulumi.Input[_builtins.int] max_size_gb: The max size of the database in gigabytes.
               
               > **Note:** This value should not be configured when the `create_mode` is `Secondary` or `OnlineSecondary`, as the sizing of the primary is then used as per [Azure documentation](https://docs.microsoft.com/azure/azure-sql/database/single-database-scale#geo-replicated-database).
        :param pulumi.Input[_builtins.float] min_capacity: Minimal capacity that database will always have allocated, if not paused. This property is only settable for Serverless databases.
        :param pulumi.Input[_builtins.str] name: The name of the MS SQL Database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] read_replica_count: The number of readonly secondary replicas associated with the database to which readonly application intent connections may be routed. This property is only settable for Hyperscale edition databases.
        :param pulumi.Input[_builtins.bool] read_scale: If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica. This property is only settable for Premium and Business Critical databases.
        :param pulumi.Input[_builtins.str] recover_database_id: The ID of the database to be recovered. This property is only applicable when the `create_mode` is `Recovery`.
        :param pulumi.Input[_builtins.str] recovery_point_id: The ID of the Recovery Services Recovery Point Id to be restored. This property is only applicable when the `create_mode` is `Recovery`.
        :param pulumi.Input[_builtins.str] restore_dropped_database_id: The ID of the database to be restored. This property is only applicable when the `create_mode` is `Restore`.
        :param pulumi.Input[_builtins.str] restore_long_term_retention_backup_id: The ID of the long term retention backup to be restored. This property is only applicable when the `create_mode` is `RestoreLongTermRetentionBackup`.
        :param pulumi.Input[_builtins.str] restore_point_in_time: Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. This property is only settable for `create_mode`= `PointInTimeRestore` databases.
        :param pulumi.Input[_builtins.str] sample_name: Specifies the name of the sample schema to apply when creating this database. Possible value is `AdventureWorksLT`.
        :param pulumi.Input[_builtins.str] secondary_type: How do you want your replica to be made? Valid values include `Geo` and `Named`. Defaults to `Geo`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] server_id: The id of the MS SQL Server on which to create the database. Changing this forces a new resource to be created.
               
               > **Note:** This setting is still required for "Serverless" SKUs
        :param pulumi.Input[Union['DatabaseShortTermRetentionPolicyArgs', 'DatabaseShortTermRetentionPolicyArgsDict']] short_term_retention_policy: A `short_term_retention_policy` block as defined below.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the name of the SKU used by the database. For example, `GP_S_Gen5_2`,`HS_Gen4_1`,`BC_Gen5_2`, `ElasticPool`, `Basic`,`S0`, `P2` ,`DW100c`, `DS100`. Changing this from the HyperScale service tier to another service tier will create a new resource.
               
               > **Note:** A full list of supported SKU names by region can be retrieved using the Azure CLI: `az sql db list-editions -l <region> -o table`
               
               > **Note:** The default `sku_name` value may differ between Azure locations depending on local availability of Gen4/Gen5 capacity. When databases are replicated using the `creation_source_database_id` property, the source (primary) database cannot have a higher SKU service tier than any secondary databases. When changing the `sku_name` of a database having one or more secondary databases, this resource will first update any secondary databases as necessary. In such cases it's recommended to use the same `sku_name` in your configuration for all related databases, as not doing so may cause an unresolvable diff during subsequent plans.
        :param pulumi.Input[_builtins.str] storage_account_type: Specifies the storage account type used to store backups for this database. Possible values are `Geo`, `GeoZone`, `Local` and `Zone`. Defaults to `Geo`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['DatabaseThreatDetectionPolicyArgs', 'DatabaseThreatDetectionPolicyArgsDict']] threat_detection_policy: Threat detection policy configuration. The `threat_detection_policy` block supports fields documented below.
        :param pulumi.Input[_builtins.bool] transparent_data_encryption_enabled: If set to true, Transparent Data Encryption will be enabled on the database. Defaults to `true`.
               
               > **Note:** `transparent_data_encryption_enabled` can only be set to `false` on DW (e.g, DataWarehouse) server SKUs.
        :param pulumi.Input[_builtins.bool] transparent_data_encryption_key_automatic_rotation_enabled: Boolean flag to specify whether TDE automatically rotates the encryption Key to latest version or not. Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** When the `sku_name` is `DW100c`, the `transparent_data_encryption_key_automatic_rotation_enabled` and the `transparent_data_encryption_key_vault_key_id` properties should not be specified, as database-level CMK is not supported for Data Warehouse SKUs.
        :param pulumi.Input[_builtins.str] transparent_data_encryption_key_vault_key_id: The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.
               
               > **Note:** To successfully deploy a `Microsoft SQL Database` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.
        :param pulumi.Input[_builtins.bool] zone_redundant: Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones. This property is only settable for Premium and Business Critical databases.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_server = azure.mssql.Server("example",
            name="example-sqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        example_database = azure.mssql.Database("example",
            name="example-db",
            server_id=example_server.id,
            collation="SQL_Latin1_General_CP1_CI_AS",
            license_type="LicenseIncluded",
            max_size_gb=2,
            sku_name="S0",
            enclave_type="VBS",
            tags={
                "foo": "bar",
            })
        ```

        ### Transparent Data Encryption(TDE) With A Customer Managed Key(CMK) During Create
        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-admin",
            location=example.location,
            resource_group_name=example.name)
        example_account = azure.storage.Account("example",
            name="examplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_server = azure.mssql.Server("example",
            name="example-sqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        # Create a key vault with access policies which allow for the current user to get, list, create, delete, update, recover, purge and getRotationPolicy for the key vault key and also add a key vault access policy for the Microsoft Sql Server instance User Managed Identity to get, wrap, and unwrap key(s)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="mssqltdeexample",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=example_user_assigned_identity.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=True,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current["tenantId"],
                    "object_id": current["objectId"],
                    "key_permissions": [
                        "Get",
                        "List",
                        "Create",
                        "Delete",
                        "Update",
                        "Recover",
                        "Purge",
                        "GetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": example_user_assigned_identity.tenant_id,
                    "object_id": example_user_assigned_identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "WrapKey",
                        "UnwrapKey",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_key_vault]))
        example_database = azure.mssql.Database("example",
            name="example-db",
            server_id=example_server.id,
            collation="SQL_Latin1_General_CP1_CI_AS",
            license_type="LicenseIncluded",
            max_size_gb=4,
            read_scale=True,
            sku_name="S0",
            zone_redundant=True,
            enclave_type="VBS",
            tags={
                "foo": "bar",
            },
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            transparent_data_encryption_key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        SQL Database can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/database:Database example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/databases/example1
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pause_delay_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_source_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 elastic_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enclave_type: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['DatabaseIdentityArgs', 'DatabaseIdentityArgsDict']]] = None,
                 import_: Optional[pulumi.Input[Union['DatabaseImportArgs', 'DatabaseImportArgsDict']]] = None,
                 ledger_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 long_term_retention_policy: Optional[pulumi.Input[Union['DatabaseLongTermRetentionPolicyArgs', 'DatabaseLongTermRetentionPolicyArgsDict']]] = None,
                 maintenance_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 min_capacity: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 read_scale: Optional[pulumi.Input[_builtins.bool]] = None,
                 recover_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_dropped_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_long_term_retention_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_point_in_time: Optional[pulumi.Input[_builtins.str]] = None,
                 sample_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_type: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 short_term_retention_policy: Optional[pulumi.Input[Union['DatabaseShortTermRetentionPolicyArgs', 'DatabaseShortTermRetentionPolicyArgsDict']]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 threat_detection_policy: Optional[pulumi.Input[Union['DatabaseThreatDetectionPolicyArgs', 'DatabaseThreatDetectionPolicyArgsDict']]] = None,
                 transparent_data_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transparent_data_encryption_key_automatic_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 transparent_data_encryption_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            __props__.__dict__["auto_pause_delay_in_minutes"] = auto_pause_delay_in_minutes
            __props__.__dict__["collation"] = collation
            __props__.__dict__["create_mode"] = create_mode
            __props__.__dict__["creation_source_database_id"] = creation_source_database_id
            __props__.__dict__["elastic_pool_id"] = elastic_pool_id
            __props__.__dict__["enclave_type"] = enclave_type
            __props__.__dict__["geo_backup_enabled"] = geo_backup_enabled
            __props__.__dict__["identity"] = identity
            __props__.__dict__["import_"] = import_
            __props__.__dict__["ledger_enabled"] = ledger_enabled
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["long_term_retention_policy"] = long_term_retention_policy
            __props__.__dict__["maintenance_configuration_name"] = maintenance_configuration_name
            __props__.__dict__["max_size_gb"] = max_size_gb
            __props__.__dict__["min_capacity"] = min_capacity
            __props__.__dict__["name"] = name
            __props__.__dict__["read_replica_count"] = read_replica_count
            __props__.__dict__["read_scale"] = read_scale
            __props__.__dict__["recover_database_id"] = recover_database_id
            __props__.__dict__["recovery_point_id"] = recovery_point_id
            __props__.__dict__["restore_dropped_database_id"] = restore_dropped_database_id
            __props__.__dict__["restore_long_term_retention_backup_id"] = restore_long_term_retention_backup_id
            __props__.__dict__["restore_point_in_time"] = restore_point_in_time
            __props__.__dict__["sample_name"] = sample_name
            __props__.__dict__["secondary_type"] = secondary_type
            if server_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_id'")
            __props__.__dict__["server_id"] = server_id
            __props__.__dict__["short_term_retention_policy"] = short_term_retention_policy
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["storage_account_type"] = storage_account_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["threat_detection_policy"] = threat_detection_policy
            __props__.__dict__["transparent_data_encryption_enabled"] = transparent_data_encryption_enabled
            __props__.__dict__["transparent_data_encryption_key_automatic_rotation_enabled"] = transparent_data_encryption_key_automatic_rotation_enabled
            __props__.__dict__["transparent_data_encryption_key_vault_key_id"] = transparent_data_encryption_key_vault_key_id
            __props__.__dict__["zone_redundant"] = zone_redundant
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:sql/database:Database")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Database, __self__).__init__(
            'azure:mssql/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pause_delay_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            collation: Optional[pulumi.Input[_builtins.str]] = None,
            create_mode: Optional[pulumi.Input[_builtins.str]] = None,
            creation_source_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            elastic_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            enclave_type: Optional[pulumi.Input[_builtins.str]] = None,
            geo_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['DatabaseIdentityArgs', 'DatabaseIdentityArgsDict']]] = None,
            import_: Optional[pulumi.Input[Union['DatabaseImportArgs', 'DatabaseImportArgsDict']]] = None,
            ledger_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            license_type: Optional[pulumi.Input[_builtins.str]] = None,
            long_term_retention_policy: Optional[pulumi.Input[Union['DatabaseLongTermRetentionPolicyArgs', 'DatabaseLongTermRetentionPolicyArgsDict']]] = None,
            maintenance_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
            max_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
            min_capacity: Optional[pulumi.Input[_builtins.float]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            read_replica_count: Optional[pulumi.Input[_builtins.int]] = None,
            read_scale: Optional[pulumi.Input[_builtins.bool]] = None,
            recover_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_point_id: Optional[pulumi.Input[_builtins.str]] = None,
            restore_dropped_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            restore_long_term_retention_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
            restore_point_in_time: Optional[pulumi.Input[_builtins.str]] = None,
            sample_name: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_type: Optional[pulumi.Input[_builtins.str]] = None,
            server_id: Optional[pulumi.Input[_builtins.str]] = None,
            short_term_retention_policy: Optional[pulumi.Input[Union['DatabaseShortTermRetentionPolicyArgs', 'DatabaseShortTermRetentionPolicyArgsDict']]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            threat_detection_policy: Optional[pulumi.Input[Union['DatabaseThreatDetectionPolicyArgs', 'DatabaseThreatDetectionPolicyArgsDict']]] = None,
            transparent_data_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            transparent_data_encryption_key_automatic_rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            transparent_data_encryption_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] auto_pause_delay_in_minutes: Time in minutes after which database is automatically paused. A value of `-1` means that automatic pause is disabled. This property is only settable for Serverless databases.
        :param pulumi.Input[_builtins.str] collation: Specifies the collation of the database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] create_mode: The create mode of the database. Possible values are `Copy`, `Default`, `OnlineSecondary`, `PointInTimeRestore`, `Recovery`, `Restore`, `RestoreExternalBackup`, `RestoreExternalBackupSecondary`, `RestoreLongTermRetentionBackup` and `Secondary`. Mutually exclusive with `import`. Changing this forces a new resource to be created. Defaults to `Default`.
        :param pulumi.Input[_builtins.str] creation_source_database_id: The ID of the source database from which to create the new database. This should only be used for databases with `create_mode` values that use another database as reference. Changing this forces a new resource to be created.
               
               > **Note:** When configuring a secondary database, please be aware of the constraints for the `sku_name` property, as noted below, for both the primary and secondary databases. The `sku_name` of the secondary database may be inadvertently changed to match that of the primary when an incompatible combination of SKUs is detected by the provider.
        :param pulumi.Input[_builtins.str] elastic_pool_id: Specifies the ID of the elastic pool containing this database.
        :param pulumi.Input[_builtins.str] enclave_type: Specifies the type of enclave to be used by the elastic pool. When `enclave_type` is not specified (e.g., the default) enclaves are not enabled on the database. Once enabled (e.g., by specifying `Default` or `VBS`) removing the `enclave_type` field from the configuration file will force the creation of a new resource. Possible values are `Default` or `VBS`.
               
               > **Note:** `enclave_type` is currently not supported for DW (e.g, DataWarehouse) and DC-series SKUs.
               
               > **Note:** Geo Replicated and Failover databases must have the same `enclave_type`.
               
               > **Note:** The default value for the `enclave_type` field is unset not `Default`.
        :param pulumi.Input[_builtins.bool] geo_backup_enabled: A boolean that specifies if the Geo Backup Policy is enabled. Defaults to `true`.
               
               > **Note:** `geo_backup_enabled` is only applicable for DataWarehouse SKUs (DW*). This setting is ignored for all other SKUs.
        :param pulumi.Input[Union['DatabaseIdentityArgs', 'DatabaseIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['DatabaseImportArgs', 'DatabaseImportArgsDict']] import_: A `import` block as documented below. Mutually exclusive with `create_mode`.
        :param pulumi.Input[_builtins.bool] ledger_enabled: A boolean that specifies if this is a ledger database. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] license_type: Specifies the license type applied to this database. Possible values are `LicenseIncluded` and `BasePrice`.
        :param pulumi.Input[Union['DatabaseLongTermRetentionPolicyArgs', 'DatabaseLongTermRetentionPolicyArgsDict']] long_term_retention_policy: A `long_term_retention_policy` block as defined below.
        :param pulumi.Input[_builtins.str] maintenance_configuration_name: The name of the Public Maintenance Configuration window to apply to the database. Valid values include `SQL_Default`, `SQL_EastUS_DB_1`, `SQL_EastUS2_DB_1`, `SQL_SoutheastAsia_DB_1`, `SQL_AustraliaEast_DB_1`, `SQL_NorthEurope_DB_1`, `SQL_SouthCentralUS_DB_1`, `SQL_WestUS2_DB_1`, `SQL_UKSouth_DB_1`, `SQL_WestEurope_DB_1`, `SQL_EastUS_DB_2`, `SQL_EastUS2_DB_2`, `SQL_WestUS2_DB_2`, `SQL_SoutheastAsia_DB_2`, `SQL_AustraliaEast_DB_2`, `SQL_NorthEurope_DB_2`, `SQL_SouthCentralUS_DB_2`, `SQL_UKSouth_DB_2`, `SQL_WestEurope_DB_2`, `SQL_AustraliaSoutheast_DB_1`, `SQL_BrazilSouth_DB_1`, `SQL_CanadaCentral_DB_1`, `SQL_CanadaEast_DB_1`, `SQL_CentralUS_DB_1`, `SQL_EastAsia_DB_1`, `SQL_FranceCentral_DB_1`, `SQL_GermanyWestCentral_DB_1`, `SQL_CentralIndia_DB_1`, `SQL_SouthIndia_DB_1`, `SQL_JapanEast_DB_1`, `SQL_JapanWest_DB_1`, `SQL_NorthCentralUS_DB_1`, `SQL_UKWest_DB_1`, `SQL_WestUS_DB_1`, `SQL_AustraliaSoutheast_DB_2`, `SQL_BrazilSouth_DB_2`, `SQL_CanadaCentral_DB_2`, `SQL_CanadaEast_DB_2`, `SQL_CentralUS_DB_2`, `SQL_EastAsia_DB_2`, `SQL_FranceCentral_DB_2`, `SQL_GermanyWestCentral_DB_2`, `SQL_CentralIndia_DB_2`, `SQL_SouthIndia_DB_2`, `SQL_JapanEast_DB_2`, `SQL_JapanWest_DB_2`, `SQL_NorthCentralUS_DB_2`, `SQL_UKWest_DB_2`, `SQL_WestUS_DB_2`, `SQL_WestCentralUS_DB_1`, `SQL_FranceSouth_DB_1`, `SQL_WestCentralUS_DB_2`, `SQL_FranceSouth_DB_2`, `SQL_SwitzerlandNorth_DB_1`, `SQL_SwitzerlandNorth_DB_2`, `SQL_BrazilSoutheast_DB_1`, `SQL_UAENorth_DB_1`, `SQL_BrazilSoutheast_DB_2`, `SQL_UAENorth_DB_2`, `SQL_SouthAfricaNorth_DB_1`, `SQL_SouthAfricaNorth_DB_2`, `SQL_WestUS3_DB_1`, `SQL_WestUS3_DB_2`, `SQL_SwedenCentral_DB_1`, `SQL_SwedenCentral_DB_2`. Defaults to `SQL_Default`.
               
               > **Note:** `maintenance_configuration_name` is only applicable if `elastic_pool_id` is not set.
        :param pulumi.Input[_builtins.int] max_size_gb: The max size of the database in gigabytes.
               
               > **Note:** This value should not be configured when the `create_mode` is `Secondary` or `OnlineSecondary`, as the sizing of the primary is then used as per [Azure documentation](https://docs.microsoft.com/azure/azure-sql/database/single-database-scale#geo-replicated-database).
        :param pulumi.Input[_builtins.float] min_capacity: Minimal capacity that database will always have allocated, if not paused. This property is only settable for Serverless databases.
        :param pulumi.Input[_builtins.str] name: The name of the MS SQL Database. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] read_replica_count: The number of readonly secondary replicas associated with the database to which readonly application intent connections may be routed. This property is only settable for Hyperscale edition databases.
        :param pulumi.Input[_builtins.bool] read_scale: If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica. This property is only settable for Premium and Business Critical databases.
        :param pulumi.Input[_builtins.str] recover_database_id: The ID of the database to be recovered. This property is only applicable when the `create_mode` is `Recovery`.
        :param pulumi.Input[_builtins.str] recovery_point_id: The ID of the Recovery Services Recovery Point Id to be restored. This property is only applicable when the `create_mode` is `Recovery`.
        :param pulumi.Input[_builtins.str] restore_dropped_database_id: The ID of the database to be restored. This property is only applicable when the `create_mode` is `Restore`.
        :param pulumi.Input[_builtins.str] restore_long_term_retention_backup_id: The ID of the long term retention backup to be restored. This property is only applicable when the `create_mode` is `RestoreLongTermRetentionBackup`.
        :param pulumi.Input[_builtins.str] restore_point_in_time: Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. This property is only settable for `create_mode`= `PointInTimeRestore` databases.
        :param pulumi.Input[_builtins.str] sample_name: Specifies the name of the sample schema to apply when creating this database. Possible value is `AdventureWorksLT`.
        :param pulumi.Input[_builtins.str] secondary_type: How do you want your replica to be made? Valid values include `Geo` and `Named`. Defaults to `Geo`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] server_id: The id of the MS SQL Server on which to create the database. Changing this forces a new resource to be created.
               
               > **Note:** This setting is still required for "Serverless" SKUs
        :param pulumi.Input[Union['DatabaseShortTermRetentionPolicyArgs', 'DatabaseShortTermRetentionPolicyArgsDict']] short_term_retention_policy: A `short_term_retention_policy` block as defined below.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the name of the SKU used by the database. For example, `GP_S_Gen5_2`,`HS_Gen4_1`,`BC_Gen5_2`, `ElasticPool`, `Basic`,`S0`, `P2` ,`DW100c`, `DS100`. Changing this from the HyperScale service tier to another service tier will create a new resource.
               
               > **Note:** A full list of supported SKU names by region can be retrieved using the Azure CLI: `az sql db list-editions -l <region> -o table`
               
               > **Note:** The default `sku_name` value may differ between Azure locations depending on local availability of Gen4/Gen5 capacity. When databases are replicated using the `creation_source_database_id` property, the source (primary) database cannot have a higher SKU service tier than any secondary databases. When changing the `sku_name` of a database having one or more secondary databases, this resource will first update any secondary databases as necessary. In such cases it's recommended to use the same `sku_name` in your configuration for all related databases, as not doing so may cause an unresolvable diff during subsequent plans.
        :param pulumi.Input[_builtins.str] storage_account_type: Specifies the storage account type used to store backups for this database. Possible values are `Geo`, `GeoZone`, `Local` and `Zone`. Defaults to `Geo`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['DatabaseThreatDetectionPolicyArgs', 'DatabaseThreatDetectionPolicyArgsDict']] threat_detection_policy: Threat detection policy configuration. The `threat_detection_policy` block supports fields documented below.
        :param pulumi.Input[_builtins.bool] transparent_data_encryption_enabled: If set to true, Transparent Data Encryption will be enabled on the database. Defaults to `true`.
               
               > **Note:** `transparent_data_encryption_enabled` can only be set to `false` on DW (e.g, DataWarehouse) server SKUs.
        :param pulumi.Input[_builtins.bool] transparent_data_encryption_key_automatic_rotation_enabled: Boolean flag to specify whether TDE automatically rotates the encryption Key to latest version or not. Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** When the `sku_name` is `DW100c`, the `transparent_data_encryption_key_automatic_rotation_enabled` and the `transparent_data_encryption_key_vault_key_id` properties should not be specified, as database-level CMK is not supported for Data Warehouse SKUs.
        :param pulumi.Input[_builtins.str] transparent_data_encryption_key_vault_key_id: The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.
               
               > **Note:** To successfully deploy a `Microsoft SQL Database` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.
        :param pulumi.Input[_builtins.bool] zone_redundant: Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones. This property is only settable for Premium and Business Critical databases.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["auto_pause_delay_in_minutes"] = auto_pause_delay_in_minutes
        __props__.__dict__["collation"] = collation
        __props__.__dict__["create_mode"] = create_mode
        __props__.__dict__["creation_source_database_id"] = creation_source_database_id
        __props__.__dict__["elastic_pool_id"] = elastic_pool_id
        __props__.__dict__["enclave_type"] = enclave_type
        __props__.__dict__["geo_backup_enabled"] = geo_backup_enabled
        __props__.__dict__["identity"] = identity
        __props__.__dict__["import_"] = import_
        __props__.__dict__["ledger_enabled"] = ledger_enabled
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["long_term_retention_policy"] = long_term_retention_policy
        __props__.__dict__["maintenance_configuration_name"] = maintenance_configuration_name
        __props__.__dict__["max_size_gb"] = max_size_gb
        __props__.__dict__["min_capacity"] = min_capacity
        __props__.__dict__["name"] = name
        __props__.__dict__["read_replica_count"] = read_replica_count
        __props__.__dict__["read_scale"] = read_scale
        __props__.__dict__["recover_database_id"] = recover_database_id
        __props__.__dict__["recovery_point_id"] = recovery_point_id
        __props__.__dict__["restore_dropped_database_id"] = restore_dropped_database_id
        __props__.__dict__["restore_long_term_retention_backup_id"] = restore_long_term_retention_backup_id
        __props__.__dict__["restore_point_in_time"] = restore_point_in_time
        __props__.__dict__["sample_name"] = sample_name
        __props__.__dict__["secondary_type"] = secondary_type
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["short_term_retention_policy"] = short_term_retention_policy
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["storage_account_type"] = storage_account_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["threat_detection_policy"] = threat_detection_policy
        __props__.__dict__["transparent_data_encryption_enabled"] = transparent_data_encryption_enabled
        __props__.__dict__["transparent_data_encryption_key_automatic_rotation_enabled"] = transparent_data_encryption_key_automatic_rotation_enabled
        __props__.__dict__["transparent_data_encryption_key_vault_key_id"] = transparent_data_encryption_key_vault_key_id
        __props__.__dict__["zone_redundant"] = zone_redundant
        return Database(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPauseDelayInMinutes")
    def auto_pause_delay_in_minutes(self) -> pulumi.Output[_builtins.int]:
        """
        Time in minutes after which database is automatically paused. A value of `-1` means that automatic pause is disabled. This property is only settable for Serverless databases.
        """
        return pulumi.get(self, "auto_pause_delay_in_minutes")

    @_builtins.property
    @pulumi.getter
    def collation(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the collation of the database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "collation")

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The create mode of the database. Possible values are `Copy`, `Default`, `OnlineSecondary`, `PointInTimeRestore`, `Recovery`, `Restore`, `RestoreExternalBackup`, `RestoreExternalBackupSecondary`, `RestoreLongTermRetentionBackup` and `Secondary`. Mutually exclusive with `import`. Changing this forces a new resource to be created. Defaults to `Default`.
        """
        return pulumi.get(self, "create_mode")

    @_builtins.property
    @pulumi.getter(name="creationSourceDatabaseId")
    def creation_source_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the source database from which to create the new database. This should only be used for databases with `create_mode` values that use another database as reference. Changing this forces a new resource to be created.

        > **Note:** When configuring a secondary database, please be aware of the constraints for the `sku_name` property, as noted below, for both the primary and secondary databases. The `sku_name` of the secondary database may be inadvertently changed to match that of the primary when an incompatible combination of SKUs is detected by the provider.
        """
        return pulumi.get(self, "creation_source_database_id")

    @_builtins.property
    @pulumi.getter(name="elasticPoolId")
    def elastic_pool_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the elastic pool containing this database.
        """
        return pulumi.get(self, "elastic_pool_id")

    @_builtins.property
    @pulumi.getter(name="enclaveType")
    def enclave_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of enclave to be used by the elastic pool. When `enclave_type` is not specified (e.g., the default) enclaves are not enabled on the database. Once enabled (e.g., by specifying `Default` or `VBS`) removing the `enclave_type` field from the configuration file will force the creation of a new resource. Possible values are `Default` or `VBS`.

        > **Note:** `enclave_type` is currently not supported for DW (e.g, DataWarehouse) and DC-series SKUs.

        > **Note:** Geo Replicated and Failover databases must have the same `enclave_type`.

        > **Note:** The default value for the `enclave_type` field is unset not `Default`.
        """
        return pulumi.get(self, "enclave_type")

    @_builtins.property
    @pulumi.getter(name="geoBackupEnabled")
    def geo_backup_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean that specifies if the Geo Backup Policy is enabled. Defaults to `true`.

        > **Note:** `geo_backup_enabled` is only applicable for DataWarehouse SKUs (DW*). This setting is ignored for all other SKUs.
        """
        return pulumi.get(self, "geo_backup_enabled")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.DatabaseIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="import")
    def import_(self) -> pulumi.Output[Optional['outputs.DatabaseImport']]:
        """
        A `import` block as documented below. Mutually exclusive with `create_mode`.
        """
        return pulumi.get(self, "import_")

    @_builtins.property
    @pulumi.getter(name="ledgerEnabled")
    def ledger_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        A boolean that specifies if this is a ledger database. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ledger_enabled")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the license type applied to this database. Possible values are `LicenseIncluded` and `BasePrice`.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter(name="longTermRetentionPolicy")
    def long_term_retention_policy(self) -> pulumi.Output['outputs.DatabaseLongTermRetentionPolicy']:
        """
        A `long_term_retention_policy` block as defined below.
        """
        return pulumi.get(self, "long_term_retention_policy")

    @_builtins.property
    @pulumi.getter(name="maintenanceConfigurationName")
    def maintenance_configuration_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Public Maintenance Configuration window to apply to the database. Valid values include `SQL_Default`, `SQL_EastUS_DB_1`, `SQL_EastUS2_DB_1`, `SQL_SoutheastAsia_DB_1`, `SQL_AustraliaEast_DB_1`, `SQL_NorthEurope_DB_1`, `SQL_SouthCentralUS_DB_1`, `SQL_WestUS2_DB_1`, `SQL_UKSouth_DB_1`, `SQL_WestEurope_DB_1`, `SQL_EastUS_DB_2`, `SQL_EastUS2_DB_2`, `SQL_WestUS2_DB_2`, `SQL_SoutheastAsia_DB_2`, `SQL_AustraliaEast_DB_2`, `SQL_NorthEurope_DB_2`, `SQL_SouthCentralUS_DB_2`, `SQL_UKSouth_DB_2`, `SQL_WestEurope_DB_2`, `SQL_AustraliaSoutheast_DB_1`, `SQL_BrazilSouth_DB_1`, `SQL_CanadaCentral_DB_1`, `SQL_CanadaEast_DB_1`, `SQL_CentralUS_DB_1`, `SQL_EastAsia_DB_1`, `SQL_FranceCentral_DB_1`, `SQL_GermanyWestCentral_DB_1`, `SQL_CentralIndia_DB_1`, `SQL_SouthIndia_DB_1`, `SQL_JapanEast_DB_1`, `SQL_JapanWest_DB_1`, `SQL_NorthCentralUS_DB_1`, `SQL_UKWest_DB_1`, `SQL_WestUS_DB_1`, `SQL_AustraliaSoutheast_DB_2`, `SQL_BrazilSouth_DB_2`, `SQL_CanadaCentral_DB_2`, `SQL_CanadaEast_DB_2`, `SQL_CentralUS_DB_2`, `SQL_EastAsia_DB_2`, `SQL_FranceCentral_DB_2`, `SQL_GermanyWestCentral_DB_2`, `SQL_CentralIndia_DB_2`, `SQL_SouthIndia_DB_2`, `SQL_JapanEast_DB_2`, `SQL_JapanWest_DB_2`, `SQL_NorthCentralUS_DB_2`, `SQL_UKWest_DB_2`, `SQL_WestUS_DB_2`, `SQL_WestCentralUS_DB_1`, `SQL_FranceSouth_DB_1`, `SQL_WestCentralUS_DB_2`, `SQL_FranceSouth_DB_2`, `SQL_SwitzerlandNorth_DB_1`, `SQL_SwitzerlandNorth_DB_2`, `SQL_BrazilSoutheast_DB_1`, `SQL_UAENorth_DB_1`, `SQL_BrazilSoutheast_DB_2`, `SQL_UAENorth_DB_2`, `SQL_SouthAfricaNorth_DB_1`, `SQL_SouthAfricaNorth_DB_2`, `SQL_WestUS3_DB_1`, `SQL_WestUS3_DB_2`, `SQL_SwedenCentral_DB_1`, `SQL_SwedenCentral_DB_2`. Defaults to `SQL_Default`.

        > **Note:** `maintenance_configuration_name` is only applicable if `elastic_pool_id` is not set.
        """
        return pulumi.get(self, "maintenance_configuration_name")

    @_builtins.property
    @pulumi.getter(name="maxSizeGb")
    def max_size_gb(self) -> pulumi.Output[_builtins.int]:
        """
        The max size of the database in gigabytes.

        > **Note:** This value should not be configured when the `create_mode` is `Secondary` or `OnlineSecondary`, as the sizing of the primary is then used as per [Azure documentation](https://docs.microsoft.com/azure/azure-sql/database/single-database-scale#geo-replicated-database).
        """
        return pulumi.get(self, "max_size_gb")

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Output[_builtins.float]:
        """
        Minimal capacity that database will always have allocated, if not paused. This property is only settable for Serverless databases.
        """
        return pulumi.get(self, "min_capacity")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the MS SQL Database. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readReplicaCount")
    def read_replica_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of readonly secondary replicas associated with the database to which readonly application intent connections may be routed. This property is only settable for Hyperscale edition databases.
        """
        return pulumi.get(self, "read_replica_count")

    @_builtins.property
    @pulumi.getter(name="readScale")
    def read_scale(self) -> pulumi.Output[_builtins.bool]:
        """
        If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica. This property is only settable for Premium and Business Critical databases.
        """
        return pulumi.get(self, "read_scale")

    @_builtins.property
    @pulumi.getter(name="recoverDatabaseId")
    def recover_database_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the database to be recovered. This property is only applicable when the `create_mode` is `Recovery`.
        """
        return pulumi.get(self, "recover_database_id")

    @_builtins.property
    @pulumi.getter(name="recoveryPointId")
    def recovery_point_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Recovery Services Recovery Point Id to be restored. This property is only applicable when the `create_mode` is `Recovery`.
        """
        return pulumi.get(self, "recovery_point_id")

    @_builtins.property
    @pulumi.getter(name="restoreDroppedDatabaseId")
    def restore_dropped_database_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the database to be restored. This property is only applicable when the `create_mode` is `Restore`.
        """
        return pulumi.get(self, "restore_dropped_database_id")

    @_builtins.property
    @pulumi.getter(name="restoreLongTermRetentionBackupId")
    def restore_long_term_retention_backup_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the long term retention backup to be restored. This property is only applicable when the `create_mode` is `RestoreLongTermRetentionBackup`.
        """
        return pulumi.get(self, "restore_long_term_retention_backup_id")

    @_builtins.property
    @pulumi.getter(name="restorePointInTime")
    def restore_point_in_time(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. This property is only settable for `create_mode`= `PointInTimeRestore` databases.
        """
        return pulumi.get(self, "restore_point_in_time")

    @_builtins.property
    @pulumi.getter(name="sampleName")
    def sample_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the sample schema to apply when creating this database. Possible value is `AdventureWorksLT`.
        """
        return pulumi.get(self, "sample_name")

    @_builtins.property
    @pulumi.getter(name="secondaryType")
    def secondary_type(self) -> pulumi.Output[_builtins.str]:
        """
        How do you want your replica to be made? Valid values include `Geo` and `Named`. Defaults to `Geo`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secondary_type")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the MS SQL Server on which to create the database. Changing this forces a new resource to be created.

        > **Note:** This setting is still required for "Serverless" SKUs
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="shortTermRetentionPolicy")
    def short_term_retention_policy(self) -> pulumi.Output['outputs.DatabaseShortTermRetentionPolicy']:
        """
        A `short_term_retention_policy` block as defined below.
        """
        return pulumi.get(self, "short_term_retention_policy")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the SKU used by the database. For example, `GP_S_Gen5_2`,`HS_Gen4_1`,`BC_Gen5_2`, `ElasticPool`, `Basic`,`S0`, `P2` ,`DW100c`, `DS100`. Changing this from the HyperScale service tier to another service tier will create a new resource.

        > **Note:** A full list of supported SKU names by region can be retrieved using the Azure CLI: `az sql db list-editions -l <region> -o table`

        > **Note:** The default `sku_name` value may differ between Azure locations depending on local availability of Gen4/Gen5 capacity. When databases are replicated using the `creation_source_database_id` property, the source (primary) database cannot have a higher SKU service tier than any secondary databases. When changing the `sku_name` of a database having one or more secondary databases, this resource will first update any secondary databases as necessary. In such cases it's recommended to use the same `sku_name` in your configuration for all related databases, as not doing so may cause an unresolvable diff during subsequent plans.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the storage account type used to store backups for this database. Possible values are `Geo`, `GeoZone`, `Local` and `Zone`. Defaults to `Geo`.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="threatDetectionPolicy")
    def threat_detection_policy(self) -> pulumi.Output['outputs.DatabaseThreatDetectionPolicy']:
        """
        Threat detection policy configuration. The `threat_detection_policy` block supports fields documented below.
        """
        return pulumi.get(self, "threat_detection_policy")

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionEnabled")
    def transparent_data_encryption_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, Transparent Data Encryption will be enabled on the database. Defaults to `true`.

        > **Note:** `transparent_data_encryption_enabled` can only be set to `false` on DW (e.g, DataWarehouse) server SKUs.
        """
        return pulumi.get(self, "transparent_data_encryption_enabled")

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyAutomaticRotationEnabled")
    def transparent_data_encryption_key_automatic_rotation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag to specify whether TDE automatically rotates the encryption Key to latest version or not. Possible values are `true` or `false`. Defaults to `false`.

        > **Note:** When the `sku_name` is `DW100c`, the `transparent_data_encryption_key_automatic_rotation_enabled` and the `transparent_data_encryption_key_vault_key_id` properties should not be specified, as database-level CMK is not supported for Data Warehouse SKUs.
        """
        return pulumi.get(self, "transparent_data_encryption_key_automatic_rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyVaultKeyId")
    def transparent_data_encryption_key_vault_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.

        > **Note:** To successfully deploy a `Microsoft SQL Database` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.
        """
        return pulumi.get(self, "transparent_data_encryption_key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones. This property is only settable for Premium and Business Critical databases.
        """
        return pulumi.get(self, "zone_redundant")

