# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServerResult',
    'AwaitableGetServerResult',
    'get_server',
    'get_server_output',
]

@pulumi.output_type
class GetServerResult:
    """
    A collection of values returned by getServer.
    """
    def __init__(__self__, administrator_login=None, express_vulnerability_assessment_enabled=None, fully_qualified_domain_name=None, id=None, identities=None, location=None, name=None, resource_group_name=None, restorable_dropped_database_ids=None, tags=None, transparent_data_encryption_key_vault_key_id=None, version=None):
        if administrator_login and not isinstance(administrator_login, str):
            raise TypeError("Expected argument 'administrator_login' to be a str")
        pulumi.set(__self__, "administrator_login", administrator_login)
        if express_vulnerability_assessment_enabled and not isinstance(express_vulnerability_assessment_enabled, bool):
            raise TypeError("Expected argument 'express_vulnerability_assessment_enabled' to be a bool")
        pulumi.set(__self__, "express_vulnerability_assessment_enabled", express_vulnerability_assessment_enabled)
        if fully_qualified_domain_name and not isinstance(fully_qualified_domain_name, str):
            raise TypeError("Expected argument 'fully_qualified_domain_name' to be a str")
        pulumi.set(__self__, "fully_qualified_domain_name", fully_qualified_domain_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if restorable_dropped_database_ids and not isinstance(restorable_dropped_database_ids, list):
            raise TypeError("Expected argument 'restorable_dropped_database_ids' to be a list")
        pulumi.set(__self__, "restorable_dropped_database_ids", restorable_dropped_database_ids)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if transparent_data_encryption_key_vault_key_id and not isinstance(transparent_data_encryption_key_vault_key_id, str):
            raise TypeError("Expected argument 'transparent_data_encryption_key_vault_key_id' to be a str")
        pulumi.set(__self__, "transparent_data_encryption_key_vault_key_id", transparent_data_encryption_key_vault_key_id)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> _builtins.str:
        """
        The administrator login name of the Microsoft SQL Server.
        """
        return pulumi.get(self, "administrator_login")

    @_builtins.property
    @pulumi.getter(name="expressVulnerabilityAssessmentEnabled")
    def express_vulnerability_assessment_enabled(self) -> _builtins.bool:
        """
        Whether the Express Vulnerability Assessment Configuration is enabled.
        """
        return pulumi.get(self, "express_vulnerability_assessment_enabled")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedDomainName")
    def fully_qualified_domain_name(self) -> _builtins.str:
        """
        The fully qualified domain name of the Microsoft SQL Server.
        """
        return pulumi.get(self, "fully_qualified_domain_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetServerIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Microsoft SQL Server exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="restorableDroppedDatabaseIds")
    def restorable_dropped_database_ids(self) -> Sequence[_builtins.str]:
        """
        A list of dropped restorable database IDs on the Microsoft SQL Server.
        """
        return pulumi.get(self, "restorable_dropped_database_ids")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to this Microsoft SQL Server.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyVaultKeyId")
    def transparent_data_encryption_key_vault_key_id(self) -> _builtins.str:
        """
        The Key Vault Key URI to be used as the `Customer Managed Key` (CMK/BYOK) for the `Transparent Data Encryption` (TDE) layer.
        """
        return pulumi.get(self, "transparent_data_encryption_key_vault_key_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the Microsoft SQL Server.
        """
        return pulumi.get(self, "version")


class AwaitableGetServerResult(GetServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerResult(
            administrator_login=self.administrator_login,
            express_vulnerability_assessment_enabled=self.express_vulnerability_assessment_enabled,
            fully_qualified_domain_name=self.fully_qualified_domain_name,
            id=self.id,
            identities=self.identities,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            restorable_dropped_database_ids=self.restorable_dropped_database_ids,
            tags=self.tags,
            transparent_data_encryption_key_vault_key_id=self.transparent_data_encryption_key_vault_key_id,
            version=self.version)


def get_server(name: Optional[_builtins.str] = None,
               resource_group_name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerResult:
    """
    Use this data source to access information about an existing Microsoft SQL Server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mssql.get_server(name="existingMsSqlServer",
        resource_group_name="existingResGroup")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Sql`: 2023-08-01-preview


    :param _builtins.str name: The name of this Microsoft SQL Server.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Microsoft SQL Server exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:mssql/getServer:getServer', __args__, opts=opts, typ=GetServerResult).value

    return AwaitableGetServerResult(
        administrator_login=pulumi.get(__ret__, 'administrator_login'),
        express_vulnerability_assessment_enabled=pulumi.get(__ret__, 'express_vulnerability_assessment_enabled'),
        fully_qualified_domain_name=pulumi.get(__ret__, 'fully_qualified_domain_name'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        restorable_dropped_database_ids=pulumi.get(__ret__, 'restorable_dropped_database_ids'),
        tags=pulumi.get(__ret__, 'tags'),
        transparent_data_encryption_key_vault_key_id=pulumi.get(__ret__, 'transparent_data_encryption_key_vault_key_id'),
        version=pulumi.get(__ret__, 'version'))
def get_server_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                      resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerResult]:
    """
    Use this data source to access information about an existing Microsoft SQL Server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mssql.get_server(name="existingMsSqlServer",
        resource_group_name="existingResGroup")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Sql`: 2023-08-01-preview


    :param _builtins.str name: The name of this Microsoft SQL Server.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Microsoft SQL Server exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:mssql/getServer:getServer', __args__, opts=opts, typ=GetServerResult)
    return __ret__.apply(lambda __response__: GetServerResult(
        administrator_login=pulumi.get(__response__, 'administrator_login'),
        express_vulnerability_assessment_enabled=pulumi.get(__response__, 'express_vulnerability_assessment_enabled'),
        fully_qualified_domain_name=pulumi.get(__response__, 'fully_qualified_domain_name'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        restorable_dropped_database_ids=pulumi.get(__response__, 'restorable_dropped_database_ids'),
        tags=pulumi.get(__response__, 'tags'),
        transparent_data_encryption_key_vault_key_id=pulumi.get(__response__, 'transparent_data_encryption_key_vault_key_id'),
        version=pulumi.get(__response__, 'version')))
