# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobStepArgs', 'JobStep']

@pulumi.input_type
class JobStepArgs:
    def __init__(__self__, *,
                 job_credential_id: pulumi.Input[_builtins.str],
                 job_id: pulumi.Input[_builtins.str],
                 job_step_index: pulumi.Input[_builtins.int],
                 job_target_group_id: pulumi.Input[_builtins.str],
                 sql_script: pulumi.Input[_builtins.str],
                 initial_retry_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_retry_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_target: Optional[pulumi.Input['JobStepOutputTargetArgs']] = None,
                 retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_interval_backoff_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a JobStep resource.
        :param pulumi.Input[_builtins.str] job_credential_id: The ID of the Elastic Job Credential to use when executing this Elastic Job Step.
        :param pulumi.Input[_builtins.str] job_id: The ID of the Elastic Job. Changing this forces a new Elastic Job Step to be created.
        :param pulumi.Input[_builtins.int] job_step_index: The index at which to insert this Elastic Job Step into the Elastic Job.
               
               > **Note:** This value must be greater than or equal to 1 and less than or equal to the number of job steps in the Elastic Job.
        :param pulumi.Input[_builtins.str] job_target_group_id: The ID of the Elastic Job Target Group.
        :param pulumi.Input[_builtins.str] sql_script: The T-SQL script to be executed by this Elastic Job Step.
               
               > **Note:** While Azure places no restrictions on the script provided here, it is recommended to ensure the script is idempotent.
        :param pulumi.Input[_builtins.int] initial_retry_interval_seconds: The initial retry interval in seconds. Defaults to `1`.
        :param pulumi.Input[_builtins.int] maximum_retry_interval_seconds: The maximum retry interval in seconds. Defaults to `120`.
               
               > **Note:** `maximum_retry_interval_seconds` must be greater than `initial_retry_interval_seconds`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Elastic Job Step. Changing this forces a new Elastic Job Step to be created.
        :param pulumi.Input['JobStepOutputTargetArgs'] output_target: An `output_target` block as defined below.
        :param pulumi.Input[_builtins.int] retry_attempts: The number of retry attempts. Defaults to `10`.
        :param pulumi.Input[_builtins.float] retry_interval_backoff_multiplier: The multiplier for time between retries. Defaults to `2`.
        :param pulumi.Input[_builtins.int] timeout_seconds: The execution timeout in seconds for this Elastic Job Step. Defaults to `43200`.
        """
        pulumi.set(__self__, "job_credential_id", job_credential_id)
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "job_step_index", job_step_index)
        pulumi.set(__self__, "job_target_group_id", job_target_group_id)
        pulumi.set(__self__, "sql_script", sql_script)
        if initial_retry_interval_seconds is not None:
            pulumi.set(__self__, "initial_retry_interval_seconds", initial_retry_interval_seconds)
        if maximum_retry_interval_seconds is not None:
            pulumi.set(__self__, "maximum_retry_interval_seconds", maximum_retry_interval_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_target is not None:
            pulumi.set(__self__, "output_target", output_target)
        if retry_attempts is not None:
            pulumi.set(__self__, "retry_attempts", retry_attempts)
        if retry_interval_backoff_multiplier is not None:
            pulumi.set(__self__, "retry_interval_backoff_multiplier", retry_interval_backoff_multiplier)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="jobCredentialId")
    def job_credential_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Elastic Job Credential to use when executing this Elastic Job Step.
        """
        return pulumi.get(self, "job_credential_id")

    @job_credential_id.setter
    def job_credential_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "job_credential_id", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Elastic Job. Changing this forces a new Elastic Job Step to be created.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="jobStepIndex")
    def job_step_index(self) -> pulumi.Input[_builtins.int]:
        """
        The index at which to insert this Elastic Job Step into the Elastic Job.

        > **Note:** This value must be greater than or equal to 1 and less than or equal to the number of job steps in the Elastic Job.
        """
        return pulumi.get(self, "job_step_index")

    @job_step_index.setter
    def job_step_index(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "job_step_index", value)

    @_builtins.property
    @pulumi.getter(name="jobTargetGroupId")
    def job_target_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Elastic Job Target Group.
        """
        return pulumi.get(self, "job_target_group_id")

    @job_target_group_id.setter
    def job_target_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "job_target_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sqlScript")
    def sql_script(self) -> pulumi.Input[_builtins.str]:
        """
        The T-SQL script to be executed by this Elastic Job Step.

        > **Note:** While Azure places no restrictions on the script provided here, it is recommended to ensure the script is idempotent.
        """
        return pulumi.get(self, "sql_script")

    @sql_script.setter
    def sql_script(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sql_script", value)

    @_builtins.property
    @pulumi.getter(name="initialRetryIntervalSeconds")
    def initial_retry_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial retry interval in seconds. Defaults to `1`.
        """
        return pulumi.get(self, "initial_retry_interval_seconds")

    @initial_retry_interval_seconds.setter
    def initial_retry_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial_retry_interval_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maximumRetryIntervalSeconds")
    def maximum_retry_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum retry interval in seconds. Defaults to `120`.

        > **Note:** `maximum_retry_interval_seconds` must be greater than `initial_retry_interval_seconds`.
        """
        return pulumi.get(self, "maximum_retry_interval_seconds")

    @maximum_retry_interval_seconds.setter
    def maximum_retry_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_retry_interval_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Elastic Job Step. Changing this forces a new Elastic Job Step to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputTarget")
    def output_target(self) -> Optional[pulumi.Input['JobStepOutputTargetArgs']]:
        """
        An `output_target` block as defined below.
        """
        return pulumi.get(self, "output_target")

    @output_target.setter
    def output_target(self, value: Optional[pulumi.Input['JobStepOutputTargetArgs']]):
        pulumi.set(self, "output_target", value)

    @_builtins.property
    @pulumi.getter(name="retryAttempts")
    def retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of retry attempts. Defaults to `10`.
        """
        return pulumi.get(self, "retry_attempts")

    @retry_attempts.setter
    def retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_attempts", value)

    @_builtins.property
    @pulumi.getter(name="retryIntervalBackoffMultiplier")
    def retry_interval_backoff_multiplier(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The multiplier for time between retries. Defaults to `2`.
        """
        return pulumi.get(self, "retry_interval_backoff_multiplier")

    @retry_interval_backoff_multiplier.setter
    def retry_interval_backoff_multiplier(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "retry_interval_backoff_multiplier", value)

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The execution timeout in seconds for this Elastic Job Step. Defaults to `43200`.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class _JobStepState:
    def __init__(__self__, *,
                 initial_retry_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 job_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_step_index: Optional[pulumi.Input[_builtins.int]] = None,
                 job_target_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_retry_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_target: Optional[pulumi.Input['JobStepOutputTargetArgs']] = None,
                 retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_interval_backoff_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 sql_script: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering JobStep resources.
        :param pulumi.Input[_builtins.int] initial_retry_interval_seconds: The initial retry interval in seconds. Defaults to `1`.
        :param pulumi.Input[_builtins.str] job_credential_id: The ID of the Elastic Job Credential to use when executing this Elastic Job Step.
        :param pulumi.Input[_builtins.str] job_id: The ID of the Elastic Job. Changing this forces a new Elastic Job Step to be created.
        :param pulumi.Input[_builtins.int] job_step_index: The index at which to insert this Elastic Job Step into the Elastic Job.
               
               > **Note:** This value must be greater than or equal to 1 and less than or equal to the number of job steps in the Elastic Job.
        :param pulumi.Input[_builtins.str] job_target_group_id: The ID of the Elastic Job Target Group.
        :param pulumi.Input[_builtins.int] maximum_retry_interval_seconds: The maximum retry interval in seconds. Defaults to `120`.
               
               > **Note:** `maximum_retry_interval_seconds` must be greater than `initial_retry_interval_seconds`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Elastic Job Step. Changing this forces a new Elastic Job Step to be created.
        :param pulumi.Input['JobStepOutputTargetArgs'] output_target: An `output_target` block as defined below.
        :param pulumi.Input[_builtins.int] retry_attempts: The number of retry attempts. Defaults to `10`.
        :param pulumi.Input[_builtins.float] retry_interval_backoff_multiplier: The multiplier for time between retries. Defaults to `2`.
        :param pulumi.Input[_builtins.str] sql_script: The T-SQL script to be executed by this Elastic Job Step.
               
               > **Note:** While Azure places no restrictions on the script provided here, it is recommended to ensure the script is idempotent.
        :param pulumi.Input[_builtins.int] timeout_seconds: The execution timeout in seconds for this Elastic Job Step. Defaults to `43200`.
        """
        if initial_retry_interval_seconds is not None:
            pulumi.set(__self__, "initial_retry_interval_seconds", initial_retry_interval_seconds)
        if job_credential_id is not None:
            pulumi.set(__self__, "job_credential_id", job_credential_id)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if job_step_index is not None:
            pulumi.set(__self__, "job_step_index", job_step_index)
        if job_target_group_id is not None:
            pulumi.set(__self__, "job_target_group_id", job_target_group_id)
        if maximum_retry_interval_seconds is not None:
            pulumi.set(__self__, "maximum_retry_interval_seconds", maximum_retry_interval_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_target is not None:
            pulumi.set(__self__, "output_target", output_target)
        if retry_attempts is not None:
            pulumi.set(__self__, "retry_attempts", retry_attempts)
        if retry_interval_backoff_multiplier is not None:
            pulumi.set(__self__, "retry_interval_backoff_multiplier", retry_interval_backoff_multiplier)
        if sql_script is not None:
            pulumi.set(__self__, "sql_script", sql_script)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="initialRetryIntervalSeconds")
    def initial_retry_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The initial retry interval in seconds. Defaults to `1`.
        """
        return pulumi.get(self, "initial_retry_interval_seconds")

    @initial_retry_interval_seconds.setter
    def initial_retry_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial_retry_interval_seconds", value)

    @_builtins.property
    @pulumi.getter(name="jobCredentialId")
    def job_credential_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Elastic Job Credential to use when executing this Elastic Job Step.
        """
        return pulumi.get(self, "job_credential_id")

    @job_credential_id.setter
    def job_credential_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_credential_id", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Elastic Job. Changing this forces a new Elastic Job Step to be created.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="jobStepIndex")
    def job_step_index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The index at which to insert this Elastic Job Step into the Elastic Job.

        > **Note:** This value must be greater than or equal to 1 and less than or equal to the number of job steps in the Elastic Job.
        """
        return pulumi.get(self, "job_step_index")

    @job_step_index.setter
    def job_step_index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "job_step_index", value)

    @_builtins.property
    @pulumi.getter(name="jobTargetGroupId")
    def job_target_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Elastic Job Target Group.
        """
        return pulumi.get(self, "job_target_group_id")

    @job_target_group_id.setter
    def job_target_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_target_group_id", value)

    @_builtins.property
    @pulumi.getter(name="maximumRetryIntervalSeconds")
    def maximum_retry_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum retry interval in seconds. Defaults to `120`.

        > **Note:** `maximum_retry_interval_seconds` must be greater than `initial_retry_interval_seconds`.
        """
        return pulumi.get(self, "maximum_retry_interval_seconds")

    @maximum_retry_interval_seconds.setter
    def maximum_retry_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_retry_interval_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Elastic Job Step. Changing this forces a new Elastic Job Step to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputTarget")
    def output_target(self) -> Optional[pulumi.Input['JobStepOutputTargetArgs']]:
        """
        An `output_target` block as defined below.
        """
        return pulumi.get(self, "output_target")

    @output_target.setter
    def output_target(self, value: Optional[pulumi.Input['JobStepOutputTargetArgs']]):
        pulumi.set(self, "output_target", value)

    @_builtins.property
    @pulumi.getter(name="retryAttempts")
    def retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of retry attempts. Defaults to `10`.
        """
        return pulumi.get(self, "retry_attempts")

    @retry_attempts.setter
    def retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_attempts", value)

    @_builtins.property
    @pulumi.getter(name="retryIntervalBackoffMultiplier")
    def retry_interval_backoff_multiplier(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The multiplier for time between retries. Defaults to `2`.
        """
        return pulumi.get(self, "retry_interval_backoff_multiplier")

    @retry_interval_backoff_multiplier.setter
    def retry_interval_backoff_multiplier(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "retry_interval_backoff_multiplier", value)

    @_builtins.property
    @pulumi.getter(name="sqlScript")
    def sql_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The T-SQL script to be executed by this Elastic Job Step.

        > **Note:** While Azure places no restrictions on the script provided here, it is recommended to ensure the script is idempotent.
        """
        return pulumi.get(self, "sql_script")

    @sql_script.setter
    def sql_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_script", value)

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The execution timeout in seconds for this Elastic Job Step. Defaults to `43200`.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.type_token("azure:mssql/jobStep:JobStep")
class JobStep(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 initial_retry_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 job_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_step_index: Optional[pulumi.Input[_builtins.int]] = None,
                 job_target_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_retry_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_target: Optional[pulumi.Input[Union['JobStepOutputTargetArgs', 'JobStepOutputTargetArgsDict']]] = None,
                 retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_interval_backoff_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 sql_script: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages an Elastic Job Step.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="westeurope")
        example_server = azure.mssql.Server("example",
            name="example-server",
            location=example.location,
            resource_group_name=example.name,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        example_database = azure.mssql.Database("example",
            name="example-db",
            server_id=example_server.id,
            collation="SQL_Latin1_General_CP1_CI_AS",
            sku_name="S1")
        example_job_agent = azure.mssql.JobAgent("example",
            name="example-job-agent",
            location=example.location,
            database_id=example_database.id)
        example_job_credential = azure.mssql.JobCredential("example",
            name="example-job-credential",
            job_agent_id=example_job_agent.id,
            username="testusername",
            password="testpassword")
        example_job_target_group = azure.mssql.JobTargetGroup("example",
            name="example-target-group",
            job_agent_id=example_job_agent.id,
            job_targets=[{
                "server_name": example_server.name,
                "database_name": example_database.name,
                "job_credential_id": example_job_credential.id,
            }])
        example_job = azure.mssql.Job("example",
            name="example-job",
            job_agent_id=example_job_agent.id,
            description="example description")
        test = azure.mssql.JobStep("test",
            name="example-job-step",
            job_id=example_job.id,
            job_credential_id=example_job_credential.id,
            job_target_group_id=example_job_target_group.id,
            job_step_index=1,
            sql_script=\"\"\"IF NOT EXISTS (SELECT * FROM sys.objects WHERE [name] = N'Pets')
          CREATE TABLE Pets (
            Animal NVARCHAR(50),
            Name NVARCHAR(50),
          );
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        Elastic Job Steps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/jobStep:JobStep example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Sql/servers/myserver1/jobAgents/myjobagent1/jobs/myjob1/steps/myjobstep1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] initial_retry_interval_seconds: The initial retry interval in seconds. Defaults to `1`.
        :param pulumi.Input[_builtins.str] job_credential_id: The ID of the Elastic Job Credential to use when executing this Elastic Job Step.
        :param pulumi.Input[_builtins.str] job_id: The ID of the Elastic Job. Changing this forces a new Elastic Job Step to be created.
        :param pulumi.Input[_builtins.int] job_step_index: The index at which to insert this Elastic Job Step into the Elastic Job.
               
               > **Note:** This value must be greater than or equal to 1 and less than or equal to the number of job steps in the Elastic Job.
        :param pulumi.Input[_builtins.str] job_target_group_id: The ID of the Elastic Job Target Group.
        :param pulumi.Input[_builtins.int] maximum_retry_interval_seconds: The maximum retry interval in seconds. Defaults to `120`.
               
               > **Note:** `maximum_retry_interval_seconds` must be greater than `initial_retry_interval_seconds`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Elastic Job Step. Changing this forces a new Elastic Job Step to be created.
        :param pulumi.Input[Union['JobStepOutputTargetArgs', 'JobStepOutputTargetArgsDict']] output_target: An `output_target` block as defined below.
        :param pulumi.Input[_builtins.int] retry_attempts: The number of retry attempts. Defaults to `10`.
        :param pulumi.Input[_builtins.float] retry_interval_backoff_multiplier: The multiplier for time between retries. Defaults to `2`.
        :param pulumi.Input[_builtins.str] sql_script: The T-SQL script to be executed by this Elastic Job Step.
               
               > **Note:** While Azure places no restrictions on the script provided here, it is recommended to ensure the script is idempotent.
        :param pulumi.Input[_builtins.int] timeout_seconds: The execution timeout in seconds for this Elastic Job Step. Defaults to `43200`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobStepArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Elastic Job Step.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="westeurope")
        example_server = azure.mssql.Server("example",
            name="example-server",
            location=example.location,
            resource_group_name=example.name,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        example_database = azure.mssql.Database("example",
            name="example-db",
            server_id=example_server.id,
            collation="SQL_Latin1_General_CP1_CI_AS",
            sku_name="S1")
        example_job_agent = azure.mssql.JobAgent("example",
            name="example-job-agent",
            location=example.location,
            database_id=example_database.id)
        example_job_credential = azure.mssql.JobCredential("example",
            name="example-job-credential",
            job_agent_id=example_job_agent.id,
            username="testusername",
            password="testpassword")
        example_job_target_group = azure.mssql.JobTargetGroup("example",
            name="example-target-group",
            job_agent_id=example_job_agent.id,
            job_targets=[{
                "server_name": example_server.name,
                "database_name": example_database.name,
                "job_credential_id": example_job_credential.id,
            }])
        example_job = azure.mssql.Job("example",
            name="example-job",
            job_agent_id=example_job_agent.id,
            description="example description")
        test = azure.mssql.JobStep("test",
            name="example-job-step",
            job_id=example_job.id,
            job_credential_id=example_job_credential.id,
            job_target_group_id=example_job_target_group.id,
            job_step_index=1,
            sql_script=\"\"\"IF NOT EXISTS (SELECT * FROM sys.objects WHERE [name] = N'Pets')
          CREATE TABLE Pets (
            Animal NVARCHAR(50),
            Name NVARCHAR(50),
          );
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        Elastic Job Steps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/jobStep:JobStep example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Sql/servers/myserver1/jobAgents/myjobagent1/jobs/myjob1/steps/myjobstep1
        ```

        :param str resource_name: The name of the resource.
        :param JobStepArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobStepArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 initial_retry_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 job_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_step_index: Optional[pulumi.Input[_builtins.int]] = None,
                 job_target_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_retry_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_target: Optional[pulumi.Input[Union['JobStepOutputTargetArgs', 'JobStepOutputTargetArgsDict']]] = None,
                 retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_interval_backoff_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 sql_script: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobStepArgs.__new__(JobStepArgs)

            __props__.__dict__["initial_retry_interval_seconds"] = initial_retry_interval_seconds
            if job_credential_id is None and not opts.urn:
                raise TypeError("Missing required property 'job_credential_id'")
            __props__.__dict__["job_credential_id"] = job_credential_id
            if job_id is None and not opts.urn:
                raise TypeError("Missing required property 'job_id'")
            __props__.__dict__["job_id"] = job_id
            if job_step_index is None and not opts.urn:
                raise TypeError("Missing required property 'job_step_index'")
            __props__.__dict__["job_step_index"] = job_step_index
            if job_target_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'job_target_group_id'")
            __props__.__dict__["job_target_group_id"] = job_target_group_id
            __props__.__dict__["maximum_retry_interval_seconds"] = maximum_retry_interval_seconds
            __props__.__dict__["name"] = name
            __props__.__dict__["output_target"] = output_target
            __props__.__dict__["retry_attempts"] = retry_attempts
            __props__.__dict__["retry_interval_backoff_multiplier"] = retry_interval_backoff_multiplier
            if sql_script is None and not opts.urn:
                raise TypeError("Missing required property 'sql_script'")
            __props__.__dict__["sql_script"] = sql_script
            __props__.__dict__["timeout_seconds"] = timeout_seconds
        super(JobStep, __self__).__init__(
            'azure:mssql/jobStep:JobStep',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            initial_retry_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            job_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
            job_id: Optional[pulumi.Input[_builtins.str]] = None,
            job_step_index: Optional[pulumi.Input[_builtins.int]] = None,
            job_target_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            maximum_retry_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            output_target: Optional[pulumi.Input[Union['JobStepOutputTargetArgs', 'JobStepOutputTargetArgsDict']]] = None,
            retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
            retry_interval_backoff_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
            sql_script: Optional[pulumi.Input[_builtins.str]] = None,
            timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None) -> 'JobStep':
        """
        Get an existing JobStep resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] initial_retry_interval_seconds: The initial retry interval in seconds. Defaults to `1`.
        :param pulumi.Input[_builtins.str] job_credential_id: The ID of the Elastic Job Credential to use when executing this Elastic Job Step.
        :param pulumi.Input[_builtins.str] job_id: The ID of the Elastic Job. Changing this forces a new Elastic Job Step to be created.
        :param pulumi.Input[_builtins.int] job_step_index: The index at which to insert this Elastic Job Step into the Elastic Job.
               
               > **Note:** This value must be greater than or equal to 1 and less than or equal to the number of job steps in the Elastic Job.
        :param pulumi.Input[_builtins.str] job_target_group_id: The ID of the Elastic Job Target Group.
        :param pulumi.Input[_builtins.int] maximum_retry_interval_seconds: The maximum retry interval in seconds. Defaults to `120`.
               
               > **Note:** `maximum_retry_interval_seconds` must be greater than `initial_retry_interval_seconds`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Elastic Job Step. Changing this forces a new Elastic Job Step to be created.
        :param pulumi.Input[Union['JobStepOutputTargetArgs', 'JobStepOutputTargetArgsDict']] output_target: An `output_target` block as defined below.
        :param pulumi.Input[_builtins.int] retry_attempts: The number of retry attempts. Defaults to `10`.
        :param pulumi.Input[_builtins.float] retry_interval_backoff_multiplier: The multiplier for time between retries. Defaults to `2`.
        :param pulumi.Input[_builtins.str] sql_script: The T-SQL script to be executed by this Elastic Job Step.
               
               > **Note:** While Azure places no restrictions on the script provided here, it is recommended to ensure the script is idempotent.
        :param pulumi.Input[_builtins.int] timeout_seconds: The execution timeout in seconds for this Elastic Job Step. Defaults to `43200`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobStepState.__new__(_JobStepState)

        __props__.__dict__["initial_retry_interval_seconds"] = initial_retry_interval_seconds
        __props__.__dict__["job_credential_id"] = job_credential_id
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["job_step_index"] = job_step_index
        __props__.__dict__["job_target_group_id"] = job_target_group_id
        __props__.__dict__["maximum_retry_interval_seconds"] = maximum_retry_interval_seconds
        __props__.__dict__["name"] = name
        __props__.__dict__["output_target"] = output_target
        __props__.__dict__["retry_attempts"] = retry_attempts
        __props__.__dict__["retry_interval_backoff_multiplier"] = retry_interval_backoff_multiplier
        __props__.__dict__["sql_script"] = sql_script
        __props__.__dict__["timeout_seconds"] = timeout_seconds
        return JobStep(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="initialRetryIntervalSeconds")
    def initial_retry_interval_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The initial retry interval in seconds. Defaults to `1`.
        """
        return pulumi.get(self, "initial_retry_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="jobCredentialId")
    def job_credential_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Elastic Job Credential to use when executing this Elastic Job Step.
        """
        return pulumi.get(self, "job_credential_id")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Elastic Job. Changing this forces a new Elastic Job Step to be created.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="jobStepIndex")
    def job_step_index(self) -> pulumi.Output[_builtins.int]:
        """
        The index at which to insert this Elastic Job Step into the Elastic Job.

        > **Note:** This value must be greater than or equal to 1 and less than or equal to the number of job steps in the Elastic Job.
        """
        return pulumi.get(self, "job_step_index")

    @_builtins.property
    @pulumi.getter(name="jobTargetGroupId")
    def job_target_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Elastic Job Target Group.
        """
        return pulumi.get(self, "job_target_group_id")

    @_builtins.property
    @pulumi.getter(name="maximumRetryIntervalSeconds")
    def maximum_retry_interval_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum retry interval in seconds. Defaults to `120`.

        > **Note:** `maximum_retry_interval_seconds` must be greater than `initial_retry_interval_seconds`.
        """
        return pulumi.get(self, "maximum_retry_interval_seconds")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Elastic Job Step. Changing this forces a new Elastic Job Step to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outputTarget")
    def output_target(self) -> pulumi.Output[Optional['outputs.JobStepOutputTarget']]:
        """
        An `output_target` block as defined below.
        """
        return pulumi.get(self, "output_target")

    @_builtins.property
    @pulumi.getter(name="retryAttempts")
    def retry_attempts(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of retry attempts. Defaults to `10`.
        """
        return pulumi.get(self, "retry_attempts")

    @_builtins.property
    @pulumi.getter(name="retryIntervalBackoffMultiplier")
    def retry_interval_backoff_multiplier(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The multiplier for time between retries. Defaults to `2`.
        """
        return pulumi.get(self, "retry_interval_backoff_multiplier")

    @_builtins.property
    @pulumi.getter(name="sqlScript")
    def sql_script(self) -> pulumi.Output[_builtins.str]:
        """
        The T-SQL script to be executed by this Elastic Job Step.

        > **Note:** While Azure places no restrictions on the script provided here, it is recommended to ensure the script is idempotent.
        """
        return pulumi.get(self, "sql_script")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The execution timeout in seconds for this Elastic Job Step. Defaults to `43200`.
        """
        return pulumi.get(self, "timeout_seconds")

