# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 azuread_administrator: Optional[pulumi.Input['ServerAzureadAdministratorArgs']] = None,
                 connection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 express_vulnerability_assessment_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ServerIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_network_restriction_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 primary_user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transparent_data_encryption_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Microsoft SQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] version: The version for the new server. Valid values are: 2.0 (for v11 server) and 12.0 (for v12 server). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] administrator_login: The administrator login name for the new server. Required unless `azuread_authentication_only` in the `azuread_administrator` block is `true`. When omitted, Azure will generate a default username which cannot be subsequently changed. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] administrator_login_password: The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx).
        :param pulumi.Input[_builtins.int] administrator_login_password_wo_version: An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        :param pulumi.Input['ServerAzureadAdministratorArgs'] azuread_administrator: An `azuread_administrator` block as defined below.
        :param pulumi.Input[_builtins.str] connection_policy: The connection policy the server will use. Possible values are `Default`, `Proxy`, and `Redirect`. Defaults to `Default`.
        :param pulumi.Input[_builtins.bool] express_vulnerability_assessment_enabled: Whether to enable the Express Vulnerability Assessment Configuration. Defaults to `false`.
               
               > **Note:** If you have enabled the Classic SQL Vulnerability Assessment configuration using the `mssql.ServerVulnerabilityAssessment` resource, you must first delete it before enabling `express_vulnerability_assessment_enabled`. If you wish to revert back to using the Classic SQL Vulnerability Assessment configuration you must first disable this setting.
        :param pulumi.Input['ServerIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` , `1.2` and `Disabled`. Defaults to `1.2`.
               
               > **Note:** The `minimum_tls_version` is set to `Disabled` means all TLS versions are allowed. After you enforce a version of `minimum_tls_version`, it's not possible to revert to `Disabled`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the Microsoft SQL Server. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] outbound_network_restriction_enabled: Whether outbound network traffic is restricted for this server. Defaults to `false`.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity_id: Specifies the primary user managed identity id. Required if `type` within the `identity` block is set to either `SystemAssigned, UserAssigned` or `UserAssigned` and should be set at same time as setting `identity_ids`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for this server. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transparent_data_encryption_key_vault_key_id: The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.
               
               > **Note:** To successfully deploy a `Microsoft SQL Server` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.
               
               > **Note:** Cross-tenant `Key Vault` and `Microsoft SQL Server` interactions are not supported. Please see the [product documentation](https://learn.microsoft.com/azure/azure-sql/database/transparent-data-encryption-byok-overview?view=azuresql#requirements-for-configuring-customer-managed-tde) for more information.
               
               > **Note:** When using a firewall with a `Key Vault`, you must enable the option `Allow trusted Microsoft services to bypass the firewall`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "version", version)
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if administrator_login_password_wo_version is not None:
            pulumi.set(__self__, "administrator_login_password_wo_version", administrator_login_password_wo_version)
        if azuread_administrator is not None:
            pulumi.set(__self__, "azuread_administrator", azuread_administrator)
        if connection_policy is not None:
            pulumi.set(__self__, "connection_policy", connection_policy)
        if express_vulnerability_assessment_enabled is not None:
            pulumi.set(__self__, "express_vulnerability_assessment_enabled", express_vulnerability_assessment_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_network_restriction_enabled is not None:
            pulumi.set(__self__, "outbound_network_restriction_enabled", outbound_network_restriction_enabled)
        if primary_user_assigned_identity_id is not None:
            pulumi.set(__self__, "primary_user_assigned_identity_id", primary_user_assigned_identity_id)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transparent_data_encryption_key_vault_key_id is not None:
            pulumi.set(__self__, "transparent_data_encryption_key_vault_key_id", transparent_data_encryption_key_vault_key_id)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Microsoft SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The version for the new server. Valid values are: 2.0 (for v11 server) and 12.0 (for v12 server). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The administrator login name for the new server. Required unless `azuread_authentication_only` in the `azuread_administrator` block is `true`. When omitted, Azure will generate a default username which cannot be subsequently changed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_login", value)

    @_builtins.property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx).
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_login_password", value)

    @_builtins.property
    @pulumi.getter(name="administratorLoginPasswordWoVersion")
    def administrator_login_password_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        """
        return pulumi.get(self, "administrator_login_password_wo_version")

    @administrator_login_password_wo_version.setter
    def administrator_login_password_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "administrator_login_password_wo_version", value)

    @_builtins.property
    @pulumi.getter(name="azureadAdministrator")
    def azuread_administrator(self) -> Optional[pulumi.Input['ServerAzureadAdministratorArgs']]:
        """
        An `azuread_administrator` block as defined below.
        """
        return pulumi.get(self, "azuread_administrator")

    @azuread_administrator.setter
    def azuread_administrator(self, value: Optional[pulumi.Input['ServerAzureadAdministratorArgs']]):
        pulumi.set(self, "azuread_administrator", value)

    @_builtins.property
    @pulumi.getter(name="connectionPolicy")
    def connection_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection policy the server will use. Possible values are `Default`, `Proxy`, and `Redirect`. Defaults to `Default`.
        """
        return pulumi.get(self, "connection_policy")

    @connection_policy.setter
    def connection_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_policy", value)

    @_builtins.property
    @pulumi.getter(name="expressVulnerabilityAssessmentEnabled")
    def express_vulnerability_assessment_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the Express Vulnerability Assessment Configuration. Defaults to `false`.

        > **Note:** If you have enabled the Classic SQL Vulnerability Assessment configuration using the `mssql.ServerVulnerabilityAssessment` resource, you must first delete it before enabling `express_vulnerability_assessment_enabled`. If you wish to revert back to using the Classic SQL Vulnerability Assessment configuration you must first disable this setting.
        """
        return pulumi.get(self, "express_vulnerability_assessment_enabled")

    @express_vulnerability_assessment_enabled.setter
    def express_vulnerability_assessment_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "express_vulnerability_assessment_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServerIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServerIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` , `1.2` and `Disabled`. Defaults to `1.2`.

        > **Note:** The `minimum_tls_version` is set to `Disabled` means all TLS versions are allowed. After you enforce a version of `minimum_tls_version`, it's not possible to revert to `Disabled`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Microsoft SQL Server. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outboundNetworkRestrictionEnabled")
    def outbound_network_restriction_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether outbound network traffic is restricted for this server. Defaults to `false`.
        """
        return pulumi.get(self, "outbound_network_restriction_enabled")

    @outbound_network_restriction_enabled.setter
    def outbound_network_restriction_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "outbound_network_restriction_enabled", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentityId")
    def primary_user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the primary user managed identity id. Required if `type` within the `identity` block is set to either `SystemAssigned, UserAssigned` or `UserAssigned` and should be set at same time as setting `identity_ids`.
        """
        return pulumi.get(self, "primary_user_assigned_identity_id")

    @primary_user_assigned_identity_id.setter
    def primary_user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_user_assigned_identity_id", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is allowed for this server. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyVaultKeyId")
    def transparent_data_encryption_key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.

        > **Note:** To successfully deploy a `Microsoft SQL Server` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.

        > **Note:** Cross-tenant `Key Vault` and `Microsoft SQL Server` interactions are not supported. Please see the [product documentation](https://learn.microsoft.com/azure/azure-sql/database/transparent-data-encryption-byok-overview?view=azuresql#requirements-for-configuring-customer-managed-tde) for more information.

        > **Note:** When using a firewall with a `Key Vault`, you must enable the option `Allow trusted Microsoft services to bypass the firewall`.
        """
        return pulumi.get(self, "transparent_data_encryption_key_vault_key_id")

    @transparent_data_encryption_key_vault_key_id.setter
    def transparent_data_encryption_key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transparent_data_encryption_key_vault_key_id", value)


@pulumi.input_type
class _ServerState:
    def __init__(__self__, *,
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 azuread_administrator: Optional[pulumi.Input['ServerAzureadAdministratorArgs']] = None,
                 connection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 express_vulnerability_assessment_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fully_qualified_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ServerIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_network_restriction_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 primary_user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 restorable_dropped_database_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transparent_data_encryption_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Server resources.
        :param pulumi.Input[_builtins.str] administrator_login: The administrator login name for the new server. Required unless `azuread_authentication_only` in the `azuread_administrator` block is `true`. When omitted, Azure will generate a default username which cannot be subsequently changed. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] administrator_login_password: The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx).
        :param pulumi.Input[_builtins.int] administrator_login_password_wo_version: An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        :param pulumi.Input['ServerAzureadAdministratorArgs'] azuread_administrator: An `azuread_administrator` block as defined below.
        :param pulumi.Input[_builtins.str] connection_policy: The connection policy the server will use. Possible values are `Default`, `Proxy`, and `Redirect`. Defaults to `Default`.
        :param pulumi.Input[_builtins.bool] express_vulnerability_assessment_enabled: Whether to enable the Express Vulnerability Assessment Configuration. Defaults to `false`.
               
               > **Note:** If you have enabled the Classic SQL Vulnerability Assessment configuration using the `mssql.ServerVulnerabilityAssessment` resource, you must first delete it before enabling `express_vulnerability_assessment_enabled`. If you wish to revert back to using the Classic SQL Vulnerability Assessment configuration you must first disable this setting.
        :param pulumi.Input[_builtins.str] fully_qualified_domain_name: The fully qualified domain name of the Azure SQL Server (e.g. myServerName.database.windows.net)
        :param pulumi.Input['ServerIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` , `1.2` and `Disabled`. Defaults to `1.2`.
               
               > **Note:** The `minimum_tls_version` is set to `Disabled` means all TLS versions are allowed. After you enforce a version of `minimum_tls_version`, it's not possible to revert to `Disabled`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the Microsoft SQL Server. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] outbound_network_restriction_enabled: Whether outbound network traffic is restricted for this server. Defaults to `false`.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity_id: Specifies the primary user managed identity id. Required if `type` within the `identity` block is set to either `SystemAssigned, UserAssigned` or `UserAssigned` and should be set at same time as setting `identity_ids`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for this server. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Microsoft SQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] restorable_dropped_database_ids: A list of dropped restorable database IDs on the server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transparent_data_encryption_key_vault_key_id: The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.
               
               > **Note:** To successfully deploy a `Microsoft SQL Server` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.
               
               > **Note:** Cross-tenant `Key Vault` and `Microsoft SQL Server` interactions are not supported. Please see the [product documentation](https://learn.microsoft.com/azure/azure-sql/database/transparent-data-encryption-byok-overview?view=azuresql#requirements-for-configuring-customer-managed-tde) for more information.
               
               > **Note:** When using a firewall with a `Key Vault`, you must enable the option `Allow trusted Microsoft services to bypass the firewall`.
        :param pulumi.Input[_builtins.str] version: The version for the new server. Valid values are: 2.0 (for v11 server) and 12.0 (for v12 server). Changing this forces a new resource to be created.
        """
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if administrator_login_password_wo_version is not None:
            pulumi.set(__self__, "administrator_login_password_wo_version", administrator_login_password_wo_version)
        if azuread_administrator is not None:
            pulumi.set(__self__, "azuread_administrator", azuread_administrator)
        if connection_policy is not None:
            pulumi.set(__self__, "connection_policy", connection_policy)
        if express_vulnerability_assessment_enabled is not None:
            pulumi.set(__self__, "express_vulnerability_assessment_enabled", express_vulnerability_assessment_enabled)
        if fully_qualified_domain_name is not None:
            pulumi.set(__self__, "fully_qualified_domain_name", fully_qualified_domain_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_network_restriction_enabled is not None:
            pulumi.set(__self__, "outbound_network_restriction_enabled", outbound_network_restriction_enabled)
        if primary_user_assigned_identity_id is not None:
            pulumi.set(__self__, "primary_user_assigned_identity_id", primary_user_assigned_identity_id)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if restorable_dropped_database_ids is not None:
            pulumi.set(__self__, "restorable_dropped_database_ids", restorable_dropped_database_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transparent_data_encryption_key_vault_key_id is not None:
            pulumi.set(__self__, "transparent_data_encryption_key_vault_key_id", transparent_data_encryption_key_vault_key_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The administrator login name for the new server. Required unless `azuread_authentication_only` in the `azuread_administrator` block is `true`. When omitted, Azure will generate a default username which cannot be subsequently changed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_login", value)

    @_builtins.property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx).
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_login_password", value)

    @_builtins.property
    @pulumi.getter(name="administratorLoginPasswordWoVersion")
    def administrator_login_password_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        """
        return pulumi.get(self, "administrator_login_password_wo_version")

    @administrator_login_password_wo_version.setter
    def administrator_login_password_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "administrator_login_password_wo_version", value)

    @_builtins.property
    @pulumi.getter(name="azureadAdministrator")
    def azuread_administrator(self) -> Optional[pulumi.Input['ServerAzureadAdministratorArgs']]:
        """
        An `azuread_administrator` block as defined below.
        """
        return pulumi.get(self, "azuread_administrator")

    @azuread_administrator.setter
    def azuread_administrator(self, value: Optional[pulumi.Input['ServerAzureadAdministratorArgs']]):
        pulumi.set(self, "azuread_administrator", value)

    @_builtins.property
    @pulumi.getter(name="connectionPolicy")
    def connection_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection policy the server will use. Possible values are `Default`, `Proxy`, and `Redirect`. Defaults to `Default`.
        """
        return pulumi.get(self, "connection_policy")

    @connection_policy.setter
    def connection_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_policy", value)

    @_builtins.property
    @pulumi.getter(name="expressVulnerabilityAssessmentEnabled")
    def express_vulnerability_assessment_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the Express Vulnerability Assessment Configuration. Defaults to `false`.

        > **Note:** If you have enabled the Classic SQL Vulnerability Assessment configuration using the `mssql.ServerVulnerabilityAssessment` resource, you must first delete it before enabling `express_vulnerability_assessment_enabled`. If you wish to revert back to using the Classic SQL Vulnerability Assessment configuration you must first disable this setting.
        """
        return pulumi.get(self, "express_vulnerability_assessment_enabled")

    @express_vulnerability_assessment_enabled.setter
    def express_vulnerability_assessment_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "express_vulnerability_assessment_enabled", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedDomainName")
    def fully_qualified_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name of the Azure SQL Server (e.g. myServerName.database.windows.net)
        """
        return pulumi.get(self, "fully_qualified_domain_name")

    @fully_qualified_domain_name.setter
    def fully_qualified_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_domain_name", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServerIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServerIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` , `1.2` and `Disabled`. Defaults to `1.2`.

        > **Note:** The `minimum_tls_version` is set to `Disabled` means all TLS versions are allowed. After you enforce a version of `minimum_tls_version`, it's not possible to revert to `Disabled`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Microsoft SQL Server. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outboundNetworkRestrictionEnabled")
    def outbound_network_restriction_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether outbound network traffic is restricted for this server. Defaults to `false`.
        """
        return pulumi.get(self, "outbound_network_restriction_enabled")

    @outbound_network_restriction_enabled.setter
    def outbound_network_restriction_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "outbound_network_restriction_enabled", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentityId")
    def primary_user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the primary user managed identity id. Required if `type` within the `identity` block is set to either `SystemAssigned, UserAssigned` or `UserAssigned` and should be set at same time as setting `identity_ids`.
        """
        return pulumi.get(self, "primary_user_assigned_identity_id")

    @primary_user_assigned_identity_id.setter
    def primary_user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_user_assigned_identity_id", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is allowed for this server. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Microsoft SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="restorableDroppedDatabaseIds")
    def restorable_dropped_database_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of dropped restorable database IDs on the server.
        """
        return pulumi.get(self, "restorable_dropped_database_ids")

    @restorable_dropped_database_ids.setter
    def restorable_dropped_database_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "restorable_dropped_database_ids", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyVaultKeyId")
    def transparent_data_encryption_key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.

        > **Note:** To successfully deploy a `Microsoft SQL Server` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.

        > **Note:** Cross-tenant `Key Vault` and `Microsoft SQL Server` interactions are not supported. Please see the [product documentation](https://learn.microsoft.com/azure/azure-sql/database/transparent-data-encryption-byok-overview?view=azuresql#requirements-for-configuring-customer-managed-tde) for more information.

        > **Note:** When using a firewall with a `Key Vault`, you must enable the option `Allow trusted Microsoft services to bypass the firewall`.
        """
        return pulumi.get(self, "transparent_data_encryption_key_vault_key_id")

    @transparent_data_encryption_key_vault_key_id.setter
    def transparent_data_encryption_key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transparent_data_encryption_key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version for the new server. Valid values are: 2.0 (for v11 server) and 12.0 (for v12 server). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:mssql/server:Server")
class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 azuread_administrator: Optional[pulumi.Input[Union['ServerAzureadAdministratorArgs', 'ServerAzureadAdministratorArgsDict']]] = None,
                 connection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 express_vulnerability_assessment_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ServerIdentityArgs', 'ServerIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_network_restriction_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 primary_user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transparent_data_encryption_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Microsoft SQL Azure Database Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="database-rg",
            location="West Europe")
        example_server = azure.mssql.Server("example",
            name="mssqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="missadministrator",
            administrator_login_password="thisIsKat11",
            minimum_tls_version="1.2",
            azuread_administrator={
                "login_username": "AzureAD Admin",
                "object_id": "00000000-0000-0000-0000-000000000000",
            },
            tags={
                "environment": "production",
            })
        ```

        ### Transparent Data Encryption (TDE) With A Customer Managed Key (CMK) During Create

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-admin",
            location=example.location,
            resource_group_name=example.name)
        # Create a key vault with access policies which allow for the current user to get, list, create, delete, update, recover, purge and getRotationPolicy for the key vault key and also add a key vault access policy for the Microsoft Sql Server instance User Managed Identity to get, wrap, and unwrap key(s)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="mssqltdeexample",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=example_user_assigned_identity.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=True,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Get",
                        "List",
                        "Create",
                        "Delete",
                        "Update",
                        "Recover",
                        "Purge",
                        "GetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": example_user_assigned_identity.tenant_id,
                    "object_id": example_user_assigned_identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "WrapKey",
                        "UnwrapKey",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_key_vault]))
        example_server = azure.mssql.Server("example",
            name="example-resource",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="Example-Administrator",
            administrator_login_password="Example_Password!",
            minimum_tls_version="1.2",
            azuread_administrator={
                "login_username": example_user_assigned_identity.name,
                "object_id": example_user_assigned_identity.principal_id,
            },
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            primary_user_assigned_identity_id=example_user_assigned_identity.id,
            transparent_data_encryption_key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        SQL Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/server:Server example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Sql/servers/myserver
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] administrator_login: The administrator login name for the new server. Required unless `azuread_authentication_only` in the `azuread_administrator` block is `true`. When omitted, Azure will generate a default username which cannot be subsequently changed. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] administrator_login_password: The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx).
        :param pulumi.Input[_builtins.int] administrator_login_password_wo_version: An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        :param pulumi.Input[Union['ServerAzureadAdministratorArgs', 'ServerAzureadAdministratorArgsDict']] azuread_administrator: An `azuread_administrator` block as defined below.
        :param pulumi.Input[_builtins.str] connection_policy: The connection policy the server will use. Possible values are `Default`, `Proxy`, and `Redirect`. Defaults to `Default`.
        :param pulumi.Input[_builtins.bool] express_vulnerability_assessment_enabled: Whether to enable the Express Vulnerability Assessment Configuration. Defaults to `false`.
               
               > **Note:** If you have enabled the Classic SQL Vulnerability Assessment configuration using the `mssql.ServerVulnerabilityAssessment` resource, you must first delete it before enabling `express_vulnerability_assessment_enabled`. If you wish to revert back to using the Classic SQL Vulnerability Assessment configuration you must first disable this setting.
        :param pulumi.Input[Union['ServerIdentityArgs', 'ServerIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` , `1.2` and `Disabled`. Defaults to `1.2`.
               
               > **Note:** The `minimum_tls_version` is set to `Disabled` means all TLS versions are allowed. After you enforce a version of `minimum_tls_version`, it's not possible to revert to `Disabled`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the Microsoft SQL Server. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] outbound_network_restriction_enabled: Whether outbound network traffic is restricted for this server. Defaults to `false`.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity_id: Specifies the primary user managed identity id. Required if `type` within the `identity` block is set to either `SystemAssigned, UserAssigned` or `UserAssigned` and should be set at same time as setting `identity_ids`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for this server. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Microsoft SQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transparent_data_encryption_key_vault_key_id: The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.
               
               > **Note:** To successfully deploy a `Microsoft SQL Server` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.
               
               > **Note:** Cross-tenant `Key Vault` and `Microsoft SQL Server` interactions are not supported. Please see the [product documentation](https://learn.microsoft.com/azure/azure-sql/database/transparent-data-encryption-byok-overview?view=azuresql#requirements-for-configuring-customer-managed-tde) for more information.
               
               > **Note:** When using a firewall with a `Key Vault`, you must enable the option `Allow trusted Microsoft services to bypass the firewall`.
        :param pulumi.Input[_builtins.str] version: The version for the new server. Valid values are: 2.0 (for v11 server) and 12.0 (for v12 server). Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Microsoft SQL Azure Database Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="database-rg",
            location="West Europe")
        example_server = azure.mssql.Server("example",
            name="mssqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="missadministrator",
            administrator_login_password="thisIsKat11",
            minimum_tls_version="1.2",
            azuread_administrator={
                "login_username": "AzureAD Admin",
                "object_id": "00000000-0000-0000-0000-000000000000",
            },
            tags={
                "environment": "production",
            })
        ```

        ### Transparent Data Encryption (TDE) With A Customer Managed Key (CMK) During Create

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-admin",
            location=example.location,
            resource_group_name=example.name)
        # Create a key vault with access policies which allow for the current user to get, list, create, delete, update, recover, purge and getRotationPolicy for the key vault key and also add a key vault access policy for the Microsoft Sql Server instance User Managed Identity to get, wrap, and unwrap key(s)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="mssqltdeexample",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=example_user_assigned_identity.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=True,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Get",
                        "List",
                        "Create",
                        "Delete",
                        "Update",
                        "Recover",
                        "Purge",
                        "GetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": example_user_assigned_identity.tenant_id,
                    "object_id": example_user_assigned_identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "WrapKey",
                        "UnwrapKey",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "unwrapKey",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example_key_vault]))
        example_server = azure.mssql.Server("example",
            name="example-resource",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="Example-Administrator",
            administrator_login_password="Example_Password!",
            minimum_tls_version="1.2",
            azuread_administrator={
                "login_username": example_user_assigned_identity.name,
                "object_id": example_user_assigned_identity.principal_id,
            },
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            primary_user_assigned_identity_id=example_user_assigned_identity.id,
            transparent_data_encryption_key_vault_key_id=example_key.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        SQL Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/server:Server example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Sql/servers/myserver
        ```

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_login_password_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 azuread_administrator: Optional[pulumi.Input[Union['ServerAzureadAdministratorArgs', 'ServerAzureadAdministratorArgsDict']]] = None,
                 connection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 express_vulnerability_assessment_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ServerIdentityArgs', 'ServerIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_network_restriction_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 primary_user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transparent_data_encryption_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["administrator_login"] = administrator_login
            __props__.__dict__["administrator_login_password"] = None if administrator_login_password is None else pulumi.Output.secret(administrator_login_password)
            __props__.__dict__["administrator_login_password_wo_version"] = administrator_login_password_wo_version
            __props__.__dict__["azuread_administrator"] = azuread_administrator
            __props__.__dict__["connection_policy"] = connection_policy
            __props__.__dict__["express_vulnerability_assessment_enabled"] = express_vulnerability_assessment_enabled
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["minimum_tls_version"] = minimum_tls_version
            __props__.__dict__["name"] = name
            __props__.__dict__["outbound_network_restriction_enabled"] = outbound_network_restriction_enabled
            __props__.__dict__["primary_user_assigned_identity_id"] = primary_user_assigned_identity_id
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transparent_data_encryption_key_vault_key_id"] = transparent_data_encryption_key_vault_key_id
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["fully_qualified_domain_name"] = None
            __props__.__dict__["restorable_dropped_database_ids"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:sql/sqlServer:SqlServer")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["administratorLoginPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Server, __self__).__init__(
            'azure:mssql/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
            administrator_login_password: Optional[pulumi.Input[_builtins.str]] = None,
            administrator_login_password_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
            azuread_administrator: Optional[pulumi.Input[Union['ServerAzureadAdministratorArgs', 'ServerAzureadAdministratorArgsDict']]] = None,
            connection_policy: Optional[pulumi.Input[_builtins.str]] = None,
            express_vulnerability_assessment_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            fully_qualified_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ServerIdentityArgs', 'ServerIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            outbound_network_restriction_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            primary_user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            restorable_dropped_database_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transparent_data_encryption_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] administrator_login: The administrator login name for the new server. Required unless `azuread_authentication_only` in the `azuread_administrator` block is `true`. When omitted, Azure will generate a default username which cannot be subsequently changed. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] administrator_login_password: The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx).
        :param pulumi.Input[_builtins.int] administrator_login_password_wo_version: An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        :param pulumi.Input[Union['ServerAzureadAdministratorArgs', 'ServerAzureadAdministratorArgsDict']] azuread_administrator: An `azuread_administrator` block as defined below.
        :param pulumi.Input[_builtins.str] connection_policy: The connection policy the server will use. Possible values are `Default`, `Proxy`, and `Redirect`. Defaults to `Default`.
        :param pulumi.Input[_builtins.bool] express_vulnerability_assessment_enabled: Whether to enable the Express Vulnerability Assessment Configuration. Defaults to `false`.
               
               > **Note:** If you have enabled the Classic SQL Vulnerability Assessment configuration using the `mssql.ServerVulnerabilityAssessment` resource, you must first delete it before enabling `express_vulnerability_assessment_enabled`. If you wish to revert back to using the Classic SQL Vulnerability Assessment configuration you must first disable this setting.
        :param pulumi.Input[_builtins.str] fully_qualified_domain_name: The fully qualified domain name of the Azure SQL Server (e.g. myServerName.database.windows.net)
        :param pulumi.Input[Union['ServerIdentityArgs', 'ServerIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` , `1.2` and `Disabled`. Defaults to `1.2`.
               
               > **Note:** The `minimum_tls_version` is set to `Disabled` means all TLS versions are allowed. After you enforce a version of `minimum_tls_version`, it's not possible to revert to `Disabled`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the Microsoft SQL Server. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] outbound_network_restriction_enabled: Whether outbound network traffic is restricted for this server. Defaults to `false`.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity_id: Specifies the primary user managed identity id. Required if `type` within the `identity` block is set to either `SystemAssigned, UserAssigned` or `UserAssigned` and should be set at same time as setting `identity_ids`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for this server. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Microsoft SQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] restorable_dropped_database_ids: A list of dropped restorable database IDs on the server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transparent_data_encryption_key_vault_key_id: The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.
               
               > **Note:** To successfully deploy a `Microsoft SQL Server` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.
               
               > **Note:** Cross-tenant `Key Vault` and `Microsoft SQL Server` interactions are not supported. Please see the [product documentation](https://learn.microsoft.com/azure/azure-sql/database/transparent-data-encryption-byok-overview?view=azuresql#requirements-for-configuring-customer-managed-tde) for more information.
               
               > **Note:** When using a firewall with a `Key Vault`, you must enable the option `Allow trusted Microsoft services to bypass the firewall`.
        :param pulumi.Input[_builtins.str] version: The version for the new server. Valid values are: 2.0 (for v11 server) and 12.0 (for v12 server). Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerState.__new__(_ServerState)

        __props__.__dict__["administrator_login"] = administrator_login
        __props__.__dict__["administrator_login_password"] = administrator_login_password
        __props__.__dict__["administrator_login_password_wo_version"] = administrator_login_password_wo_version
        __props__.__dict__["azuread_administrator"] = azuread_administrator
        __props__.__dict__["connection_policy"] = connection_policy
        __props__.__dict__["express_vulnerability_assessment_enabled"] = express_vulnerability_assessment_enabled
        __props__.__dict__["fully_qualified_domain_name"] = fully_qualified_domain_name
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["minimum_tls_version"] = minimum_tls_version
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_network_restriction_enabled"] = outbound_network_restriction_enabled
        __props__.__dict__["primary_user_assigned_identity_id"] = primary_user_assigned_identity_id
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["restorable_dropped_database_ids"] = restorable_dropped_database_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transparent_data_encryption_key_vault_key_id"] = transparent_data_encryption_key_vault_key_id
        __props__.__dict__["version"] = version
        return Server(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> pulumi.Output[_builtins.str]:
        """
        The administrator login name for the new server. Required unless `azuread_authentication_only` in the `azuread_administrator` block is `true`. When omitted, Azure will generate a default username which cannot be subsequently changed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "administrator_login")

    @_builtins.property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password associated with the `administrator_login` user. Needs to comply with Azure's [Password Policy](https://msdn.microsoft.com/library/ms161959.aspx).
        """
        return pulumi.get(self, "administrator_login_password")

    @_builtins.property
    @pulumi.getter(name="administratorLoginPasswordWoVersion")
    def administrator_login_password_wo_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_login_password_wo`. This property should be incremented when updating `administrator_login_password_wo`.
        """
        return pulumi.get(self, "administrator_login_password_wo_version")

    @_builtins.property
    @pulumi.getter(name="azureadAdministrator")
    def azuread_administrator(self) -> pulumi.Output[Optional['outputs.ServerAzureadAdministrator']]:
        """
        An `azuread_administrator` block as defined below.
        """
        return pulumi.get(self, "azuread_administrator")

    @_builtins.property
    @pulumi.getter(name="connectionPolicy")
    def connection_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The connection policy the server will use. Possible values are `Default`, `Proxy`, and `Redirect`. Defaults to `Default`.
        """
        return pulumi.get(self, "connection_policy")

    @_builtins.property
    @pulumi.getter(name="expressVulnerabilityAssessmentEnabled")
    def express_vulnerability_assessment_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the Express Vulnerability Assessment Configuration. Defaults to `false`.

        > **Note:** If you have enabled the Classic SQL Vulnerability Assessment configuration using the `mssql.ServerVulnerabilityAssessment` resource, you must first delete it before enabling `express_vulnerability_assessment_enabled`. If you wish to revert back to using the Classic SQL Vulnerability Assessment configuration you must first disable this setting.
        """
        return pulumi.get(self, "express_vulnerability_assessment_enabled")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedDomainName")
    def fully_qualified_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified domain name of the Azure SQL Server (e.g. myServerName.database.windows.net)
        """
        return pulumi.get(self, "fully_qualified_domain_name")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ServerIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Minimum TLS Version for all SQL Database and SQL Data Warehouse databases associated with the server. Valid values are: `1.0`, `1.1` , `1.2` and `Disabled`. Defaults to `1.2`.

        > **Note:** The `minimum_tls_version` is set to `Disabled` means all TLS versions are allowed. After you enforce a version of `minimum_tls_version`, it's not possible to revert to `Disabled`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Microsoft SQL Server. This needs to be globally unique within Azure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outboundNetworkRestrictionEnabled")
    def outbound_network_restriction_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether outbound network traffic is restricted for this server. Defaults to `false`.
        """
        return pulumi.get(self, "outbound_network_restriction_enabled")

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentityId")
    def primary_user_assigned_identity_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the primary user managed identity id. Required if `type` within the `identity` block is set to either `SystemAssigned, UserAssigned` or `UserAssigned` and should be set at same time as setting `identity_ids`.
        """
        return pulumi.get(self, "primary_user_assigned_identity_id")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether public network access is allowed for this server. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Microsoft SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="restorableDroppedDatabaseIds")
    def restorable_dropped_database_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of dropped restorable database IDs on the server.
        """
        return pulumi.get(self, "restorable_dropped_database_ids")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transparentDataEncryptionKeyVaultKeyId")
    def transparent_data_encryption_key_vault_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully versioned `Key Vault` `Key` URL (e.g. `'https://<YourVaultName>.vault.azure.net/keys/<YourKeyName>/<YourKeyVersion>`) to be used as the `Customer Managed Key`(CMK/BYOK) for the `Transparent Data Encryption`(TDE) layer.

        > **Note:** To successfully deploy a `Microsoft SQL Server` in CMK/BYOK TDE the `Key Vault` must have `Soft-delete` and `purge protection` enabled to protect from data loss due to accidental key and/or key vault deletion. The `Key Vault` and the `Microsoft SQL Server` `User Managed Identity Instance` must belong to the same `Azure Active Directory` `tenant`.

        > **Note:** Cross-tenant `Key Vault` and `Microsoft SQL Server` interactions are not supported. Please see the [product documentation](https://learn.microsoft.com/azure/azure-sql/database/transparent-data-encryption-byok-overview?view=azuresql#requirements-for-configuring-customer-managed-tde) for more information.

        > **Note:** When using a firewall with a `Key Vault`, you must enable the option `Allow trusted Microsoft services to bypass the firewall`.
        """
        return pulumi.get(self, "transparent_data_encryption_key_vault_key_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version for the new server. Valid values are: 2.0 (for v11 server) and 12.0 (for v12 server). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")

