# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackupPolicyArgs', 'BackupPolicy']

@pulumi.input_type
class BackupPolicyArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 daily_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monthly_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 weekly_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a BackupPolicy resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Policy should be created under. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Backup Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] daily_backups_to_keep: Provides the number of daily backups to keep, defaults to `2` which is the minimum, maximum is 1019.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Backup Policy is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] monthly_backups_to_keep: Provides the number of monthly backups to keep, defaults to `1` which is the minimum, maximum is 1019.
               
               > **Note:** Currently, the combined (daily + weekly + monthy) retention counts cannot exceed 1019.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] weekly_backups_to_keep: Provides the number of weekly backups to keep, defaults to `1` which is the minimum, maximum is 1019.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if daily_backups_to_keep is not None:
            pulumi.set(__self__, "daily_backups_to_keep", daily_backups_to_keep)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if monthly_backups_to_keep is not None:
            pulumi.set(__self__, "monthly_backups_to_keep", monthly_backups_to_keep)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if weekly_backups_to_keep is not None:
            pulumi.set(__self__, "weekly_backups_to_keep", weekly_backups_to_keep)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the NetApp account in which the NetApp Policy should be created under. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group where the NetApp Backup Policy should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="dailyBackupsToKeep")
    def daily_backups_to_keep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Provides the number of daily backups to keep, defaults to `2` which is the minimum, maximum is 1019.
        """
        return pulumi.get(self, "daily_backups_to_keep")

    @daily_backups_to_keep.setter
    def daily_backups_to_keep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "daily_backups_to_keep", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Backup Policy is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="monthlyBackupsToKeep")
    def monthly_backups_to_keep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Provides the number of monthly backups to keep, defaults to `1` which is the minimum, maximum is 1019.

        > **Note:** Currently, the combined (daily + weekly + monthy) retention counts cannot exceed 1019.
        """
        return pulumi.get(self, "monthly_backups_to_keep")

    @monthly_backups_to_keep.setter
    def monthly_backups_to_keep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "monthly_backups_to_keep", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NetApp Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="weeklyBackupsToKeep")
    def weekly_backups_to_keep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Provides the number of weekly backups to keep, defaults to `1` which is the minimum, maximum is 1019.
        """
        return pulumi.get(self, "weekly_backups_to_keep")

    @weekly_backups_to_keep.setter
    def weekly_backups_to_keep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weekly_backups_to_keep", value)


@pulumi.input_type
class _BackupPolicyState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 daily_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monthly_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 weekly_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering BackupPolicy resources.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Policy should be created under. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] daily_backups_to_keep: Provides the number of daily backups to keep, defaults to `2` which is the minimum, maximum is 1019.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Backup Policy is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] monthly_backups_to_keep: Provides the number of monthly backups to keep, defaults to `1` which is the minimum, maximum is 1019.
               
               > **Note:** Currently, the combined (daily + weekly + monthy) retention counts cannot exceed 1019.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Backup Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] weekly_backups_to_keep: Provides the number of weekly backups to keep, defaults to `1` which is the minimum, maximum is 1019.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if daily_backups_to_keep is not None:
            pulumi.set(__self__, "daily_backups_to_keep", daily_backups_to_keep)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if monthly_backups_to_keep is not None:
            pulumi.set(__self__, "monthly_backups_to_keep", monthly_backups_to_keep)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if weekly_backups_to_keep is not None:
            pulumi.set(__self__, "weekly_backups_to_keep", weekly_backups_to_keep)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NetApp account in which the NetApp Policy should be created under. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="dailyBackupsToKeep")
    def daily_backups_to_keep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Provides the number of daily backups to keep, defaults to `2` which is the minimum, maximum is 1019.
        """
        return pulumi.get(self, "daily_backups_to_keep")

    @daily_backups_to_keep.setter
    def daily_backups_to_keep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "daily_backups_to_keep", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Backup Policy is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="monthlyBackupsToKeep")
    def monthly_backups_to_keep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Provides the number of monthly backups to keep, defaults to `1` which is the minimum, maximum is 1019.

        > **Note:** Currently, the combined (daily + weekly + monthy) retention counts cannot exceed 1019.
        """
        return pulumi.get(self, "monthly_backups_to_keep")

    @monthly_backups_to_keep.setter
    def monthly_backups_to_keep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "monthly_backups_to_keep", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NetApp Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group where the NetApp Backup Policy should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="weeklyBackupsToKeep")
    def weekly_backups_to_keep(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Provides the number of weekly backups to keep, defaults to `1` which is the minimum, maximum is 1019.
        """
        return pulumi.get(self, "weekly_backups_to_keep")

    @weekly_backups_to_keep.setter
    def weekly_backups_to_keep(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weekly_backups_to_keep", value)


@pulumi.type_token("azure:netapp/backupPolicy:BackupPolicy")
class BackupPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 daily_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monthly_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 weekly_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a NetApp Backup Policy.

        ## NetApp Backup Policy Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.netapp.Account("example",
            name="example-netappaccount",
            location=example.location,
            resource_group_name=example.name)
        example_backup_policy = azure.netapp.BackupPolicy("example",
            name="example-netappbackuppolicy",
            resource_group_name=example.name,
            location=example.location,
            account_name=example_account.name,
            enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp`: 2025-01-01

        ## Import

        NetApp Backup Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/backupPolicy:BackupPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1/backupPolicies/backuppolicy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Policy should be created under. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] daily_backups_to_keep: Provides the number of daily backups to keep, defaults to `2` which is the minimum, maximum is 1019.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Backup Policy is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] monthly_backups_to_keep: Provides the number of monthly backups to keep, defaults to `1` which is the minimum, maximum is 1019.
               
               > **Note:** Currently, the combined (daily + weekly + monthy) retention counts cannot exceed 1019.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Backup Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] weekly_backups_to_keep: Provides the number of weekly backups to keep, defaults to `1` which is the minimum, maximum is 1019.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a NetApp Backup Policy.

        ## NetApp Backup Policy Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.netapp.Account("example",
            name="example-netappaccount",
            location=example.location,
            resource_group_name=example.name)
        example_backup_policy = azure.netapp.BackupPolicy("example",
            name="example-netappbackuppolicy",
            resource_group_name=example.name,
            location=example.location,
            account_name=example_account.name,
            enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp`: 2025-01-01

        ## Import

        NetApp Backup Policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/backupPolicy:BackupPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1/backupPolicies/backuppolicy1
        ```

        :param str resource_name: The name of the resource.
        :param BackupPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 daily_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monthly_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 weekly_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPolicyArgs.__new__(BackupPolicyArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["daily_backups_to_keep"] = daily_backups_to_keep
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["monthly_backups_to_keep"] = monthly_backups_to_keep
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["weekly_backups_to_keep"] = weekly_backups_to_keep
        super(BackupPolicy, __self__).__init__(
            'azure:netapp/backupPolicy:BackupPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            daily_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            monthly_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            weekly_backups_to_keep: Optional[pulumi.Input[_builtins.int]] = None) -> 'BackupPolicy':
        """
        Get an existing BackupPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Policy should be created under. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] daily_backups_to_keep: Provides the number of daily backups to keep, defaults to `2` which is the minimum, maximum is 1019.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Backup Policy is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] monthly_backups_to_keep: Provides the number of monthly backups to keep, defaults to `1` which is the minimum, maximum is 1019.
               
               > **Note:** Currently, the combined (daily + weekly + monthy) retention counts cannot exceed 1019.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Backup Policy should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] weekly_backups_to_keep: Provides the number of weekly backups to keep, defaults to `1` which is the minimum, maximum is 1019.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPolicyState.__new__(_BackupPolicyState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["daily_backups_to_keep"] = daily_backups_to_keep
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["monthly_backups_to_keep"] = monthly_backups_to_keep
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["weekly_backups_to_keep"] = weekly_backups_to_keep
        return BackupPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the NetApp account in which the NetApp Policy should be created under. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="dailyBackupsToKeep")
    def daily_backups_to_keep(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Provides the number of daily backups to keep, defaults to `2` which is the minimum, maximum is 1019.
        """
        return pulumi.get(self, "daily_backups_to_keep")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the Backup Policy is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="monthlyBackupsToKeep")
    def monthly_backups_to_keep(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Provides the number of monthly backups to keep, defaults to `1` which is the minimum, maximum is 1019.

        > **Note:** Currently, the combined (daily + weekly + monthy) retention counts cannot exceed 1019.
        """
        return pulumi.get(self, "monthly_backups_to_keep")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the NetApp Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group where the NetApp Backup Policy should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="weeklyBackupsToKeep")
    def weekly_backups_to_keep(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Provides the number of weekly backups to keep, defaults to `1` which is the minimum, maximum is 1019.
        """
        return pulumi.get(self, "weekly_backups_to_keep")

