# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetVolumeQuotaRuleResult',
    'AwaitableGetVolumeQuotaRuleResult',
    'get_volume_quota_rule',
    'get_volume_quota_rule_output',
]

@pulumi.output_type
class GetVolumeQuotaRuleResult:
    """
    A collection of values returned by getVolumeQuotaRule.
    """
    def __init__(__self__, id=None, location=None, name=None, quota_size_in_kib=None, quota_target=None, quota_type=None, volume_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if quota_size_in_kib and not isinstance(quota_size_in_kib, int):
            raise TypeError("Expected argument 'quota_size_in_kib' to be a int")
        pulumi.set(__self__, "quota_size_in_kib", quota_size_in_kib)
        if quota_target and not isinstance(quota_target, str):
            raise TypeError("Expected argument 'quota_target' to be a str")
        pulumi.set(__self__, "quota_target", quota_target)
        if quota_type and not isinstance(quota_type, str):
            raise TypeError("Expected argument 'quota_type' to be a str")
        pulumi.set(__self__, "quota_type", quota_type)
        if volume_id and not isinstance(volume_id, str):
            raise TypeError("Expected argument 'volume_id' to be a str")
        pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Volume Quota Rule exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="quotaSizeInKib")
    def quota_size_in_kib(self) -> _builtins.int:
        """
        The quota size in kibibytes.
        """
        return pulumi.get(self, "quota_size_in_kib")

    @_builtins.property
    @pulumi.getter(name="quotaTarget")
    def quota_target(self) -> _builtins.str:
        """
        The quota Target.
        """
        return pulumi.get(self, "quota_target")

    @_builtins.property
    @pulumi.getter(name="quotaType")
    def quota_type(self) -> _builtins.str:
        """
        The quota type.
        """
        return pulumi.get(self, "quota_type")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> _builtins.str:
        return pulumi.get(self, "volume_id")


class AwaitableGetVolumeQuotaRuleResult(GetVolumeQuotaRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeQuotaRuleResult(
            id=self.id,
            location=self.location,
            name=self.name,
            quota_size_in_kib=self.quota_size_in_kib,
            quota_target=self.quota_target,
            quota_type=self.quota_type,
            volume_id=self.volume_id)


def get_volume_quota_rule(name: Optional[_builtins.str] = None,
                          volume_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeQuotaRuleResult:
    """
    Use this data source to access information about an existing Volume Quota Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.netapp.get_volume_quota_rule(name="exampleQuotaRule",
        volume_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/vol1")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.NetApp`: 2025-01-01


    :param _builtins.str name: The name of this Volume Quota Rule.
    :param _builtins.str volume_id: The NetApp volume ID where the Volume Quota Rule is assigned to.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['volumeId'] = volume_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:netapp/getVolumeQuotaRule:getVolumeQuotaRule', __args__, opts=opts, typ=GetVolumeQuotaRuleResult).value

    return AwaitableGetVolumeQuotaRuleResult(
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        quota_size_in_kib=pulumi.get(__ret__, 'quota_size_in_kib'),
        quota_target=pulumi.get(__ret__, 'quota_target'),
        quota_type=pulumi.get(__ret__, 'quota_type'),
        volume_id=pulumi.get(__ret__, 'volume_id'))
def get_volume_quota_rule_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeQuotaRuleResult]:
    """
    Use this data source to access information about an existing Volume Quota Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.netapp.get_volume_quota_rule(name="exampleQuotaRule",
        volume_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/vol1")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.NetApp`: 2025-01-01


    :param _builtins.str name: The name of this Volume Quota Rule.
    :param _builtins.str volume_id: The NetApp volume ID where the Volume Quota Rule is assigned to.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['volumeId'] = volume_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:netapp/getVolumeQuotaRule:getVolumeQuotaRule', __args__, opts=opts, typ=GetVolumeQuotaRuleResult)
    return __ret__.apply(lambda __response__: GetVolumeQuotaRuleResult(
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        quota_size_in_kib=pulumi.get(__response__, 'quota_size_in_kib'),
        quota_target=pulumi.get(__response__, 'quota_target'),
        quota_type=pulumi.get(__response__, 'quota_type'),
        volume_id=pulumi.get(__response__, 'volume_id')))
