# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkManagerAdminRuleCollectionArgs', 'NetworkManagerAdminRuleCollection']

@pulumi.input_type
class NetworkManagerAdminRuleCollectionArgs:
    def __init__(__self__, *,
                 network_group_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 security_admin_configuration_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkManagerAdminRuleCollection resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_group_ids: A list of Network Group ID which this Network Manager Admin Rule Collection applies to.
        :param pulumi.Input[_builtins.str] security_admin_configuration_id: Specifies the ID of the Network Manager Security Admin Configuration. Changing this forces a new Network Manager Admin Rule Collection to be created.
        :param pulumi.Input[_builtins.str] description: A description of the Network Manager Admin Rule Collection.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule Collection to be created.
        """
        pulumi.set(__self__, "network_group_ids", network_group_ids)
        pulumi.set(__self__, "security_admin_configuration_id", security_admin_configuration_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="networkGroupIds")
    def network_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of Network Group ID which this Network Manager Admin Rule Collection applies to.
        """
        return pulumi.get(self, "network_group_ids")

    @network_group_ids.setter
    def network_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "network_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityAdminConfigurationId")
    def security_admin_configuration_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Network Manager Security Admin Configuration. Changing this forces a new Network Manager Admin Rule Collection to be created.
        """
        return pulumi.get(self, "security_admin_configuration_id")

    @security_admin_configuration_id.setter
    def security_admin_configuration_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_admin_configuration_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the Network Manager Admin Rule Collection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule Collection to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkManagerAdminRuleCollectionState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_admin_configuration_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkManagerAdminRuleCollection resources.
        :param pulumi.Input[_builtins.str] description: A description of the Network Manager Admin Rule Collection.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule Collection to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_group_ids: A list of Network Group ID which this Network Manager Admin Rule Collection applies to.
        :param pulumi.Input[_builtins.str] security_admin_configuration_id: Specifies the ID of the Network Manager Security Admin Configuration. Changing this forces a new Network Manager Admin Rule Collection to be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_group_ids is not None:
            pulumi.set(__self__, "network_group_ids", network_group_ids)
        if security_admin_configuration_id is not None:
            pulumi.set(__self__, "security_admin_configuration_id", security_admin_configuration_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the Network Manager Admin Rule Collection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule Collection to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkGroupIds")
    def network_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Network Group ID which this Network Manager Admin Rule Collection applies to.
        """
        return pulumi.get(self, "network_group_ids")

    @network_group_ids.setter
    def network_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityAdminConfigurationId")
    def security_admin_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Network Manager Security Admin Configuration. Changing this forces a new Network Manager Admin Rule Collection to be created.
        """
        return pulumi.get(self, "security_admin_configuration_id")

    @security_admin_configuration_id.setter
    def security_admin_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_admin_configuration_id", value)


@pulumi.type_token("azure:network/networkManagerAdminRuleCollection:NetworkManagerAdminRuleCollection")
class NetworkManagerAdminRuleCollection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_admin_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Network Manager Admin Rule Collection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=[
                "Connectivity",
                "SecurityAdmin",
            ],
            description="example network manager")
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-network-group",
            network_manager_id=example_network_manager.id)
        example_network_manager_security_admin_configuration = azure.network.NetworkManagerSecurityAdminConfiguration("example",
            name="example-admin-conf",
            network_manager_id=example_network_manager.id)
        example_network_manager_admin_rule_collection = azure.network.NetworkManagerAdminRuleCollection("example",
            name="example-admin-rule-collection",
            security_admin_configuration_id=example_network_manager_security_admin_configuration.id,
            network_group_ids=[example_network_manager_network_group.id])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Network Manager Admin Rule Collection can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerAdminRuleCollection:NetworkManagerAdminRuleCollection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/networkManagers/networkManager1/securityAdminConfigurations/configuration1/ruleCollections/ruleCollection1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the Network Manager Admin Rule Collection.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule Collection to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_group_ids: A list of Network Group ID which this Network Manager Admin Rule Collection applies to.
        :param pulumi.Input[_builtins.str] security_admin_configuration_id: Specifies the ID of the Network Manager Security Admin Configuration. Changing this forces a new Network Manager Admin Rule Collection to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkManagerAdminRuleCollectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Manager Admin Rule Collection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=[
                "Connectivity",
                "SecurityAdmin",
            ],
            description="example network manager")
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-network-group",
            network_manager_id=example_network_manager.id)
        example_network_manager_security_admin_configuration = azure.network.NetworkManagerSecurityAdminConfiguration("example",
            name="example-admin-conf",
            network_manager_id=example_network_manager.id)
        example_network_manager_admin_rule_collection = azure.network.NetworkManagerAdminRuleCollection("example",
            name="example-admin-rule-collection",
            security_admin_configuration_id=example_network_manager_security_admin_configuration.id,
            network_group_ids=[example_network_manager_network_group.id])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Network Manager Admin Rule Collection can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerAdminRuleCollection:NetworkManagerAdminRuleCollection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/networkManagers/networkManager1/securityAdminConfigurations/configuration1/ruleCollections/ruleCollection1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkManagerAdminRuleCollectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkManagerAdminRuleCollectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_admin_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkManagerAdminRuleCollectionArgs.__new__(NetworkManagerAdminRuleCollectionArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if network_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'network_group_ids'")
            __props__.__dict__["network_group_ids"] = network_group_ids
            if security_admin_configuration_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_admin_configuration_id'")
            __props__.__dict__["security_admin_configuration_id"] = security_admin_configuration_id
        super(NetworkManagerAdminRuleCollection, __self__).__init__(
            'azure:network/networkManagerAdminRuleCollection:NetworkManagerAdminRuleCollection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_admin_configuration_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkManagerAdminRuleCollection':
        """
        Get an existing NetworkManagerAdminRuleCollection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the Network Manager Admin Rule Collection.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule Collection to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_group_ids: A list of Network Group ID which this Network Manager Admin Rule Collection applies to.
        :param pulumi.Input[_builtins.str] security_admin_configuration_id: Specifies the ID of the Network Manager Security Admin Configuration. Changing this forces a new Network Manager Admin Rule Collection to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkManagerAdminRuleCollectionState.__new__(_NetworkManagerAdminRuleCollectionState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["network_group_ids"] = network_group_ids
        __props__.__dict__["security_admin_configuration_id"] = security_admin_configuration_id
        return NetworkManagerAdminRuleCollection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the Network Manager Admin Rule Collection.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Network Manager Admin Rule Collection. Changing this forces a new Network Manager Admin Rule Collection to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkGroupIds")
    def network_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of Network Group ID which this Network Manager Admin Rule Collection applies to.
        """
        return pulumi.get(self, "network_group_ids")

    @_builtins.property
    @pulumi.getter(name="securityAdminConfigurationId")
    def security_admin_configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Network Manager Security Admin Configuration. Changing this forces a new Network Manager Admin Rule Collection to be created.
        """
        return pulumi.get(self, "security_admin_configuration_id")

