# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualNetworkGatewayArgs', 'VirtualNetworkGateway']

@pulumi.input_type
class VirtualNetworkGatewayArgs:
    def __init__(__self__, *,
                 ip_configurations: pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIpConfigurationArgs']]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 active_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_route_translation_for_nat_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_settings: Optional[pulumi.Input['VirtualNetworkGatewayBgpSettingsArgs']] = None,
                 custom_route: Optional[pulumi.Input['VirtualNetworkGatewayCustomRouteArgs']] = None,
                 default_local_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 generation: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sec_replay_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_groups: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayPolicyGroupArgs']]]] = None,
                 private_ip_address_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_vnet_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_wan_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpn_client_configuration: Optional[pulumi.Input['VirtualNetworkGatewayVpnClientConfigurationArgs']] = None,
                 vpn_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VirtualNetworkGateway resource.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIpConfigurationArgs']]] ip_configurations: One or more (up to 3) `ip_configuration` blocks documented below. Changing this forces a new resource to be created. 
               An active-standby gateway requires exactly one `ip_configuration` block,
               an active-active gateway requires exactly two `ip_configuration` blocks whereas
               an active-active zone redundant gateway with P2S configuration requires exactly three `ip_configuration` blocks.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Virtual Network Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Configuration of the size and capacity of the virtual network gateway. Valid options are `Basic`, `Standard`, `HighPerformance`, `UltraPerformance`, `ErGw1AZ`, `ErGw2AZ`, `ErGw3AZ`, `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw4`,`VpnGw5`, `VpnGw1AZ`, `VpnGw2AZ`, `VpnGw3AZ`,`VpnGw4AZ` and `VpnGw5AZ` and depend on the `type`, `vpn_type` and `generation` arguments. A `PolicyBased` gateway only supports the `Basic` SKU. Further, the `UltraPerformance` SKU is only supported by an `ExpressRoute` gateway.
               
               > **Note:** To build a UltraPerformance ExpressRoute Virtual Network gateway, the associated Public IP needs to be SKU "Basic" not "Standard"
               
               > **Note:** Not all SKUs (e.g. `ErGw1AZ`) are available in all regions. If you see `StatusCode=400 -- Original Error: Code="InvalidGatewaySkuSpecifiedForGatewayDeploymentType"` please try another region.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Network Gateway. Valid options are `Vpn` or `ExpressRoute`. Changing the type forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] active_active: If `true`, an active-active Virtual Network Gateway will be created. An active-active gateway requires a `HighPerformance` or an `UltraPerformance` SKU. If `false`, an active-standby gateway will be created. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] bgp_route_translation_for_nat_enabled: Is BGP Route Translation for NAT enabled? Defaults to `false`.
        :param pulumi.Input['VirtualNetworkGatewayBgpSettingsArgs'] bgp_settings: A `bgp_settings` block which is documented below. In this block the BGP specific settings can be defined.
        :param pulumi.Input['VirtualNetworkGatewayCustomRouteArgs'] custom_route: A `custom_route` block as defined below. Specifies a custom routes address space for a virtual network gateway and a VpnClient.
        :param pulumi.Input[_builtins.str] default_local_network_gateway_id: The ID of the local network gateway through which outbound Internet traffic from the virtual network in which the gateway is created will be routed (*forced tunnelling*). Refer to the [Azure documentation on forced tunnelling](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-forced-tunneling-rm). If not specified, forced tunnelling is disabled.
        :param pulumi.Input[_builtins.bool] dns_forwarding_enabled: Is DNS forwarding enabled?
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Virtual Network Gateway should exist. Changing this forces a new Virtual Network Gateway to be created.
        :param pulumi.Input[_builtins.bool] enable_bgp: If `true`, BGP (Border Gateway Protocol) will be enabled for this Virtual Network Gateway. Defaults to `false`.
        :param pulumi.Input[_builtins.str] generation: The Generation of the Virtual Network gateway. Possible values include `Generation1`, `Generation2` or `None`. Changing this forces a new resource to be created.
               
               > **Note:** The available values depend on the `type` and `sku` arguments - where `Generation2` is only value for a `sku` larger than `VpnGw2` or `VpnGw2AZ`.
        :param pulumi.Input[_builtins.bool] ip_sec_replay_protection_enabled: Is IP Sec Replay Protection enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The location/region where the Virtual Network Gateway is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Network Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayPolicyGroupArgs']]] policy_groups: One or more `policy_group` blocks as defined below.
        :param pulumi.Input[_builtins.bool] private_ip_address_enabled: Should private IP be enabled on this gateway for connections? Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] remote_vnet_traffic_enabled: Is remote vnet traffic that is used to configure this gateway to accept traffic from other Azure Virtual Networks enabled? Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] virtual_wan_traffic_enabled: Is remote vnet traffic that is used to configure this gateway to accept traffic from remote Virtual WAN networks enabled? Defaults to `false`.
        :param pulumi.Input['VirtualNetworkGatewayVpnClientConfigurationArgs'] vpn_client_configuration: A `vpn_client_configuration` block which is documented below. In this block the Virtual Network Gateway can be configured to accept IPSec point-to-site connections.
        :param pulumi.Input[_builtins.str] vpn_type: The routing type of the Virtual Network Gateway. Valid options are `RouteBased` or `PolicyBased`. Defaults to `RouteBased`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "type", type)
        if active_active is not None:
            pulumi.set(__self__, "active_active", active_active)
        if bgp_route_translation_for_nat_enabled is not None:
            pulumi.set(__self__, "bgp_route_translation_for_nat_enabled", bgp_route_translation_for_nat_enabled)
        if bgp_settings is not None:
            pulumi.set(__self__, "bgp_settings", bgp_settings)
        if custom_route is not None:
            pulumi.set(__self__, "custom_route", custom_route)
        if default_local_network_gateway_id is not None:
            pulumi.set(__self__, "default_local_network_gateway_id", default_local_network_gateway_id)
        if dns_forwarding_enabled is not None:
            pulumi.set(__self__, "dns_forwarding_enabled", dns_forwarding_enabled)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if ip_sec_replay_protection_enabled is not None:
            pulumi.set(__self__, "ip_sec_replay_protection_enabled", ip_sec_replay_protection_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_groups is not None:
            pulumi.set(__self__, "policy_groups", policy_groups)
        if private_ip_address_enabled is not None:
            pulumi.set(__self__, "private_ip_address_enabled", private_ip_address_enabled)
        if remote_vnet_traffic_enabled is not None:
            pulumi.set(__self__, "remote_vnet_traffic_enabled", remote_vnet_traffic_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_wan_traffic_enabled is not None:
            pulumi.set(__self__, "virtual_wan_traffic_enabled", virtual_wan_traffic_enabled)
        if vpn_client_configuration is not None:
            pulumi.set(__self__, "vpn_client_configuration", vpn_client_configuration)
        if vpn_type is not None:
            pulumi.set(__self__, "vpn_type", vpn_type)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIpConfigurationArgs']]]:
        """
        One or more (up to 3) `ip_configuration` blocks documented below. Changing this forces a new resource to be created. 
        An active-standby gateway requires exactly one `ip_configuration` block,
        an active-active gateway requires exactly two `ip_configuration` blocks whereas
        an active-active zone redundant gateway with P2S configuration requires exactly three `ip_configuration` blocks.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIpConfigurationArgs']]]):
        pulumi.set(self, "ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Virtual Network Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        """
        Configuration of the size and capacity of the virtual network gateway. Valid options are `Basic`, `Standard`, `HighPerformance`, `UltraPerformance`, `ErGw1AZ`, `ErGw2AZ`, `ErGw3AZ`, `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw4`,`VpnGw5`, `VpnGw1AZ`, `VpnGw2AZ`, `VpnGw3AZ`,`VpnGw4AZ` and `VpnGw5AZ` and depend on the `type`, `vpn_type` and `generation` arguments. A `PolicyBased` gateway only supports the `Basic` SKU. Further, the `UltraPerformance` SKU is only supported by an `ExpressRoute` gateway.

        > **Note:** To build a UltraPerformance ExpressRoute Virtual Network gateway, the associated Public IP needs to be SKU "Basic" not "Standard"

        > **Note:** Not all SKUs (e.g. `ErGw1AZ`) are available in all regions. If you see `StatusCode=400 -- Original Error: Code="InvalidGatewaySkuSpecifiedForGatewayDeploymentType"` please try another region.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the Virtual Network Gateway. Valid options are `Vpn` or `ExpressRoute`. Changing the type forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="activeActive")
    def active_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, an active-active Virtual Network Gateway will be created. An active-active gateway requires a `HighPerformance` or an `UltraPerformance` SKU. If `false`, an active-standby gateway will be created. Defaults to `false`.
        """
        return pulumi.get(self, "active_active")

    @active_active.setter
    def active_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active_active", value)

    @_builtins.property
    @pulumi.getter(name="bgpRouteTranslationForNatEnabled")
    def bgp_route_translation_for_nat_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is BGP Route Translation for NAT enabled? Defaults to `false`.
        """
        return pulumi.get(self, "bgp_route_translation_for_nat_enabled")

    @bgp_route_translation_for_nat_enabled.setter
    def bgp_route_translation_for_nat_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bgp_route_translation_for_nat_enabled", value)

    @_builtins.property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Optional[pulumi.Input['VirtualNetworkGatewayBgpSettingsArgs']]:
        """
        A `bgp_settings` block which is documented below. In this block the BGP specific settings can be defined.
        """
        return pulumi.get(self, "bgp_settings")

    @bgp_settings.setter
    def bgp_settings(self, value: Optional[pulumi.Input['VirtualNetworkGatewayBgpSettingsArgs']]):
        pulumi.set(self, "bgp_settings", value)

    @_builtins.property
    @pulumi.getter(name="customRoute")
    def custom_route(self) -> Optional[pulumi.Input['VirtualNetworkGatewayCustomRouteArgs']]:
        """
        A `custom_route` block as defined below. Specifies a custom routes address space for a virtual network gateway and a VpnClient.
        """
        return pulumi.get(self, "custom_route")

    @custom_route.setter
    def custom_route(self, value: Optional[pulumi.Input['VirtualNetworkGatewayCustomRouteArgs']]):
        pulumi.set(self, "custom_route", value)

    @_builtins.property
    @pulumi.getter(name="defaultLocalNetworkGatewayId")
    def default_local_network_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the local network gateway through which outbound Internet traffic from the virtual network in which the gateway is created will be routed (*forced tunnelling*). Refer to the [Azure documentation on forced tunnelling](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-forced-tunneling-rm). If not specified, forced tunnelling is disabled.
        """
        return pulumi.get(self, "default_local_network_gateway_id")

    @default_local_network_gateway_id.setter
    def default_local_network_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_local_network_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsForwardingEnabled")
    def dns_forwarding_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is DNS forwarding enabled?
        """
        return pulumi.get(self, "dns_forwarding_enabled")

    @dns_forwarding_enabled.setter
    def dns_forwarding_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dns_forwarding_enabled", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Virtual Network Gateway should exist. Changing this forces a new Virtual Network Gateway to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, BGP (Border Gateway Protocol) will be enabled for this Virtual Network Gateway. Defaults to `false`.
        """
        return pulumi.get(self, "enable_bgp")

    @enable_bgp.setter
    def enable_bgp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_bgp", value)

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Generation of the Virtual Network gateway. Possible values include `Generation1`, `Generation2` or `None`. Changing this forces a new resource to be created.

        > **Note:** The available values depend on the `type` and `sku` arguments - where `Generation2` is only value for a `sku` larger than `VpnGw2` or `VpnGw2AZ`.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generation", value)

    @_builtins.property
    @pulumi.getter(name="ipSecReplayProtectionEnabled")
    def ip_sec_replay_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is IP Sec Replay Protection enabled? Defaults to `true`.
        """
        return pulumi.get(self, "ip_sec_replay_protection_enabled")

    @ip_sec_replay_protection_enabled.setter
    def ip_sec_replay_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_sec_replay_protection_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location/region where the Virtual Network Gateway is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Virtual Network Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyGroups")
    def policy_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayPolicyGroupArgs']]]]:
        """
        One or more `policy_group` blocks as defined below.
        """
        return pulumi.get(self, "policy_groups")

    @policy_groups.setter
    def policy_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayPolicyGroupArgs']]]]):
        pulumi.set(self, "policy_groups", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddressEnabled")
    def private_ip_address_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should private IP be enabled on this gateway for connections? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_ip_address_enabled")

    @private_ip_address_enabled.setter
    def private_ip_address_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_ip_address_enabled", value)

    @_builtins.property
    @pulumi.getter(name="remoteVnetTrafficEnabled")
    def remote_vnet_traffic_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is remote vnet traffic that is used to configure this gateway to accept traffic from other Azure Virtual Networks enabled? Defaults to `false`.
        """
        return pulumi.get(self, "remote_vnet_traffic_enabled")

    @remote_vnet_traffic_enabled.setter
    def remote_vnet_traffic_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remote_vnet_traffic_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualWanTrafficEnabled")
    def virtual_wan_traffic_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is remote vnet traffic that is used to configure this gateway to accept traffic from remote Virtual WAN networks enabled? Defaults to `false`.
        """
        return pulumi.get(self, "virtual_wan_traffic_enabled")

    @virtual_wan_traffic_enabled.setter
    def virtual_wan_traffic_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virtual_wan_traffic_enabled", value)

    @_builtins.property
    @pulumi.getter(name="vpnClientConfiguration")
    def vpn_client_configuration(self) -> Optional[pulumi.Input['VirtualNetworkGatewayVpnClientConfigurationArgs']]:
        """
        A `vpn_client_configuration` block which is documented below. In this block the Virtual Network Gateway can be configured to accept IPSec point-to-site connections.
        """
        return pulumi.get(self, "vpn_client_configuration")

    @vpn_client_configuration.setter
    def vpn_client_configuration(self, value: Optional[pulumi.Input['VirtualNetworkGatewayVpnClientConfigurationArgs']]):
        pulumi.set(self, "vpn_client_configuration", value)

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The routing type of the Virtual Network Gateway. Valid options are `RouteBased` or `PolicyBased`. Defaults to `RouteBased`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vpn_type")

    @vpn_type.setter
    def vpn_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_type", value)


@pulumi.input_type
class _VirtualNetworkGatewayState:
    def __init__(__self__, *,
                 active_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_route_translation_for_nat_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_settings: Optional[pulumi.Input['VirtualNetworkGatewayBgpSettingsArgs']] = None,
                 custom_route: Optional[pulumi.Input['VirtualNetworkGatewayCustomRouteArgs']] = None,
                 default_local_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 generation: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIpConfigurationArgs']]]] = None,
                 ip_sec_replay_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_groups: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayPolicyGroupArgs']]]] = None,
                 private_ip_address_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_vnet_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_wan_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpn_client_configuration: Optional[pulumi.Input['VirtualNetworkGatewayVpnClientConfigurationArgs']] = None,
                 vpn_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualNetworkGateway resources.
        :param pulumi.Input[_builtins.bool] active_active: If `true`, an active-active Virtual Network Gateway will be created. An active-active gateway requires a `HighPerformance` or an `UltraPerformance` SKU. If `false`, an active-standby gateway will be created. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] bgp_route_translation_for_nat_enabled: Is BGP Route Translation for NAT enabled? Defaults to `false`.
        :param pulumi.Input['VirtualNetworkGatewayBgpSettingsArgs'] bgp_settings: A `bgp_settings` block which is documented below. In this block the BGP specific settings can be defined.
        :param pulumi.Input['VirtualNetworkGatewayCustomRouteArgs'] custom_route: A `custom_route` block as defined below. Specifies a custom routes address space for a virtual network gateway and a VpnClient.
        :param pulumi.Input[_builtins.str] default_local_network_gateway_id: The ID of the local network gateway through which outbound Internet traffic from the virtual network in which the gateway is created will be routed (*forced tunnelling*). Refer to the [Azure documentation on forced tunnelling](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-forced-tunneling-rm). If not specified, forced tunnelling is disabled.
        :param pulumi.Input[_builtins.bool] dns_forwarding_enabled: Is DNS forwarding enabled?
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Virtual Network Gateway should exist. Changing this forces a new Virtual Network Gateway to be created.
        :param pulumi.Input[_builtins.bool] enable_bgp: If `true`, BGP (Border Gateway Protocol) will be enabled for this Virtual Network Gateway. Defaults to `false`.
        :param pulumi.Input[_builtins.str] generation: The Generation of the Virtual Network gateway. Possible values include `Generation1`, `Generation2` or `None`. Changing this forces a new resource to be created.
               
               > **Note:** The available values depend on the `type` and `sku` arguments - where `Generation2` is only value for a `sku` larger than `VpnGw2` or `VpnGw2AZ`.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIpConfigurationArgs']]] ip_configurations: One or more (up to 3) `ip_configuration` blocks documented below. Changing this forces a new resource to be created. 
               An active-standby gateway requires exactly one `ip_configuration` block,
               an active-active gateway requires exactly two `ip_configuration` blocks whereas
               an active-active zone redundant gateway with P2S configuration requires exactly three `ip_configuration` blocks.
        :param pulumi.Input[_builtins.bool] ip_sec_replay_protection_enabled: Is IP Sec Replay Protection enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The location/region where the Virtual Network Gateway is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Network Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayPolicyGroupArgs']]] policy_groups: One or more `policy_group` blocks as defined below.
        :param pulumi.Input[_builtins.bool] private_ip_address_enabled: Should private IP be enabled on this gateway for connections? Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] remote_vnet_traffic_enabled: Is remote vnet traffic that is used to configure this gateway to accept traffic from other Azure Virtual Networks enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Virtual Network Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Configuration of the size and capacity of the virtual network gateway. Valid options are `Basic`, `Standard`, `HighPerformance`, `UltraPerformance`, `ErGw1AZ`, `ErGw2AZ`, `ErGw3AZ`, `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw4`,`VpnGw5`, `VpnGw1AZ`, `VpnGw2AZ`, `VpnGw3AZ`,`VpnGw4AZ` and `VpnGw5AZ` and depend on the `type`, `vpn_type` and `generation` arguments. A `PolicyBased` gateway only supports the `Basic` SKU. Further, the `UltraPerformance` SKU is only supported by an `ExpressRoute` gateway.
               
               > **Note:** To build a UltraPerformance ExpressRoute Virtual Network gateway, the associated Public IP needs to be SKU "Basic" not "Standard"
               
               > **Note:** Not all SKUs (e.g. `ErGw1AZ`) are available in all regions. If you see `StatusCode=400 -- Original Error: Code="InvalidGatewaySkuSpecifiedForGatewayDeploymentType"` please try another region.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Network Gateway. Valid options are `Vpn` or `ExpressRoute`. Changing the type forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] virtual_wan_traffic_enabled: Is remote vnet traffic that is used to configure this gateway to accept traffic from remote Virtual WAN networks enabled? Defaults to `false`.
        :param pulumi.Input['VirtualNetworkGatewayVpnClientConfigurationArgs'] vpn_client_configuration: A `vpn_client_configuration` block which is documented below. In this block the Virtual Network Gateway can be configured to accept IPSec point-to-site connections.
        :param pulumi.Input[_builtins.str] vpn_type: The routing type of the Virtual Network Gateway. Valid options are `RouteBased` or `PolicyBased`. Defaults to `RouteBased`. Changing this forces a new resource to be created.
        """
        if active_active is not None:
            pulumi.set(__self__, "active_active", active_active)
        if bgp_route_translation_for_nat_enabled is not None:
            pulumi.set(__self__, "bgp_route_translation_for_nat_enabled", bgp_route_translation_for_nat_enabled)
        if bgp_settings is not None:
            pulumi.set(__self__, "bgp_settings", bgp_settings)
        if custom_route is not None:
            pulumi.set(__self__, "custom_route", custom_route)
        if default_local_network_gateway_id is not None:
            pulumi.set(__self__, "default_local_network_gateway_id", default_local_network_gateway_id)
        if dns_forwarding_enabled is not None:
            pulumi.set(__self__, "dns_forwarding_enabled", dns_forwarding_enabled)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if ip_sec_replay_protection_enabled is not None:
            pulumi.set(__self__, "ip_sec_replay_protection_enabled", ip_sec_replay_protection_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_groups is not None:
            pulumi.set(__self__, "policy_groups", policy_groups)
        if private_ip_address_enabled is not None:
            pulumi.set(__self__, "private_ip_address_enabled", private_ip_address_enabled)
        if remote_vnet_traffic_enabled is not None:
            pulumi.set(__self__, "remote_vnet_traffic_enabled", remote_vnet_traffic_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if virtual_wan_traffic_enabled is not None:
            pulumi.set(__self__, "virtual_wan_traffic_enabled", virtual_wan_traffic_enabled)
        if vpn_client_configuration is not None:
            pulumi.set(__self__, "vpn_client_configuration", vpn_client_configuration)
        if vpn_type is not None:
            pulumi.set(__self__, "vpn_type", vpn_type)

    @_builtins.property
    @pulumi.getter(name="activeActive")
    def active_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, an active-active Virtual Network Gateway will be created. An active-active gateway requires a `HighPerformance` or an `UltraPerformance` SKU. If `false`, an active-standby gateway will be created. Defaults to `false`.
        """
        return pulumi.get(self, "active_active")

    @active_active.setter
    def active_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active_active", value)

    @_builtins.property
    @pulumi.getter(name="bgpRouteTranslationForNatEnabled")
    def bgp_route_translation_for_nat_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is BGP Route Translation for NAT enabled? Defaults to `false`.
        """
        return pulumi.get(self, "bgp_route_translation_for_nat_enabled")

    @bgp_route_translation_for_nat_enabled.setter
    def bgp_route_translation_for_nat_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bgp_route_translation_for_nat_enabled", value)

    @_builtins.property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Optional[pulumi.Input['VirtualNetworkGatewayBgpSettingsArgs']]:
        """
        A `bgp_settings` block which is documented below. In this block the BGP specific settings can be defined.
        """
        return pulumi.get(self, "bgp_settings")

    @bgp_settings.setter
    def bgp_settings(self, value: Optional[pulumi.Input['VirtualNetworkGatewayBgpSettingsArgs']]):
        pulumi.set(self, "bgp_settings", value)

    @_builtins.property
    @pulumi.getter(name="customRoute")
    def custom_route(self) -> Optional[pulumi.Input['VirtualNetworkGatewayCustomRouteArgs']]:
        """
        A `custom_route` block as defined below. Specifies a custom routes address space for a virtual network gateway and a VpnClient.
        """
        return pulumi.get(self, "custom_route")

    @custom_route.setter
    def custom_route(self, value: Optional[pulumi.Input['VirtualNetworkGatewayCustomRouteArgs']]):
        pulumi.set(self, "custom_route", value)

    @_builtins.property
    @pulumi.getter(name="defaultLocalNetworkGatewayId")
    def default_local_network_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the local network gateway through which outbound Internet traffic from the virtual network in which the gateway is created will be routed (*forced tunnelling*). Refer to the [Azure documentation on forced tunnelling](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-forced-tunneling-rm). If not specified, forced tunnelling is disabled.
        """
        return pulumi.get(self, "default_local_network_gateway_id")

    @default_local_network_gateway_id.setter
    def default_local_network_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_local_network_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsForwardingEnabled")
    def dns_forwarding_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is DNS forwarding enabled?
        """
        return pulumi.get(self, "dns_forwarding_enabled")

    @dns_forwarding_enabled.setter
    def dns_forwarding_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dns_forwarding_enabled", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Virtual Network Gateway should exist. Changing this forces a new Virtual Network Gateway to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, BGP (Border Gateway Protocol) will be enabled for this Virtual Network Gateway. Defaults to `false`.
        """
        return pulumi.get(self, "enable_bgp")

    @enable_bgp.setter
    def enable_bgp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_bgp", value)

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Generation of the Virtual Network gateway. Possible values include `Generation1`, `Generation2` or `None`. Changing this forces a new resource to be created.

        > **Note:** The available values depend on the `type` and `sku` arguments - where `Generation2` is only value for a `sku` larger than `VpnGw2` or `VpnGw2AZ`.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generation", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIpConfigurationArgs']]]]:
        """
        One or more (up to 3) `ip_configuration` blocks documented below. Changing this forces a new resource to be created. 
        An active-standby gateway requires exactly one `ip_configuration` block,
        an active-active gateway requires exactly two `ip_configuration` blocks whereas
        an active-active zone redundant gateway with P2S configuration requires exactly three `ip_configuration` blocks.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayIpConfigurationArgs']]]]):
        pulumi.set(self, "ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="ipSecReplayProtectionEnabled")
    def ip_sec_replay_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is IP Sec Replay Protection enabled? Defaults to `true`.
        """
        return pulumi.get(self, "ip_sec_replay_protection_enabled")

    @ip_sec_replay_protection_enabled.setter
    def ip_sec_replay_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_sec_replay_protection_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location/region where the Virtual Network Gateway is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Virtual Network Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyGroups")
    def policy_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayPolicyGroupArgs']]]]:
        """
        One or more `policy_group` blocks as defined below.
        """
        return pulumi.get(self, "policy_groups")

    @policy_groups.setter
    def policy_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayPolicyGroupArgs']]]]):
        pulumi.set(self, "policy_groups", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddressEnabled")
    def private_ip_address_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should private IP be enabled on this gateway for connections? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_ip_address_enabled")

    @private_ip_address_enabled.setter
    def private_ip_address_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_ip_address_enabled", value)

    @_builtins.property
    @pulumi.getter(name="remoteVnetTrafficEnabled")
    def remote_vnet_traffic_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is remote vnet traffic that is used to configure this gateway to accept traffic from other Azure Virtual Networks enabled? Defaults to `false`.
        """
        return pulumi.get(self, "remote_vnet_traffic_enabled")

    @remote_vnet_traffic_enabled.setter
    def remote_vnet_traffic_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remote_vnet_traffic_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Virtual Network Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration of the size and capacity of the virtual network gateway. Valid options are `Basic`, `Standard`, `HighPerformance`, `UltraPerformance`, `ErGw1AZ`, `ErGw2AZ`, `ErGw3AZ`, `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw4`,`VpnGw5`, `VpnGw1AZ`, `VpnGw2AZ`, `VpnGw3AZ`,`VpnGw4AZ` and `VpnGw5AZ` and depend on the `type`, `vpn_type` and `generation` arguments. A `PolicyBased` gateway only supports the `Basic` SKU. Further, the `UltraPerformance` SKU is only supported by an `ExpressRoute` gateway.

        > **Note:** To build a UltraPerformance ExpressRoute Virtual Network gateway, the associated Public IP needs to be SKU "Basic" not "Standard"

        > **Note:** Not all SKUs (e.g. `ErGw1AZ`) are available in all regions. If you see `StatusCode=400 -- Original Error: Code="InvalidGatewaySkuSpecifiedForGatewayDeploymentType"` please try another region.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Virtual Network Gateway. Valid options are `Vpn` or `ExpressRoute`. Changing the type forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="virtualWanTrafficEnabled")
    def virtual_wan_traffic_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is remote vnet traffic that is used to configure this gateway to accept traffic from remote Virtual WAN networks enabled? Defaults to `false`.
        """
        return pulumi.get(self, "virtual_wan_traffic_enabled")

    @virtual_wan_traffic_enabled.setter
    def virtual_wan_traffic_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virtual_wan_traffic_enabled", value)

    @_builtins.property
    @pulumi.getter(name="vpnClientConfiguration")
    def vpn_client_configuration(self) -> Optional[pulumi.Input['VirtualNetworkGatewayVpnClientConfigurationArgs']]:
        """
        A `vpn_client_configuration` block which is documented below. In this block the Virtual Network Gateway can be configured to accept IPSec point-to-site connections.
        """
        return pulumi.get(self, "vpn_client_configuration")

    @vpn_client_configuration.setter
    def vpn_client_configuration(self, value: Optional[pulumi.Input['VirtualNetworkGatewayVpnClientConfigurationArgs']]):
        pulumi.set(self, "vpn_client_configuration", value)

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The routing type of the Virtual Network Gateway. Valid options are `RouteBased` or `PolicyBased`. Defaults to `RouteBased`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vpn_type")

    @vpn_type.setter
    def vpn_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_type", value)


@pulumi.type_token("azure:network/virtualNetworkGateway:VirtualNetworkGateway")
class VirtualNetworkGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_route_translation_for_nat_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_settings: Optional[pulumi.Input[Union['VirtualNetworkGatewayBgpSettingsArgs', 'VirtualNetworkGatewayBgpSettingsArgsDict']]] = None,
                 custom_route: Optional[pulumi.Input[Union['VirtualNetworkGatewayCustomRouteArgs', 'VirtualNetworkGatewayCustomRouteArgsDict']]] = None,
                 default_local_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 generation: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayIpConfigurationArgs', 'VirtualNetworkGatewayIpConfigurationArgsDict']]]]] = None,
                 ip_sec_replay_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayPolicyGroupArgs', 'VirtualNetworkGatewayPolicyGroupArgsDict']]]]] = None,
                 private_ip_address_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_vnet_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_wan_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpn_client_configuration: Optional[pulumi.Input[Union['VirtualNetworkGatewayVpnClientConfigurationArgs', 'VirtualNetworkGatewayVpnClientConfigurationArgsDict']]] = None,
                 vpn_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Virtual Network Gateway to establish secure, cross-premises connectivity.

        > **Note:** Please be aware that provisioning a Virtual Network Gateway takes a long time (between 30 minutes and 1 hour)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="test",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="GatewaySubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Dynamic")
        example_virtual_network_gateway = azure.network.VirtualNetworkGateway("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            type="Vpn",
            vpn_type="RouteBased",
            active_active=False,
            enable_bgp=False,
            sku="Basic",
            ip_configurations=[{
                "name": "vnetGatewayConfig",
                "public_ip_address_id": example_public_ip.id,
                "private_ip_address_allocation": "Dynamic",
                "subnet_id": example_subnet.id,
            }],
            vpn_client_configuration={
                "address_spaces": ["10.2.0.0/24"],
                "root_certificates": [{
                    "name": "DigiCert-Federated-ID-Root-CA",
                    "public_cert_data": \"\"\"MIIDuzCCAqOgAwIBAgIQCHTZWCM+IlfFIRXIvyKSrjANBgkqhkiG9w0BAQsFADBn
        MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
        d3cuZGlnaWNlcnQuY29tMSYwJAYDVQQDEx1EaWdpQ2VydCBGZWRlcmF0ZWQgSUQg
        Um9vdCBDQTAeFw0xMzAxMTUxMjAwMDBaFw0zMzAxMTUxMjAwMDBaMGcxCzAJBgNV
        BAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdp
        Y2VydC5jb20xJjAkBgNVBAMTHURpZ2lDZXJ0IEZlZGVyYXRlZCBJRCBSb290IENB
        MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvAEB4pcCqnNNOWE6Ur5j
        QPUH+1y1F9KdHTRSza6k5iDlXq1kGS1qAkuKtw9JsiNRrjltmFnzMZRBbX8Tlfl8
        zAhBmb6dDduDGED01kBsTkgywYPxXVTKec0WxYEEF0oMn4wSYNl0lt2eJAKHXjNf
        GTwiibdP8CUR2ghSM2sUTI8Nt1Omfc4SMHhGhYD64uJMbX98THQ/4LMGuYegou+d
        GTiahfHtjn7AboSEknwAMJHCh5RlYZZ6B1O4QbKJ+34Q0eKgnI3X6Vc9u0zf6DH8
        Dk+4zQDYRRTqTnVO3VT8jzqDlCRuNtq6YvryOWN74/dq8LQhUnXHvFyrsdMaE1X2
        DwIDAQABo2MwYTAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjAdBgNV
        HQ4EFgQUGRdkFnbGt1EWjKwbUne+5OaZvRYwHwYDVR0jBBgwFoAUGRdkFnbGt1EW
        jKwbUne+5OaZvRYwDQYJKoZIhvcNAQELBQADggEBAHcqsHkrjpESqfuVTRiptJfP
        9JbdtWqRTmOf6uJi2c8YVqI6XlKXsD8C1dUUaaHKLUJzvKiazibVuBwMIT84AyqR
        QELn3e0BtgEymEygMU569b01ZPxoFSnNXc7qDZBDef8WfqAV/sxkTi8L9BkmFYfL
        uGLOhRJOFprPdoDIUBB+tmCl3oDcBy3vnUeOEioz8zAkprcb3GHwHAK+vHmmfgcn
        WsfMLH4JCLa/tRYL+Rw/N3ybCkDp00s0WUZ+AoDywSl0Q/ZEnNY0MsFiw6LyIdbq
        M/s/1JRtO3bDSzD9TazRVzn2oBqzSa8VgIo5C1nOnoAKJTlsClJKvIhnRlaLQqk=
        \"\"\",
                }],
                "revoked_certificates": [{
                    "name": "Verizon-Global-Root-CA",
                    "thumbprint": "912198EEF23DCAC40939312FEE97DD560BAE49B1",
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Network Gateways can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetworkGateway:VirtualNetworkGateway exampleGateway /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.Network/virtualNetworkGateways/myGateway1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active_active: If `true`, an active-active Virtual Network Gateway will be created. An active-active gateway requires a `HighPerformance` or an `UltraPerformance` SKU. If `false`, an active-standby gateway will be created. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] bgp_route_translation_for_nat_enabled: Is BGP Route Translation for NAT enabled? Defaults to `false`.
        :param pulumi.Input[Union['VirtualNetworkGatewayBgpSettingsArgs', 'VirtualNetworkGatewayBgpSettingsArgsDict']] bgp_settings: A `bgp_settings` block which is documented below. In this block the BGP specific settings can be defined.
        :param pulumi.Input[Union['VirtualNetworkGatewayCustomRouteArgs', 'VirtualNetworkGatewayCustomRouteArgsDict']] custom_route: A `custom_route` block as defined below. Specifies a custom routes address space for a virtual network gateway and a VpnClient.
        :param pulumi.Input[_builtins.str] default_local_network_gateway_id: The ID of the local network gateway through which outbound Internet traffic from the virtual network in which the gateway is created will be routed (*forced tunnelling*). Refer to the [Azure documentation on forced tunnelling](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-forced-tunneling-rm). If not specified, forced tunnelling is disabled.
        :param pulumi.Input[_builtins.bool] dns_forwarding_enabled: Is DNS forwarding enabled?
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Virtual Network Gateway should exist. Changing this forces a new Virtual Network Gateway to be created.
        :param pulumi.Input[_builtins.bool] enable_bgp: If `true`, BGP (Border Gateway Protocol) will be enabled for this Virtual Network Gateway. Defaults to `false`.
        :param pulumi.Input[_builtins.str] generation: The Generation of the Virtual Network gateway. Possible values include `Generation1`, `Generation2` or `None`. Changing this forces a new resource to be created.
               
               > **Note:** The available values depend on the `type` and `sku` arguments - where `Generation2` is only value for a `sku` larger than `VpnGw2` or `VpnGw2AZ`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayIpConfigurationArgs', 'VirtualNetworkGatewayIpConfigurationArgsDict']]]] ip_configurations: One or more (up to 3) `ip_configuration` blocks documented below. Changing this forces a new resource to be created. 
               An active-standby gateway requires exactly one `ip_configuration` block,
               an active-active gateway requires exactly two `ip_configuration` blocks whereas
               an active-active zone redundant gateway with P2S configuration requires exactly three `ip_configuration` blocks.
        :param pulumi.Input[_builtins.bool] ip_sec_replay_protection_enabled: Is IP Sec Replay Protection enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The location/region where the Virtual Network Gateway is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Network Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayPolicyGroupArgs', 'VirtualNetworkGatewayPolicyGroupArgsDict']]]] policy_groups: One or more `policy_group` blocks as defined below.
        :param pulumi.Input[_builtins.bool] private_ip_address_enabled: Should private IP be enabled on this gateway for connections? Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] remote_vnet_traffic_enabled: Is remote vnet traffic that is used to configure this gateway to accept traffic from other Azure Virtual Networks enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Virtual Network Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Configuration of the size and capacity of the virtual network gateway. Valid options are `Basic`, `Standard`, `HighPerformance`, `UltraPerformance`, `ErGw1AZ`, `ErGw2AZ`, `ErGw3AZ`, `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw4`,`VpnGw5`, `VpnGw1AZ`, `VpnGw2AZ`, `VpnGw3AZ`,`VpnGw4AZ` and `VpnGw5AZ` and depend on the `type`, `vpn_type` and `generation` arguments. A `PolicyBased` gateway only supports the `Basic` SKU. Further, the `UltraPerformance` SKU is only supported by an `ExpressRoute` gateway.
               
               > **Note:** To build a UltraPerformance ExpressRoute Virtual Network gateway, the associated Public IP needs to be SKU "Basic" not "Standard"
               
               > **Note:** Not all SKUs (e.g. `ErGw1AZ`) are available in all regions. If you see `StatusCode=400 -- Original Error: Code="InvalidGatewaySkuSpecifiedForGatewayDeploymentType"` please try another region.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Network Gateway. Valid options are `Vpn` or `ExpressRoute`. Changing the type forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] virtual_wan_traffic_enabled: Is remote vnet traffic that is used to configure this gateway to accept traffic from remote Virtual WAN networks enabled? Defaults to `false`.
        :param pulumi.Input[Union['VirtualNetworkGatewayVpnClientConfigurationArgs', 'VirtualNetworkGatewayVpnClientConfigurationArgsDict']] vpn_client_configuration: A `vpn_client_configuration` block which is documented below. In this block the Virtual Network Gateway can be configured to accept IPSec point-to-site connections.
        :param pulumi.Input[_builtins.str] vpn_type: The routing type of the Virtual Network Gateway. Valid options are `RouteBased` or `PolicyBased`. Defaults to `RouteBased`. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualNetworkGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Virtual Network Gateway to establish secure, cross-premises connectivity.

        > **Note:** Please be aware that provisioning a Virtual Network Gateway takes a long time (between 30 minutes and 1 hour)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="test",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="GatewaySubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Dynamic")
        example_virtual_network_gateway = azure.network.VirtualNetworkGateway("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            type="Vpn",
            vpn_type="RouteBased",
            active_active=False,
            enable_bgp=False,
            sku="Basic",
            ip_configurations=[{
                "name": "vnetGatewayConfig",
                "public_ip_address_id": example_public_ip.id,
                "private_ip_address_allocation": "Dynamic",
                "subnet_id": example_subnet.id,
            }],
            vpn_client_configuration={
                "address_spaces": ["10.2.0.0/24"],
                "root_certificates": [{
                    "name": "DigiCert-Federated-ID-Root-CA",
                    "public_cert_data": \"\"\"MIIDuzCCAqOgAwIBAgIQCHTZWCM+IlfFIRXIvyKSrjANBgkqhkiG9w0BAQsFADBn
        MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
        d3cuZGlnaWNlcnQuY29tMSYwJAYDVQQDEx1EaWdpQ2VydCBGZWRlcmF0ZWQgSUQg
        Um9vdCBDQTAeFw0xMzAxMTUxMjAwMDBaFw0zMzAxMTUxMjAwMDBaMGcxCzAJBgNV
        BAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdp
        Y2VydC5jb20xJjAkBgNVBAMTHURpZ2lDZXJ0IEZlZGVyYXRlZCBJRCBSb290IENB
        MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvAEB4pcCqnNNOWE6Ur5j
        QPUH+1y1F9KdHTRSza6k5iDlXq1kGS1qAkuKtw9JsiNRrjltmFnzMZRBbX8Tlfl8
        zAhBmb6dDduDGED01kBsTkgywYPxXVTKec0WxYEEF0oMn4wSYNl0lt2eJAKHXjNf
        GTwiibdP8CUR2ghSM2sUTI8Nt1Omfc4SMHhGhYD64uJMbX98THQ/4LMGuYegou+d
        GTiahfHtjn7AboSEknwAMJHCh5RlYZZ6B1O4QbKJ+34Q0eKgnI3X6Vc9u0zf6DH8
        Dk+4zQDYRRTqTnVO3VT8jzqDlCRuNtq6YvryOWN74/dq8LQhUnXHvFyrsdMaE1X2
        DwIDAQABo2MwYTAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjAdBgNV
        HQ4EFgQUGRdkFnbGt1EWjKwbUne+5OaZvRYwHwYDVR0jBBgwFoAUGRdkFnbGt1EW
        jKwbUne+5OaZvRYwDQYJKoZIhvcNAQELBQADggEBAHcqsHkrjpESqfuVTRiptJfP
        9JbdtWqRTmOf6uJi2c8YVqI6XlKXsD8C1dUUaaHKLUJzvKiazibVuBwMIT84AyqR
        QELn3e0BtgEymEygMU569b01ZPxoFSnNXc7qDZBDef8WfqAV/sxkTi8L9BkmFYfL
        uGLOhRJOFprPdoDIUBB+tmCl3oDcBy3vnUeOEioz8zAkprcb3GHwHAK+vHmmfgcn
        WsfMLH4JCLa/tRYL+Rw/N3ybCkDp00s0WUZ+AoDywSl0Q/ZEnNY0MsFiw6LyIdbq
        M/s/1JRtO3bDSzD9TazRVzn2oBqzSa8VgIo5C1nOnoAKJTlsClJKvIhnRlaLQqk=
        \"\"\",
                }],
                "revoked_certificates": [{
                    "name": "Verizon-Global-Root-CA",
                    "thumbprint": "912198EEF23DCAC40939312FEE97DD560BAE49B1",
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Network Gateways can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetworkGateway:VirtualNetworkGateway exampleGateway /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.Network/virtualNetworkGateways/myGateway1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualNetworkGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualNetworkGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_route_translation_for_nat_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_settings: Optional[pulumi.Input[Union['VirtualNetworkGatewayBgpSettingsArgs', 'VirtualNetworkGatewayBgpSettingsArgsDict']]] = None,
                 custom_route: Optional[pulumi.Input[Union['VirtualNetworkGatewayCustomRouteArgs', 'VirtualNetworkGatewayCustomRouteArgsDict']]] = None,
                 default_local_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 generation: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayIpConfigurationArgs', 'VirtualNetworkGatewayIpConfigurationArgsDict']]]]] = None,
                 ip_sec_replay_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayPolicyGroupArgs', 'VirtualNetworkGatewayPolicyGroupArgsDict']]]]] = None,
                 private_ip_address_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_vnet_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_wan_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpn_client_configuration: Optional[pulumi.Input[Union['VirtualNetworkGatewayVpnClientConfigurationArgs', 'VirtualNetworkGatewayVpnClientConfigurationArgsDict']]] = None,
                 vpn_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualNetworkGatewayArgs.__new__(VirtualNetworkGatewayArgs)

            __props__.__dict__["active_active"] = active_active
            __props__.__dict__["bgp_route_translation_for_nat_enabled"] = bgp_route_translation_for_nat_enabled
            __props__.__dict__["bgp_settings"] = bgp_settings
            __props__.__dict__["custom_route"] = custom_route
            __props__.__dict__["default_local_network_gateway_id"] = default_local_network_gateway_id
            __props__.__dict__["dns_forwarding_enabled"] = dns_forwarding_enabled
            __props__.__dict__["edge_zone"] = edge_zone
            __props__.__dict__["enable_bgp"] = enable_bgp
            __props__.__dict__["generation"] = generation
            if ip_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'ip_configurations'")
            __props__.__dict__["ip_configurations"] = ip_configurations
            __props__.__dict__["ip_sec_replay_protection_enabled"] = ip_sec_replay_protection_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["policy_groups"] = policy_groups
            __props__.__dict__["private_ip_address_enabled"] = private_ip_address_enabled
            __props__.__dict__["remote_vnet_traffic_enabled"] = remote_vnet_traffic_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["virtual_wan_traffic_enabled"] = virtual_wan_traffic_enabled
            __props__.__dict__["vpn_client_configuration"] = vpn_client_configuration
            __props__.__dict__["vpn_type"] = vpn_type
        super(VirtualNetworkGateway, __self__).__init__(
            'azure:network/virtualNetworkGateway:VirtualNetworkGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_active: Optional[pulumi.Input[_builtins.bool]] = None,
            bgp_route_translation_for_nat_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            bgp_settings: Optional[pulumi.Input[Union['VirtualNetworkGatewayBgpSettingsArgs', 'VirtualNetworkGatewayBgpSettingsArgsDict']]] = None,
            custom_route: Optional[pulumi.Input[Union['VirtualNetworkGatewayCustomRouteArgs', 'VirtualNetworkGatewayCustomRouteArgsDict']]] = None,
            default_local_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            dns_forwarding_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
            enable_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
            generation: Optional[pulumi.Input[_builtins.str]] = None,
            ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayIpConfigurationArgs', 'VirtualNetworkGatewayIpConfigurationArgsDict']]]]] = None,
            ip_sec_replay_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayPolicyGroupArgs', 'VirtualNetworkGatewayPolicyGroupArgsDict']]]]] = None,
            private_ip_address_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            remote_vnet_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_wan_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            vpn_client_configuration: Optional[pulumi.Input[Union['VirtualNetworkGatewayVpnClientConfigurationArgs', 'VirtualNetworkGatewayVpnClientConfigurationArgsDict']]] = None,
            vpn_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'VirtualNetworkGateway':
        """
        Get an existing VirtualNetworkGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active_active: If `true`, an active-active Virtual Network Gateway will be created. An active-active gateway requires a `HighPerformance` or an `UltraPerformance` SKU. If `false`, an active-standby gateway will be created. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] bgp_route_translation_for_nat_enabled: Is BGP Route Translation for NAT enabled? Defaults to `false`.
        :param pulumi.Input[Union['VirtualNetworkGatewayBgpSettingsArgs', 'VirtualNetworkGatewayBgpSettingsArgsDict']] bgp_settings: A `bgp_settings` block which is documented below. In this block the BGP specific settings can be defined.
        :param pulumi.Input[Union['VirtualNetworkGatewayCustomRouteArgs', 'VirtualNetworkGatewayCustomRouteArgsDict']] custom_route: A `custom_route` block as defined below. Specifies a custom routes address space for a virtual network gateway and a VpnClient.
        :param pulumi.Input[_builtins.str] default_local_network_gateway_id: The ID of the local network gateway through which outbound Internet traffic from the virtual network in which the gateway is created will be routed (*forced tunnelling*). Refer to the [Azure documentation on forced tunnelling](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-forced-tunneling-rm). If not specified, forced tunnelling is disabled.
        :param pulumi.Input[_builtins.bool] dns_forwarding_enabled: Is DNS forwarding enabled?
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Virtual Network Gateway should exist. Changing this forces a new Virtual Network Gateway to be created.
        :param pulumi.Input[_builtins.bool] enable_bgp: If `true`, BGP (Border Gateway Protocol) will be enabled for this Virtual Network Gateway. Defaults to `false`.
        :param pulumi.Input[_builtins.str] generation: The Generation of the Virtual Network gateway. Possible values include `Generation1`, `Generation2` or `None`. Changing this forces a new resource to be created.
               
               > **Note:** The available values depend on the `type` and `sku` arguments - where `Generation2` is only value for a `sku` larger than `VpnGw2` or `VpnGw2AZ`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayIpConfigurationArgs', 'VirtualNetworkGatewayIpConfigurationArgsDict']]]] ip_configurations: One or more (up to 3) `ip_configuration` blocks documented below. Changing this forces a new resource to be created. 
               An active-standby gateway requires exactly one `ip_configuration` block,
               an active-active gateway requires exactly two `ip_configuration` blocks whereas
               an active-active zone redundant gateway with P2S configuration requires exactly three `ip_configuration` blocks.
        :param pulumi.Input[_builtins.bool] ip_sec_replay_protection_enabled: Is IP Sec Replay Protection enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: The location/region where the Virtual Network Gateway is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Network Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayPolicyGroupArgs', 'VirtualNetworkGatewayPolicyGroupArgsDict']]]] policy_groups: One or more `policy_group` blocks as defined below.
        :param pulumi.Input[_builtins.bool] private_ip_address_enabled: Should private IP be enabled on this gateway for connections? Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] remote_vnet_traffic_enabled: Is remote vnet traffic that is used to configure this gateway to accept traffic from other Azure Virtual Networks enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Virtual Network Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Configuration of the size and capacity of the virtual network gateway. Valid options are `Basic`, `Standard`, `HighPerformance`, `UltraPerformance`, `ErGw1AZ`, `ErGw2AZ`, `ErGw3AZ`, `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw4`,`VpnGw5`, `VpnGw1AZ`, `VpnGw2AZ`, `VpnGw3AZ`,`VpnGw4AZ` and `VpnGw5AZ` and depend on the `type`, `vpn_type` and `generation` arguments. A `PolicyBased` gateway only supports the `Basic` SKU. Further, the `UltraPerformance` SKU is only supported by an `ExpressRoute` gateway.
               
               > **Note:** To build a UltraPerformance ExpressRoute Virtual Network gateway, the associated Public IP needs to be SKU "Basic" not "Standard"
               
               > **Note:** Not all SKUs (e.g. `ErGw1AZ`) are available in all regions. If you see `StatusCode=400 -- Original Error: Code="InvalidGatewaySkuSpecifiedForGatewayDeploymentType"` please try another region.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Network Gateway. Valid options are `Vpn` or `ExpressRoute`. Changing the type forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] virtual_wan_traffic_enabled: Is remote vnet traffic that is used to configure this gateway to accept traffic from remote Virtual WAN networks enabled? Defaults to `false`.
        :param pulumi.Input[Union['VirtualNetworkGatewayVpnClientConfigurationArgs', 'VirtualNetworkGatewayVpnClientConfigurationArgsDict']] vpn_client_configuration: A `vpn_client_configuration` block which is documented below. In this block the Virtual Network Gateway can be configured to accept IPSec point-to-site connections.
        :param pulumi.Input[_builtins.str] vpn_type: The routing type of the Virtual Network Gateway. Valid options are `RouteBased` or `PolicyBased`. Defaults to `RouteBased`. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualNetworkGatewayState.__new__(_VirtualNetworkGatewayState)

        __props__.__dict__["active_active"] = active_active
        __props__.__dict__["bgp_route_translation_for_nat_enabled"] = bgp_route_translation_for_nat_enabled
        __props__.__dict__["bgp_settings"] = bgp_settings
        __props__.__dict__["custom_route"] = custom_route
        __props__.__dict__["default_local_network_gateway_id"] = default_local_network_gateway_id
        __props__.__dict__["dns_forwarding_enabled"] = dns_forwarding_enabled
        __props__.__dict__["edge_zone"] = edge_zone
        __props__.__dict__["enable_bgp"] = enable_bgp
        __props__.__dict__["generation"] = generation
        __props__.__dict__["ip_configurations"] = ip_configurations
        __props__.__dict__["ip_sec_replay_protection_enabled"] = ip_sec_replay_protection_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_groups"] = policy_groups
        __props__.__dict__["private_ip_address_enabled"] = private_ip_address_enabled
        __props__.__dict__["remote_vnet_traffic_enabled"] = remote_vnet_traffic_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["virtual_wan_traffic_enabled"] = virtual_wan_traffic_enabled
        __props__.__dict__["vpn_client_configuration"] = vpn_client_configuration
        __props__.__dict__["vpn_type"] = vpn_type
        return VirtualNetworkGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activeActive")
    def active_active(self) -> pulumi.Output[_builtins.bool]:
        """
        If `true`, an active-active Virtual Network Gateway will be created. An active-active gateway requires a `HighPerformance` or an `UltraPerformance` SKU. If `false`, an active-standby gateway will be created. Defaults to `false`.
        """
        return pulumi.get(self, "active_active")

    @_builtins.property
    @pulumi.getter(name="bgpRouteTranslationForNatEnabled")
    def bgp_route_translation_for_nat_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is BGP Route Translation for NAT enabled? Defaults to `false`.
        """
        return pulumi.get(self, "bgp_route_translation_for_nat_enabled")

    @_builtins.property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> pulumi.Output['outputs.VirtualNetworkGatewayBgpSettings']:
        """
        A `bgp_settings` block which is documented below. In this block the BGP specific settings can be defined.
        """
        return pulumi.get(self, "bgp_settings")

    @_builtins.property
    @pulumi.getter(name="customRoute")
    def custom_route(self) -> pulumi.Output[Optional['outputs.VirtualNetworkGatewayCustomRoute']]:
        """
        A `custom_route` block as defined below. Specifies a custom routes address space for a virtual network gateway and a VpnClient.
        """
        return pulumi.get(self, "custom_route")

    @_builtins.property
    @pulumi.getter(name="defaultLocalNetworkGatewayId")
    def default_local_network_gateway_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the local network gateway through which outbound Internet traffic from the virtual network in which the gateway is created will be routed (*forced tunnelling*). Refer to the [Azure documentation on forced tunnelling](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-forced-tunneling-rm). If not specified, forced tunnelling is disabled.
        """
        return pulumi.get(self, "default_local_network_gateway_id")

    @_builtins.property
    @pulumi.getter(name="dnsForwardingEnabled")
    def dns_forwarding_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is DNS forwarding enabled?
        """
        return pulumi.get(self, "dns_forwarding_enabled")

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Virtual Network Gateway should exist. Changing this forces a new Virtual Network Gateway to be created.
        """
        return pulumi.get(self, "edge_zone")

    @_builtins.property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> pulumi.Output[_builtins.bool]:
        """
        If `true`, BGP (Border Gateway Protocol) will be enabled for this Virtual Network Gateway. Defaults to `false`.
        """
        return pulumi.get(self, "enable_bgp")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> pulumi.Output[_builtins.str]:
        """
        The Generation of the Virtual Network gateway. Possible values include `Generation1`, `Generation2` or `None`. Changing this forces a new resource to be created.

        > **Note:** The available values depend on the `type` and `sku` arguments - where `Generation2` is only value for a `sku` larger than `VpnGw2` or `VpnGw2AZ`.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> pulumi.Output[Sequence['outputs.VirtualNetworkGatewayIpConfiguration']]:
        """
        One or more (up to 3) `ip_configuration` blocks documented below. Changing this forces a new resource to be created. 
        An active-standby gateway requires exactly one `ip_configuration` block,
        an active-active gateway requires exactly two `ip_configuration` blocks whereas
        an active-active zone redundant gateway with P2S configuration requires exactly three `ip_configuration` blocks.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter(name="ipSecReplayProtectionEnabled")
    def ip_sec_replay_protection_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is IP Sec Replay Protection enabled? Defaults to `true`.
        """
        return pulumi.get(self, "ip_sec_replay_protection_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location/region where the Virtual Network Gateway is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Virtual Network Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyGroups")
    def policy_groups(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualNetworkGatewayPolicyGroup']]]:
        """
        One or more `policy_group` blocks as defined below.
        """
        return pulumi.get(self, "policy_groups")

    @_builtins.property
    @pulumi.getter(name="privateIpAddressEnabled")
    def private_ip_address_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should private IP be enabled on this gateway for connections? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_ip_address_enabled")

    @_builtins.property
    @pulumi.getter(name="remoteVnetTrafficEnabled")
    def remote_vnet_traffic_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is remote vnet traffic that is used to configure this gateway to accept traffic from other Azure Virtual Networks enabled? Defaults to `false`.
        """
        return pulumi.get(self, "remote_vnet_traffic_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Virtual Network Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        """
        Configuration of the size and capacity of the virtual network gateway. Valid options are `Basic`, `Standard`, `HighPerformance`, `UltraPerformance`, `ErGw1AZ`, `ErGw2AZ`, `ErGw3AZ`, `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw4`,`VpnGw5`, `VpnGw1AZ`, `VpnGw2AZ`, `VpnGw3AZ`,`VpnGw4AZ` and `VpnGw5AZ` and depend on the `type`, `vpn_type` and `generation` arguments. A `PolicyBased` gateway only supports the `Basic` SKU. Further, the `UltraPerformance` SKU is only supported by an `ExpressRoute` gateway.

        > **Note:** To build a UltraPerformance ExpressRoute Virtual Network gateway, the associated Public IP needs to be SKU "Basic" not "Standard"

        > **Note:** Not all SKUs (e.g. `ErGw1AZ`) are available in all regions. If you see `StatusCode=400 -- Original Error: Code="InvalidGatewaySkuSpecifiedForGatewayDeploymentType"` please try another region.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Virtual Network Gateway. Valid options are `Vpn` or `ExpressRoute`. Changing the type forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="virtualWanTrafficEnabled")
    def virtual_wan_traffic_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is remote vnet traffic that is used to configure this gateway to accept traffic from remote Virtual WAN networks enabled? Defaults to `false`.
        """
        return pulumi.get(self, "virtual_wan_traffic_enabled")

    @_builtins.property
    @pulumi.getter(name="vpnClientConfiguration")
    def vpn_client_configuration(self) -> pulumi.Output[Optional['outputs.VirtualNetworkGatewayVpnClientConfiguration']]:
        """
        A `vpn_client_configuration` block which is documented below. In this block the Virtual Network Gateway can be configured to accept IPSec point-to-site connections.
        """
        return pulumi.get(self, "vpn_client_configuration")

    @_builtins.property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The routing type of the Virtual Network Gateway. Valid options are `RouteBased` or `PolicyBased`. Defaults to `RouteBased`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vpn_type")

