# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualNetworkGatewayNatRuleArgs', 'VirtualNetworkGatewayNatRule']

@pulumi.input_type
class VirtualNetworkGatewayNatRuleArgs:
    def __init__(__self__, *,
                 external_mappings: pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleExternalMappingArgs']]],
                 internal_mappings: pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleInternalMappingArgs']]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 virtual_network_gateway_id: pulumi.Input[_builtins.str],
                 ip_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VirtualNetworkGatewayNatRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleExternalMappingArgs']]] external_mappings: One or more `external_mapping` blocks as documented below.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleInternalMappingArgs']]] internal_mappings: One or more `internal_mapping` blocks as documented below.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group in which this Virtual Network Gateway Nat Rule should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_gateway_id: The ID of the Virtual Network Gateway that this Virtual Network Gateway Nat Rule belongs to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ip_configuration_id: The ID of the IP Configuration this Virtual Network Gateway Nat Rule applies to.
        :param pulumi.Input[_builtins.str] mode: The source Nat direction of the Virtual Network Gateway Nat. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Network Gateway Nat Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Network Gateway Nat Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "external_mappings", external_mappings)
        pulumi.set(__self__, "internal_mappings", internal_mappings)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "virtual_network_gateway_id", virtual_network_gateway_id)
        if ip_configuration_id is not None:
            pulumi.set(__self__, "ip_configuration_id", ip_configuration_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="externalMappings")
    def external_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleExternalMappingArgs']]]:
        """
        One or more `external_mapping` blocks as documented below.
        """
        return pulumi.get(self, "external_mappings")

    @external_mappings.setter
    def external_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleExternalMappingArgs']]]):
        pulumi.set(self, "external_mappings", value)

    @_builtins.property
    @pulumi.getter(name="internalMappings")
    def internal_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleInternalMappingArgs']]]:
        """
        One or more `internal_mapping` blocks as documented below.
        """
        return pulumi.get(self, "internal_mappings")

    @internal_mappings.setter
    def internal_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleInternalMappingArgs']]]):
        pulumi.set(self, "internal_mappings", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the Resource Group in which this Virtual Network Gateway Nat Rule should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkGatewayId")
    def virtual_network_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Virtual Network Gateway that this Virtual Network Gateway Nat Rule belongs to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_gateway_id")

    @virtual_network_gateway_id.setter
    def virtual_network_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_network_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigurationId")
    def ip_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP Configuration this Virtual Network Gateway Nat Rule applies to.
        """
        return pulumi.get(self, "ip_configuration_id")

    @ip_configuration_id.setter
    def ip_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_configuration_id", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source Nat direction of the Virtual Network Gateway Nat. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Virtual Network Gateway Nat Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Virtual Network Gateway Nat Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _VirtualNetworkGatewayNatRuleState:
    def __init__(__self__, *,
                 external_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleExternalMappingArgs']]]] = None,
                 internal_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleInternalMappingArgs']]]] = None,
                 ip_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualNetworkGatewayNatRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleExternalMappingArgs']]] external_mappings: One or more `external_mapping` blocks as documented below.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleInternalMappingArgs']]] internal_mappings: One or more `internal_mapping` blocks as documented below.
        :param pulumi.Input[_builtins.str] ip_configuration_id: The ID of the IP Configuration this Virtual Network Gateway Nat Rule applies to.
        :param pulumi.Input[_builtins.str] mode: The source Nat direction of the Virtual Network Gateway Nat. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Network Gateway Nat Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group in which this Virtual Network Gateway Nat Rule should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Network Gateway Nat Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_gateway_id: The ID of the Virtual Network Gateway that this Virtual Network Gateway Nat Rule belongs to. Changing this forces a new resource to be created.
        """
        if external_mappings is not None:
            pulumi.set(__self__, "external_mappings", external_mappings)
        if internal_mappings is not None:
            pulumi.set(__self__, "internal_mappings", internal_mappings)
        if ip_configuration_id is not None:
            pulumi.set(__self__, "ip_configuration_id", ip_configuration_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if virtual_network_gateway_id is not None:
            pulumi.set(__self__, "virtual_network_gateway_id", virtual_network_gateway_id)

    @_builtins.property
    @pulumi.getter(name="externalMappings")
    def external_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleExternalMappingArgs']]]]:
        """
        One or more `external_mapping` blocks as documented below.
        """
        return pulumi.get(self, "external_mappings")

    @external_mappings.setter
    def external_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleExternalMappingArgs']]]]):
        pulumi.set(self, "external_mappings", value)

    @_builtins.property
    @pulumi.getter(name="internalMappings")
    def internal_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleInternalMappingArgs']]]]:
        """
        One or more `internal_mapping` blocks as documented below.
        """
        return pulumi.get(self, "internal_mappings")

    @internal_mappings.setter
    def internal_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkGatewayNatRuleInternalMappingArgs']]]]):
        pulumi.set(self, "internal_mappings", value)

    @_builtins.property
    @pulumi.getter(name="ipConfigurationId")
    def ip_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP Configuration this Virtual Network Gateway Nat Rule applies to.
        """
        return pulumi.get(self, "ip_configuration_id")

    @ip_configuration_id.setter
    def ip_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_configuration_id", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source Nat direction of the Virtual Network Gateway Nat. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Virtual Network Gateway Nat Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the Resource Group in which this Virtual Network Gateway Nat Rule should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Virtual Network Gateway Nat Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkGatewayId")
    def virtual_network_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Network Gateway that this Virtual Network Gateway Nat Rule belongs to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_gateway_id")

    @virtual_network_gateway_id.setter
    def virtual_network_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_gateway_id", value)


@pulumi.type_token("azure:network/virtualNetworkGatewayNatRule:VirtualNetworkGatewayNatRule")
class VirtualNetworkGatewayNatRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayNatRuleExternalMappingArgs', 'VirtualNetworkGatewayNatRuleExternalMappingArgsDict']]]]] = None,
                 internal_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayNatRuleInternalMappingArgs', 'VirtualNetworkGatewayNatRuleInternalMappingArgsDict']]]]] = None,
                 ip_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Virtual Network Gateway Nat Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="GatewaySubnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            allocation_method="Dynamic")
        example_virtual_network_gateway = azure.network.VirtualNetworkGateway("example",
            name="example-vnetgw",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            type="Vpn",
            vpn_type="RouteBased",
            sku="Basic",
            ip_configurations=[{
                "public_ip_address_id": example_public_ip.id,
                "private_ip_address_allocation": "Dynamic",
                "subnet_id": example_subnet.id,
            }])
        example = azure.network.get_virtual_network_gateway_output(name=example_virtual_network_gateway.name,
            resource_group_name=example_virtual_network_gateway.resource_group_name)
        example_virtual_network_gateway_nat_rule = azure.network.VirtualNetworkGatewayNatRule("example",
            name="example-vnetgwnatrule",
            resource_group_name=example_resource_group.name,
            virtual_network_gateway_id=example.id,
            mode="EgressSnat",
            type="Dynamic",
            ip_configuration_id=example.ip_configurations[0].id,
            external_mappings=[{
                "address_space": "10.2.0.0/26",
                "port_range": "200",
            }],
            internal_mappings=[{
                "address_space": "10.4.0.0/26",
                "port_range": "400",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Network Gateway Nat Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetworkGatewayNatRule:VirtualNetworkGatewayNatRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.Network/virtualNetworkGateways/gw1/natRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayNatRuleExternalMappingArgs', 'VirtualNetworkGatewayNatRuleExternalMappingArgsDict']]]] external_mappings: One or more `external_mapping` blocks as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayNatRuleInternalMappingArgs', 'VirtualNetworkGatewayNatRuleInternalMappingArgsDict']]]] internal_mappings: One or more `internal_mapping` blocks as documented below.
        :param pulumi.Input[_builtins.str] ip_configuration_id: The ID of the IP Configuration this Virtual Network Gateway Nat Rule applies to.
        :param pulumi.Input[_builtins.str] mode: The source Nat direction of the Virtual Network Gateway Nat. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Network Gateway Nat Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group in which this Virtual Network Gateway Nat Rule should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Network Gateway Nat Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_gateway_id: The ID of the Virtual Network Gateway that this Virtual Network Gateway Nat Rule belongs to. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualNetworkGatewayNatRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Virtual Network Gateway Nat Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="GatewaySubnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            allocation_method="Dynamic")
        example_virtual_network_gateway = azure.network.VirtualNetworkGateway("example",
            name="example-vnetgw",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            type="Vpn",
            vpn_type="RouteBased",
            sku="Basic",
            ip_configurations=[{
                "public_ip_address_id": example_public_ip.id,
                "private_ip_address_allocation": "Dynamic",
                "subnet_id": example_subnet.id,
            }])
        example = azure.network.get_virtual_network_gateway_output(name=example_virtual_network_gateway.name,
            resource_group_name=example_virtual_network_gateway.resource_group_name)
        example_virtual_network_gateway_nat_rule = azure.network.VirtualNetworkGatewayNatRule("example",
            name="example-vnetgwnatrule",
            resource_group_name=example_resource_group.name,
            virtual_network_gateway_id=example.id,
            mode="EgressSnat",
            type="Dynamic",
            ip_configuration_id=example.ip_configurations[0].id,
            external_mappings=[{
                "address_space": "10.2.0.0/26",
                "port_range": "200",
            }],
            internal_mappings=[{
                "address_space": "10.4.0.0/26",
                "port_range": "400",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2024-05-01

        ## Import

        Virtual Network Gateway Nat Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetworkGatewayNatRule:VirtualNetworkGatewayNatRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.Network/virtualNetworkGateways/gw1/natRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualNetworkGatewayNatRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualNetworkGatewayNatRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayNatRuleExternalMappingArgs', 'VirtualNetworkGatewayNatRuleExternalMappingArgsDict']]]]] = None,
                 internal_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayNatRuleInternalMappingArgs', 'VirtualNetworkGatewayNatRuleInternalMappingArgsDict']]]]] = None,
                 ip_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualNetworkGatewayNatRuleArgs.__new__(VirtualNetworkGatewayNatRuleArgs)

            if external_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'external_mappings'")
            __props__.__dict__["external_mappings"] = external_mappings
            if internal_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'internal_mappings'")
            __props__.__dict__["internal_mappings"] = internal_mappings
            __props__.__dict__["ip_configuration_id"] = ip_configuration_id
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["type"] = type
            if virtual_network_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_network_gateway_id'")
            __props__.__dict__["virtual_network_gateway_id"] = virtual_network_gateway_id
        super(VirtualNetworkGatewayNatRule, __self__).__init__(
            'azure:network/virtualNetworkGatewayNatRule:VirtualNetworkGatewayNatRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            external_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayNatRuleExternalMappingArgs', 'VirtualNetworkGatewayNatRuleExternalMappingArgsDict']]]]] = None,
            internal_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayNatRuleInternalMappingArgs', 'VirtualNetworkGatewayNatRuleInternalMappingArgsDict']]]]] = None,
            ip_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VirtualNetworkGatewayNatRule':
        """
        Get an existing VirtualNetworkGatewayNatRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayNatRuleExternalMappingArgs', 'VirtualNetworkGatewayNatRuleExternalMappingArgsDict']]]] external_mappings: One or more `external_mapping` blocks as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkGatewayNatRuleInternalMappingArgs', 'VirtualNetworkGatewayNatRuleInternalMappingArgsDict']]]] internal_mappings: One or more `internal_mapping` blocks as documented below.
        :param pulumi.Input[_builtins.str] ip_configuration_id: The ID of the IP Configuration this Virtual Network Gateway Nat Rule applies to.
        :param pulumi.Input[_builtins.str] mode: The source Nat direction of the Virtual Network Gateway Nat. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Virtual Network Gateway Nat Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group in which this Virtual Network Gateway Nat Rule should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Network Gateway Nat Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_gateway_id: The ID of the Virtual Network Gateway that this Virtual Network Gateway Nat Rule belongs to. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualNetworkGatewayNatRuleState.__new__(_VirtualNetworkGatewayNatRuleState)

        __props__.__dict__["external_mappings"] = external_mappings
        __props__.__dict__["internal_mappings"] = internal_mappings
        __props__.__dict__["ip_configuration_id"] = ip_configuration_id
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["type"] = type
        __props__.__dict__["virtual_network_gateway_id"] = virtual_network_gateway_id
        return VirtualNetworkGatewayNatRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="externalMappings")
    def external_mappings(self) -> pulumi.Output[Sequence['outputs.VirtualNetworkGatewayNatRuleExternalMapping']]:
        """
        One or more `external_mapping` blocks as documented below.
        """
        return pulumi.get(self, "external_mappings")

    @_builtins.property
    @pulumi.getter(name="internalMappings")
    def internal_mappings(self) -> pulumi.Output[Sequence['outputs.VirtualNetworkGatewayNatRuleInternalMapping']]:
        """
        One or more `internal_mapping` blocks as documented below.
        """
        return pulumi.get(self, "internal_mappings")

    @_builtins.property
    @pulumi.getter(name="ipConfigurationId")
    def ip_configuration_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the IP Configuration this Virtual Network Gateway Nat Rule applies to.
        """
        return pulumi.get(self, "ip_configuration_id")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source Nat direction of the Virtual Network Gateway Nat. Possible values are `EgressSnat` and `IngressSnat`. Defaults to `EgressSnat`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Virtual Network Gateway Nat Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the Resource Group in which this Virtual Network Gateway Nat Rule should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the Virtual Network Gateway Nat Rule. Possible values are `Dynamic` and `Static`. Defaults to `Static`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkGatewayId")
    def virtual_network_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Virtual Network Gateway that this Virtual Network Gateway Nat Rule belongs to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_gateway_id")

