# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ContactArgs', 'Contact']

@pulumi.input_type
class ContactArgs:
    def __init__(__self__, *,
                 contact_profile_id: pulumi.Input[_builtins.str],
                 ground_station_name: pulumi.Input[_builtins.str],
                 reservation_end_time: pulumi.Input[_builtins.str],
                 reservation_start_time: pulumi.Input[_builtins.str],
                 spacecraft_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Contact resource.
        :param pulumi.Input[_builtins.str] contact_profile_id: ID of the orbital contact profile. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ground_station_name: Name of the Azure ground station. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] reservation_end_time: Reservation end time of the Contact. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] reservation_start_time: Reservation start time of the Contact. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spacecraft_id: The ID of the spacecraft which the contact will be made to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Contact. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "contact_profile_id", contact_profile_id)
        pulumi.set(__self__, "ground_station_name", ground_station_name)
        pulumi.set(__self__, "reservation_end_time", reservation_end_time)
        pulumi.set(__self__, "reservation_start_time", reservation_start_time)
        pulumi.set(__self__, "spacecraft_id", spacecraft_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="contactProfileId")
    def contact_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the orbital contact profile. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "contact_profile_id")

    @contact_profile_id.setter
    def contact_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contact_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="groundStationName")
    def ground_station_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Azure ground station. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ground_station_name")

    @ground_station_name.setter
    def ground_station_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ground_station_name", value)

    @_builtins.property
    @pulumi.getter(name="reservationEndTime")
    def reservation_end_time(self) -> pulumi.Input[_builtins.str]:
        """
        Reservation end time of the Contact. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "reservation_end_time")

    @reservation_end_time.setter
    def reservation_end_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "reservation_end_time", value)

    @_builtins.property
    @pulumi.getter(name="reservationStartTime")
    def reservation_start_time(self) -> pulumi.Input[_builtins.str]:
        """
        Reservation start time of the Contact. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "reservation_start_time")

    @reservation_start_time.setter
    def reservation_start_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "reservation_start_time", value)

    @_builtins.property
    @pulumi.getter(name="spacecraftId")
    def spacecraft_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the spacecraft which the contact will be made to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spacecraft_id")

    @spacecraft_id.setter
    def spacecraft_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spacecraft_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Contact. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ContactState:
    def __init__(__self__, *,
                 contact_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ground_station_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 spacecraft_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Contact resources.
        :param pulumi.Input[_builtins.str] contact_profile_id: ID of the orbital contact profile. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ground_station_name: Name of the Azure ground station. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Contact. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] reservation_end_time: Reservation end time of the Contact. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] reservation_start_time: Reservation start time of the Contact. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spacecraft_id: The ID of the spacecraft which the contact will be made to. Changing this forces a new resource to be created.
        """
        if contact_profile_id is not None:
            pulumi.set(__self__, "contact_profile_id", contact_profile_id)
        if ground_station_name is not None:
            pulumi.set(__self__, "ground_station_name", ground_station_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reservation_end_time is not None:
            pulumi.set(__self__, "reservation_end_time", reservation_end_time)
        if reservation_start_time is not None:
            pulumi.set(__self__, "reservation_start_time", reservation_start_time)
        if spacecraft_id is not None:
            pulumi.set(__self__, "spacecraft_id", spacecraft_id)

    @_builtins.property
    @pulumi.getter(name="contactProfileId")
    def contact_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the orbital contact profile. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "contact_profile_id")

    @contact_profile_id.setter
    def contact_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contact_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="groundStationName")
    def ground_station_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Azure ground station. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ground_station_name")

    @ground_station_name.setter
    def ground_station_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ground_station_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Contact. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="reservationEndTime")
    def reservation_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reservation end time of the Contact. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "reservation_end_time")

    @reservation_end_time.setter
    def reservation_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reservation_end_time", value)

    @_builtins.property
    @pulumi.getter(name="reservationStartTime")
    def reservation_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reservation start time of the Contact. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "reservation_start_time")

    @reservation_start_time.setter
    def reservation_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reservation_start_time", value)

    @_builtins.property
    @pulumi.getter(name="spacecraftId")
    def spacecraft_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the spacecraft which the contact will be made to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spacecraft_id")

    @spacecraft_id.setter
    def spacecraft_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spacecraft_id", value)


@pulumi.type_token("azure:orbital/contact:Contact")
class Contact(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ground_station_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 spacecraft_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an orbital contact.

        > **Note:** The `orbital.Contact` resource has been deprecated and will be removed in v5.0 of the AzureRM Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_spacecraft = azure.orbital.Spacecraft("example",
            name="example-spacecraft",
            resource_group_name=example.name,
            location="westeurope",
            norad_id="12345",
            links=[{
                "bandwidth_mhz": 100,
                "center_frequency_mhz": 101,
                "direction": "Uplink",
                "polarization": "LHCP",
                "name": "examplename",
            }],
            two_line_elements=[
                "1 23455U 94089A   97320.90946019  .00000140  00000-0  10191-3 0  2621",
                "2 23455  99.0090 272.6745 0008546 223.1686 136.8816 14.11711747148495",
            ],
            title_line="AQUA",
            tags={
                "aks-managed-cluster-name": "9a57225d-a405-4d40-aa46-f13d2342abef",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "orbitalgateway",
                "service_delegation": {
                    "name": "Microsoft.Orbital/orbitalGateways",
                    "actions": [
                        "Microsoft.Network/publicIPAddresses/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/read",
                        "Microsoft.Network/publicIPAddresses/read",
                    ],
                },
            }])
        example_contact_profile = azure.orbital.ContactProfile("example",
            name="example-contactprofile",
            resource_group_name=example.name,
            location=example.location,
            minimum_variable_contact_duration="PT1M",
            auto_tracking="disabled",
            links=[{
                "channels": [{
                    "name": "channelname",
                    "bandwidth_mhz": 100,
                    "center_frequency_mhz": 101,
                    "end_points": [{
                        "end_point_name": "AQUA_command",
                        "ip_address": "10.0.1.0",
                        "port": "49153",
                        "protocol": "TCP",
                    }],
                }],
                "direction": "Uplink",
                "name": "RHCP_UL",
                "polarization": "RHCP",
            }],
            network_configuration_subnet_id=example_subnet.id)
        example_contact = azure.orbital.Contact("example",
            name="example-contact",
            spacecraft_id=example_spacecraft.id,
            reservation_start_time="2020-07-16T20:35:00.00Z",
            reservation_end_time="2020-07-16T20:55:00.00Z",
            ground_station_name="WESTUS2_0",
            contact_profile_id=example_contact_profile.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Orbital`: 2022-11-01

        ## Import

        Spacecraft can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:orbital/contact:Contact example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Orbital/spacecrafts/spacecraft1/contacts/contact1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contact_profile_id: ID of the orbital contact profile. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ground_station_name: Name of the Azure ground station. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Contact. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] reservation_end_time: Reservation end time of the Contact. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] reservation_start_time: Reservation start time of the Contact. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spacecraft_id: The ID of the spacecraft which the contact will be made to. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContactArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an orbital contact.

        > **Note:** The `orbital.Contact` resource has been deprecated and will be removed in v5.0 of the AzureRM Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_spacecraft = azure.orbital.Spacecraft("example",
            name="example-spacecraft",
            resource_group_name=example.name,
            location="westeurope",
            norad_id="12345",
            links=[{
                "bandwidth_mhz": 100,
                "center_frequency_mhz": 101,
                "direction": "Uplink",
                "polarization": "LHCP",
                "name": "examplename",
            }],
            two_line_elements=[
                "1 23455U 94089A   97320.90946019  .00000140  00000-0  10191-3 0  2621",
                "2 23455  99.0090 272.6745 0008546 223.1686 136.8816 14.11711747148495",
            ],
            title_line="AQUA",
            tags={
                "aks-managed-cluster-name": "9a57225d-a405-4d40-aa46-f13d2342abef",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "orbitalgateway",
                "service_delegation": {
                    "name": "Microsoft.Orbital/orbitalGateways",
                    "actions": [
                        "Microsoft.Network/publicIPAddresses/join/action",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                        "Microsoft.Network/virtualNetworks/read",
                        "Microsoft.Network/publicIPAddresses/read",
                    ],
                },
            }])
        example_contact_profile = azure.orbital.ContactProfile("example",
            name="example-contactprofile",
            resource_group_name=example.name,
            location=example.location,
            minimum_variable_contact_duration="PT1M",
            auto_tracking="disabled",
            links=[{
                "channels": [{
                    "name": "channelname",
                    "bandwidth_mhz": 100,
                    "center_frequency_mhz": 101,
                    "end_points": [{
                        "end_point_name": "AQUA_command",
                        "ip_address": "10.0.1.0",
                        "port": "49153",
                        "protocol": "TCP",
                    }],
                }],
                "direction": "Uplink",
                "name": "RHCP_UL",
                "polarization": "RHCP",
            }],
            network_configuration_subnet_id=example_subnet.id)
        example_contact = azure.orbital.Contact("example",
            name="example-contact",
            spacecraft_id=example_spacecraft.id,
            reservation_start_time="2020-07-16T20:35:00.00Z",
            reservation_end_time="2020-07-16T20:55:00.00Z",
            ground_station_name="WESTUS2_0",
            contact_profile_id=example_contact_profile.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Orbital`: 2022-11-01

        ## Import

        Spacecraft can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:orbital/contact:Contact example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Orbital/spacecrafts/spacecraft1/contacts/contact1
        ```

        :param str resource_name: The name of the resource.
        :param ContactArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContactArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ground_station_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 spacecraft_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContactArgs.__new__(ContactArgs)

            if contact_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'contact_profile_id'")
            __props__.__dict__["contact_profile_id"] = contact_profile_id
            if ground_station_name is None and not opts.urn:
                raise TypeError("Missing required property 'ground_station_name'")
            __props__.__dict__["ground_station_name"] = ground_station_name
            __props__.__dict__["name"] = name
            if reservation_end_time is None and not opts.urn:
                raise TypeError("Missing required property 'reservation_end_time'")
            __props__.__dict__["reservation_end_time"] = reservation_end_time
            if reservation_start_time is None and not opts.urn:
                raise TypeError("Missing required property 'reservation_start_time'")
            __props__.__dict__["reservation_start_time"] = reservation_start_time
            if spacecraft_id is None and not opts.urn:
                raise TypeError("Missing required property 'spacecraft_id'")
            __props__.__dict__["spacecraft_id"] = spacecraft_id
        super(Contact, __self__).__init__(
            'azure:orbital/contact:Contact',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contact_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            ground_station_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            reservation_end_time: Optional[pulumi.Input[_builtins.str]] = None,
            reservation_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            spacecraft_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Contact':
        """
        Get an existing Contact resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contact_profile_id: ID of the orbital contact profile. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ground_station_name: Name of the Azure ground station. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Contact. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] reservation_end_time: Reservation end time of the Contact. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] reservation_start_time: Reservation start time of the Contact. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spacecraft_id: The ID of the spacecraft which the contact will be made to. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContactState.__new__(_ContactState)

        __props__.__dict__["contact_profile_id"] = contact_profile_id
        __props__.__dict__["ground_station_name"] = ground_station_name
        __props__.__dict__["name"] = name
        __props__.__dict__["reservation_end_time"] = reservation_end_time
        __props__.__dict__["reservation_start_time"] = reservation_start_time
        __props__.__dict__["spacecraft_id"] = spacecraft_id
        return Contact(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="contactProfileId")
    def contact_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the orbital contact profile. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "contact_profile_id")

    @_builtins.property
    @pulumi.getter(name="groundStationName")
    def ground_station_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Azure ground station. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ground_station_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Contact. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="reservationEndTime")
    def reservation_end_time(self) -> pulumi.Output[_builtins.str]:
        """
        Reservation end time of the Contact. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "reservation_end_time")

    @_builtins.property
    @pulumi.getter(name="reservationStartTime")
    def reservation_start_time(self) -> pulumi.Output[_builtins.str]:
        """
        Reservation start time of the Contact. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "reservation_start_time")

    @_builtins.property
    @pulumi.getter(name="spacecraftId")
    def spacecraft_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the spacecraft which the contact will be made to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spacecraft_id")

