# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpacecraftArgs', 'Spacecraft']

@pulumi.input_type
class SpacecraftArgs:
    def __init__(__self__, *,
                 links: pulumi.Input[Sequence[pulumi.Input['SpacecraftLinkArgs']]],
                 norad_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 title_line: pulumi.Input[_builtins.str],
                 two_line_elements: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Spacecraft resource.
        :param pulumi.Input[Sequence[pulumi.Input['SpacecraftLinkArgs']]] links: A `links` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] norad_id: NORAD ID of the Spacecraft.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Spacecraft exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] title_line: Title of the two line elements (TLE).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] two_line_elements: A list of the two line elements (TLE), the first string being the first of the TLE, the second string being the second line of the TLE. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the Spacecraft exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Spacecraft. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "links", links)
        pulumi.set(__self__, "norad_id", norad_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "title_line", title_line)
        pulumi.set(__self__, "two_line_elements", two_line_elements)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Input[Sequence[pulumi.Input['SpacecraftLinkArgs']]]:
        """
        A `links` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: pulumi.Input[Sequence[pulumi.Input['SpacecraftLinkArgs']]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter(name="noradId")
    def norad_id(self) -> pulumi.Input[_builtins.str]:
        """
        NORAD ID of the Spacecraft.
        """
        return pulumi.get(self, "norad_id")

    @norad_id.setter
    def norad_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "norad_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Spacecraft exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="titleLine")
    def title_line(self) -> pulumi.Input[_builtins.str]:
        """
        Title of the two line elements (TLE).
        """
        return pulumi.get(self, "title_line")

    @title_line.setter
    def title_line(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title_line", value)

    @_builtins.property
    @pulumi.getter(name="twoLineElements")
    def two_line_elements(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of the two line elements (TLE), the first string being the first of the TLE, the second string being the second line of the TLE. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "two_line_elements")

    @two_line_elements.setter
    def two_line_elements(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "two_line_elements", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Spacecraft exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Spacecraft. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SpacecraftState:
    def __init__(__self__, *,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['SpacecraftLinkArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 norad_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 title_line: Optional[pulumi.Input[_builtins.str]] = None,
                 two_line_elements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Spacecraft resources.
        :param pulumi.Input[Sequence[pulumi.Input['SpacecraftLinkArgs']]] links: A `links` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the Spacecraft exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Spacecraft. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] norad_id: NORAD ID of the Spacecraft.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Spacecraft exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] title_line: Title of the two line elements (TLE).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] two_line_elements: A list of the two line elements (TLE), the first string being the first of the TLE, the second string being the second line of the TLE. Changing this forces a new resource to be created.
        """
        if links is not None:
            pulumi.set(__self__, "links", links)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if norad_id is not None:
            pulumi.set(__self__, "norad_id", norad_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if title_line is not None:
            pulumi.set(__self__, "title_line", title_line)
        if two_line_elements is not None:
            pulumi.set(__self__, "two_line_elements", two_line_elements)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpacecraftLinkArgs']]]]:
        """
        A `links` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpacecraftLinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Spacecraft exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Spacecraft. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="noradId")
    def norad_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        NORAD ID of the Spacecraft.
        """
        return pulumi.get(self, "norad_id")

    @norad_id.setter
    def norad_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "norad_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Spacecraft exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="titleLine")
    def title_line(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Title of the two line elements (TLE).
        """
        return pulumi.get(self, "title_line")

    @title_line.setter
    def title_line(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title_line", value)

    @_builtins.property
    @pulumi.getter(name="twoLineElements")
    def two_line_elements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the two line elements (TLE), the first string being the first of the TLE, the second string being the second line of the TLE. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "two_line_elements")

    @two_line_elements.setter
    def two_line_elements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "two_line_elements", value)


@pulumi.type_token("azure:orbital/spacecraft:Spacecraft")
class Spacecraft(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpacecraftLinkArgs', 'SpacecraftLinkArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 norad_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 title_line: Optional[pulumi.Input[_builtins.str]] = None,
                 two_line_elements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Spacecraft.

        > **Note:** The `orbital.Spacecraft` resource has been deprecated and will be removed in v5.0 of the AzureRM Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_spacecraft = azure.orbital.Spacecraft("example",
            name="example-spacecraft",
            resource_group_name=example.name,
            location="westeurope",
            norad_id="12345",
            links=[{
                "bandwidth_mhz": 30,
                "center_frequency_mhz": 2050,
                "direction": "Uplink",
                "polarization": "LHCP",
                "name": "examplename",
            }],
            two_line_elements=[
                "1 23455U 94089A   97320.90946019  .00000140  00000-0  10191-3 0  2621",
                "2 23455  99.0090 272.6745 0008546 223.1686 136.8816 14.11711747148495",
            ],
            title_line="AQUA",
            tags={
                "aks-managed-cluster-name": "9a57225d-a405-4d40-aa46-f13d2342abef",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Orbital`: 2022-11-01

        ## Import

        Spacecraft can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:orbital/spacecraft:Spacecraft example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Orbital/spacecrafts/spacecraft1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpacecraftLinkArgs', 'SpacecraftLinkArgsDict']]]] links: A `links` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the Spacecraft exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Spacecraft. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] norad_id: NORAD ID of the Spacecraft.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Spacecraft exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] title_line: Title of the two line elements (TLE).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] two_line_elements: A list of the two line elements (TLE), the first string being the first of the TLE, the second string being the second line of the TLE. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpacecraftArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spacecraft.

        > **Note:** The `orbital.Spacecraft` resource has been deprecated and will be removed in v5.0 of the AzureRM Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_spacecraft = azure.orbital.Spacecraft("example",
            name="example-spacecraft",
            resource_group_name=example.name,
            location="westeurope",
            norad_id="12345",
            links=[{
                "bandwidth_mhz": 30,
                "center_frequency_mhz": 2050,
                "direction": "Uplink",
                "polarization": "LHCP",
                "name": "examplename",
            }],
            two_line_elements=[
                "1 23455U 94089A   97320.90946019  .00000140  00000-0  10191-3 0  2621",
                "2 23455  99.0090 272.6745 0008546 223.1686 136.8816 14.11711747148495",
            ],
            title_line="AQUA",
            tags={
                "aks-managed-cluster-name": "9a57225d-a405-4d40-aa46-f13d2342abef",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Orbital`: 2022-11-01

        ## Import

        Spacecraft can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:orbital/spacecraft:Spacecraft example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Orbital/spacecrafts/spacecraft1
        ```

        :param str resource_name: The name of the resource.
        :param SpacecraftArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpacecraftArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpacecraftLinkArgs', 'SpacecraftLinkArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 norad_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 title_line: Optional[pulumi.Input[_builtins.str]] = None,
                 two_line_elements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpacecraftArgs.__new__(SpacecraftArgs)

            if links is None and not opts.urn:
                raise TypeError("Missing required property 'links'")
            __props__.__dict__["links"] = links
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if norad_id is None and not opts.urn:
                raise TypeError("Missing required property 'norad_id'")
            __props__.__dict__["norad_id"] = norad_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            if title_line is None and not opts.urn:
                raise TypeError("Missing required property 'title_line'")
            __props__.__dict__["title_line"] = title_line
            if two_line_elements is None and not opts.urn:
                raise TypeError("Missing required property 'two_line_elements'")
            __props__.__dict__["two_line_elements"] = two_line_elements
        super(Spacecraft, __self__).__init__(
            'azure:orbital/spacecraft:Spacecraft',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpacecraftLinkArgs', 'SpacecraftLinkArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            norad_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            title_line: Optional[pulumi.Input[_builtins.str]] = None,
            two_line_elements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Spacecraft':
        """
        Get an existing Spacecraft resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpacecraftLinkArgs', 'SpacecraftLinkArgsDict']]]] links: A `links` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The location where the Spacecraft exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Spacecraft. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] norad_id: NORAD ID of the Spacecraft.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Spacecraft exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] title_line: Title of the two line elements (TLE).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] two_line_elements: A list of the two line elements (TLE), the first string being the first of the TLE, the second string being the second line of the TLE. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpacecraftState.__new__(_SpacecraftState)

        __props__.__dict__["links"] = links
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["norad_id"] = norad_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["title_line"] = title_line
        __props__.__dict__["two_line_elements"] = two_line_elements
        return Spacecraft(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.SpacecraftLink']]:
        """
        A `links` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location where the Spacecraft exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Spacecraft. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="noradId")
    def norad_id(self) -> pulumi.Output[_builtins.str]:
        """
        NORAD ID of the Spacecraft.
        """
        return pulumi.get(self, "norad_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Spacecraft exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="titleLine")
    def title_line(self) -> pulumi.Output[_builtins.str]:
        """
        Title of the two line elements (TLE).
        """
        return pulumi.get(self, "title_line")

    @_builtins.property
    @pulumi.getter(name="twoLineElements")
    def two_line_elements(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of the two line elements (TLE), the first string being the first of the TLE, the second string being the second line of the TLE. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "two_line_elements")

