# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LocalRulestackOutboundTrustCertificateAssociationArgs', 'LocalRulestackOutboundTrustCertificateAssociation']

@pulumi.input_type
class LocalRulestackOutboundTrustCertificateAssociationArgs:
    def __init__(__self__, *,
                 certificate_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a LocalRulestackOutboundTrustCertificateAssociation resource.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of the Certificate to use as the Outbound Trust Certificate. Changing this forces a new Palo Alto Networks Rulestack Outbound Trust Certificate Association to be created.
        """
        pulumi.set(__self__, "certificate_id", certificate_id)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Certificate to use as the Outbound Trust Certificate. Changing this forces a new Palo Alto Networks Rulestack Outbound Trust Certificate Association to be created.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_id", value)


@pulumi.input_type
class _LocalRulestackOutboundTrustCertificateAssociationState:
    def __init__(__self__, *,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LocalRulestackOutboundTrustCertificateAssociation resources.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of the Certificate to use as the Outbound Trust Certificate. Changing this forces a new Palo Alto Networks Rulestack Outbound Trust Certificate Association to be created.
        """
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Certificate to use as the Outbound Trust Certificate. Changing this forces a new Palo Alto Networks Rulestack Outbound Trust Certificate Association to be created.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)


@pulumi.type_token("azure:paloalto/localRulestackOutboundTrustCertificateAssociation:LocalRulestackOutboundTrustCertificateAssociation")
class LocalRulestackOutboundTrustCertificateAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Palo Alto Networks Rulestack Outbound Trust Certificate Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_local_rulestack = azure.paloalto.LocalRulestack("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_local_rulestack_certificate = azure.paloalto.LocalRulestackCertificate("example",
            name="example",
            rulestack_id=example_local_rulestack.id,
            self_signed=True)
        example_local_rulestack_outbound_trust_certificate_association = azure.paloalto.LocalRulestackOutboundTrustCertificateAssociation("example", certificate_id=example_local_rulestack_certificate.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `PaloAltoNetworks.Cloudngfw`: 2022-08-29

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of the Certificate to use as the Outbound Trust Certificate. Changing this forces a new Palo Alto Networks Rulestack Outbound Trust Certificate Association to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocalRulestackOutboundTrustCertificateAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Palo Alto Networks Rulestack Outbound Trust Certificate Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_local_rulestack = azure.paloalto.LocalRulestack("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_local_rulestack_certificate = azure.paloalto.LocalRulestackCertificate("example",
            name="example",
            rulestack_id=example_local_rulestack.id,
            self_signed=True)
        example_local_rulestack_outbound_trust_certificate_association = azure.paloalto.LocalRulestackOutboundTrustCertificateAssociation("example", certificate_id=example_local_rulestack_certificate.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `PaloAltoNetworks.Cloudngfw`: 2022-08-29

        :param str resource_name: The name of the resource.
        :param LocalRulestackOutboundTrustCertificateAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocalRulestackOutboundTrustCertificateAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocalRulestackOutboundTrustCertificateAssociationArgs.__new__(LocalRulestackOutboundTrustCertificateAssociationArgs)

            if certificate_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_id'")
            __props__.__dict__["certificate_id"] = certificate_id
        super(LocalRulestackOutboundTrustCertificateAssociation, __self__).__init__(
            'azure:paloalto/localRulestackOutboundTrustCertificateAssociation:LocalRulestackOutboundTrustCertificateAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LocalRulestackOutboundTrustCertificateAssociation':
        """
        Get an existing LocalRulestackOutboundTrustCertificateAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of the Certificate to use as the Outbound Trust Certificate. Changing this forces a new Palo Alto Networks Rulestack Outbound Trust Certificate Association to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LocalRulestackOutboundTrustCertificateAssociationState.__new__(_LocalRulestackOutboundTrustCertificateAssociationState)

        __props__.__dict__["certificate_id"] = certificate_id
        return LocalRulestackOutboundTrustCertificateAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Certificate to use as the Outbound Trust Certificate. Changing this forces a new Palo Alto Networks Rulestack Outbound Trust Certificate Association to be created.
        """
        return pulumi.get(self, "certificate_id")

