# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NextGenerationFirewallVirtualNetworkLocalRulestackArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestack']

@pulumi.input_type
class NextGenerationFirewallVirtualNetworkLocalRulestackArgs:
    def __init__(__self__, *,
                 network_profile: pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 rulestack_id: pulumi.Input[_builtins.str],
                 destination_nats: Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs']]]] = None,
                 dns_settings: Optional[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs']] = None,
                 marketplace_offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NextGenerationFirewallVirtualNetworkLocalRulestack resource.
        :param pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs'] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Palo Alto Next Generation Firewall Virtual Network Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack which will be used to configure this Firewall Resource.
        :param pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs']]] destination_nats: One or more `destination_nat` blocks as defined below.
        :param pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs'] dns_settings: A `dns_settings` block as defined below.
        :param pulumi.Input[_builtins.str] marketplace_offer_id: The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Next Generation Firewall Virtual Network Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        :param pulumi.Input[_builtins.str] plan_id: The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.
               
               > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall Virtual Network Local Rulestack.
        """
        pulumi.set(__self__, "network_profile", network_profile)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "rulestack_id", rulestack_id)
        if destination_nats is not None:
            pulumi.set(__self__, "destination_nats", destination_nats)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if marketplace_offer_id is not None:
            pulumi.set(__self__, "marketplace_offer_id", marketplace_offer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs']:
        """
        A `network_profile` block as defined below.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs']):
        pulumi.set(self, "network_profile", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Palo Alto Next Generation Firewall Virtual Network Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Local Rulestack which will be used to configure this Firewall Resource.
        """
        return pulumi.get(self, "rulestack_id")

    @rulestack_id.setter
    def rulestack_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rulestack_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationNats")
    def destination_nats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs']]]]:
        """
        One or more `destination_nat` blocks as defined below.
        """
        return pulumi.get(self, "destination_nats")

    @destination_nats.setter
    def destination_nats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs']]]]):
        pulumi.set(self, "destination_nats", value)

    @_builtins.property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs']]:
        """
        A `dns_settings` block as defined below.
        """
        return pulumi.get(self, "dns_settings")

    @dns_settings.setter
    def dns_settings(self, value: Optional[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs']]):
        pulumi.set(self, "dns_settings", value)

    @_builtins.property
    @pulumi.getter(name="marketplaceOfferId")
    def marketplace_offer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "marketplace_offer_id")

    @marketplace_offer_id.setter
    def marketplace_offer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "marketplace_offer_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Palo Alto Next Generation Firewall Virtual Network Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.

        > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall Virtual Network Local Rulestack.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NextGenerationFirewallVirtualNetworkLocalRulestackState:
    def __init__(__self__, *,
                 destination_nats: Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs']]]] = None,
                 dns_settings: Optional[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs']] = None,
                 marketplace_offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs']] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NextGenerationFirewallVirtualNetworkLocalRulestack resources.
        :param pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs']]] destination_nats: One or more `destination_nat` blocks as defined below.
        :param pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs'] dns_settings: A `dns_settings` block as defined below.
        :param pulumi.Input[_builtins.str] marketplace_offer_id: The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Next Generation Firewall Virtual Network Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        :param pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs'] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[_builtins.str] plan_id: The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.
               
               > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Palo Alto Next Generation Firewall Virtual Network Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack which will be used to configure this Firewall Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall Virtual Network Local Rulestack.
        """
        if destination_nats is not None:
            pulumi.set(__self__, "destination_nats", destination_nats)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if marketplace_offer_id is not None:
            pulumi.set(__self__, "marketplace_offer_id", marketplace_offer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if rulestack_id is not None:
            pulumi.set(__self__, "rulestack_id", rulestack_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="destinationNats")
    def destination_nats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs']]]]:
        """
        One or more `destination_nat` blocks as defined below.
        """
        return pulumi.get(self, "destination_nats")

    @destination_nats.setter
    def destination_nats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs']]]]):
        pulumi.set(self, "destination_nats", value)

    @_builtins.property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs']]:
        """
        A `dns_settings` block as defined below.
        """
        return pulumi.get(self, "dns_settings")

    @dns_settings.setter
    def dns_settings(self, value: Optional[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs']]):
        pulumi.set(self, "dns_settings", value)

    @_builtins.property
    @pulumi.getter(name="marketplaceOfferId")
    def marketplace_offer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "marketplace_offer_id")

    @marketplace_offer_id.setter
    def marketplace_offer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "marketplace_offer_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Palo Alto Next Generation Firewall Virtual Network Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs']]:
        """
        A `network_profile` block as defined below.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.

        > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Palo Alto Next Generation Firewall Virtual Network Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Local Rulestack which will be used to configure this Firewall Resource.
        """
        return pulumi.get(self, "rulestack_id")

    @rulestack_id.setter
    def rulestack_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rulestack_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall Virtual Network Local Rulestack.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:paloalto/nextGenerationFirewallVirtualNetworkLocalRulestack:NextGenerationFirewallVirtualNetworkLocalRulestack")
class NextGenerationFirewallVirtualNetworkLocalRulestack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_nats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgsDict']]]]] = None,
                 dns_settings: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgsDict']]] = None,
                 marketplace_offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgsDict']]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Palo Alto Next Generation Firewall Deployed in a Virtual Network and configured via a Local Rulestack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="westeurope")
        example_public_ip = azure.network.PublicIp("example",
            name="example-public-ip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            sku="Standard")
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="example-nsg",
            location=test["location"],
            resource_group_name=test["name"])
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name,
            tags={
                "environment": "Production",
            })
        trust = azure.network.Subnet("trust",
            name="example-trust-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "trusted",
                "service_delegation": {
                    "name": "PaloAltoNetworks.Cloudngfw/firewalls",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        trust_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("trust",
            subnet_id=trust.id,
            network_security_group_id=example_network_security_group.id)
        untrust = azure.network.Subnet("untrust",
            name="example-untrust-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "untrusted",
                "service_delegation": {
                    "name": "PaloAltoNetworks.Cloudngfw/firewalls",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        untrust_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("untrust",
            subnet_id=untrust.id,
            network_security_group_id=example_network_security_group.id)
        example_local_rulestack = azure.paloalto.LocalRulestack("example",
            name="example-rulestack",
            resource_group_name=example.name,
            location=example.locatio)
        example_local_rulestack_rule = azure.paloalto.LocalRulestackRule("example",
            name="example-rulestack-rule",
            rulestack_id=example_local_rulestack.id,
            priority=1001,
            action="Allow",
            applications=["any"],
            destination={
                "cidrs": ["any"],
            },
            source={
                "cidrs": ["any"],
            })
        example_next_generation_firewall_virtual_network_local_rulestack = azure.paloalto.NextGenerationFirewallVirtualNetworkLocalRulestack("example",
            name="example-ngfwvn",
            resource_group_name=example.name,
            rulestack_id=example_local_rulestack.id,
            network_profile={
                "public_ip_address_ids": [example_public_ip.id],
                "vnet_configuration": {
                    "virtual_network_id": example_virtual_network.id,
                    "trusted_subnet_id": trust.id,
                    "untrusted_subnet_id": untrust.id,
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `PaloAltoNetworks.Cloudngfw`: 2023-09-01, 2022-08-29

        ## Import

        Palo Alto Next Generation Firewall Virtual Network Local Rulestacks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:paloalto/nextGenerationFirewallVirtualNetworkLocalRulestack:NextGenerationFirewallVirtualNetworkLocalRulestack example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/PaloAltoNetworks.Cloudngfw/firewalls/myVNetRulestackFW
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgsDict']]]] destination_nats: One or more `destination_nat` blocks as defined below.
        :param pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgsDict']] dns_settings: A `dns_settings` block as defined below.
        :param pulumi.Input[_builtins.str] marketplace_offer_id: The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Next Generation Firewall Virtual Network Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        :param pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgsDict']] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[_builtins.str] plan_id: The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.
               
               > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Palo Alto Next Generation Firewall Virtual Network Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack which will be used to configure this Firewall Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall Virtual Network Local Rulestack.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NextGenerationFirewallVirtualNetworkLocalRulestackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Palo Alto Next Generation Firewall Deployed in a Virtual Network and configured via a Local Rulestack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="westeurope")
        example_public_ip = azure.network.PublicIp("example",
            name="example-public-ip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            sku="Standard")
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="example-nsg",
            location=test["location"],
            resource_group_name=test["name"])
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name,
            tags={
                "environment": "Production",
            })
        trust = azure.network.Subnet("trust",
            name="example-trust-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "trusted",
                "service_delegation": {
                    "name": "PaloAltoNetworks.Cloudngfw/firewalls",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        trust_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("trust",
            subnet_id=trust.id,
            network_security_group_id=example_network_security_group.id)
        untrust = azure.network.Subnet("untrust",
            name="example-untrust-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "untrusted",
                "service_delegation": {
                    "name": "PaloAltoNetworks.Cloudngfw/firewalls",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        untrust_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("untrust",
            subnet_id=untrust.id,
            network_security_group_id=example_network_security_group.id)
        example_local_rulestack = azure.paloalto.LocalRulestack("example",
            name="example-rulestack",
            resource_group_name=example.name,
            location=example.locatio)
        example_local_rulestack_rule = azure.paloalto.LocalRulestackRule("example",
            name="example-rulestack-rule",
            rulestack_id=example_local_rulestack.id,
            priority=1001,
            action="Allow",
            applications=["any"],
            destination={
                "cidrs": ["any"],
            },
            source={
                "cidrs": ["any"],
            })
        example_next_generation_firewall_virtual_network_local_rulestack = azure.paloalto.NextGenerationFirewallVirtualNetworkLocalRulestack("example",
            name="example-ngfwvn",
            resource_group_name=example.name,
            rulestack_id=example_local_rulestack.id,
            network_profile={
                "public_ip_address_ids": [example_public_ip.id],
                "vnet_configuration": {
                    "virtual_network_id": example_virtual_network.id,
                    "trusted_subnet_id": trust.id,
                    "untrusted_subnet_id": untrust.id,
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `PaloAltoNetworks.Cloudngfw`: 2023-09-01, 2022-08-29

        ## Import

        Palo Alto Next Generation Firewall Virtual Network Local Rulestacks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:paloalto/nextGenerationFirewallVirtualNetworkLocalRulestack:NextGenerationFirewallVirtualNetworkLocalRulestack example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/PaloAltoNetworks.Cloudngfw/firewalls/myVNetRulestackFW
        ```

        :param str resource_name: The name of the resource.
        :param NextGenerationFirewallVirtualNetworkLocalRulestackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NextGenerationFirewallVirtualNetworkLocalRulestackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_nats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgsDict']]]]] = None,
                 dns_settings: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgsDict']]] = None,
                 marketplace_offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgsDict']]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NextGenerationFirewallVirtualNetworkLocalRulestackArgs.__new__(NextGenerationFirewallVirtualNetworkLocalRulestackArgs)

            __props__.__dict__["destination_nats"] = destination_nats
            __props__.__dict__["dns_settings"] = dns_settings
            __props__.__dict__["marketplace_offer_id"] = marketplace_offer_id
            __props__.__dict__["name"] = name
            if network_profile is None and not opts.urn:
                raise TypeError("Missing required property 'network_profile'")
            __props__.__dict__["network_profile"] = network_profile
            __props__.__dict__["plan_id"] = plan_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if rulestack_id is None and not opts.urn:
                raise TypeError("Missing required property 'rulestack_id'")
            __props__.__dict__["rulestack_id"] = rulestack_id
            __props__.__dict__["tags"] = tags
        super(NextGenerationFirewallVirtualNetworkLocalRulestack, __self__).__init__(
            'azure:paloalto/nextGenerationFirewallVirtualNetworkLocalRulestack:NextGenerationFirewallVirtualNetworkLocalRulestack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destination_nats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgsDict']]]]] = None,
            dns_settings: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgsDict']]] = None,
            marketplace_offer_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_profile: Optional[pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgsDict']]] = None,
            plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'NextGenerationFirewallVirtualNetworkLocalRulestack':
        """
        Get an existing NextGenerationFirewallVirtualNetworkLocalRulestack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNatArgsDict']]]] destination_nats: One or more `destination_nat` blocks as defined below.
        :param pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettingsArgsDict']] dns_settings: A `dns_settings` block as defined below.
        :param pulumi.Input[_builtins.str] marketplace_offer_id: The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Next Generation Firewall Virtual Network Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        :param pulumi.Input[Union['NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgs', 'NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfileArgsDict']] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[_builtins.str] plan_id: The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.
               
               > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Palo Alto Next Generation Firewall Virtual Network Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack which will be used to configure this Firewall Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall Virtual Network Local Rulestack.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NextGenerationFirewallVirtualNetworkLocalRulestackState.__new__(_NextGenerationFirewallVirtualNetworkLocalRulestackState)

        __props__.__dict__["destination_nats"] = destination_nats
        __props__.__dict__["dns_settings"] = dns_settings
        __props__.__dict__["marketplace_offer_id"] = marketplace_offer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_profile"] = network_profile
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["rulestack_id"] = rulestack_id
        __props__.__dict__["tags"] = tags
        return NextGenerationFirewallVirtualNetworkLocalRulestack(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="destinationNats")
    def destination_nats(self) -> pulumi.Output[Optional[Sequence['outputs.NextGenerationFirewallVirtualNetworkLocalRulestackDestinationNat']]]:
        """
        One or more `destination_nat` blocks as defined below.
        """
        return pulumi.get(self, "destination_nats")

    @_builtins.property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> pulumi.Output[Optional['outputs.NextGenerationFirewallVirtualNetworkLocalRulestackDnsSettings']]:
        """
        A `dns_settings` block as defined below.
        """
        return pulumi.get(self, "dns_settings")

    @_builtins.property
    @pulumi.getter(name="marketplaceOfferId")
    def marketplace_offer_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The marketplace offer ID. Defaults to `pan_swfw_cloud_ngfw`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "marketplace_offer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Palo Alto Next Generation Firewall Virtual Network Local Rulestack. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> pulumi.Output['outputs.NextGenerationFirewallVirtualNetworkLocalRulestackNetworkProfile']:
        """
        A `network_profile` block as defined below.
        """
        return pulumi.get(self, "network_profile")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing plan ID as published by Liftr.PAN. Defaults to `panw-cloud-ngfw-payg`.

        > **Note:** The former `plan_id` `panw-cloud-ngfw-payg` is defined as stop sell, but has been set as the default to not break any existing resources that were originally provisioned with it. Users need to explicitly set `plan_id` to `panw-cngfw-payg` when creating new resources.
        """
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Palo Alto Next Generation Firewall Virtual Network Local Rulestack should exist. Changing this forces a new Palo Alto Next Generation Firewall Virtual Network Local Rulestack to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Local Rulestack which will be used to configure this Firewall Resource.
        """
        return pulumi.get(self, "rulestack_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Palo Alto Next Generation Firewall Virtual Network Local Rulestack.
        """
        return pulumi.get(self, "tags")

