# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RoleManagementPolicyArgs', 'RoleManagementPolicy']

@pulumi.input_type
class RoleManagementPolicyArgs:
    def __init__(__self__, *,
                 role_definition_id: pulumi.Input[_builtins.str],
                 scope: pulumi.Input[_builtins.str],
                 activation_rules: Optional[pulumi.Input['RoleManagementPolicyActivationRulesArgs']] = None,
                 active_assignment_rules: Optional[pulumi.Input['RoleManagementPolicyActiveAssignmentRulesArgs']] = None,
                 eligible_assignment_rules: Optional[pulumi.Input['RoleManagementPolicyEligibleAssignmentRulesArgs']] = None,
                 notification_rules: Optional[pulumi.Input['RoleManagementPolicyNotificationRulesArgs']] = None):
        """
        The set of arguments for constructing a RoleManagementPolicy resource.
        :param pulumi.Input[_builtins.str] role_definition_id: The scoped Role Definition ID of the role for which this policy will apply. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope: The scope to which this Role Management Policy will apply. Can refer to a management group, a subscription, a resource group or a resource. Changing this forces a new resource to be created.
        :param pulumi.Input['RoleManagementPolicyActivationRulesArgs'] activation_rules: An `activation_rules` block as defined below.
        :param pulumi.Input['RoleManagementPolicyActiveAssignmentRulesArgs'] active_assignment_rules: An `active_assignment_rules` block as defined below.
        :param pulumi.Input['RoleManagementPolicyEligibleAssignmentRulesArgs'] eligible_assignment_rules: An `eligible_assignment_rules` block as defined below.
        :param pulumi.Input['RoleManagementPolicyNotificationRulesArgs'] notification_rules: A `notification_rules` block as defined below.
        """
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        pulumi.set(__self__, "scope", scope)
        if activation_rules is not None:
            pulumi.set(__self__, "activation_rules", activation_rules)
        if active_assignment_rules is not None:
            pulumi.set(__self__, "active_assignment_rules", active_assignment_rules)
        if eligible_assignment_rules is not None:
            pulumi.set(__self__, "eligible_assignment_rules", eligible_assignment_rules)
        if notification_rules is not None:
            pulumi.set(__self__, "notification_rules", notification_rules)

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Input[_builtins.str]:
        """
        The scoped Role Definition ID of the role for which this policy will apply. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_definition_id", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Input[_builtins.str]:
        """
        The scope to which this Role Management Policy will apply. Can refer to a management group, a subscription, a resource group or a resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter(name="activationRules")
    def activation_rules(self) -> Optional[pulumi.Input['RoleManagementPolicyActivationRulesArgs']]:
        """
        An `activation_rules` block as defined below.
        """
        return pulumi.get(self, "activation_rules")

    @activation_rules.setter
    def activation_rules(self, value: Optional[pulumi.Input['RoleManagementPolicyActivationRulesArgs']]):
        pulumi.set(self, "activation_rules", value)

    @_builtins.property
    @pulumi.getter(name="activeAssignmentRules")
    def active_assignment_rules(self) -> Optional[pulumi.Input['RoleManagementPolicyActiveAssignmentRulesArgs']]:
        """
        An `active_assignment_rules` block as defined below.
        """
        return pulumi.get(self, "active_assignment_rules")

    @active_assignment_rules.setter
    def active_assignment_rules(self, value: Optional[pulumi.Input['RoleManagementPolicyActiveAssignmentRulesArgs']]):
        pulumi.set(self, "active_assignment_rules", value)

    @_builtins.property
    @pulumi.getter(name="eligibleAssignmentRules")
    def eligible_assignment_rules(self) -> Optional[pulumi.Input['RoleManagementPolicyEligibleAssignmentRulesArgs']]:
        """
        An `eligible_assignment_rules` block as defined below.
        """
        return pulumi.get(self, "eligible_assignment_rules")

    @eligible_assignment_rules.setter
    def eligible_assignment_rules(self, value: Optional[pulumi.Input['RoleManagementPolicyEligibleAssignmentRulesArgs']]):
        pulumi.set(self, "eligible_assignment_rules", value)

    @_builtins.property
    @pulumi.getter(name="notificationRules")
    def notification_rules(self) -> Optional[pulumi.Input['RoleManagementPolicyNotificationRulesArgs']]:
        """
        A `notification_rules` block as defined below.
        """
        return pulumi.get(self, "notification_rules")

    @notification_rules.setter
    def notification_rules(self, value: Optional[pulumi.Input['RoleManagementPolicyNotificationRulesArgs']]):
        pulumi.set(self, "notification_rules", value)


@pulumi.input_type
class _RoleManagementPolicyState:
    def __init__(__self__, *,
                 activation_rules: Optional[pulumi.Input['RoleManagementPolicyActivationRulesArgs']] = None,
                 active_assignment_rules: Optional[pulumi.Input['RoleManagementPolicyActiveAssignmentRulesArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eligible_assignment_rules: Optional[pulumi.Input['RoleManagementPolicyEligibleAssignmentRulesArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_rules: Optional[pulumi.Input['RoleManagementPolicyNotificationRulesArgs']] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RoleManagementPolicy resources.
        :param pulumi.Input['RoleManagementPolicyActivationRulesArgs'] activation_rules: An `activation_rules` block as defined below.
        :param pulumi.Input['RoleManagementPolicyActiveAssignmentRulesArgs'] active_assignment_rules: An `active_assignment_rules` block as defined below.
        :param pulumi.Input[_builtins.str] description: (String) The description of this policy.
        :param pulumi.Input['RoleManagementPolicyEligibleAssignmentRulesArgs'] eligible_assignment_rules: An `eligible_assignment_rules` block as defined below.
        :param pulumi.Input[_builtins.str] name: (String) The name of this policy, which is typically a UUID and may change over time.
        :param pulumi.Input['RoleManagementPolicyNotificationRulesArgs'] notification_rules: A `notification_rules` block as defined below.
        :param pulumi.Input[_builtins.str] role_definition_id: The scoped Role Definition ID of the role for which this policy will apply. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope: The scope to which this Role Management Policy will apply. Can refer to a management group, a subscription, a resource group or a resource. Changing this forces a new resource to be created.
        """
        if activation_rules is not None:
            pulumi.set(__self__, "activation_rules", activation_rules)
        if active_assignment_rules is not None:
            pulumi.set(__self__, "active_assignment_rules", active_assignment_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eligible_assignment_rules is not None:
            pulumi.set(__self__, "eligible_assignment_rules", eligible_assignment_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_rules is not None:
            pulumi.set(__self__, "notification_rules", notification_rules)
        if role_definition_id is not None:
            pulumi.set(__self__, "role_definition_id", role_definition_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="activationRules")
    def activation_rules(self) -> Optional[pulumi.Input['RoleManagementPolicyActivationRulesArgs']]:
        """
        An `activation_rules` block as defined below.
        """
        return pulumi.get(self, "activation_rules")

    @activation_rules.setter
    def activation_rules(self, value: Optional[pulumi.Input['RoleManagementPolicyActivationRulesArgs']]):
        pulumi.set(self, "activation_rules", value)

    @_builtins.property
    @pulumi.getter(name="activeAssignmentRules")
    def active_assignment_rules(self) -> Optional[pulumi.Input['RoleManagementPolicyActiveAssignmentRulesArgs']]:
        """
        An `active_assignment_rules` block as defined below.
        """
        return pulumi.get(self, "active_assignment_rules")

    @active_assignment_rules.setter
    def active_assignment_rules(self, value: Optional[pulumi.Input['RoleManagementPolicyActiveAssignmentRulesArgs']]):
        pulumi.set(self, "active_assignment_rules", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) The description of this policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eligibleAssignmentRules")
    def eligible_assignment_rules(self) -> Optional[pulumi.Input['RoleManagementPolicyEligibleAssignmentRulesArgs']]:
        """
        An `eligible_assignment_rules` block as defined below.
        """
        return pulumi.get(self, "eligible_assignment_rules")

    @eligible_assignment_rules.setter
    def eligible_assignment_rules(self, value: Optional[pulumi.Input['RoleManagementPolicyEligibleAssignmentRulesArgs']]):
        pulumi.set(self, "eligible_assignment_rules", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (String) The name of this policy, which is typically a UUID and may change over time.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationRules")
    def notification_rules(self) -> Optional[pulumi.Input['RoleManagementPolicyNotificationRulesArgs']]:
        """
        A `notification_rules` block as defined below.
        """
        return pulumi.get(self, "notification_rules")

    @notification_rules.setter
    def notification_rules(self, value: Optional[pulumi.Input['RoleManagementPolicyNotificationRulesArgs']]):
        pulumi.set(self, "notification_rules", value)

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scoped Role Definition ID of the role for which this policy will apply. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_definition_id", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope to which this Role Management Policy will apply. Can refer to a management group, a subscription, a resource group or a resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.type_token("azure:pim/roleManagementPolicy:RoleManagementPolicy")
class RoleManagementPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_rules: Optional[pulumi.Input[Union['RoleManagementPolicyActivationRulesArgs', 'RoleManagementPolicyActivationRulesArgsDict']]] = None,
                 active_assignment_rules: Optional[pulumi.Input[Union['RoleManagementPolicyActiveAssignmentRulesArgs', 'RoleManagementPolicyActiveAssignmentRulesArgsDict']]] = None,
                 eligible_assignment_rules: Optional[pulumi.Input[Union['RoleManagementPolicyEligibleAssignmentRulesArgs', 'RoleManagementPolicyEligibleAssignmentRulesArgsDict']]] = None,
                 notification_rules: Optional[pulumi.Input[Union['RoleManagementPolicyNotificationRulesArgs', 'RoleManagementPolicyNotificationRulesArgsDict']]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage a role policy for an Azure Management Group, Subscription, Resource Group or resource.

        ## Example Usage

        ### Resource Group

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="East US")
        rg_contributor = azure.authorization.get_role_definition_output(name="Contributor",
            scope=example.id)
        approvers = azuread.get_group(display_name="Example Approver Group")
        example_role_management_policy = azure.pim.RoleManagementPolicy("example",
            scope=test["id"],
            role_definition_id=contributor["id"],
            active_assignment_rules={
                "expire_after": "P365D",
            },
            eligible_assignment_rules={
                "expiration_required": False,
            },
            activation_rules={
                "maximum_duration": "PT1H",
                "require_approval": True,
                "approval_stage": {
                    "primary_approvers": [{
                        "object_id": approvers.object_id,
                        "type": "Group",
                    }],
                },
            },
            notification_rules={
                "eligible_assignments": {
                    "approver_notifications": {
                        "notification_level": "Critical",
                        "default_recipients": False,
                        "additional_recipients": ["someone@example.com"],
                    },
                },
                "eligible_activations": {
                    "assignee_notifications": {
                        "notification_level": "All",
                        "default_recipients": True,
                        "additional_recipients": ["someone.else@example.com"],
                    },
                },
            })
        ```

        ### Management Group

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.management.Group("example", name="example-group")
        mg_contributor = azure.authorization.get_role_definition_output(name="Contributor",
            scope=example.id)
        example_role_management_policy = azure.pim.RoleManagementPolicy("example",
            scope=example.id,
            role_definition_id=mg_contributor.id,
            eligible_assignment_rules={
                "expiration_required": False,
            },
            active_assignment_rules={
                "expire_after": "P90D",
            },
            activation_rules={
                "maximum_duration": "PT1H",
                "require_approval": True,
            },
            notification_rules={
                "active_assignments": {
                    "admin_notifications": {
                        "notification_level": "Critical",
                        "default_recipients": False,
                        "additional_recipients": ["someone@example.com"],
                    },
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization`: 2020-10-01

        ## Import

        Because these policies are created automatically by Azure, they will auto-import on first use. They can be imported using the `resource id` of the role definition, combined with the scope id, e.g.

        ```sh
        $ pulumi import azure:pim/roleManagementPolicy:RoleManagementPolicy example "/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/roleDefinitions/00000000-0000-0000-0000-000000000000|<scope>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RoleManagementPolicyActivationRulesArgs', 'RoleManagementPolicyActivationRulesArgsDict']] activation_rules: An `activation_rules` block as defined below.
        :param pulumi.Input[Union['RoleManagementPolicyActiveAssignmentRulesArgs', 'RoleManagementPolicyActiveAssignmentRulesArgsDict']] active_assignment_rules: An `active_assignment_rules` block as defined below.
        :param pulumi.Input[Union['RoleManagementPolicyEligibleAssignmentRulesArgs', 'RoleManagementPolicyEligibleAssignmentRulesArgsDict']] eligible_assignment_rules: An `eligible_assignment_rules` block as defined below.
        :param pulumi.Input[Union['RoleManagementPolicyNotificationRulesArgs', 'RoleManagementPolicyNotificationRulesArgsDict']] notification_rules: A `notification_rules` block as defined below.
        :param pulumi.Input[_builtins.str] role_definition_id: The scoped Role Definition ID of the role for which this policy will apply. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope: The scope to which this Role Management Policy will apply. Can refer to a management group, a subscription, a resource group or a resource. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoleManagementPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a role policy for an Azure Management Group, Subscription, Resource Group or resource.

        ## Example Usage

        ### Resource Group

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="East US")
        rg_contributor = azure.authorization.get_role_definition_output(name="Contributor",
            scope=example.id)
        approvers = azuread.get_group(display_name="Example Approver Group")
        example_role_management_policy = azure.pim.RoleManagementPolicy("example",
            scope=test["id"],
            role_definition_id=contributor["id"],
            active_assignment_rules={
                "expire_after": "P365D",
            },
            eligible_assignment_rules={
                "expiration_required": False,
            },
            activation_rules={
                "maximum_duration": "PT1H",
                "require_approval": True,
                "approval_stage": {
                    "primary_approvers": [{
                        "object_id": approvers.object_id,
                        "type": "Group",
                    }],
                },
            },
            notification_rules={
                "eligible_assignments": {
                    "approver_notifications": {
                        "notification_level": "Critical",
                        "default_recipients": False,
                        "additional_recipients": ["someone@example.com"],
                    },
                },
                "eligible_activations": {
                    "assignee_notifications": {
                        "notification_level": "All",
                        "default_recipients": True,
                        "additional_recipients": ["someone.else@example.com"],
                    },
                },
            })
        ```

        ### Management Group

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.management.Group("example", name="example-group")
        mg_contributor = azure.authorization.get_role_definition_output(name="Contributor",
            scope=example.id)
        example_role_management_policy = azure.pim.RoleManagementPolicy("example",
            scope=example.id,
            role_definition_id=mg_contributor.id,
            eligible_assignment_rules={
                "expiration_required": False,
            },
            active_assignment_rules={
                "expire_after": "P90D",
            },
            activation_rules={
                "maximum_duration": "PT1H",
                "require_approval": True,
            },
            notification_rules={
                "active_assignments": {
                    "admin_notifications": {
                        "notification_level": "Critical",
                        "default_recipients": False,
                        "additional_recipients": ["someone@example.com"],
                    },
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization`: 2020-10-01

        ## Import

        Because these policies are created automatically by Azure, they will auto-import on first use. They can be imported using the `resource id` of the role definition, combined with the scope id, e.g.

        ```sh
        $ pulumi import azure:pim/roleManagementPolicy:RoleManagementPolicy example "/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Authorization/roleDefinitions/00000000-0000-0000-0000-000000000000|<scope>"
        ```

        :param str resource_name: The name of the resource.
        :param RoleManagementPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleManagementPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_rules: Optional[pulumi.Input[Union['RoleManagementPolicyActivationRulesArgs', 'RoleManagementPolicyActivationRulesArgsDict']]] = None,
                 active_assignment_rules: Optional[pulumi.Input[Union['RoleManagementPolicyActiveAssignmentRulesArgs', 'RoleManagementPolicyActiveAssignmentRulesArgsDict']]] = None,
                 eligible_assignment_rules: Optional[pulumi.Input[Union['RoleManagementPolicyEligibleAssignmentRulesArgs', 'RoleManagementPolicyEligibleAssignmentRulesArgsDict']]] = None,
                 notification_rules: Optional[pulumi.Input[Union['RoleManagementPolicyNotificationRulesArgs', 'RoleManagementPolicyNotificationRulesArgsDict']]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleManagementPolicyArgs.__new__(RoleManagementPolicyArgs)

            __props__.__dict__["activation_rules"] = activation_rules
            __props__.__dict__["active_assignment_rules"] = active_assignment_rules
            __props__.__dict__["eligible_assignment_rules"] = eligible_assignment_rules
            __props__.__dict__["notification_rules"] = notification_rules
            if role_definition_id is None and not opts.urn:
                raise TypeError("Missing required property 'role_definition_id'")
            __props__.__dict__["role_definition_id"] = role_definition_id
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["description"] = None
            __props__.__dict__["name"] = None
        super(RoleManagementPolicy, __self__).__init__(
            'azure:pim/roleManagementPolicy:RoleManagementPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_rules: Optional[pulumi.Input[Union['RoleManagementPolicyActivationRulesArgs', 'RoleManagementPolicyActivationRulesArgsDict']]] = None,
            active_assignment_rules: Optional[pulumi.Input[Union['RoleManagementPolicyActiveAssignmentRulesArgs', 'RoleManagementPolicyActiveAssignmentRulesArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            eligible_assignment_rules: Optional[pulumi.Input[Union['RoleManagementPolicyEligibleAssignmentRulesArgs', 'RoleManagementPolicyEligibleAssignmentRulesArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_rules: Optional[pulumi.Input[Union['RoleManagementPolicyNotificationRulesArgs', 'RoleManagementPolicyNotificationRulesArgsDict']]] = None,
            role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None) -> 'RoleManagementPolicy':
        """
        Get an existing RoleManagementPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RoleManagementPolicyActivationRulesArgs', 'RoleManagementPolicyActivationRulesArgsDict']] activation_rules: An `activation_rules` block as defined below.
        :param pulumi.Input[Union['RoleManagementPolicyActiveAssignmentRulesArgs', 'RoleManagementPolicyActiveAssignmentRulesArgsDict']] active_assignment_rules: An `active_assignment_rules` block as defined below.
        :param pulumi.Input[_builtins.str] description: (String) The description of this policy.
        :param pulumi.Input[Union['RoleManagementPolicyEligibleAssignmentRulesArgs', 'RoleManagementPolicyEligibleAssignmentRulesArgsDict']] eligible_assignment_rules: An `eligible_assignment_rules` block as defined below.
        :param pulumi.Input[_builtins.str] name: (String) The name of this policy, which is typically a UUID and may change over time.
        :param pulumi.Input[Union['RoleManagementPolicyNotificationRulesArgs', 'RoleManagementPolicyNotificationRulesArgsDict']] notification_rules: A `notification_rules` block as defined below.
        :param pulumi.Input[_builtins.str] role_definition_id: The scoped Role Definition ID of the role for which this policy will apply. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope: The scope to which this Role Management Policy will apply. Can refer to a management group, a subscription, a resource group or a resource. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleManagementPolicyState.__new__(_RoleManagementPolicyState)

        __props__.__dict__["activation_rules"] = activation_rules
        __props__.__dict__["active_assignment_rules"] = active_assignment_rules
        __props__.__dict__["description"] = description
        __props__.__dict__["eligible_assignment_rules"] = eligible_assignment_rules
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_rules"] = notification_rules
        __props__.__dict__["role_definition_id"] = role_definition_id
        __props__.__dict__["scope"] = scope
        return RoleManagementPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activationRules")
    def activation_rules(self) -> pulumi.Output['outputs.RoleManagementPolicyActivationRules']:
        """
        An `activation_rules` block as defined below.
        """
        return pulumi.get(self, "activation_rules")

    @_builtins.property
    @pulumi.getter(name="activeAssignmentRules")
    def active_assignment_rules(self) -> pulumi.Output['outputs.RoleManagementPolicyActiveAssignmentRules']:
        """
        An `active_assignment_rules` block as defined below.
        """
        return pulumi.get(self, "active_assignment_rules")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (String) The description of this policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eligibleAssignmentRules")
    def eligible_assignment_rules(self) -> pulumi.Output['outputs.RoleManagementPolicyEligibleAssignmentRules']:
        """
        An `eligible_assignment_rules` block as defined below.
        """
        return pulumi.get(self, "eligible_assignment_rules")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        (String) The name of this policy, which is typically a UUID and may change over time.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationRules")
    def notification_rules(self) -> pulumi.Output['outputs.RoleManagementPolicyNotificationRules']:
        """
        A `notification_rules` block as defined below.
        """
        return pulumi.get(self, "notification_rules")

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Output[_builtins.str]:
        """
        The scoped Role Definition ID of the role for which this policy will apply. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        The scope to which this Role Management Policy will apply. Can refer to a management group, a subscription, a resource group or a resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

