# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'FlexibleServerAuthenticationArgs',
    'FlexibleServerAuthenticationArgsDict',
    'FlexibleServerCustomerManagedKeyArgs',
    'FlexibleServerCustomerManagedKeyArgsDict',
    'FlexibleServerHighAvailabilityArgs',
    'FlexibleServerHighAvailabilityArgsDict',
    'FlexibleServerIdentityArgs',
    'FlexibleServerIdentityArgsDict',
    'FlexibleServerMaintenanceWindowArgs',
    'FlexibleServerMaintenanceWindowArgsDict',
    'ServerIdentityArgs',
    'ServerIdentityArgsDict',
    'ServerThreatDetectionPolicyArgs',
    'ServerThreatDetectionPolicyArgsDict',
]

MYPY = False

if not MYPY:
    class FlexibleServerAuthenticationArgsDict(TypedDict):
        active_directory_auth_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether Active Directory authentication is allowed to access the PostgreSQL Flexible Server. Defaults to `false`.
        """
        password_auth_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether password authentication is allowed to access the PostgreSQL Flexible Server. Defaults to `true`.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID of the Azure Active Directory which is used by the Active Directory authentication. `active_directory_auth_enabled` must be set to `true`.

        > **Note:** Setting `active_directory_auth_enabled` to `true` requires a Service Principal for the Postgres Flexible Server. For more details see [this document](https://learn.microsoft.com/en-us/azure/postgresql/flexible-server/how-to-configure-sign-in-azure-ad-authentication).

        > **Note:** `tenant_id` is required when `active_directory_auth_enabled` is set to `true`. And it should not be specified when `active_directory_auth_enabled` is set to `false`
        """
elif False:
    FlexibleServerAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlexibleServerAuthenticationArgs:
    def __init__(__self__, *,
                 active_directory_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] active_directory_auth_enabled: Whether Active Directory authentication is allowed to access the PostgreSQL Flexible Server. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] password_auth_enabled: Whether password authentication is allowed to access the PostgreSQL Flexible Server. Defaults to `true`.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID of the Azure Active Directory which is used by the Active Directory authentication. `active_directory_auth_enabled` must be set to `true`.
               
               > **Note:** Setting `active_directory_auth_enabled` to `true` requires a Service Principal for the Postgres Flexible Server. For more details see [this document](https://learn.microsoft.com/en-us/azure/postgresql/flexible-server/how-to-configure-sign-in-azure-ad-authentication).
               
               > **Note:** `tenant_id` is required when `active_directory_auth_enabled` is set to `true`. And it should not be specified when `active_directory_auth_enabled` is set to `false`
        """
        if active_directory_auth_enabled is not None:
            pulumi.set(__self__, "active_directory_auth_enabled", active_directory_auth_enabled)
        if password_auth_enabled is not None:
            pulumi.set(__self__, "password_auth_enabled", password_auth_enabled)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="activeDirectoryAuthEnabled")
    def active_directory_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Active Directory authentication is allowed to access the PostgreSQL Flexible Server. Defaults to `false`.
        """
        return pulumi.get(self, "active_directory_auth_enabled")

    @active_directory_auth_enabled.setter
    def active_directory_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active_directory_auth_enabled", value)

    @_builtins.property
    @pulumi.getter(name="passwordAuthEnabled")
    def password_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether password authentication is allowed to access the PostgreSQL Flexible Server. Defaults to `true`.
        """
        return pulumi.get(self, "password_auth_enabled")

    @password_auth_enabled.setter
    def password_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_auth_enabled", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID of the Azure Active Directory which is used by the Active Directory authentication. `active_directory_auth_enabled` must be set to `true`.

        > **Note:** Setting `active_directory_auth_enabled` to `true` requires a Service Principal for the Postgres Flexible Server. For more details see [this document](https://learn.microsoft.com/en-us/azure/postgresql/flexible-server/how-to-configure-sign-in-azure-ad-authentication).

        > **Note:** `tenant_id` is required when `active_directory_auth_enabled` is set to `true`. And it should not be specified when `active_directory_auth_enabled` is set to `false`
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class FlexibleServerCustomerManagedKeyArgsDict(TypedDict):
        key_vault_key_id: pulumi.Input[_builtins.str]
        """
        The versioned/versionless ID of the Key Vault Key.
        """
        geo_backup_key_vault_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The versioned ID of the geo backup Key Vault Key.

        > **Note:** The key vault in which this key exists must be in the same region as the geo-redundant backup.
        """
        geo_backup_user_assigned_identity_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The geo backup user managed identity id for a Customer Managed Key. Must be added to `identity.identity_ids`.

        > **Note:** This managed identity cannot be the same as `primary_user_assigned_identity_id`, additionally this identity must be created in the same region as the geo-redundant backup.

        > **Note:** `primary_user_assigned_identity_id` or `geo_backup_user_assigned_identity_id` is required when `type` is set to `UserAssigned`.
        """
        primary_user_assigned_identity_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the primary user managed identity id for a Customer Managed Key. Must be added to `identity.identity_ids`.
        """
elif False:
    FlexibleServerCustomerManagedKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlexibleServerCustomerManagedKeyArgs:
    def __init__(__self__, *,
                 key_vault_key_id: pulumi.Input[_builtins.str],
                 geo_backup_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_backup_user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key_vault_key_id: The versioned/versionless ID of the Key Vault Key.
        :param pulumi.Input[_builtins.str] geo_backup_key_vault_key_id: The versioned ID of the geo backup Key Vault Key.
               
               > **Note:** The key vault in which this key exists must be in the same region as the geo-redundant backup.
        :param pulumi.Input[_builtins.str] geo_backup_user_assigned_identity_id: The geo backup user managed identity id for a Customer Managed Key. Must be added to `identity.identity_ids`.
               
               > **Note:** This managed identity cannot be the same as `primary_user_assigned_identity_id`, additionally this identity must be created in the same region as the geo-redundant backup.
               
               > **Note:** `primary_user_assigned_identity_id` or `geo_backup_user_assigned_identity_id` is required when `type` is set to `UserAssigned`.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity_id: Specifies the primary user managed identity id for a Customer Managed Key. Must be added to `identity.identity_ids`.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if geo_backup_key_vault_key_id is not None:
            pulumi.set(__self__, "geo_backup_key_vault_key_id", geo_backup_key_vault_key_id)
        if geo_backup_user_assigned_identity_id is not None:
            pulumi.set(__self__, "geo_backup_user_assigned_identity_id", geo_backup_user_assigned_identity_id)
        if primary_user_assigned_identity_id is not None:
            pulumi.set(__self__, "primary_user_assigned_identity_id", primary_user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The versioned/versionless ID of the Key Vault Key.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="geoBackupKeyVaultKeyId")
    def geo_backup_key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The versioned ID of the geo backup Key Vault Key.

        > **Note:** The key vault in which this key exists must be in the same region as the geo-redundant backup.
        """
        return pulumi.get(self, "geo_backup_key_vault_key_id")

    @geo_backup_key_vault_key_id.setter
    def geo_backup_key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geo_backup_key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="geoBackupUserAssignedIdentityId")
    def geo_backup_user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geo backup user managed identity id for a Customer Managed Key. Must be added to `identity.identity_ids`.

        > **Note:** This managed identity cannot be the same as `primary_user_assigned_identity_id`, additionally this identity must be created in the same region as the geo-redundant backup.

        > **Note:** `primary_user_assigned_identity_id` or `geo_backup_user_assigned_identity_id` is required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "geo_backup_user_assigned_identity_id")

    @geo_backup_user_assigned_identity_id.setter
    def geo_backup_user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geo_backup_user_assigned_identity_id", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentityId")
    def primary_user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the primary user managed identity id for a Customer Managed Key. Must be added to `identity.identity_ids`.
        """
        return pulumi.get(self, "primary_user_assigned_identity_id")

    @primary_user_assigned_identity_id.setter
    def primary_user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_user_assigned_identity_id", value)


if not MYPY:
    class FlexibleServerHighAvailabilityArgsDict(TypedDict):
        mode: pulumi.Input[_builtins.str]
        """
        The high availability mode for the PostgreSQL Flexible Server. Possible value are `SameZone` or `ZoneRedundant`.
        """
        standby_availability_zone: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    FlexibleServerHighAvailabilityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlexibleServerHighAvailabilityArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[_builtins.str],
                 standby_availability_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] mode: The high availability mode for the PostgreSQL Flexible Server. Possible value are `SameZone` or `ZoneRedundant`.
        """
        pulumi.set(__self__, "mode", mode)
        if standby_availability_zone is not None:
            pulumi.set(__self__, "standby_availability_zone", standby_availability_zone)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Input[_builtins.str]:
        """
        The high availability mode for the PostgreSQL Flexible Server. Possible value are `SameZone` or `ZoneRedundant`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="standbyAvailabilityZone")
    def standby_availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "standby_availability_zone")

    @standby_availability_zone.setter
    def standby_availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "standby_availability_zone", value)


if not MYPY:
    class FlexibleServerIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this PostgreSQL Flexible Server. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`.

        > **Note:** Once `UserAssigned` has been added, removing it forces a new resource to be created.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of User Assigned Managed Identity IDs to be assigned to this PostgreSQL Flexible Server. Required if used together with `customer_managed_key` block.

        > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    FlexibleServerIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlexibleServerIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this PostgreSQL Flexible Server. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`.
               
               > **Note:** Once `UserAssigned` has been added, removing it forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this PostgreSQL Flexible Server. Required if used together with `customer_managed_key` block.
               
               > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this PostgreSQL Flexible Server. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`.

        > **Note:** Once `UserAssigned` has been added, removing it forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this PostgreSQL Flexible Server. Required if used together with `customer_managed_key` block.

        > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class FlexibleServerMaintenanceWindowArgsDict(TypedDict):
        day_of_week: NotRequired[pulumi.Input[_builtins.int]]
        """
        The day of week for maintenance window, where the week starts on a Sunday, i.e. Sunday = `0`, Monday = `1`. Defaults to `0`.
        """
        start_hour: NotRequired[pulumi.Input[_builtins.int]]
        """
        The start hour for maintenance window. Defaults to `0`.
        """
        start_minute: NotRequired[pulumi.Input[_builtins.int]]
        """
        The start minute for maintenance window. Defaults to `0`.

        > **Note:** The specified `maintenance_window` is always defined in UTC time. When unspecified, the maintenance window falls back to the default [system-managed](https://learn.microsoft.com/en-us/azure/postgresql/flexible-server/how-to-maintenance-portal#specify-maintenance-schedule-options).
        """
elif False:
    FlexibleServerMaintenanceWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlexibleServerMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day_of_week: Optional[pulumi.Input[_builtins.int]] = None,
                 start_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 start_minute: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] day_of_week: The day of week for maintenance window, where the week starts on a Sunday, i.e. Sunday = `0`, Monday = `1`. Defaults to `0`.
        :param pulumi.Input[_builtins.int] start_hour: The start hour for maintenance window. Defaults to `0`.
        :param pulumi.Input[_builtins.int] start_minute: The start minute for maintenance window. Defaults to `0`.
               
               > **Note:** The specified `maintenance_window` is always defined in UTC time. When unspecified, the maintenance window falls back to the default [system-managed](https://learn.microsoft.com/en-us/azure/postgresql/flexible-server/how-to-maintenance-portal#specify-maintenance-schedule-options).
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_hour is not None:
            pulumi.set(__self__, "start_hour", start_hour)
        if start_minute is not None:
            pulumi.set(__self__, "start_minute", start_minute)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The day of week for maintenance window, where the week starts on a Sunday, i.e. Sunday = `0`, Monday = `1`. Defaults to `0`.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The start hour for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "start_hour")

    @start_hour.setter
    def start_hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_hour", value)

    @_builtins.property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The start minute for maintenance window. Defaults to `0`.

        > **Note:** The specified `maintenance_window` is always defined in UTC time. When unspecified, the maintenance window falls back to the default [system-managed](https://learn.microsoft.com/en-us/azure/postgresql/flexible-server/how-to-maintenance-portal#specify-maintenance-schedule-options).
        """
        return pulumi.get(self, "start_minute")

    @start_minute.setter
    def start_minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_minute", value)


if not MYPY:
    class ServerIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this PostgreSQL Server. The only possible value is `SystemAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    ServerIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this PostgreSQL Server. The only possible value is `SystemAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this PostgreSQL Server. The only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ServerThreatDetectionPolicyArgsDict(TypedDict):
        disabled_alerts: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of alerts which should be disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration` and `Unsafe_Action`.
        """
        email_account_admins: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Should the account administrators be emailed when this alert is triggered?
        """
        email_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of email addresses which alerts should be sent to.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is the policy enabled?
        """
        retention_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the number of days to keep in the Threat Detection audit logs.
        """
        storage_account_access_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the identifier key of the Threat Detection audit storage account.
        """
        storage_endpoint: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all Threat Detection audit logs.
        """
elif False:
    ServerThreatDetectionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerThreatDetectionPolicyArgs:
    def __init__(__self__, *,
                 disabled_alerts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_account_admins: Optional[pulumi.Input[_builtins.bool]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disabled_alerts: Specifies a list of alerts which should be disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration` and `Unsafe_Action`.
        :param pulumi.Input[_builtins.bool] email_account_admins: Should the account administrators be emailed when this alert is triggered?
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: A list of email addresses which alerts should be sent to.
        :param pulumi.Input[_builtins.bool] enabled: Is the policy enabled?
        :param pulumi.Input[_builtins.int] retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the identifier key of the Threat Detection audit storage account.
        :param pulumi.Input[_builtins.str] storage_endpoint: Specifies the blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all Threat Detection audit logs.
        """
        if disabled_alerts is not None:
            pulumi.set(__self__, "disabled_alerts", disabled_alerts)
        if email_account_admins is not None:
            pulumi.set(__self__, "email_account_admins", email_account_admins)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_endpoint is not None:
            pulumi.set(__self__, "storage_endpoint", storage_endpoint)

    @_builtins.property
    @pulumi.getter(name="disabledAlerts")
    def disabled_alerts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of alerts which should be disabled. Possible values are `Sql_Injection`, `Sql_Injection_Vulnerability`, `Access_Anomaly`, `Data_Exfiltration` and `Unsafe_Action`.
        """
        return pulumi.get(self, "disabled_alerts")

    @disabled_alerts.setter
    def disabled_alerts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disabled_alerts", value)

    @_builtins.property
    @pulumi.getter(name="emailAccountAdmins")
    def email_account_admins(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the account administrators be emailed when this alert is triggered?
        """
        return pulumi.get(self, "email_account_admins")

    @email_account_admins.setter
    def email_account_admins(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "email_account_admins", value)

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of email addresses which alerts should be sent to.
        """
        return pulumi.get(self, "email_addresses")

    @email_addresses.setter
    def email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "email_addresses", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the policy enabled?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of days to keep in the Threat Detection audit logs.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier key of the Threat Detection audit storage account.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the blob storage endpoint (e.g. <https://example.blob.core.windows.net>). This blob storage will hold all Threat Detection audit logs.
        """
        return pulumi.get(self, "storage_endpoint")

    @storage_endpoint.setter
    def storage_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_endpoint", value)


