# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResolverForwardingRuleResult',
    'AwaitableGetResolverForwardingRuleResult',
    'get_resolver_forwarding_rule',
    'get_resolver_forwarding_rule_output',
]

@pulumi.output_type
class GetResolverForwardingRuleResult:
    """
    A collection of values returned by getResolverForwardingRule.
    """
    def __init__(__self__, dns_forwarding_ruleset_id=None, domain_name=None, enabled=None, id=None, metadata=None, name=None, target_dns_servers=None):
        if dns_forwarding_ruleset_id and not isinstance(dns_forwarding_ruleset_id, str):
            raise TypeError("Expected argument 'dns_forwarding_ruleset_id' to be a str")
        pulumi.set(__self__, "dns_forwarding_ruleset_id", dns_forwarding_ruleset_id)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if target_dns_servers and not isinstance(target_dns_servers, list):
            raise TypeError("Expected argument 'target_dns_servers' to be a list")
        pulumi.set(__self__, "target_dns_servers", target_dns_servers)

    @_builtins.property
    @pulumi.getter(name="dnsForwardingRulesetId")
    def dns_forwarding_ruleset_id(self) -> _builtins.str:
        return pulumi.get(self, "dns_forwarding_ruleset_id")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The domain name for the Private DNS Resolver Forwarding Rule.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Is the Private DNS Resolver Forwarding Rule enabled?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        The metadata attached to the Private DNS Resolver Forwarding Rule.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="targetDnsServers")
    def target_dns_servers(self) -> Sequence['outputs.GetResolverForwardingRuleTargetDnsServerResult']:
        """
        A list of `target_dns_servers` block as defined below.
        """
        return pulumi.get(self, "target_dns_servers")


class AwaitableGetResolverForwardingRuleResult(GetResolverForwardingRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResolverForwardingRuleResult(
            dns_forwarding_ruleset_id=self.dns_forwarding_ruleset_id,
            domain_name=self.domain_name,
            enabled=self.enabled,
            id=self.id,
            metadata=self.metadata,
            name=self.name,
            target_dns_servers=self.target_dns_servers)


def get_resolver_forwarding_rule(dns_forwarding_ruleset_id: Optional[_builtins.str] = None,
                                 name: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResolverForwardingRuleResult:
    """
    Gets information about an existing Private DNS Resolver Forwarding Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.privatedns.get_resolver_forwarding_rule(name="example-rule",
        dns_forwarding_ruleset_id="example-forwarding-rulset-id")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2022-07-01


    :param _builtins.str dns_forwarding_ruleset_id: ID of the Private DNS Resolver Forwarding Ruleset.
    :param _builtins.str name: Name of the Private DNS Resolver Forwarding Rule.
    """
    __args__ = dict()
    __args__['dnsForwardingRulesetId'] = dns_forwarding_ruleset_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:privatedns/getResolverForwardingRule:getResolverForwardingRule', __args__, opts=opts, typ=GetResolverForwardingRuleResult).value

    return AwaitableGetResolverForwardingRuleResult(
        dns_forwarding_ruleset_id=pulumi.get(__ret__, 'dns_forwarding_ruleset_id'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        target_dns_servers=pulumi.get(__ret__, 'target_dns_servers'))
def get_resolver_forwarding_rule_output(dns_forwarding_ruleset_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        name: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResolverForwardingRuleResult]:
    """
    Gets information about an existing Private DNS Resolver Forwarding Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.privatedns.get_resolver_forwarding_rule(name="example-rule",
        dns_forwarding_ruleset_id="example-forwarding-rulset-id")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network`: 2022-07-01


    :param _builtins.str dns_forwarding_ruleset_id: ID of the Private DNS Resolver Forwarding Ruleset.
    :param _builtins.str name: Name of the Private DNS Resolver Forwarding Rule.
    """
    __args__ = dict()
    __args__['dnsForwardingRulesetId'] = dns_forwarding_ruleset_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:privatedns/getResolverForwardingRule:getResolverForwardingRule', __args__, opts=opts, typ=GetResolverForwardingRuleResult)
    return __ret__.apply(lambda __response__: GetResolverForwardingRuleResult(
        dns_forwarding_ruleset_id=pulumi.get(__response__, 'dns_forwarding_ruleset_id'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        target_dns_servers=pulumi.get(__response__, 'target_dns_servers')))
