# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AssessmentStatusArgs',
    'AssessmentStatusArgsDict',
    'AutomationActionArgs',
    'AutomationActionArgsDict',
    'AutomationSourceArgs',
    'AutomationSourceArgsDict',
    'AutomationSourceRuleSetArgs',
    'AutomationSourceRuleSetArgsDict',
    'AutomationSourceRuleSetRuleArgs',
    'AutomationSourceRuleSetRuleArgsDict',
    'SubscriptionPricingExtensionArgs',
    'SubscriptionPricingExtensionArgsDict',
]

MYPY = False

if not MYPY:
    class AssessmentStatusArgsDict(TypedDict):
        code: pulumi.Input[_builtins.str]
        """
        Specifies the programmatic code of the assessment status. Possible values are `Healthy`, `Unhealthy` and `NotApplicable`.
        """
        cause: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the cause of the assessment status.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the human readable description of the assessment status.
        """
elif False:
    AssessmentStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssessmentStatusArgs:
    def __init__(__self__, *,
                 code: pulumi.Input[_builtins.str],
                 cause: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] code: Specifies the programmatic code of the assessment status. Possible values are `Healthy`, `Unhealthy` and `NotApplicable`.
        :param pulumi.Input[_builtins.str] cause: Specifies the cause of the assessment status.
        :param pulumi.Input[_builtins.str] description: Specifies the human readable description of the assessment status.
        """
        pulumi.set(__self__, "code", code)
        if cause is not None:
            pulumi.set(__self__, "cause", cause)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def code(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the programmatic code of the assessment status. Possible values are `Healthy`, `Unhealthy` and `NotApplicable`.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter
    def cause(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cause of the assessment status.
        """
        return pulumi.get(self, "cause")

    @cause.setter
    def cause(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cause", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the human readable description of the assessment status.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class AutomationActionArgsDict(TypedDict):
        resource_id: pulumi.Input[_builtins.str]
        """
        The resource id of the target Logic App, Event Hub namespace or Log Analytics workspace.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of Azure resource to send data to. Must be set to one of: `logicapp`, `eventhub` or `loganalytics`.
        """
        connection_string: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Optional, but required when `type` is `eventhub`) A connection string to send data to the target Event Hub namespace, this should include a key with send permissions.
        """
        trigger_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Optional, but required when `type` is `logicapp`) The callback URL to trigger the Logic App that will receive and process data sent by this automation. This can be found in the Azure Portal under "See trigger history"
        """
elif False:
    AutomationActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutomationActionArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] resource_id: The resource id of the target Logic App, Event Hub namespace or Log Analytics workspace.
        :param pulumi.Input[_builtins.str] type: Type of Azure resource to send data to. Must be set to one of: `logicapp`, `eventhub` or `loganalytics`.
        :param pulumi.Input[_builtins.str] connection_string: (Optional, but required when `type` is `eventhub`) A connection string to send data to the target Event Hub namespace, this should include a key with send permissions.
        :param pulumi.Input[_builtins.str] trigger_url: (Optional, but required when `type` is `logicapp`) The callback URL to trigger the Logic App that will receive and process data sent by this automation. This can be found in the Azure Portal under "See trigger history"
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "type", type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if trigger_url is not None:
            pulumi.set(__self__, "trigger_url", trigger_url)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource id of the target Logic App, Event Hub namespace or Log Analytics workspace.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of Azure resource to send data to. Must be set to one of: `logicapp`, `eventhub` or `loganalytics`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional, but required when `type` is `eventhub`) A connection string to send data to the target Event Hub namespace, this should include a key with send permissions.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="triggerUrl")
    def trigger_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional, but required when `type` is `logicapp`) The callback URL to trigger the Logic App that will receive and process data sent by this automation. This can be found in the Azure Portal under "See trigger history"
        """
        return pulumi.get(self, "trigger_url")

    @trigger_url.setter
    def trigger_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_url", value)


if not MYPY:
    class AutomationSourceArgsDict(TypedDict):
        event_source: pulumi.Input[_builtins.str]
        """
        Type of data that will trigger this automation. Must be one of `Alerts`, `Assessments`, `AssessmentsSnapshot`, `RegulatoryComplianceAssessment`, `RegulatoryComplianceAssessmentSnapshot`, `SecureScoreControls`, `SecureScoreControlsSnapshot`, `SecureScores`, `SecureScoresSnapshot`, `SubAssessments` or `SubAssessmentsSnapshot`. Note. assessments are also referred to as recommendations
        """
        rule_sets: NotRequired[pulumi.Input[Sequence[pulumi.Input['AutomationSourceRuleSetArgsDict']]]]
        """
        A set of rules which evaluate upon event and data interception. This is defined in one or more `rule_set` blocks as defined below.

        > **Note:** When multiple `rule_set` block are provided, a logical 'OR' is applied to the evaluation of them.
        """
elif False:
    AutomationSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutomationSourceArgs:
    def __init__(__self__, *,
                 event_source: pulumi.Input[_builtins.str],
                 rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input['AutomationSourceRuleSetArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] event_source: Type of data that will trigger this automation. Must be one of `Alerts`, `Assessments`, `AssessmentsSnapshot`, `RegulatoryComplianceAssessment`, `RegulatoryComplianceAssessmentSnapshot`, `SecureScoreControls`, `SecureScoreControlsSnapshot`, `SecureScores`, `SecureScoresSnapshot`, `SubAssessments` or `SubAssessmentsSnapshot`. Note. assessments are also referred to as recommendations
        :param pulumi.Input[Sequence[pulumi.Input['AutomationSourceRuleSetArgs']]] rule_sets: A set of rules which evaluate upon event and data interception. This is defined in one or more `rule_set` blocks as defined below.
               
               > **Note:** When multiple `rule_set` block are provided, a logical 'OR' is applied to the evaluation of them.
        """
        pulumi.set(__self__, "event_source", event_source)
        if rule_sets is not None:
            pulumi.set(__self__, "rule_sets", rule_sets)

    @_builtins.property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> pulumi.Input[_builtins.str]:
        """
        Type of data that will trigger this automation. Must be one of `Alerts`, `Assessments`, `AssessmentsSnapshot`, `RegulatoryComplianceAssessment`, `RegulatoryComplianceAssessmentSnapshot`, `SecureScoreControls`, `SecureScoreControlsSnapshot`, `SecureScores`, `SecureScoresSnapshot`, `SubAssessments` or `SubAssessmentsSnapshot`. Note. assessments are also referred to as recommendations
        """
        return pulumi.get(self, "event_source")

    @event_source.setter
    def event_source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "event_source", value)

    @_builtins.property
    @pulumi.getter(name="ruleSets")
    def rule_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutomationSourceRuleSetArgs']]]]:
        """
        A set of rules which evaluate upon event and data interception. This is defined in one or more `rule_set` blocks as defined below.

        > **Note:** When multiple `rule_set` block are provided, a logical 'OR' is applied to the evaluation of them.
        """
        return pulumi.get(self, "rule_sets")

    @rule_sets.setter
    def rule_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutomationSourceRuleSetArgs']]]]):
        pulumi.set(self, "rule_sets", value)


if not MYPY:
    class AutomationSourceRuleSetArgsDict(TypedDict):
        rules: pulumi.Input[Sequence[pulumi.Input['AutomationSourceRuleSetRuleArgsDict']]]
        """
        One or more `rule` blocks as defined below.

        > **Note:** This automation will trigger when all of the `rule`s in this `rule_set` are evaluated as 'true'. This is equivalent to a logical 'AND'.
        """
elif False:
    AutomationSourceRuleSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutomationSourceRuleSetArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['AutomationSourceRuleSetRuleArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['AutomationSourceRuleSetRuleArgs']]] rules: One or more `rule` blocks as defined below.
               
               > **Note:** This automation will trigger when all of the `rule`s in this `rule_set` are evaluated as 'true'. This is equivalent to a logical 'AND'.
        """
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['AutomationSourceRuleSetRuleArgs']]]:
        """
        One or more `rule` blocks as defined below.

        > **Note:** This automation will trigger when all of the `rule`s in this `rule_set` are evaluated as 'true'. This is equivalent to a logical 'AND'.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['AutomationSourceRuleSetRuleArgs']]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class AutomationSourceRuleSetRuleArgsDict(TypedDict):
        expected_value: pulumi.Input[_builtins.str]
        """
        A value that will be compared with the value in `property_path`.
        """
        operator: pulumi.Input[_builtins.str]
        """
        The comparison operator to use, must be one of: `Contains`, `EndsWith`, `Equals`, `GreaterThan`, `GreaterThanOrEqualTo`, `LesserThan`, `LesserThanOrEqualTo`, `NotEquals`, `StartsWith`
        """
        property_path: pulumi.Input[_builtins.str]
        """
        The JPath of the entity model property that should be checked.
        """
        property_type: pulumi.Input[_builtins.str]
        """
        The data type of the compared operands, must be one of: `Integer`, `String`, `Boolean` or `Number`.

        > **Note:** The schema for Security Center alerts (when `event_source` is "Alerts") [can be found here](https://docs.microsoft.com/azure/security-center/alerts-schemas?tabs=schema-continuousexport)
        """
elif False:
    AutomationSourceRuleSetRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutomationSourceRuleSetRuleArgs:
    def __init__(__self__, *,
                 expected_value: pulumi.Input[_builtins.str],
                 operator: pulumi.Input[_builtins.str],
                 property_path: pulumi.Input[_builtins.str],
                 property_type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] expected_value: A value that will be compared with the value in `property_path`.
        :param pulumi.Input[_builtins.str] operator: The comparison operator to use, must be one of: `Contains`, `EndsWith`, `Equals`, `GreaterThan`, `GreaterThanOrEqualTo`, `LesserThan`, `LesserThanOrEqualTo`, `NotEquals`, `StartsWith`
        :param pulumi.Input[_builtins.str] property_path: The JPath of the entity model property that should be checked.
        :param pulumi.Input[_builtins.str] property_type: The data type of the compared operands, must be one of: `Integer`, `String`, `Boolean` or `Number`.
               
               > **Note:** The schema for Security Center alerts (when `event_source` is "Alerts") [can be found here](https://docs.microsoft.com/azure/security-center/alerts-schemas?tabs=schema-continuousexport)
        """
        pulumi.set(__self__, "expected_value", expected_value)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "property_path", property_path)
        pulumi.set(__self__, "property_type", property_type)

    @_builtins.property
    @pulumi.getter(name="expectedValue")
    def expected_value(self) -> pulumi.Input[_builtins.str]:
        """
        A value that will be compared with the value in `property_path`.
        """
        return pulumi.get(self, "expected_value")

    @expected_value.setter
    def expected_value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expected_value", value)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> pulumi.Input[_builtins.str]:
        """
        The comparison operator to use, must be one of: `Contains`, `EndsWith`, `Equals`, `GreaterThan`, `GreaterThanOrEqualTo`, `LesserThan`, `LesserThanOrEqualTo`, `NotEquals`, `StartsWith`
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "operator", value)

    @_builtins.property
    @pulumi.getter(name="propertyPath")
    def property_path(self) -> pulumi.Input[_builtins.str]:
        """
        The JPath of the entity model property that should be checked.
        """
        return pulumi.get(self, "property_path")

    @property_path.setter
    def property_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "property_path", value)

    @_builtins.property
    @pulumi.getter(name="propertyType")
    def property_type(self) -> pulumi.Input[_builtins.str]:
        """
        The data type of the compared operands, must be one of: `Integer`, `String`, `Boolean` or `Number`.

        > **Note:** The schema for Security Center alerts (when `event_source` is "Alerts") [can be found here](https://docs.microsoft.com/azure/security-center/alerts-schemas?tabs=schema-continuousexport)
        """
        return pulumi.get(self, "property_type")

    @property_type.setter
    def property_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "property_type", value)


if not MYPY:
    class SubscriptionPricingExtensionArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of extension.
        """
        additional_extension_properties: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Key/Value pairs that are required for some extensions.

        > **Note:** If an extension is not defined, it will not be enabled.

        > **Note:** Changing the pricing tier to `Standard` affects all resources of the given type in the subscription and could be quite costly.
        """
elif False:
    SubscriptionPricingExtensionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SubscriptionPricingExtensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 additional_extension_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of extension.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_extension_properties: Key/Value pairs that are required for some extensions.
               
               > **Note:** If an extension is not defined, it will not be enabled.
               
               > **Note:** Changing the pricing tier to `Standard` affects all resources of the given type in the subscription and could be quite costly.
        """
        pulumi.set(__self__, "name", name)
        if additional_extension_properties is not None:
            pulumi.set(__self__, "additional_extension_properties", additional_extension_properties)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of extension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="additionalExtensionProperties")
    def additional_extension_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key/Value pairs that are required for some extensions.

        > **Note:** If an extension is not defined, it will not be enabled.

        > **Note:** Changing the pricing tier to `Standard` affects all resources of the given type in the subscription and could be quite costly.
        """
        return pulumi.get(self, "additional_extension_properties")

    @additional_extension_properties.setter
    def additional_extension_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_extension_properties", value)


