# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServerVulnerabilityAssessmentsSettingArgs', 'ServerVulnerabilityAssessmentsSetting']

@pulumi.input_type
class ServerVulnerabilityAssessmentsSettingArgs:
    def __init__(__self__, *,
                 vulnerability_assessment_provider: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ServerVulnerabilityAssessmentsSetting resource.
        :param pulumi.Input[_builtins.str] vulnerability_assessment_provider: The vulnerability assesment provider to use. The only possible values is `MdeTvm`.
        """
        pulumi.set(__self__, "vulnerability_assessment_provider", vulnerability_assessment_provider)

    @_builtins.property
    @pulumi.getter(name="vulnerabilityAssessmentProvider")
    def vulnerability_assessment_provider(self) -> pulumi.Input[_builtins.str]:
        """
        The vulnerability assesment provider to use. The only possible values is `MdeTvm`.
        """
        return pulumi.get(self, "vulnerability_assessment_provider")

    @vulnerability_assessment_provider.setter
    def vulnerability_assessment_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vulnerability_assessment_provider", value)


@pulumi.input_type
class _ServerVulnerabilityAssessmentsSettingState:
    def __init__(__self__, *,
                 vulnerability_assessment_provider: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerVulnerabilityAssessmentsSetting resources.
        :param pulumi.Input[_builtins.str] vulnerability_assessment_provider: The vulnerability assesment provider to use. The only possible values is `MdeTvm`.
        """
        if vulnerability_assessment_provider is not None:
            pulumi.set(__self__, "vulnerability_assessment_provider", vulnerability_assessment_provider)

    @_builtins.property
    @pulumi.getter(name="vulnerabilityAssessmentProvider")
    def vulnerability_assessment_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vulnerability assesment provider to use. The only possible values is `MdeTvm`.
        """
        return pulumi.get(self, "vulnerability_assessment_provider")

    @vulnerability_assessment_provider.setter
    def vulnerability_assessment_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vulnerability_assessment_provider", value)


@pulumi.type_token("azure:securitycenter/serverVulnerabilityAssessmentsSetting:ServerVulnerabilityAssessmentsSetting")
class ServerVulnerabilityAssessmentsSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 vulnerability_assessment_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the Server Vulnerability Assesments Setting for Azure Security Center.

        > **Note:** This resource requires the `Owner` permission on the Subscription.

        > **Note:** Deletion of this resource disables the setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.securitycenter.ServerVulnerabilityAssessmentsSetting("example", vulnerability_assessment_provider="MdeTvm")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Security`: 2023-05-01

        ## Import

        The setting can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/serverVulnerabilityAssessmentsSetting:ServerVulnerabilityAssessmentsSetting example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/AzureServersSetting
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] vulnerability_assessment_provider: The vulnerability assesment provider to use. The only possible values is `MdeTvm`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerVulnerabilityAssessmentsSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Server Vulnerability Assesments Setting for Azure Security Center.

        > **Note:** This resource requires the `Owner` permission on the Subscription.

        > **Note:** Deletion of this resource disables the setting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.securitycenter.ServerVulnerabilityAssessmentsSetting("example", vulnerability_assessment_provider="MdeTvm")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Security`: 2023-05-01

        ## Import

        The setting can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/serverVulnerabilityAssessmentsSetting:ServerVulnerabilityAssessmentsSetting example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/AzureServersSetting
        ```

        :param str resource_name: The name of the resource.
        :param ServerVulnerabilityAssessmentsSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerVulnerabilityAssessmentsSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 vulnerability_assessment_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerVulnerabilityAssessmentsSettingArgs.__new__(ServerVulnerabilityAssessmentsSettingArgs)

            if vulnerability_assessment_provider is None and not opts.urn:
                raise TypeError("Missing required property 'vulnerability_assessment_provider'")
            __props__.__dict__["vulnerability_assessment_provider"] = vulnerability_assessment_provider
        super(ServerVulnerabilityAssessmentsSetting, __self__).__init__(
            'azure:securitycenter/serverVulnerabilityAssessmentsSetting:ServerVulnerabilityAssessmentsSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            vulnerability_assessment_provider: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServerVulnerabilityAssessmentsSetting':
        """
        Get an existing ServerVulnerabilityAssessmentsSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] vulnerability_assessment_provider: The vulnerability assesment provider to use. The only possible values is `MdeTvm`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerVulnerabilityAssessmentsSettingState.__new__(_ServerVulnerabilityAssessmentsSettingState)

        __props__.__dict__["vulnerability_assessment_provider"] = vulnerability_assessment_provider
        return ServerVulnerabilityAssessmentsSetting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="vulnerabilityAssessmentProvider")
    def vulnerability_assessment_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The vulnerability assesment provider to use. The only possible values is `MdeTvm`.
        """
        return pulumi.get(self, "vulnerability_assessment_provider")

