# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DataConnectorThreatIntelligenceTaxiiArgs', 'DataConnectorThreatIntelligenceTaxii']

@pulumi.input_type
class DataConnectorThreatIntelligenceTaxiiArgs:
    def __init__(__self__, *,
                 api_root_url: pulumi.Input[_builtins.str],
                 collection_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 log_analytics_workspace_id: pulumi.Input[_builtins.str],
                 lookback_date: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 polling_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DataConnectorThreatIntelligenceTaxii resource.
        :param pulumi.Input[_builtins.str] api_root_url: The API root URI of the TAXII server.
        :param pulumi.Input[_builtins.str] collection_id: The collection ID of the TAXII server.
        :param pulumi.Input[_builtins.str] display_name: The friendly name which should be used for this Threat Intelligence TAXII Data Connector.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace that this Threat Intelligence TAXII Data Connector resides in. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        :param pulumi.Input[_builtins.str] lookback_date: The lookback date for the TAXII server in RFC3339. Defaults to `1970-01-01T00:00:00Z`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Threat Intelligence TAXII Data Connector. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        :param pulumi.Input[_builtins.str] password: The password for the TAXII server.
        :param pulumi.Input[_builtins.str] polling_frequency: The polling frequency for the TAXII server. Possible values are `OnceAMinute`, `OnceAnHour` and `OnceADay`. Defaults to `OnceAnHour`.
        :param pulumi.Input[_builtins.str] tenant_id: The ID of the tenant that this Threat Intelligence TAXII Data Connector connects to. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
               
               > **Note:** Currently, only the same tenant as the running account is allowed. Cross-tenant scenario is not supported yet.
        :param pulumi.Input[_builtins.str] user_name: The user name for the TAXII server.
        """
        pulumi.set(__self__, "api_root_url", api_root_url)
        pulumi.set(__self__, "collection_id", collection_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if lookback_date is not None:
            pulumi.set(__self__, "lookback_date", lookback_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if polling_frequency is not None:
            pulumi.set(__self__, "polling_frequency", polling_frequency)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="apiRootUrl")
    def api_root_url(self) -> pulumi.Input[_builtins.str]:
        """
        The API root URI of the TAXII server.
        """
        return pulumi.get(self, "api_root_url")

    @api_root_url.setter
    def api_root_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_root_url", value)

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Input[_builtins.str]:
        """
        The collection ID of the TAXII server.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "collection_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The friendly name which should be used for this Threat Intelligence TAXII Data Connector.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Log Analytics Workspace that this Threat Intelligence TAXII Data Connector resides in. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="lookbackDate")
    def lookback_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lookback date for the TAXII server in RFC3339. Defaults to `1970-01-01T00:00:00Z`.
        """
        return pulumi.get(self, "lookback_date")

    @lookback_date.setter
    def lookback_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lookback_date", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Threat Intelligence TAXII Data Connector. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the TAXII server.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="pollingFrequency")
    def polling_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The polling frequency for the TAXII server. Possible values are `OnceAMinute`, `OnceAnHour` and `OnceADay`. Defaults to `OnceAnHour`.
        """
        return pulumi.get(self, "polling_frequency")

    @polling_frequency.setter
    def polling_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "polling_frequency", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the tenant that this Threat Intelligence TAXII Data Connector connects to. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.

        > **Note:** Currently, only the same tenant as the running account is allowed. Cross-tenant scenario is not supported yet.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user name for the TAXII server.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class _DataConnectorThreatIntelligenceTaxiiState:
    def __init__(__self__, *,
                 api_root_url: Optional[pulumi.Input[_builtins.str]] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lookback_date: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 polling_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataConnectorThreatIntelligenceTaxii resources.
        :param pulumi.Input[_builtins.str] api_root_url: The API root URI of the TAXII server.
        :param pulumi.Input[_builtins.str] collection_id: The collection ID of the TAXII server.
        :param pulumi.Input[_builtins.str] display_name: The friendly name which should be used for this Threat Intelligence TAXII Data Connector.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace that this Threat Intelligence TAXII Data Connector resides in. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        :param pulumi.Input[_builtins.str] lookback_date: The lookback date for the TAXII server in RFC3339. Defaults to `1970-01-01T00:00:00Z`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Threat Intelligence TAXII Data Connector. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        :param pulumi.Input[_builtins.str] password: The password for the TAXII server.
        :param pulumi.Input[_builtins.str] polling_frequency: The polling frequency for the TAXII server. Possible values are `OnceAMinute`, `OnceAnHour` and `OnceADay`. Defaults to `OnceAnHour`.
        :param pulumi.Input[_builtins.str] tenant_id: The ID of the tenant that this Threat Intelligence TAXII Data Connector connects to. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
               
               > **Note:** Currently, only the same tenant as the running account is allowed. Cross-tenant scenario is not supported yet.
        :param pulumi.Input[_builtins.str] user_name: The user name for the TAXII server.
        """
        if api_root_url is not None:
            pulumi.set(__self__, "api_root_url", api_root_url)
        if collection_id is not None:
            pulumi.set(__self__, "collection_id", collection_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if lookback_date is not None:
            pulumi.set(__self__, "lookback_date", lookback_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if polling_frequency is not None:
            pulumi.set(__self__, "polling_frequency", polling_frequency)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="apiRootUrl")
    def api_root_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API root URI of the TAXII server.
        """
        return pulumi.get(self, "api_root_url")

    @api_root_url.setter
    def api_root_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_root_url", value)

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The collection ID of the TAXII server.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collection_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The friendly name which should be used for this Threat Intelligence TAXII Data Connector.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Log Analytics Workspace that this Threat Intelligence TAXII Data Connector resides in. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="lookbackDate")
    def lookback_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lookback date for the TAXII server in RFC3339. Defaults to `1970-01-01T00:00:00Z`.
        """
        return pulumi.get(self, "lookback_date")

    @lookback_date.setter
    def lookback_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lookback_date", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Threat Intelligence TAXII Data Connector. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the TAXII server.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="pollingFrequency")
    def polling_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The polling frequency for the TAXII server. Possible values are `OnceAMinute`, `OnceAnHour` and `OnceADay`. Defaults to `OnceAnHour`.
        """
        return pulumi.get(self, "polling_frequency")

    @polling_frequency.setter
    def polling_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "polling_frequency", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the tenant that this Threat Intelligence TAXII Data Connector connects to. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.

        > **Note:** Currently, only the same tenant as the running account is allowed. Cross-tenant scenario is not supported yet.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user name for the TAXII server.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("azure:sentinel/dataConnectorThreatIntelligenceTaxii:DataConnectorThreatIntelligenceTaxii")
class DataConnectorThreatIntelligenceTaxii(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_root_url: Optional[pulumi.Input[_builtins.str]] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lookback_date: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 polling_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Threat Intelligence TAXII Data Connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_data_connector_threat_intelligence_taxii = azure.sentinel.DataConnectorThreatIntelligenceTaxii("example",
            name="example",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="example",
            api_root_url="https://foo/taxii2/api2/",
            collection_id="someid")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2022-10-01

        ## Import

        Threat Intelligence TAXII Data Connectors can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/dataConnectorThreatIntelligenceTaxii:DataConnectorThreatIntelligenceTaxii example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/dataConnectors/dc1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_root_url: The API root URI of the TAXII server.
        :param pulumi.Input[_builtins.str] collection_id: The collection ID of the TAXII server.
        :param pulumi.Input[_builtins.str] display_name: The friendly name which should be used for this Threat Intelligence TAXII Data Connector.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace that this Threat Intelligence TAXII Data Connector resides in. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        :param pulumi.Input[_builtins.str] lookback_date: The lookback date for the TAXII server in RFC3339. Defaults to `1970-01-01T00:00:00Z`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Threat Intelligence TAXII Data Connector. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        :param pulumi.Input[_builtins.str] password: The password for the TAXII server.
        :param pulumi.Input[_builtins.str] polling_frequency: The polling frequency for the TAXII server. Possible values are `OnceAMinute`, `OnceAnHour` and `OnceADay`. Defaults to `OnceAnHour`.
        :param pulumi.Input[_builtins.str] tenant_id: The ID of the tenant that this Threat Intelligence TAXII Data Connector connects to. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
               
               > **Note:** Currently, only the same tenant as the running account is allowed. Cross-tenant scenario is not supported yet.
        :param pulumi.Input[_builtins.str] user_name: The user name for the TAXII server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataConnectorThreatIntelligenceTaxiiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Threat Intelligence TAXII Data Connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_data_connector_threat_intelligence_taxii = azure.sentinel.DataConnectorThreatIntelligenceTaxii("example",
            name="example",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="example",
            api_root_url="https://foo/taxii2/api2/",
            collection_id="someid")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2022-10-01

        ## Import

        Threat Intelligence TAXII Data Connectors can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/dataConnectorThreatIntelligenceTaxii:DataConnectorThreatIntelligenceTaxii example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/dataConnectors/dc1
        ```

        :param str resource_name: The name of the resource.
        :param DataConnectorThreatIntelligenceTaxiiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataConnectorThreatIntelligenceTaxiiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_root_url: Optional[pulumi.Input[_builtins.str]] = None,
                 collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lookback_date: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 polling_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataConnectorThreatIntelligenceTaxiiArgs.__new__(DataConnectorThreatIntelligenceTaxiiArgs)

            if api_root_url is None and not opts.urn:
                raise TypeError("Missing required property 'api_root_url'")
            __props__.__dict__["api_root_url"] = api_root_url
            if collection_id is None and not opts.urn:
                raise TypeError("Missing required property 'collection_id'")
            __props__.__dict__["collection_id"] = collection_id
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if log_analytics_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_analytics_workspace_id'")
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            __props__.__dict__["lookback_date"] = lookback_date
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["polling_frequency"] = polling_frequency
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["user_name"] = None if user_name is None else pulumi.Output.secret(user_name)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "userName"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DataConnectorThreatIntelligenceTaxii, __self__).__init__(
            'azure:sentinel/dataConnectorThreatIntelligenceTaxii:DataConnectorThreatIntelligenceTaxii',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_root_url: Optional[pulumi.Input[_builtins.str]] = None,
            collection_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            lookback_date: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            polling_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'DataConnectorThreatIntelligenceTaxii':
        """
        Get an existing DataConnectorThreatIntelligenceTaxii resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_root_url: The API root URI of the TAXII server.
        :param pulumi.Input[_builtins.str] collection_id: The collection ID of the TAXII server.
        :param pulumi.Input[_builtins.str] display_name: The friendly name which should be used for this Threat Intelligence TAXII Data Connector.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace that this Threat Intelligence TAXII Data Connector resides in. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        :param pulumi.Input[_builtins.str] lookback_date: The lookback date for the TAXII server in RFC3339. Defaults to `1970-01-01T00:00:00Z`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Threat Intelligence TAXII Data Connector. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        :param pulumi.Input[_builtins.str] password: The password for the TAXII server.
        :param pulumi.Input[_builtins.str] polling_frequency: The polling frequency for the TAXII server. Possible values are `OnceAMinute`, `OnceAnHour` and `OnceADay`. Defaults to `OnceAnHour`.
        :param pulumi.Input[_builtins.str] tenant_id: The ID of the tenant that this Threat Intelligence TAXII Data Connector connects to. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
               
               > **Note:** Currently, only the same tenant as the running account is allowed. Cross-tenant scenario is not supported yet.
        :param pulumi.Input[_builtins.str] user_name: The user name for the TAXII server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataConnectorThreatIntelligenceTaxiiState.__new__(_DataConnectorThreatIntelligenceTaxiiState)

        __props__.__dict__["api_root_url"] = api_root_url
        __props__.__dict__["collection_id"] = collection_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["lookback_date"] = lookback_date
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["polling_frequency"] = polling_frequency
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["user_name"] = user_name
        return DataConnectorThreatIntelligenceTaxii(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiRootUrl")
    def api_root_url(self) -> pulumi.Output[_builtins.str]:
        """
        The API root URI of the TAXII server.
        """
        return pulumi.get(self, "api_root_url")

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The collection ID of the TAXII server.
        """
        return pulumi.get(self, "collection_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The friendly name which should be used for this Threat Intelligence TAXII Data Connector.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Log Analytics Workspace that this Threat Intelligence TAXII Data Connector resides in. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @_builtins.property
    @pulumi.getter(name="lookbackDate")
    def lookback_date(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The lookback date for the TAXII server in RFC3339. Defaults to `1970-01-01T00:00:00Z`.
        """
        return pulumi.get(self, "lookback_date")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Threat Intelligence TAXII Data Connector. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password for the TAXII server.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="pollingFrequency")
    def polling_frequency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The polling frequency for the TAXII server. Possible values are `OnceAMinute`, `OnceAnHour` and `OnceADay`. Defaults to `OnceAnHour`.
        """
        return pulumi.get(self, "polling_frequency")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the tenant that this Threat Intelligence TAXII Data Connector connects to. Changing this forces a new Threat Intelligence TAXII Data Connector to be created.

        > **Note:** Currently, only the same tenant as the running account is allowed. Cross-tenant scenario is not supported yet.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user name for the TAXII server.
        """
        return pulumi.get(self, "user_name")

