# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ThreatIntelligenceIndicatorArgs', 'ThreatIntelligenceIndicator']

@pulumi.input_type
class ThreatIntelligenceIndicatorArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 pattern: pulumi.Input[_builtins.str],
                 pattern_type: pulumi.Input[_builtins.str],
                 source: pulumi.Input[_builtins.str],
                 validate_from_utc: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 confidence: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 extension: Optional[pulumi.Input[_builtins.str]] = None,
                 external_references: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]] = None,
                 granular_markings: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]] = None,
                 kill_chain_phases: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 object_marking_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pattern_version: Optional[pulumi.Input[_builtins.str]] = None,
                 revoked: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 threat_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 validate_until_utc: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ThreatIntelligenceIndicator resource.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] pattern: The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        :param pulumi.Input[_builtins.str] pattern_type: The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        :param pulumi.Input[_builtins.str] source: Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] validate_from_utc: The start of validate date in RFC3339.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        :param pulumi.Input[_builtins.int] confidence: Confidence levels of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] created_by: The creator of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] description: The description of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] extension: The extension config of the Threat Intelligence Indicator in JSON format.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]] external_references: One or more `external_reference` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]] granular_markings: One or more `granular_marking` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]] kill_chain_phases: One or more `kill_chain_phase` blocks as defined below.
        :param pulumi.Input[_builtins.str] language: The language of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_marking_refs: Specifies a list of Threat Intelligence marking references.
        :param pulumi.Input[_builtins.str] pattern_version: The version of a Threat Intelligence entity.
        :param pulumi.Input[_builtins.bool] revoked: Whether the Threat Intelligence entity revoked.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Specifies a list of tags of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] threat_types: Specifies a list of threat types of this Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] validate_until_utc: The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "pattern_type", pattern_type)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "validate_from_utc", validate_from_utc)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if confidence is not None:
            pulumi.set(__self__, "confidence", confidence)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if external_references is not None:
            pulumi.set(__self__, "external_references", external_references)
        if granular_markings is not None:
            pulumi.set(__self__, "granular_markings", granular_markings)
        if kill_chain_phases is not None:
            pulumi.set(__self__, "kill_chain_phases", kill_chain_phases)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if object_marking_refs is not None:
            pulumi.set(__self__, "object_marking_refs", object_marking_refs)
        if pattern_version is not None:
            pulumi.set(__self__, "pattern_version", pattern_version)
        if revoked is not None:
            pulumi.set(__self__, "revoked", revoked)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_types is not None:
            pulumi.set(__self__, "threat_types", threat_types)
        if validate_until_utc is not None:
            pulumi.set(__self__, "validate_until_utc", validate_until_utc)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> pulumi.Input[_builtins.str]:
        """
        The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        """
        return pulumi.get(self, "pattern_type")

    @pattern_type.setter
    def pattern_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pattern_type", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="validateFromUtc")
    def validate_from_utc(self) -> pulumi.Input[_builtins.str]:
        """
        The start of validate date in RFC3339.
        """
        return pulumi.get(self, "validate_from_utc")

    @validate_from_utc.setter
    def validate_from_utc(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "validate_from_utc", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def confidence(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Confidence levels of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "confidence")

    @confidence.setter
    def confidence(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "confidence", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creator of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extension config of the Threat Intelligence Indicator in JSON format.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extension", value)

    @_builtins.property
    @pulumi.getter(name="externalReferences")
    def external_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]]:
        """
        One or more `external_reference` blocks as defined below.
        """
        return pulumi.get(self, "external_references")

    @external_references.setter
    def external_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]]):
        pulumi.set(self, "external_references", value)

    @_builtins.property
    @pulumi.getter(name="granularMarkings")
    def granular_markings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]]:
        """
        One or more `granular_marking` blocks as defined below.
        """
        return pulumi.get(self, "granular_markings")

    @granular_markings.setter
    def granular_markings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]]):
        pulumi.set(self, "granular_markings", value)

    @_builtins.property
    @pulumi.getter(name="killChainPhases")
    def kill_chain_phases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]]:
        """
        One or more `kill_chain_phase` blocks as defined below.
        """
        return pulumi.get(self, "kill_chain_phases")

    @kill_chain_phases.setter
    def kill_chain_phases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]]):
        pulumi.set(self, "kill_chain_phases", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter(name="objectMarkingRefs")
    def object_marking_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Threat Intelligence marking references.
        """
        return pulumi.get(self, "object_marking_refs")

    @object_marking_refs.setter
    def object_marking_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "object_marking_refs", value)

    @_builtins.property
    @pulumi.getter(name="patternVersion")
    def pattern_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of a Threat Intelligence entity.
        """
        return pulumi.get(self, "pattern_version")

    @pattern_version.setter
    def pattern_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern_version", value)

    @_builtins.property
    @pulumi.getter
    def revoked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Threat Intelligence entity revoked.
        """
        return pulumi.get(self, "revoked")

    @revoked.setter
    def revoked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "revoked", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of tags of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="threatTypes")
    def threat_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of threat types of this Threat Intelligence Indicator.
        """
        return pulumi.get(self, "threat_types")

    @threat_types.setter
    def threat_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "threat_types", value)

    @_builtins.property
    @pulumi.getter(name="validateUntilUtc")
    def validate_until_utc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        """
        return pulumi.get(self, "validate_until_utc")

    @validate_until_utc.setter
    def validate_until_utc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validate_until_utc", value)


@pulumi.input_type
class _ThreatIntelligenceIndicatorState:
    def __init__(__self__, *,
                 confidence: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 defanged: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extension: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_last_updated_time_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 external_references: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]] = None,
                 granular_markings: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]] = None,
                 guid: Optional[pulumi.Input[_builtins.str]] = None,
                 indicator_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 kill_chain_phases: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_time_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 object_marking_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parsed_patterns: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorParsedPatternArgs']]]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_version: Optional[pulumi.Input[_builtins.str]] = None,
                 revoked: Optional[pulumi.Input[_builtins.bool]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 threat_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 validate_from_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 validate_until_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ThreatIntelligenceIndicator resources.
        :param pulumi.Input[_builtins.int] confidence: Confidence levels of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] created_by: The creator of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] created_on: The date of this Threat Intelligence Indicator created.
        :param pulumi.Input[_builtins.bool] defanged: Whether the Threat Intelligence entity is defanged?
        :param pulumi.Input[_builtins.str] description: The description of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] extension: The extension config of the Threat Intelligence Indicator in JSON format.
        :param pulumi.Input[_builtins.str] external_id: The external ID of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] external_last_updated_time_utc: the External last updated time in UTC.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]] external_references: One or more `external_reference` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]] granular_markings: One or more `granular_marking` blocks as defined below.
        :param pulumi.Input[_builtins.str] guid: The guid of this Sentinel Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] indicator_types: A list of indicator types of this Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]] kill_chain_phases: One or more `kill_chain_phase` blocks as defined below.
        :param pulumi.Input[_builtins.str] language: The language of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] last_updated_time_utc: The last updated time of the Threat Intelligence Indicator in UTC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_marking_refs: Specifies a list of Threat Intelligence marking references.
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorParsedPatternArgs']]] parsed_patterns: A `parsed_pattern` block as defined below.
        :param pulumi.Input[_builtins.str] pattern: The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        :param pulumi.Input[_builtins.str] pattern_type: The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        :param pulumi.Input[_builtins.str] pattern_version: The version of a Threat Intelligence entity.
        :param pulumi.Input[_builtins.bool] revoked: Whether the Threat Intelligence entity revoked.
        :param pulumi.Input[_builtins.str] source: Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Specifies a list of tags of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] threat_types: Specifies a list of threat types of this Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] validate_from_utc: The start of validate date in RFC3339.
        :param pulumi.Input[_builtins.str] validate_until_utc: The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        if confidence is not None:
            pulumi.set(__self__, "confidence", confidence)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if defanged is not None:
            pulumi.set(__self__, "defanged", defanged)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if external_last_updated_time_utc is not None:
            pulumi.set(__self__, "external_last_updated_time_utc", external_last_updated_time_utc)
        if external_references is not None:
            pulumi.set(__self__, "external_references", external_references)
        if granular_markings is not None:
            pulumi.set(__self__, "granular_markings", granular_markings)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if indicator_types is not None:
            pulumi.set(__self__, "indicator_types", indicator_types)
        if kill_chain_phases is not None:
            pulumi.set(__self__, "kill_chain_phases", kill_chain_phases)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if last_updated_time_utc is not None:
            pulumi.set(__self__, "last_updated_time_utc", last_updated_time_utc)
        if object_marking_refs is not None:
            pulumi.set(__self__, "object_marking_refs", object_marking_refs)
        if parsed_patterns is not None:
            pulumi.set(__self__, "parsed_patterns", parsed_patterns)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if pattern_type is not None:
            pulumi.set(__self__, "pattern_type", pattern_type)
        if pattern_version is not None:
            pulumi.set(__self__, "pattern_version", pattern_version)
        if revoked is not None:
            pulumi.set(__self__, "revoked", revoked)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threat_types is not None:
            pulumi.set(__self__, "threat_types", threat_types)
        if validate_from_utc is not None:
            pulumi.set(__self__, "validate_from_utc", validate_from_utc)
        if validate_until_utc is not None:
            pulumi.set(__self__, "validate_until_utc", validate_until_utc)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def confidence(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Confidence levels of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "confidence")

    @confidence.setter
    def confidence(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "confidence", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creator of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date of this Threat Intelligence Indicator created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def defanged(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Threat Intelligence entity is defanged?
        """
        return pulumi.get(self, "defanged")

    @defanged.setter
    def defanged(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "defanged", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extension config of the Threat Intelligence Indicator in JSON format.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extension", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The external ID of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter(name="externalLastUpdatedTimeUtc")
    def external_last_updated_time_utc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the External last updated time in UTC.
        """
        return pulumi.get(self, "external_last_updated_time_utc")

    @external_last_updated_time_utc.setter
    def external_last_updated_time_utc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_last_updated_time_utc", value)

    @_builtins.property
    @pulumi.getter(name="externalReferences")
    def external_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]]:
        """
        One or more `external_reference` blocks as defined below.
        """
        return pulumi.get(self, "external_references")

    @external_references.setter
    def external_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorExternalReferenceArgs']]]]):
        pulumi.set(self, "external_references", value)

    @_builtins.property
    @pulumi.getter(name="granularMarkings")
    def granular_markings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]]:
        """
        One or more `granular_marking` blocks as defined below.
        """
        return pulumi.get(self, "granular_markings")

    @granular_markings.setter
    def granular_markings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorGranularMarkingArgs']]]]):
        pulumi.set(self, "granular_markings", value)

    @_builtins.property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The guid of this Sentinel Threat Intelligence Indicator.
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guid", value)

    @_builtins.property
    @pulumi.getter(name="indicatorTypes")
    def indicator_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of indicator types of this Threat Intelligence Indicator.
        """
        return pulumi.get(self, "indicator_types")

    @indicator_types.setter
    def indicator_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "indicator_types", value)

    @_builtins.property
    @pulumi.getter(name="killChainPhases")
    def kill_chain_phases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]]:
        """
        One or more `kill_chain_phase` blocks as defined below.
        """
        return pulumi.get(self, "kill_chain_phases")

    @kill_chain_phases.setter
    def kill_chain_phases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorKillChainPhaseArgs']]]]):
        pulumi.set(self, "kill_chain_phases", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTimeUtc")
    def last_updated_time_utc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last updated time of the Threat Intelligence Indicator in UTC.
        """
        return pulumi.get(self, "last_updated_time_utc")

    @last_updated_time_utc.setter
    def last_updated_time_utc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_time_utc", value)

    @_builtins.property
    @pulumi.getter(name="objectMarkingRefs")
    def object_marking_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Threat Intelligence marking references.
        """
        return pulumi.get(self, "object_marking_refs")

    @object_marking_refs.setter
    def object_marking_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "object_marking_refs", value)

    @_builtins.property
    @pulumi.getter(name="parsedPatterns")
    def parsed_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorParsedPatternArgs']]]]:
        """
        A `parsed_pattern` block as defined below.
        """
        return pulumi.get(self, "parsed_patterns")

    @parsed_patterns.setter
    def parsed_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceIndicatorParsedPatternArgs']]]]):
        pulumi.set(self, "parsed_patterns", value)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        """
        return pulumi.get(self, "pattern_type")

    @pattern_type.setter
    def pattern_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern_type", value)

    @_builtins.property
    @pulumi.getter(name="patternVersion")
    def pattern_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of a Threat Intelligence entity.
        """
        return pulumi.get(self, "pattern_version")

    @pattern_version.setter
    def pattern_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern_version", value)

    @_builtins.property
    @pulumi.getter
    def revoked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Threat Intelligence entity revoked.
        """
        return pulumi.get(self, "revoked")

    @revoked.setter
    def revoked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "revoked", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of tags of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="threatTypes")
    def threat_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of threat types of this Threat Intelligence Indicator.
        """
        return pulumi.get(self, "threat_types")

    @threat_types.setter
    def threat_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "threat_types", value)

    @_builtins.property
    @pulumi.getter(name="validateFromUtc")
    def validate_from_utc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start of validate date in RFC3339.
        """
        return pulumi.get(self, "validate_from_utc")

    @validate_from_utc.setter
    def validate_from_utc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validate_from_utc", value)

    @_builtins.property
    @pulumi.getter(name="validateUntilUtc")
    def validate_until_utc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        """
        return pulumi.get(self, "validate_until_utc")

    @validate_until_utc.setter
    def validate_until_utc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validate_until_utc", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:sentinel/threatIntelligenceIndicator:ThreatIntelligenceIndicator")
class ThreatIntelligenceIndicator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 confidence: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extension: Optional[pulumi.Input[_builtins.str]] = None,
                 external_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorExternalReferenceArgs', 'ThreatIntelligenceIndicatorExternalReferenceArgsDict']]]]] = None,
                 granular_markings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorGranularMarkingArgs', 'ThreatIntelligenceIndicatorGranularMarkingArgsDict']]]]] = None,
                 kill_chain_phases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorKillChainPhaseArgs', 'ThreatIntelligenceIndicatorKillChainPhaseArgsDict']]]]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 object_marking_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_version: Optional[pulumi.Input[_builtins.str]] = None,
                 revoked: Optional[pulumi.Input[_builtins.bool]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 threat_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 validate_from_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 validate_until_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Sentinel Threat Intelligence Indicator.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="east us")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-law",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_threat_intelligence_indicator = azure.sentinel.ThreatIntelligenceIndicator("example",
            workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            pattern_type="domain-name",
            pattern="http://example.com",
            source="Microsoft Sentinel",
            validate_from_utc="2022-12-14T16:00:00Z",
            display_name="example-indicator")
        ```

        ## Import

        Sentinel Threat Intelligence Indicators can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/threatIntelligenceIndicator:ThreatIntelligenceIndicator example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourcegroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/threatIntelligence/main/indicators/indicator1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] confidence: Confidence levels of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] created_by: The creator of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] description: The description of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] extension: The extension config of the Threat Intelligence Indicator in JSON format.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorExternalReferenceArgs', 'ThreatIntelligenceIndicatorExternalReferenceArgsDict']]]] external_references: One or more `external_reference` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorGranularMarkingArgs', 'ThreatIntelligenceIndicatorGranularMarkingArgsDict']]]] granular_markings: One or more `granular_marking` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorKillChainPhaseArgs', 'ThreatIntelligenceIndicatorKillChainPhaseArgsDict']]]] kill_chain_phases: One or more `kill_chain_phase` blocks as defined below.
        :param pulumi.Input[_builtins.str] language: The language of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_marking_refs: Specifies a list of Threat Intelligence marking references.
        :param pulumi.Input[_builtins.str] pattern: The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        :param pulumi.Input[_builtins.str] pattern_type: The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        :param pulumi.Input[_builtins.str] pattern_version: The version of a Threat Intelligence entity.
        :param pulumi.Input[_builtins.bool] revoked: Whether the Threat Intelligence entity revoked.
        :param pulumi.Input[_builtins.str] source: Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Specifies a list of tags of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] threat_types: Specifies a list of threat types of this Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] validate_from_utc: The start of validate date in RFC3339.
        :param pulumi.Input[_builtins.str] validate_until_utc: The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ThreatIntelligenceIndicatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Sentinel Threat Intelligence Indicator.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="east us")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-law",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_threat_intelligence_indicator = azure.sentinel.ThreatIntelligenceIndicator("example",
            workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            pattern_type="domain-name",
            pattern="http://example.com",
            source="Microsoft Sentinel",
            validate_from_utc="2022-12-14T16:00:00Z",
            display_name="example-indicator")
        ```

        ## Import

        Sentinel Threat Intelligence Indicators can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/threatIntelligenceIndicator:ThreatIntelligenceIndicator example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourcegroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/threatIntelligence/main/indicators/indicator1
        ```

        :param str resource_name: The name of the resource.
        :param ThreatIntelligenceIndicatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThreatIntelligenceIndicatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 confidence: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extension: Optional[pulumi.Input[_builtins.str]] = None,
                 external_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorExternalReferenceArgs', 'ThreatIntelligenceIndicatorExternalReferenceArgsDict']]]]] = None,
                 granular_markings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorGranularMarkingArgs', 'ThreatIntelligenceIndicatorGranularMarkingArgsDict']]]]] = None,
                 kill_chain_phases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorKillChainPhaseArgs', 'ThreatIntelligenceIndicatorKillChainPhaseArgsDict']]]]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 object_marking_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_version: Optional[pulumi.Input[_builtins.str]] = None,
                 revoked: Optional[pulumi.Input[_builtins.bool]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 threat_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 validate_from_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 validate_until_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThreatIntelligenceIndicatorArgs.__new__(ThreatIntelligenceIndicatorArgs)

            __props__.__dict__["confidence"] = confidence
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["extension"] = extension
            __props__.__dict__["external_references"] = external_references
            __props__.__dict__["granular_markings"] = granular_markings
            __props__.__dict__["kill_chain_phases"] = kill_chain_phases
            __props__.__dict__["language"] = language
            __props__.__dict__["object_marking_refs"] = object_marking_refs
            if pattern is None and not opts.urn:
                raise TypeError("Missing required property 'pattern'")
            __props__.__dict__["pattern"] = pattern
            if pattern_type is None and not opts.urn:
                raise TypeError("Missing required property 'pattern_type'")
            __props__.__dict__["pattern_type"] = pattern_type
            __props__.__dict__["pattern_version"] = pattern_version
            __props__.__dict__["revoked"] = revoked
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
            __props__.__dict__["threat_types"] = threat_types
            if validate_from_utc is None and not opts.urn:
                raise TypeError("Missing required property 'validate_from_utc'")
            __props__.__dict__["validate_from_utc"] = validate_from_utc
            __props__.__dict__["validate_until_utc"] = validate_until_utc
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["defanged"] = None
            __props__.__dict__["external_id"] = None
            __props__.__dict__["external_last_updated_time_utc"] = None
            __props__.__dict__["guid"] = None
            __props__.__dict__["indicator_types"] = None
            __props__.__dict__["last_updated_time_utc"] = None
            __props__.__dict__["parsed_patterns"] = None
        super(ThreatIntelligenceIndicator, __self__).__init__(
            'azure:sentinel/threatIntelligenceIndicator:ThreatIntelligenceIndicator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            confidence: Optional[pulumi.Input[_builtins.int]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            defanged: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            extension: Optional[pulumi.Input[_builtins.str]] = None,
            external_id: Optional[pulumi.Input[_builtins.str]] = None,
            external_last_updated_time_utc: Optional[pulumi.Input[_builtins.str]] = None,
            external_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorExternalReferenceArgs', 'ThreatIntelligenceIndicatorExternalReferenceArgsDict']]]]] = None,
            granular_markings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorGranularMarkingArgs', 'ThreatIntelligenceIndicatorGranularMarkingArgsDict']]]]] = None,
            guid: Optional[pulumi.Input[_builtins.str]] = None,
            indicator_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            kill_chain_phases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorKillChainPhaseArgs', 'ThreatIntelligenceIndicatorKillChainPhaseArgsDict']]]]] = None,
            language: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_time_utc: Optional[pulumi.Input[_builtins.str]] = None,
            object_marking_refs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            parsed_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorParsedPatternArgs', 'ThreatIntelligenceIndicatorParsedPatternArgsDict']]]]] = None,
            pattern: Optional[pulumi.Input[_builtins.str]] = None,
            pattern_type: Optional[pulumi.Input[_builtins.str]] = None,
            pattern_version: Optional[pulumi.Input[_builtins.str]] = None,
            revoked: Optional[pulumi.Input[_builtins.bool]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            threat_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            validate_from_utc: Optional[pulumi.Input[_builtins.str]] = None,
            validate_until_utc: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ThreatIntelligenceIndicator':
        """
        Get an existing ThreatIntelligenceIndicator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] confidence: Confidence levels of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] created_by: The creator of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] created_on: The date of this Threat Intelligence Indicator created.
        :param pulumi.Input[_builtins.bool] defanged: Whether the Threat Intelligence entity is defanged?
        :param pulumi.Input[_builtins.str] description: The description of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] extension: The extension config of the Threat Intelligence Indicator in JSON format.
        :param pulumi.Input[_builtins.str] external_id: The external ID of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] external_last_updated_time_utc: the External last updated time in UTC.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorExternalReferenceArgs', 'ThreatIntelligenceIndicatorExternalReferenceArgsDict']]]] external_references: One or more `external_reference` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorGranularMarkingArgs', 'ThreatIntelligenceIndicatorGranularMarkingArgsDict']]]] granular_markings: One or more `granular_marking` blocks as defined below.
        :param pulumi.Input[_builtins.str] guid: The guid of this Sentinel Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] indicator_types: A list of indicator types of this Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorKillChainPhaseArgs', 'ThreatIntelligenceIndicatorKillChainPhaseArgsDict']]]] kill_chain_phases: One or more `kill_chain_phase` blocks as defined below.
        :param pulumi.Input[_builtins.str] language: The language of the Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] last_updated_time_utc: The last updated time of the Threat Intelligence Indicator in UTC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] object_marking_refs: Specifies a list of Threat Intelligence marking references.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThreatIntelligenceIndicatorParsedPatternArgs', 'ThreatIntelligenceIndicatorParsedPatternArgsDict']]]] parsed_patterns: A `parsed_pattern` block as defined below.
        :param pulumi.Input[_builtins.str] pattern: The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        :param pulumi.Input[_builtins.str] pattern_type: The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        :param pulumi.Input[_builtins.str] pattern_version: The version of a Threat Intelligence entity.
        :param pulumi.Input[_builtins.bool] revoked: Whether the Threat Intelligence entity revoked.
        :param pulumi.Input[_builtins.str] source: Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Specifies a list of tags of the Threat Intelligence Indicator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] threat_types: Specifies a list of threat types of this Threat Intelligence Indicator.
        :param pulumi.Input[_builtins.str] validate_from_utc: The start of validate date in RFC3339.
        :param pulumi.Input[_builtins.str] validate_until_utc: The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ThreatIntelligenceIndicatorState.__new__(_ThreatIntelligenceIndicatorState)

        __props__.__dict__["confidence"] = confidence
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["defanged"] = defanged
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["extension"] = extension
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["external_last_updated_time_utc"] = external_last_updated_time_utc
        __props__.__dict__["external_references"] = external_references
        __props__.__dict__["granular_markings"] = granular_markings
        __props__.__dict__["guid"] = guid
        __props__.__dict__["indicator_types"] = indicator_types
        __props__.__dict__["kill_chain_phases"] = kill_chain_phases
        __props__.__dict__["language"] = language
        __props__.__dict__["last_updated_time_utc"] = last_updated_time_utc
        __props__.__dict__["object_marking_refs"] = object_marking_refs
        __props__.__dict__["parsed_patterns"] = parsed_patterns
        __props__.__dict__["pattern"] = pattern
        __props__.__dict__["pattern_type"] = pattern_type
        __props__.__dict__["pattern_version"] = pattern_version
        __props__.__dict__["revoked"] = revoked
        __props__.__dict__["source"] = source
        __props__.__dict__["tags"] = tags
        __props__.__dict__["threat_types"] = threat_types
        __props__.__dict__["validate_from_utc"] = validate_from_utc
        __props__.__dict__["validate_until_utc"] = validate_until_utc
        __props__.__dict__["workspace_id"] = workspace_id
        return ThreatIntelligenceIndicator(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def confidence(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Confidence levels of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "confidence")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The creator of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        The date of this Threat Intelligence Indicator created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def defanged(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the Threat Intelligence entity is defanged?
        """
        return pulumi.get(self, "defanged")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def extension(self) -> pulumi.Output[_builtins.str]:
        """
        The extension config of the Threat Intelligence Indicator in JSON format.
        """
        return pulumi.get(self, "extension")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[_builtins.str]:
        """
        The external ID of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter(name="externalLastUpdatedTimeUtc")
    def external_last_updated_time_utc(self) -> pulumi.Output[_builtins.str]:
        """
        the External last updated time in UTC.
        """
        return pulumi.get(self, "external_last_updated_time_utc")

    @_builtins.property
    @pulumi.getter(name="externalReferences")
    def external_references(self) -> pulumi.Output[Optional[Sequence['outputs.ThreatIntelligenceIndicatorExternalReference']]]:
        """
        One or more `external_reference` blocks as defined below.
        """
        return pulumi.get(self, "external_references")

    @_builtins.property
    @pulumi.getter(name="granularMarkings")
    def granular_markings(self) -> pulumi.Output[Optional[Sequence['outputs.ThreatIntelligenceIndicatorGranularMarking']]]:
        """
        One or more `granular_marking` blocks as defined below.
        """
        return pulumi.get(self, "granular_markings")

    @_builtins.property
    @pulumi.getter
    def guid(self) -> pulumi.Output[_builtins.str]:
        """
        The guid of this Sentinel Threat Intelligence Indicator.
        """
        return pulumi.get(self, "guid")

    @_builtins.property
    @pulumi.getter(name="indicatorTypes")
    def indicator_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of indicator types of this Threat Intelligence Indicator.
        """
        return pulumi.get(self, "indicator_types")

    @_builtins.property
    @pulumi.getter(name="killChainPhases")
    def kill_chain_phases(self) -> pulumi.Output[Optional[Sequence['outputs.ThreatIntelligenceIndicatorKillChainPhase']]]:
        """
        One or more `kill_chain_phase` blocks as defined below.
        """
        return pulumi.get(self, "kill_chain_phases")

    @_builtins.property
    @pulumi.getter
    def language(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The language of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTimeUtc")
    def last_updated_time_utc(self) -> pulumi.Output[_builtins.str]:
        """
        The last updated time of the Threat Intelligence Indicator in UTC.
        """
        return pulumi.get(self, "last_updated_time_utc")

    @_builtins.property
    @pulumi.getter(name="objectMarkingRefs")
    def object_marking_refs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Threat Intelligence marking references.
        """
        return pulumi.get(self, "object_marking_refs")

    @_builtins.property
    @pulumi.getter(name="parsedPatterns")
    def parsed_patterns(self) -> pulumi.Output[Sequence['outputs.ThreatIntelligenceIndicatorParsedPattern']]:
        """
        A `parsed_pattern` block as defined below.
        """
        return pulumi.get(self, "parsed_patterns")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> pulumi.Output[_builtins.str]:
        """
        The pattern used by the Threat Intelligence Indicator. When `pattern_type` set to `file`, `pattern` must be specified with `<HashName>:<Value>` format, such as `MD5:78ecc5c05cd8b79af480df2f8fba0b9d`.
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of pattern used by the Threat Intelligence Indicator. Possible values are `domain-name`, `file`, `ipv4-addr`, `ipv6-addr` and `url`.
        """
        return pulumi.get(self, "pattern_type")

    @_builtins.property
    @pulumi.getter(name="patternVersion")
    def pattern_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version of a Threat Intelligence entity.
        """
        return pulumi.get(self, "pattern_version")

    @_builtins.property
    @pulumi.getter
    def revoked(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the Threat Intelligence entity revoked.
        """
        return pulumi.get(self, "revoked")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        Source of the Threat Intelligence Indicator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of tags of the Threat Intelligence Indicator.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="threatTypes")
    def threat_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of threat types of this Threat Intelligence Indicator.
        """
        return pulumi.get(self, "threat_types")

    @_builtins.property
    @pulumi.getter(name="validateFromUtc")
    def validate_from_utc(self) -> pulumi.Output[_builtins.str]:
        """
        The start of validate date in RFC3339.
        """
        return pulumi.get(self, "validate_from_utc")

    @_builtins.property
    @pulumi.getter(name="validateUntilUtc")
    def validate_until_utc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The end of validate date of the Threat Intelligence Indicator in RFC3339 format.
        """
        return pulumi.get(self, "validate_until_utc")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Log Analytics Workspace. Changing this forces a new Sentinel Threat Intelligence Indicator to be created.
        """
        return pulumi.get(self, "workspace_id")

