# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTopicResult',
    'AwaitableGetTopicResult',
    'get_topic',
    'get_topic_output',
]

@pulumi.output_type
class GetTopicResult:
    """
    A collection of values returned by getTopic.
    """
    def __init__(__self__, auto_delete_on_idle=None, batched_operations_enabled=None, default_message_ttl=None, duplicate_detection_history_time_window=None, enable_batched_operations=None, enable_express=None, enable_partitioning=None, express_enabled=None, id=None, max_size_in_megabytes=None, name=None, namespace_id=None, namespace_name=None, partitioning_enabled=None, requires_duplicate_detection=None, resource_group_name=None, status=None, support_ordering=None):
        if auto_delete_on_idle and not isinstance(auto_delete_on_idle, str):
            raise TypeError("Expected argument 'auto_delete_on_idle' to be a str")
        pulumi.set(__self__, "auto_delete_on_idle", auto_delete_on_idle)
        if batched_operations_enabled and not isinstance(batched_operations_enabled, bool):
            raise TypeError("Expected argument 'batched_operations_enabled' to be a bool")
        pulumi.set(__self__, "batched_operations_enabled", batched_operations_enabled)
        if default_message_ttl and not isinstance(default_message_ttl, str):
            raise TypeError("Expected argument 'default_message_ttl' to be a str")
        pulumi.set(__self__, "default_message_ttl", default_message_ttl)
        if duplicate_detection_history_time_window and not isinstance(duplicate_detection_history_time_window, str):
            raise TypeError("Expected argument 'duplicate_detection_history_time_window' to be a str")
        pulumi.set(__self__, "duplicate_detection_history_time_window", duplicate_detection_history_time_window)
        if enable_batched_operations and not isinstance(enable_batched_operations, bool):
            raise TypeError("Expected argument 'enable_batched_operations' to be a bool")
        pulumi.set(__self__, "enable_batched_operations", enable_batched_operations)
        if enable_express and not isinstance(enable_express, bool):
            raise TypeError("Expected argument 'enable_express' to be a bool")
        pulumi.set(__self__, "enable_express", enable_express)
        if enable_partitioning and not isinstance(enable_partitioning, bool):
            raise TypeError("Expected argument 'enable_partitioning' to be a bool")
        pulumi.set(__self__, "enable_partitioning", enable_partitioning)
        if express_enabled and not isinstance(express_enabled, bool):
            raise TypeError("Expected argument 'express_enabled' to be a bool")
        pulumi.set(__self__, "express_enabled", express_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_size_in_megabytes and not isinstance(max_size_in_megabytes, int):
            raise TypeError("Expected argument 'max_size_in_megabytes' to be a int")
        pulumi.set(__self__, "max_size_in_megabytes", max_size_in_megabytes)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace_id and not isinstance(namespace_id, str):
            raise TypeError("Expected argument 'namespace_id' to be a str")
        pulumi.set(__self__, "namespace_id", namespace_id)
        if namespace_name and not isinstance(namespace_name, str):
            raise TypeError("Expected argument 'namespace_name' to be a str")
        pulumi.set(__self__, "namespace_name", namespace_name)
        if partitioning_enabled and not isinstance(partitioning_enabled, bool):
            raise TypeError("Expected argument 'partitioning_enabled' to be a bool")
        pulumi.set(__self__, "partitioning_enabled", partitioning_enabled)
        if requires_duplicate_detection and not isinstance(requires_duplicate_detection, bool):
            raise TypeError("Expected argument 'requires_duplicate_detection' to be a bool")
        pulumi.set(__self__, "requires_duplicate_detection", requires_duplicate_detection)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if support_ordering and not isinstance(support_ordering, bool):
            raise TypeError("Expected argument 'support_ordering' to be a bool")
        pulumi.set(__self__, "support_ordering", support_ordering)

    @_builtins.property
    @pulumi.getter(name="autoDeleteOnIdle")
    def auto_delete_on_idle(self) -> _builtins.str:
        """
        The ISO 8601 timespan duration of the idle interval after which the Topic is automatically deleted, minimum of 5 minutes.
        """
        return pulumi.get(self, "auto_delete_on_idle")

    @_builtins.property
    @pulumi.getter(name="batchedOperationsEnabled")
    def batched_operations_enabled(self) -> _builtins.bool:
        """
        Boolean flag which controls if server-side batched operations are enabled.
        """
        return pulumi.get(self, "batched_operations_enabled")

    @_builtins.property
    @pulumi.getter(name="defaultMessageTtl")
    def default_message_ttl(self) -> _builtins.str:
        """
        The ISO 8601 timespan duration of TTL of messages sent to this topic if no TTL value is set on the message itself.
        """
        return pulumi.get(self, "default_message_ttl")

    @_builtins.property
    @pulumi.getter(name="duplicateDetectionHistoryTimeWindow")
    def duplicate_detection_history_time_window(self) -> _builtins.str:
        """
        The ISO 8601 timespan duration during which duplicates can be detected.
        """
        return pulumi.get(self, "duplicate_detection_history_time_window")

    @_builtins.property
    @pulumi.getter(name="enableBatchedOperations")
    def enable_batched_operations(self) -> _builtins.bool:
        return pulumi.get(self, "enable_batched_operations")

    @_builtins.property
    @pulumi.getter(name="enableExpress")
    def enable_express(self) -> _builtins.bool:
        return pulumi.get(self, "enable_express")

    @_builtins.property
    @pulumi.getter(name="enablePartitioning")
    def enable_partitioning(self) -> _builtins.bool:
        return pulumi.get(self, "enable_partitioning")

    @_builtins.property
    @pulumi.getter(name="expressEnabled")
    def express_enabled(self) -> _builtins.bool:
        """
        Boolean flag which controls whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
        """
        return pulumi.get(self, "express_enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxSizeInMegabytes")
    def max_size_in_megabytes(self) -> _builtins.int:
        """
        Integer value which controls the size of memory allocated for the topic. For supported values see the "Queue/topic size" section of [this document](https://docs.microsoft.com/azure/service-bus-messaging/service-bus-quotas).
        """
        return pulumi.get(self, "max_size_in_megabytes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    @_utilities.deprecated("""`namespace_name` will be removed in favour of the `namespace_id` property in v5.0 of the AzureRM Provider.""")
    def namespace_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter(name="partitioningEnabled")
    def partitioning_enabled(self) -> _builtins.bool:
        """
        Boolean flag which controls whether to enable the topic to be partitioned across multiple message brokers.
        """
        return pulumi.get(self, "partitioning_enabled")

    @_builtins.property
    @pulumi.getter(name="requiresDuplicateDetection")
    def requires_duplicate_detection(self) -> _builtins.bool:
        """
        Boolean flag which controls whether the Topic requires duplicate detection.
        """
        return pulumi.get(self, "requires_duplicate_detection")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    @_utilities.deprecated("""`resource_group_name` will be removed in favour of the `namespace_id` property in v5.0 of the AzureRM Provider.""")
    def resource_group_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The Status of the Service Bus Topic. Acceptable values are Active or Disabled.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="supportOrdering")
    def support_ordering(self) -> _builtins.bool:
        """
        Boolean flag which controls whether the Topic supports ordering.
        """
        return pulumi.get(self, "support_ordering")


class AwaitableGetTopicResult(GetTopicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopicResult(
            auto_delete_on_idle=self.auto_delete_on_idle,
            batched_operations_enabled=self.batched_operations_enabled,
            default_message_ttl=self.default_message_ttl,
            duplicate_detection_history_time_window=self.duplicate_detection_history_time_window,
            enable_batched_operations=self.enable_batched_operations,
            enable_express=self.enable_express,
            enable_partitioning=self.enable_partitioning,
            express_enabled=self.express_enabled,
            id=self.id,
            max_size_in_megabytes=self.max_size_in_megabytes,
            name=self.name,
            namespace_id=self.namespace_id,
            namespace_name=self.namespace_name,
            partitioning_enabled=self.partitioning_enabled,
            requires_duplicate_detection=self.requires_duplicate_detection,
            resource_group_name=self.resource_group_name,
            status=self.status,
            support_ordering=self.support_ordering)


def get_topic(name: Optional[_builtins.str] = None,
              namespace_id: Optional[_builtins.str] = None,
              namespace_name: Optional[_builtins.str] = None,
              resource_group_name: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopicResult:
    """
    Use this data source to access information about an existing Service Bus Topic.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.servicebus.get_topic(name="existing",
        namespace_id="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ServiceBus`: 2022-10-01-preview, 2021-06-01-preview


    :param _builtins.str name: The name of this Service Bus Topic.
    :param _builtins.str namespace_id: The ID of the ServiceBus Namespace where the Service Bus Topic exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['namespaceName'] = namespace_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:servicebus/getTopic:getTopic', __args__, opts=opts, typ=GetTopicResult).value

    return AwaitableGetTopicResult(
        auto_delete_on_idle=pulumi.get(__ret__, 'auto_delete_on_idle'),
        batched_operations_enabled=pulumi.get(__ret__, 'batched_operations_enabled'),
        default_message_ttl=pulumi.get(__ret__, 'default_message_ttl'),
        duplicate_detection_history_time_window=pulumi.get(__ret__, 'duplicate_detection_history_time_window'),
        enable_batched_operations=pulumi.get(__ret__, 'enable_batched_operations'),
        enable_express=pulumi.get(__ret__, 'enable_express'),
        enable_partitioning=pulumi.get(__ret__, 'enable_partitioning'),
        express_enabled=pulumi.get(__ret__, 'express_enabled'),
        id=pulumi.get(__ret__, 'id'),
        max_size_in_megabytes=pulumi.get(__ret__, 'max_size_in_megabytes'),
        name=pulumi.get(__ret__, 'name'),
        namespace_id=pulumi.get(__ret__, 'namespace_id'),
        namespace_name=pulumi.get(__ret__, 'namespace_name'),
        partitioning_enabled=pulumi.get(__ret__, 'partitioning_enabled'),
        requires_duplicate_detection=pulumi.get(__ret__, 'requires_duplicate_detection'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        status=pulumi.get(__ret__, 'status'),
        support_ordering=pulumi.get(__ret__, 'support_ordering'))
def get_topic_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                     namespace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     namespace_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     resource_group_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTopicResult]:
    """
    Use this data source to access information about an existing Service Bus Topic.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.servicebus.get_topic(name="existing",
        namespace_id="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ServiceBus`: 2022-10-01-preview, 2021-06-01-preview


    :param _builtins.str name: The name of this Service Bus Topic.
    :param _builtins.str namespace_id: The ID of the ServiceBus Namespace where the Service Bus Topic exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['namespaceName'] = namespace_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:servicebus/getTopic:getTopic', __args__, opts=opts, typ=GetTopicResult)
    return __ret__.apply(lambda __response__: GetTopicResult(
        auto_delete_on_idle=pulumi.get(__response__, 'auto_delete_on_idle'),
        batched_operations_enabled=pulumi.get(__response__, 'batched_operations_enabled'),
        default_message_ttl=pulumi.get(__response__, 'default_message_ttl'),
        duplicate_detection_history_time_window=pulumi.get(__response__, 'duplicate_detection_history_time_window'),
        enable_batched_operations=pulumi.get(__response__, 'enable_batched_operations'),
        enable_express=pulumi.get(__response__, 'enable_express'),
        enable_partitioning=pulumi.get(__response__, 'enable_partitioning'),
        express_enabled=pulumi.get(__response__, 'express_enabled'),
        id=pulumi.get(__response__, 'id'),
        max_size_in_megabytes=pulumi.get(__response__, 'max_size_in_megabytes'),
        name=pulumi.get(__response__, 'name'),
        namespace_id=pulumi.get(__response__, 'namespace_id'),
        namespace_name=pulumi.get(__response__, 'namespace_name'),
        partitioning_enabled=pulumi.get(__response__, 'partitioning_enabled'),
        requires_duplicate_detection=pulumi.get(__response__, 'requires_duplicate_detection'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        status=pulumi.get(__response__, 'status'),
        support_ordering=pulumi.get(__response__, 'support_ordering')))
