# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagementPolicyArgs', 'ManagementPolicy']

@pulumi.input_type
class ManagementPolicyArgs:
    def __init__(__self__, *,
                 storage_account_id: pulumi.Input[_builtins.str],
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]] = None):
        """
        The set of arguments for constructing a ManagementPolicy resource.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the id of the storage account to apply the management policy to. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]] rules: A `rule` block as documented below.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the id of the storage account to apply the management policy to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]]:
        """
        A `rule` block as documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _ManagementPolicyState:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagementPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]] rules: A `rule` block as documented below.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the id of the storage account to apply the management policy to. Changing this forces a new resource to be created.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]]:
        """
        A `rule` block as documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the id of the storage account to apply the management policy to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)


@pulumi.type_token("azure:storage/managementPolicy:ManagementPolicy")
class ManagementPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementPolicyRuleArgs', 'ManagementPolicyRuleArgsDict']]]]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Storage Account Management Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="resourceGroupName",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="BlobStorage")
        example_management_policy = azure.storage.ManagementPolicy("example",
            storage_account_id=example_account.id,
            rules=[
                {
                    "name": "rule1",
                    "enabled": True,
                    "filters": {
                        "prefix_matches": ["container1/prefix1"],
                        "blob_types": ["blockBlob"],
                        "match_blob_index_tags": [{
                            "name": "tag1",
                            "operation": "==",
                            "value": "val1",
                        }],
                    },
                    "actions": {
                        "base_blob": {
                            "tier_to_cool_after_days_since_modification_greater_than": 10,
                            "tier_to_archive_after_days_since_modification_greater_than": 50,
                            "delete_after_days_since_modification_greater_than": 100,
                        },
                        "snapshot": {
                            "delete_after_days_since_creation_greater_than": 30,
                        },
                    },
                },
                {
                    "name": "rule2",
                    "enabled": False,
                    "filters": {
                        "prefix_matches": [
                            "container2/prefix1",
                            "container2/prefix2",
                        ],
                        "blob_types": ["blockBlob"],
                    },
                    "actions": {
                        "base_blob": {
                            "tier_to_cool_after_days_since_modification_greater_than": 11,
                            "tier_to_archive_after_days_since_modification_greater_than": 51,
                            "delete_after_days_since_modification_greater_than": 101,
                        },
                        "snapshot": {
                            "change_tier_to_archive_after_days_since_creation": 90,
                            "change_tier_to_cool_after_days_since_creation": 23,
                            "delete_after_days_since_creation_greater_than": 31,
                        },
                        "version": {
                            "change_tier_to_archive_after_days_since_creation": 9,
                            "change_tier_to_cool_after_days_since_creation": 90,
                            "delete_after_days_since_creation": 3,
                        },
                    },
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage`: 2023-05-01

        ## Import

        Storage Account Management Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/managementPolicy:ManagementPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Storage/storageAccounts/myaccountname/managementPolicies/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementPolicyRuleArgs', 'ManagementPolicyRuleArgsDict']]]] rules: A `rule` block as documented below.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the id of the storage account to apply the management policy to. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagementPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Storage Account Management Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="resourceGroupName",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="BlobStorage")
        example_management_policy = azure.storage.ManagementPolicy("example",
            storage_account_id=example_account.id,
            rules=[
                {
                    "name": "rule1",
                    "enabled": True,
                    "filters": {
                        "prefix_matches": ["container1/prefix1"],
                        "blob_types": ["blockBlob"],
                        "match_blob_index_tags": [{
                            "name": "tag1",
                            "operation": "==",
                            "value": "val1",
                        }],
                    },
                    "actions": {
                        "base_blob": {
                            "tier_to_cool_after_days_since_modification_greater_than": 10,
                            "tier_to_archive_after_days_since_modification_greater_than": 50,
                            "delete_after_days_since_modification_greater_than": 100,
                        },
                        "snapshot": {
                            "delete_after_days_since_creation_greater_than": 30,
                        },
                    },
                },
                {
                    "name": "rule2",
                    "enabled": False,
                    "filters": {
                        "prefix_matches": [
                            "container2/prefix1",
                            "container2/prefix2",
                        ],
                        "blob_types": ["blockBlob"],
                    },
                    "actions": {
                        "base_blob": {
                            "tier_to_cool_after_days_since_modification_greater_than": 11,
                            "tier_to_archive_after_days_since_modification_greater_than": 51,
                            "delete_after_days_since_modification_greater_than": 101,
                        },
                        "snapshot": {
                            "change_tier_to_archive_after_days_since_creation": 90,
                            "change_tier_to_cool_after_days_since_creation": 23,
                            "delete_after_days_since_creation_greater_than": 31,
                        },
                        "version": {
                            "change_tier_to_archive_after_days_since_creation": 9,
                            "change_tier_to_cool_after_days_since_creation": 90,
                            "delete_after_days_since_creation": 3,
                        },
                    },
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage`: 2023-05-01

        ## Import

        Storage Account Management Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/managementPolicy:ManagementPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Storage/storageAccounts/myaccountname/managementPolicies/default
        ```

        :param str resource_name: The name of the resource.
        :param ManagementPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagementPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementPolicyRuleArgs', 'ManagementPolicyRuleArgsDict']]]]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagementPolicyArgs.__new__(ManagementPolicyArgs)

            __props__.__dict__["rules"] = rules
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
        super(ManagementPolicy, __self__).__init__(
            'azure:storage/managementPolicy:ManagementPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementPolicyRuleArgs', 'ManagementPolicyRuleArgsDict']]]]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagementPolicy':
        """
        Get an existing ManagementPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementPolicyRuleArgs', 'ManagementPolicyRuleArgsDict']]]] rules: A `rule` block as documented below.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the id of the storage account to apply the management policy to. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagementPolicyState.__new__(_ManagementPolicyState)

        __props__.__dict__["rules"] = rules
        __props__.__dict__["storage_account_id"] = storage_account_id
        return ManagementPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.ManagementPolicyRule']]]:
        """
        A `rule` block as documented below.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the id of the storage account to apply the management policy to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

