# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionJavaScriptUDFArgs', 'FunctionJavaScriptUDF']

@pulumi.input_type
class FunctionJavaScriptUDFArgs:
    def __init__(__self__, *,
                 inputs: pulumi.Input[Sequence[pulumi.Input['FunctionJavaScriptUDFInputArgs']]],
                 output: pulumi.Input['FunctionJavaScriptUDFOutputArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 script: pulumi.Input[_builtins.str],
                 stream_analytics_job_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FunctionJavaScriptUDF resource.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionJavaScriptUDFInputArgs']]] inputs: One or more `input` blocks as defined below.
        :param pulumi.Input['FunctionJavaScriptUDFOutputArgs'] output: An `output` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] script: The JavaScript of this UDF Function.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job where this Function should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the JavaScript UDF Function. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "inputs", inputs)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "script", script)
        pulumi.set(__self__, "stream_analytics_job_name", stream_analytics_job_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def inputs(self) -> pulumi.Input[Sequence[pulumi.Input['FunctionJavaScriptUDFInputArgs']]]:
        """
        One or more `input` blocks as defined below.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: pulumi.Input[Sequence[pulumi.Input['FunctionJavaScriptUDFInputArgs']]]):
        pulumi.set(self, "inputs", value)

    @_builtins.property
    @pulumi.getter
    def output(self) -> pulumi.Input['FunctionJavaScriptUDFOutputArgs']:
        """
        An `output` blocks as defined below.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: pulumi.Input['FunctionJavaScriptUDFOutputArgs']):
        pulumi.set(self, "output", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def script(self) -> pulumi.Input[_builtins.str]:
        """
        The JavaScript of this UDF Function.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "script", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Stream Analytics Job where this Function should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @stream_analytics_job_name.setter
    def stream_analytics_job_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stream_analytics_job_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the JavaScript UDF Function. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FunctionJavaScriptUDFState:
    def __init__(__self__, *,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionJavaScriptUDFInputArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output: Optional[pulumi.Input['FunctionJavaScriptUDFOutputArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 script: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FunctionJavaScriptUDF resources.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionJavaScriptUDFInputArgs']]] inputs: One or more `input` blocks as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the JavaScript UDF Function. Changing this forces a new resource to be created.
        :param pulumi.Input['FunctionJavaScriptUDFOutputArgs'] output: An `output` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] script: The JavaScript of this UDF Function.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job where this Function should be created. Changing this forces a new resource to be created.
        """
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if stream_analytics_job_name is not None:
            pulumi.set(__self__, "stream_analytics_job_name", stream_analytics_job_name)

    @_builtins.property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionJavaScriptUDFInputArgs']]]]:
        """
        One or more `input` blocks as defined below.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionJavaScriptUDFInputArgs']]]]):
        pulumi.set(self, "inputs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the JavaScript UDF Function. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input['FunctionJavaScriptUDFOutputArgs']]:
        """
        An `output` blocks as defined below.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input['FunctionJavaScriptUDFOutputArgs']]):
        pulumi.set(self, "output", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JavaScript of this UDF Function.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Analytics Job where this Function should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @stream_analytics_job_name.setter
    def stream_analytics_job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_analytics_job_name", value)


@pulumi.type_token("azure:streamanalytics/functionJavaScriptUDF:FunctionJavaScriptUDF")
class FunctionJavaScriptUDF(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionJavaScriptUDFInputArgs', 'FunctionJavaScriptUDFInputArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output: Optional[pulumi.Input[Union['FunctionJavaScriptUDFOutputArgs', 'FunctionJavaScriptUDFOutputArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 script: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a JavaScript UDF Function within Stream Analytics Streaming Job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.get_resource_group(name="example-resources")
        example_get_job = azure.streamanalytics.get_job(name="example-job",
            resource_group_name=example.name)
        example_function_java_script_udf = azure.streamanalytics.FunctionJavaScriptUDF("example",
            name="example-javascript-function",
            stream_analytics_job_name=example_get_job.name,
            resource_group_name=example_get_job.resource_group_name,
            script=\"\"\"function getRandomNumber(in) {
          return in;
        }
        \"\"\",
            inputs=[{
                "type": "bigint",
            }],
            output={
                "type": "bigint",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2020-03-01

        ## Import

        Stream Analytics JavaScript UDF Functions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/functionJavaScriptUDF:FunctionJavaScriptUDF example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/functions/func1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionJavaScriptUDFInputArgs', 'FunctionJavaScriptUDFInputArgsDict']]]] inputs: One or more `input` blocks as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the JavaScript UDF Function. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['FunctionJavaScriptUDFOutputArgs', 'FunctionJavaScriptUDFOutputArgsDict']] output: An `output` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] script: The JavaScript of this UDF Function.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job where this Function should be created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionJavaScriptUDFArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a JavaScript UDF Function within Stream Analytics Streaming Job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.get_resource_group(name="example-resources")
        example_get_job = azure.streamanalytics.get_job(name="example-job",
            resource_group_name=example.name)
        example_function_java_script_udf = azure.streamanalytics.FunctionJavaScriptUDF("example",
            name="example-javascript-function",
            stream_analytics_job_name=example_get_job.name,
            resource_group_name=example_get_job.resource_group_name,
            script=\"\"\"function getRandomNumber(in) {
          return in;
        }
        \"\"\",
            inputs=[{
                "type": "bigint",
            }],
            output={
                "type": "bigint",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2020-03-01

        ## Import

        Stream Analytics JavaScript UDF Functions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/functionJavaScriptUDF:FunctionJavaScriptUDF example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/functions/func1
        ```

        :param str resource_name: The name of the resource.
        :param FunctionJavaScriptUDFArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionJavaScriptUDFArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionJavaScriptUDFInputArgs', 'FunctionJavaScriptUDFInputArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output: Optional[pulumi.Input[Union['FunctionJavaScriptUDFOutputArgs', 'FunctionJavaScriptUDFOutputArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 script: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionJavaScriptUDFArgs.__new__(FunctionJavaScriptUDFArgs)

            if inputs is None and not opts.urn:
                raise TypeError("Missing required property 'inputs'")
            __props__.__dict__["inputs"] = inputs
            __props__.__dict__["name"] = name
            if output is None and not opts.urn:
                raise TypeError("Missing required property 'output'")
            __props__.__dict__["output"] = output
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if script is None and not opts.urn:
                raise TypeError("Missing required property 'script'")
            __props__.__dict__["script"] = script
            if stream_analytics_job_name is None and not opts.urn:
                raise TypeError("Missing required property 'stream_analytics_job_name'")
            __props__.__dict__["stream_analytics_job_name"] = stream_analytics_job_name
        super(FunctionJavaScriptUDF, __self__).__init__(
            'azure:streamanalytics/functionJavaScriptUDF:FunctionJavaScriptUDF',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionJavaScriptUDFInputArgs', 'FunctionJavaScriptUDFInputArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            output: Optional[pulumi.Input[Union['FunctionJavaScriptUDFOutputArgs', 'FunctionJavaScriptUDFOutputArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            script: Optional[pulumi.Input[_builtins.str]] = None,
            stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'FunctionJavaScriptUDF':
        """
        Get an existing FunctionJavaScriptUDF resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionJavaScriptUDFInputArgs', 'FunctionJavaScriptUDFInputArgsDict']]]] inputs: One or more `input` blocks as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the JavaScript UDF Function. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['FunctionJavaScriptUDFOutputArgs', 'FunctionJavaScriptUDFOutputArgsDict']] output: An `output` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] script: The JavaScript of this UDF Function.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job where this Function should be created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionJavaScriptUDFState.__new__(_FunctionJavaScriptUDFState)

        __props__.__dict__["inputs"] = inputs
        __props__.__dict__["name"] = name
        __props__.__dict__["output"] = output
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["script"] = script
        __props__.__dict__["stream_analytics_job_name"] = stream_analytics_job_name
        return FunctionJavaScriptUDF(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def inputs(self) -> pulumi.Output[Sequence['outputs.FunctionJavaScriptUDFInput']]:
        """
        One or more `input` blocks as defined below.
        """
        return pulumi.get(self, "inputs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the JavaScript UDF Function. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def output(self) -> pulumi.Output['outputs.FunctionJavaScriptUDFOutput']:
        """
        An `output` blocks as defined below.
        """
        return pulumi.get(self, "output")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def script(self) -> pulumi.Output[_builtins.str]:
        """
        The JavaScript of this UDF Function.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Stream Analytics Job where this Function should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

