# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamInputEventHubV2Args', 'StreamInputEventHubV2']

@pulumi.input_type
class StreamInputEventHubV2Args:
    def __init__(__self__, *,
                 eventhub_name: pulumi.Input[_builtins.str],
                 serialization: pulumi.Input['StreamInputEventHubV2SerializationArgs'],
                 servicebus_namespace: pulumi.Input[_builtins.str],
                 stream_analytics_job_id: pulumi.Input[_builtins.str],
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_consumer_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_access_policy_key: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_access_policy_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StreamInputEventHubV2 resource.
        :param pulumi.Input[_builtins.str] eventhub_name: The name of the Event Hub.
        :param pulumi.Input['StreamInputEventHubV2SerializationArgs'] serialization: A `serialization` block as defined below.
        :param pulumi.Input[_builtins.str] servicebus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc.
        :param pulumi.Input[_builtins.str] stream_analytics_job_id: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[_builtins.str] eventhub_consumer_group_name: The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not set the input will use the Event Hub's default consumer group.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Input EventHub V2. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key: The property the input Event Hub has been partitioned by.
        :param pulumi.Input[_builtins.str] shared_access_policy_key: The shared access policy key for the specified shared access policy.
        :param pulumi.Input[_builtins.str] shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc.
        """
        pulumi.set(__self__, "eventhub_name", eventhub_name)
        pulumi.set(__self__, "serialization", serialization)
        pulumi.set(__self__, "servicebus_namespace", servicebus_namespace)
        pulumi.set(__self__, "stream_analytics_job_id", stream_analytics_job_id)
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if eventhub_consumer_group_name is not None:
            pulumi.set(__self__, "eventhub_consumer_group_name", eventhub_consumer_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)

    @_builtins.property
    @pulumi.getter(name="eventhubName")
    def eventhub_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Event Hub.
        """
        return pulumi.get(self, "eventhub_name")

    @eventhub_name.setter
    def eventhub_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "eventhub_name", value)

    @_builtins.property
    @pulumi.getter
    def serialization(self) -> pulumi.Input['StreamInputEventHubV2SerializationArgs']:
        """
        A `serialization` block as defined below.
        """
        return pulumi.get(self, "serialization")

    @serialization.setter
    def serialization(self, value: pulumi.Input['StreamInputEventHubV2SerializationArgs']):
        pulumi.set(self, "serialization", value)

    @_builtins.property
    @pulumi.getter(name="servicebusNamespace")
    def servicebus_namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc.
        """
        return pulumi.get(self, "servicebus_namespace")

    @servicebus_namespace.setter
    def servicebus_namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "servicebus_namespace", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobId")
    def stream_analytics_job_id(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_id")

    @stream_analytics_job_id.setter
    def stream_analytics_job_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stream_analytics_job_id", value)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_mode", value)

    @_builtins.property
    @pulumi.getter(name="eventhubConsumerGroupName")
    def eventhub_consumer_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not set the input will use the Event Hub's default consumer group.
        """
        return pulumi.get(self, "eventhub_consumer_group_name")

    @eventhub_consumer_group_name.setter
    def eventhub_consumer_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventhub_consumer_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Input EventHub V2. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property the input Event Hub has been partitioned by.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition_key", value)

    @_builtins.property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shared access policy key for the specified shared access policy.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @shared_access_policy_key.setter
    def shared_access_policy_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_access_policy_key", value)

    @_builtins.property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc.
        """
        return pulumi.get(self, "shared_access_policy_name")

    @shared_access_policy_name.setter
    def shared_access_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_access_policy_name", value)


@pulumi.input_type
class _StreamInputEventHubV2State:
    def __init__(__self__, *,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_consumer_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key: Optional[pulumi.Input[_builtins.str]] = None,
                 serialization: Optional[pulumi.Input['StreamInputEventHubV2SerializationArgs']] = None,
                 servicebus_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_access_policy_key: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_access_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StreamInputEventHubV2 resources.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[_builtins.str] eventhub_consumer_group_name: The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not set the input will use the Event Hub's default consumer group.
        :param pulumi.Input[_builtins.str] eventhub_name: The name of the Event Hub.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Input EventHub V2. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key: The property the input Event Hub has been partitioned by.
        :param pulumi.Input['StreamInputEventHubV2SerializationArgs'] serialization: A `serialization` block as defined below.
        :param pulumi.Input[_builtins.str] servicebus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc.
        :param pulumi.Input[_builtins.str] shared_access_policy_key: The shared access policy key for the specified shared access policy.
        :param pulumi.Input[_builtins.str] shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc.
        :param pulumi.Input[_builtins.str] stream_analytics_job_id: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if eventhub_consumer_group_name is not None:
            pulumi.set(__self__, "eventhub_consumer_group_name", eventhub_consumer_group_name)
        if eventhub_name is not None:
            pulumi.set(__self__, "eventhub_name", eventhub_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if serialization is not None:
            pulumi.set(__self__, "serialization", serialization)
        if servicebus_namespace is not None:
            pulumi.set(__self__, "servicebus_namespace", servicebus_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)
        if stream_analytics_job_id is not None:
            pulumi.set(__self__, "stream_analytics_job_id", stream_analytics_job_id)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_mode", value)

    @_builtins.property
    @pulumi.getter(name="eventhubConsumerGroupName")
    def eventhub_consumer_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not set the input will use the Event Hub's default consumer group.
        """
        return pulumi.get(self, "eventhub_consumer_group_name")

    @eventhub_consumer_group_name.setter
    def eventhub_consumer_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventhub_consumer_group_name", value)

    @_builtins.property
    @pulumi.getter(name="eventhubName")
    def eventhub_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Event Hub.
        """
        return pulumi.get(self, "eventhub_name")

    @eventhub_name.setter
    def eventhub_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eventhub_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Input EventHub V2. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property the input Event Hub has been partitioned by.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition_key", value)

    @_builtins.property
    @pulumi.getter
    def serialization(self) -> Optional[pulumi.Input['StreamInputEventHubV2SerializationArgs']]:
        """
        A `serialization` block as defined below.
        """
        return pulumi.get(self, "serialization")

    @serialization.setter
    def serialization(self, value: Optional[pulumi.Input['StreamInputEventHubV2SerializationArgs']]):
        pulumi.set(self, "serialization", value)

    @_builtins.property
    @pulumi.getter(name="servicebusNamespace")
    def servicebus_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc.
        """
        return pulumi.get(self, "servicebus_namespace")

    @servicebus_namespace.setter
    def servicebus_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "servicebus_namespace", value)

    @_builtins.property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shared access policy key for the specified shared access policy.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @shared_access_policy_key.setter
    def shared_access_policy_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_access_policy_key", value)

    @_builtins.property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc.
        """
        return pulumi.get(self, "shared_access_policy_name")

    @shared_access_policy_name.setter
    def shared_access_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_access_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobId")
    def stream_analytics_job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_id")

    @stream_analytics_job_id.setter
    def stream_analytics_job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_analytics_job_id", value)


@pulumi.type_token("azure:streamanalytics/streamInputEventHubV2:StreamInputEventHubV2")
class StreamInputEventHubV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_consumer_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key: Optional[pulumi.Input[_builtins.str]] = None,
                 serialization: Optional[pulumi.Input[Union['StreamInputEventHubV2SerializationArgs', 'StreamInputEventHubV2SerializationArgsDict']]] = None,
                 servicebus_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_access_policy_key: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_access_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **Note:** This resource creates a Stream Input of type `Microsoft.EventHub/EventHub`, to create a Stream Input of type `Microsoft.ServiceBus/EventHub` please use the resource azurerm_stream_analytics_stream_input_eventhub.

        Manages a Stream Analytics Stream Input EventHub V2.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.streamanalytics.get_job_output(name="example-job",
            resource_group_name=example_resource_group.name)
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-namespace",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            sku="Standard",
            capacity=1)
        example_event_hub = azure.eventhub.EventHub("example",
            name="example-eventhub",
            namespace_name=example_event_hub_namespace.name,
            resource_group_name=example_resource_group.name,
            partition_count=2,
            message_retention=1)
        example_consumer_group = azure.eventhub.ConsumerGroup("example",
            name="example-consumergroup",
            namespace_name=example_event_hub_namespace.name,
            eventhub_name=example_event_hub.name,
            resource_group_name=example_resource_group.name)
        example_stream_input_event_hub_v2 = azure.streamanalytics.StreamInputEventHubV2("example",
            name="eventhub-stream-input",
            stream_analytics_job_id=example.id,
            eventhub_consumer_group_name=example_consumer_group.name,
            eventhub_name=example_event_hub.name,
            servicebus_namespace=example_event_hub_namespace.name,
            shared_access_policy_key=example_event_hub_namespace.default_primary_key,
            shared_access_policy_name="RootManageSharedAccessKey",
            serialization={
                "type": "Json",
                "encoding": "UTF8",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2020-03-01

        ## Import

        Stream Analytics Stream Input EventHub's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/streamInputEventHubV2:StreamInputEventHubV2 example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/inputs/input1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[_builtins.str] eventhub_consumer_group_name: The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not set the input will use the Event Hub's default consumer group.
        :param pulumi.Input[_builtins.str] eventhub_name: The name of the Event Hub.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Input EventHub V2. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key: The property the input Event Hub has been partitioned by.
        :param pulumi.Input[Union['StreamInputEventHubV2SerializationArgs', 'StreamInputEventHubV2SerializationArgsDict']] serialization: A `serialization` block as defined below.
        :param pulumi.Input[_builtins.str] servicebus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc.
        :param pulumi.Input[_builtins.str] shared_access_policy_key: The shared access policy key for the specified shared access policy.
        :param pulumi.Input[_builtins.str] shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc.
        :param pulumi.Input[_builtins.str] stream_analytics_job_id: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamInputEventHubV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Note:** This resource creates a Stream Input of type `Microsoft.EventHub/EventHub`, to create a Stream Input of type `Microsoft.ServiceBus/EventHub` please use the resource azurerm_stream_analytics_stream_input_eventhub.

        Manages a Stream Analytics Stream Input EventHub V2.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.streamanalytics.get_job_output(name="example-job",
            resource_group_name=example_resource_group.name)
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-namespace",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            sku="Standard",
            capacity=1)
        example_event_hub = azure.eventhub.EventHub("example",
            name="example-eventhub",
            namespace_name=example_event_hub_namespace.name,
            resource_group_name=example_resource_group.name,
            partition_count=2,
            message_retention=1)
        example_consumer_group = azure.eventhub.ConsumerGroup("example",
            name="example-consumergroup",
            namespace_name=example_event_hub_namespace.name,
            eventhub_name=example_event_hub.name,
            resource_group_name=example_resource_group.name)
        example_stream_input_event_hub_v2 = azure.streamanalytics.StreamInputEventHubV2("example",
            name="eventhub-stream-input",
            stream_analytics_job_id=example.id,
            eventhub_consumer_group_name=example_consumer_group.name,
            eventhub_name=example_event_hub.name,
            servicebus_namespace=example_event_hub_namespace.name,
            shared_access_policy_key=example_event_hub_namespace.default_primary_key,
            shared_access_policy_name="RootManageSharedAccessKey",
            serialization={
                "type": "Json",
                "encoding": "UTF8",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2020-03-01

        ## Import

        Stream Analytics Stream Input EventHub's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/streamInputEventHubV2:StreamInputEventHubV2 example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/inputs/input1
        ```

        :param str resource_name: The name of the resource.
        :param StreamInputEventHubV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamInputEventHubV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_consumer_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 eventhub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key: Optional[pulumi.Input[_builtins.str]] = None,
                 serialization: Optional[pulumi.Input[Union['StreamInputEventHubV2SerializationArgs', 'StreamInputEventHubV2SerializationArgsDict']]] = None,
                 servicebus_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_access_policy_key: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_access_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamInputEventHubV2Args.__new__(StreamInputEventHubV2Args)

            __props__.__dict__["authentication_mode"] = authentication_mode
            __props__.__dict__["eventhub_consumer_group_name"] = eventhub_consumer_group_name
            if eventhub_name is None and not opts.urn:
                raise TypeError("Missing required property 'eventhub_name'")
            __props__.__dict__["eventhub_name"] = eventhub_name
            __props__.__dict__["name"] = name
            __props__.__dict__["partition_key"] = partition_key
            if serialization is None and not opts.urn:
                raise TypeError("Missing required property 'serialization'")
            __props__.__dict__["serialization"] = serialization
            if servicebus_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'servicebus_namespace'")
            __props__.__dict__["servicebus_namespace"] = servicebus_namespace
            __props__.__dict__["shared_access_policy_key"] = None if shared_access_policy_key is None else pulumi.Output.secret(shared_access_policy_key)
            __props__.__dict__["shared_access_policy_name"] = shared_access_policy_name
            if stream_analytics_job_id is None and not opts.urn:
                raise TypeError("Missing required property 'stream_analytics_job_id'")
            __props__.__dict__["stream_analytics_job_id"] = stream_analytics_job_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sharedAccessPolicyKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(StreamInputEventHubV2, __self__).__init__(
            'azure:streamanalytics/streamInputEventHubV2:StreamInputEventHubV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
            eventhub_consumer_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            eventhub_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partition_key: Optional[pulumi.Input[_builtins.str]] = None,
            serialization: Optional[pulumi.Input[Union['StreamInputEventHubV2SerializationArgs', 'StreamInputEventHubV2SerializationArgsDict']]] = None,
            servicebus_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            shared_access_policy_key: Optional[pulumi.Input[_builtins.str]] = None,
            shared_access_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            stream_analytics_job_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'StreamInputEventHubV2':
        """
        Get an existing StreamInputEventHubV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[_builtins.str] eventhub_consumer_group_name: The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not set the input will use the Event Hub's default consumer group.
        :param pulumi.Input[_builtins.str] eventhub_name: The name of the Event Hub.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Input EventHub V2. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key: The property the input Event Hub has been partitioned by.
        :param pulumi.Input[Union['StreamInputEventHubV2SerializationArgs', 'StreamInputEventHubV2SerializationArgsDict']] serialization: A `serialization` block as defined below.
        :param pulumi.Input[_builtins.str] servicebus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc.
        :param pulumi.Input[_builtins.str] shared_access_policy_key: The shared access policy key for the specified shared access policy.
        :param pulumi.Input[_builtins.str] shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc.
        :param pulumi.Input[_builtins.str] stream_analytics_job_id: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamInputEventHubV2State.__new__(_StreamInputEventHubV2State)

        __props__.__dict__["authentication_mode"] = authentication_mode
        __props__.__dict__["eventhub_consumer_group_name"] = eventhub_consumer_group_name
        __props__.__dict__["eventhub_name"] = eventhub_name
        __props__.__dict__["name"] = name
        __props__.__dict__["partition_key"] = partition_key
        __props__.__dict__["serialization"] = serialization
        __props__.__dict__["servicebus_namespace"] = servicebus_namespace
        __props__.__dict__["shared_access_policy_key"] = shared_access_policy_key
        __props__.__dict__["shared_access_policy_name"] = shared_access_policy_name
        __props__.__dict__["stream_analytics_job_id"] = stream_analytics_job_id
        return StreamInputEventHubV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The authentication mode for the Stream Output. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        """
        return pulumi.get(self, "authentication_mode")

    @_builtins.property
    @pulumi.getter(name="eventhubConsumerGroupName")
    def eventhub_consumer_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not set the input will use the Event Hub's default consumer group.
        """
        return pulumi.get(self, "eventhub_consumer_group_name")

    @_builtins.property
    @pulumi.getter(name="eventhubName")
    def eventhub_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Event Hub.
        """
        return pulumi.get(self, "eventhub_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Stream Input EventHub V2. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The property the input Event Hub has been partitioned by.
        """
        return pulumi.get(self, "partition_key")

    @_builtins.property
    @pulumi.getter
    def serialization(self) -> pulumi.Output['outputs.StreamInputEventHubV2Serialization']:
        """
        A `serialization` block as defined below.
        """
        return pulumi.get(self, "serialization")

    @_builtins.property
    @pulumi.getter(name="servicebusNamespace")
    def servicebus_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc.
        """
        return pulumi.get(self, "servicebus_namespace")

    @_builtins.property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The shared access policy key for the specified shared access policy.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @_builtins.property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc.
        """
        return pulumi.get(self, "shared_access_policy_name")

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobId")
    def stream_analytics_job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_id")

