# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlPoolArgs', 'SqlPool']

@pulumi.input_type
class SqlPoolArgs:
    def __init__(__self__, *,
                 sku_name: pulumi.Input[_builtins.str],
                 storage_account_type: pulumi.Input[_builtins.str],
                 synapse_workspace_id: pulumi.Input[_builtins.str],
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 geo_backup_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input['SqlPoolRestoreArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SqlPool resource.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Synapse SQL Pool. Possible values are `DW100c`, `DW200c`, `DW300c`, `DW400c`, `DW500c`, `DW1000c`, `DW1500c`, `DW2000c`, `DW2500c`, `DW3000c`, `DW5000c`, `DW6000c`, `DW7500c`, `DW10000c`, `DW15000c` or `DW30000c`.
        :param pulumi.Input[_builtins.str] storage_account_type: The storage account type that will be used to store backups for this Synapse SQL Pool. Possible values are `LRS` or `GRS`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] synapse_workspace_id: The ID of Synapse Workspace within which this SQL Pool should be created. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] collation: The name of the collation to use with this pool, only applicable when `create_mode` is set to `Default`. Azure default is `SQL_LATIN1_GENERAL_CP1_CI_AS`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] create_mode: Specifies how to create the SQL Pool. Valid values are: `Default`, `Recovery` or `PointInTimeRestore`. Must be `Default` to create a new database. Defaults to `Default`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.bool] data_encrypted: Is transparent data encryption enabled?
        :param pulumi.Input[_builtins.bool] geo_backup_policy_enabled: Is geo-backup policy enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Synapse SQL Pool. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] recovery_database_id: The ID of the Synapse SQL Pool or SQL Database which is to back up, only applicable when `create_mode` is set to `Recovery`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input['SqlPoolRestoreArgs'] restore: A `restore` block as defined below. Only applicable when `create_mode` is set to `PointInTimeRestore`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Synapse SQL Pool.
        """
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        pulumi.set(__self__, "synapse_workspace_id", synapse_workspace_id)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if data_encrypted is not None:
            pulumi.set(__self__, "data_encrypted", data_encrypted)
        if geo_backup_policy_enabled is not None:
            pulumi.set(__self__, "geo_backup_policy_enabled", geo_backup_policy_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recovery_database_id is not None:
            pulumi.set(__self__, "recovery_database_id", recovery_database_id)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the SKU Name for this Synapse SQL Pool. Possible values are `DW100c`, `DW200c`, `DW300c`, `DW400c`, `DW500c`, `DW1000c`, `DW1500c`, `DW2000c`, `DW2500c`, `DW3000c`, `DW5000c`, `DW6000c`, `DW7500c`, `DW10000c`, `DW15000c` or `DW30000c`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> pulumi.Input[_builtins.str]:
        """
        The storage account type that will be used to store backups for this Synapse SQL Pool. Possible values are `LRS` or `GRS`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_type", value)

    @_builtins.property
    @pulumi.getter(name="synapseWorkspaceId")
    def synapse_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of Synapse Workspace within which this SQL Pool should be created. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "synapse_workspace_id")

    @synapse_workspace_id.setter
    def synapse_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "synapse_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the collation to use with this pool, only applicable when `create_mode` is set to `Default`. Azure default is `SQL_LATIN1_GENERAL_CP1_CI_AS`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collation", value)

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how to create the SQL Pool. Valid values are: `Default`, `Recovery` or `PointInTimeRestore`. Must be `Default` to create a new database. Defaults to `Default`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataEncrypted")
    def data_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is transparent data encryption enabled?
        """
        return pulumi.get(self, "data_encrypted")

    @data_encrypted.setter
    def data_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="geoBackupPolicyEnabled")
    def geo_backup_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is geo-backup policy enabled? Defaults to `true`.
        """
        return pulumi.get(self, "geo_backup_policy_enabled")

    @geo_backup_policy_enabled.setter
    def geo_backup_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "geo_backup_policy_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Synapse SQL Pool. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryDatabaseId")
    def recovery_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Synapse SQL Pool or SQL Database which is to back up, only applicable when `create_mode` is set to `Recovery`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "recovery_database_id")

    @recovery_database_id.setter
    def recovery_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_database_id", value)

    @_builtins.property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['SqlPoolRestoreArgs']]:
        """
        A `restore` block as defined below. Only applicable when `create_mode` is set to `PointInTimeRestore`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['SqlPoolRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Synapse SQL Pool.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SqlPoolState:
    def __init__(__self__, *,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 geo_backup_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input['SqlPoolRestoreArgs']] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 synapse_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SqlPool resources.
        :param pulumi.Input[_builtins.str] collation: The name of the collation to use with this pool, only applicable when `create_mode` is set to `Default`. Azure default is `SQL_LATIN1_GENERAL_CP1_CI_AS`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] create_mode: Specifies how to create the SQL Pool. Valid values are: `Default`, `Recovery` or `PointInTimeRestore`. Must be `Default` to create a new database. Defaults to `Default`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.bool] data_encrypted: Is transparent data encryption enabled?
        :param pulumi.Input[_builtins.bool] geo_backup_policy_enabled: Is geo-backup policy enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Synapse SQL Pool. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] recovery_database_id: The ID of the Synapse SQL Pool or SQL Database which is to back up, only applicable when `create_mode` is set to `Recovery`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input['SqlPoolRestoreArgs'] restore: A `restore` block as defined below. Only applicable when `create_mode` is set to `PointInTimeRestore`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Synapse SQL Pool. Possible values are `DW100c`, `DW200c`, `DW300c`, `DW400c`, `DW500c`, `DW1000c`, `DW1500c`, `DW2000c`, `DW2500c`, `DW3000c`, `DW5000c`, `DW6000c`, `DW7500c`, `DW10000c`, `DW15000c` or `DW30000c`.
        :param pulumi.Input[_builtins.str] storage_account_type: The storage account type that will be used to store backups for this Synapse SQL Pool. Possible values are `LRS` or `GRS`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] synapse_workspace_id: The ID of Synapse Workspace within which this SQL Pool should be created. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Synapse SQL Pool.
        """
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if data_encrypted is not None:
            pulumi.set(__self__, "data_encrypted", data_encrypted)
        if geo_backup_policy_enabled is not None:
            pulumi.set(__self__, "geo_backup_policy_enabled", geo_backup_policy_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recovery_database_id is not None:
            pulumi.set(__self__, "recovery_database_id", recovery_database_id)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if synapse_workspace_id is not None:
            pulumi.set(__self__, "synapse_workspace_id", synapse_workspace_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the collation to use with this pool, only applicable when `create_mode` is set to `Default`. Azure default is `SQL_LATIN1_GENERAL_CP1_CI_AS`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collation", value)

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how to create the SQL Pool. Valid values are: `Default`, `Recovery` or `PointInTimeRestore`. Must be `Default` to create a new database. Defaults to `Default`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataEncrypted")
    def data_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is transparent data encryption enabled?
        """
        return pulumi.get(self, "data_encrypted")

    @data_encrypted.setter
    def data_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="geoBackupPolicyEnabled")
    def geo_backup_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is geo-backup policy enabled? Defaults to `true`.
        """
        return pulumi.get(self, "geo_backup_policy_enabled")

    @geo_backup_policy_enabled.setter
    def geo_backup_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "geo_backup_policy_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Synapse SQL Pool. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryDatabaseId")
    def recovery_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Synapse SQL Pool or SQL Database which is to back up, only applicable when `create_mode` is set to `Recovery`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "recovery_database_id")

    @recovery_database_id.setter
    def recovery_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_database_id", value)

    @_builtins.property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['SqlPoolRestoreArgs']]:
        """
        A `restore` block as defined below. Only applicable when `create_mode` is set to `PointInTimeRestore`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['SqlPoolRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU Name for this Synapse SQL Pool. Possible values are `DW100c`, `DW200c`, `DW300c`, `DW400c`, `DW500c`, `DW1000c`, `DW1500c`, `DW2000c`, `DW2500c`, `DW3000c`, `DW5000c`, `DW6000c`, `DW7500c`, `DW10000c`, `DW15000c` or `DW30000c`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage account type that will be used to store backups for this Synapse SQL Pool. Possible values are `LRS` or `GRS`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_type", value)

    @_builtins.property
    @pulumi.getter(name="synapseWorkspaceId")
    def synapse_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Synapse Workspace within which this SQL Pool should be created. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "synapse_workspace_id")

    @synapse_workspace_id.setter
    def synapse_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "synapse_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Synapse SQL Pool.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:synapse/sqlPool:SqlPool")
class SqlPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 geo_backup_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input[Union['SqlPoolRestoreArgs', 'SqlPoolRestoreArgsDict']]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 synapse_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Synapse SQL Pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="BlobStorage")
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            })
        example_sql_pool = azure.synapse.SqlPool("example",
            name="examplesqlpool",
            synapse_workspace_id=example_workspace.id,
            sku_name="DW100c",
            create_mode="Default",
            storage_account_type="GRS")
        ```

        ## Import

        Synapse SQL Pool can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/sqlPool:SqlPool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1/sqlPools/sqlPool1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] collation: The name of the collation to use with this pool, only applicable when `create_mode` is set to `Default`. Azure default is `SQL_LATIN1_GENERAL_CP1_CI_AS`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] create_mode: Specifies how to create the SQL Pool. Valid values are: `Default`, `Recovery` or `PointInTimeRestore`. Must be `Default` to create a new database. Defaults to `Default`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.bool] data_encrypted: Is transparent data encryption enabled?
        :param pulumi.Input[_builtins.bool] geo_backup_policy_enabled: Is geo-backup policy enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Synapse SQL Pool. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] recovery_database_id: The ID of the Synapse SQL Pool or SQL Database which is to back up, only applicable when `create_mode` is set to `Recovery`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[Union['SqlPoolRestoreArgs', 'SqlPoolRestoreArgsDict']] restore: A `restore` block as defined below. Only applicable when `create_mode` is set to `PointInTimeRestore`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Synapse SQL Pool. Possible values are `DW100c`, `DW200c`, `DW300c`, `DW400c`, `DW500c`, `DW1000c`, `DW1500c`, `DW2000c`, `DW2500c`, `DW3000c`, `DW5000c`, `DW6000c`, `DW7500c`, `DW10000c`, `DW15000c` or `DW30000c`.
        :param pulumi.Input[_builtins.str] storage_account_type: The storage account type that will be used to store backups for this Synapse SQL Pool. Possible values are `LRS` or `GRS`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] synapse_workspace_id: The ID of Synapse Workspace within which this SQL Pool should be created. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Synapse SQL Pool.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Synapse SQL Pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageacc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="BlobStorage")
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            })
        example_sql_pool = azure.synapse.SqlPool("example",
            name="examplesqlpool",
            synapse_workspace_id=example_workspace.id,
            sku_name="DW100c",
            create_mode="Default",
            storage_account_type="GRS")
        ```

        ## Import

        Synapse SQL Pool can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/sqlPool:SqlPool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Synapse/workspaces/workspace1/sqlPools/sqlPool1
        ```

        :param str resource_name: The name of the resource.
        :param SqlPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 geo_backup_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input[Union['SqlPoolRestoreArgs', 'SqlPoolRestoreArgsDict']]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 synapse_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlPoolArgs.__new__(SqlPoolArgs)

            __props__.__dict__["collation"] = collation
            __props__.__dict__["create_mode"] = create_mode
            __props__.__dict__["data_encrypted"] = data_encrypted
            __props__.__dict__["geo_backup_policy_enabled"] = geo_backup_policy_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["recovery_database_id"] = recovery_database_id
            __props__.__dict__["restore"] = restore
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            if storage_account_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_type'")
            __props__.__dict__["storage_account_type"] = storage_account_type
            if synapse_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'synapse_workspace_id'")
            __props__.__dict__["synapse_workspace_id"] = synapse_workspace_id
            __props__.__dict__["tags"] = tags
        super(SqlPool, __self__).__init__(
            'azure:synapse/sqlPool:SqlPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            collation: Optional[pulumi.Input[_builtins.str]] = None,
            create_mode: Optional[pulumi.Input[_builtins.str]] = None,
            data_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            geo_backup_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            restore: Optional[pulumi.Input[Union['SqlPoolRestoreArgs', 'SqlPoolRestoreArgsDict']]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
            synapse_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'SqlPool':
        """
        Get an existing SqlPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] collation: The name of the collation to use with this pool, only applicable when `create_mode` is set to `Default`. Azure default is `SQL_LATIN1_GENERAL_CP1_CI_AS`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] create_mode: Specifies how to create the SQL Pool. Valid values are: `Default`, `Recovery` or `PointInTimeRestore`. Must be `Default` to create a new database. Defaults to `Default`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.bool] data_encrypted: Is transparent data encryption enabled?
        :param pulumi.Input[_builtins.bool] geo_backup_policy_enabled: Is geo-backup policy enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Synapse SQL Pool. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] recovery_database_id: The ID of the Synapse SQL Pool or SQL Database which is to back up, only applicable when `create_mode` is set to `Recovery`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[Union['SqlPoolRestoreArgs', 'SqlPoolRestoreArgsDict']] restore: A `restore` block as defined below. Only applicable when `create_mode` is set to `PointInTimeRestore`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Synapse SQL Pool. Possible values are `DW100c`, `DW200c`, `DW300c`, `DW400c`, `DW500c`, `DW1000c`, `DW1500c`, `DW2000c`, `DW2500c`, `DW3000c`, `DW5000c`, `DW6000c`, `DW7500c`, `DW10000c`, `DW15000c` or `DW30000c`.
        :param pulumi.Input[_builtins.str] storage_account_type: The storage account type that will be used to store backups for this Synapse SQL Pool. Possible values are `LRS` or `GRS`. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[_builtins.str] synapse_workspace_id: The ID of Synapse Workspace within which this SQL Pool should be created. Changing this forces a new Synapse SQL Pool to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Synapse SQL Pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlPoolState.__new__(_SqlPoolState)

        __props__.__dict__["collation"] = collation
        __props__.__dict__["create_mode"] = create_mode
        __props__.__dict__["data_encrypted"] = data_encrypted
        __props__.__dict__["geo_backup_policy_enabled"] = geo_backup_policy_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["recovery_database_id"] = recovery_database_id
        __props__.__dict__["restore"] = restore
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["storage_account_type"] = storage_account_type
        __props__.__dict__["synapse_workspace_id"] = synapse_workspace_id
        __props__.__dict__["tags"] = tags
        return SqlPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the collation to use with this pool, only applicable when `create_mode` is set to `Default`. Azure default is `SQL_LATIN1_GENERAL_CP1_CI_AS`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "collation")

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies how to create the SQL Pool. Valid values are: `Default`, `Recovery` or `PointInTimeRestore`. Must be `Default` to create a new database. Defaults to `Default`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "create_mode")

    @_builtins.property
    @pulumi.getter(name="dataEncrypted")
    def data_encrypted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is transparent data encryption enabled?
        """
        return pulumi.get(self, "data_encrypted")

    @_builtins.property
    @pulumi.getter(name="geoBackupPolicyEnabled")
    def geo_backup_policy_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is geo-backup policy enabled? Defaults to `true`.
        """
        return pulumi.get(self, "geo_backup_policy_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Synapse SQL Pool. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recoveryDatabaseId")
    def recovery_database_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Synapse SQL Pool or SQL Database which is to back up, only applicable when `create_mode` is set to `Recovery`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "recovery_database_id")

    @_builtins.property
    @pulumi.getter
    def restore(self) -> pulumi.Output[Optional['outputs.SqlPoolRestore']]:
        """
        A `restore` block as defined below. Only applicable when `create_mode` is set to `PointInTimeRestore`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "restore")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SKU Name for this Synapse SQL Pool. Possible values are `DW100c`, `DW200c`, `DW300c`, `DW400c`, `DW500c`, `DW1000c`, `DW1500c`, `DW2000c`, `DW2500c`, `DW3000c`, `DW5000c`, `DW6000c`, `DW7500c`, `DW10000c`, `DW15000c` or `DW30000c`.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> pulumi.Output[_builtins.str]:
        """
        The storage account type that will be used to store backups for this Synapse SQL Pool. Possible values are `LRS` or `GRS`. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter(name="synapseWorkspaceId")
    def synapse_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of Synapse Workspace within which this SQL Pool should be created. Changing this forces a new Synapse SQL Pool to be created.
        """
        return pulumi.get(self, "synapse_workspace_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Synapse SQL Pool.
        """
        return pulumi.get(self, "tags")

