# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SqlPoolWorkloadClassifierArgs', 'SqlPoolWorkloadClassifier']

@pulumi.input_type
class SqlPoolWorkloadClassifierArgs:
    def __init__(__self__, *,
                 member_name: pulumi.Input[_builtins.str],
                 workload_group_id: pulumi.Input[_builtins.str],
                 context: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 importance: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SqlPoolWorkloadClassifier resource.
        :param pulumi.Input[_builtins.str] member_name: The workload classifier member name used to classified against.
        :param pulumi.Input[_builtins.str] workload_group_id: The ID of the Synapse SQL Pool Workload Group. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        :param pulumi.Input[_builtins.str] context: Specifies the session context value that a request can be classified against.
        :param pulumi.Input[_builtins.str] end_time: The workload classifier end time for classification. It's of the `HH:MM` format in UTC time zone.
        :param pulumi.Input[_builtins.str] importance: The workload classifier importance. The allowed values are `low`, `below_normal`, `normal`, `above_normal` and `high`.
        :param pulumi.Input[_builtins.str] label: Specifies the label value that a request can be classified against.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Synapse SQL Pool Workload Classifier. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        :param pulumi.Input[_builtins.str] start_time: The workload classifier start time for classification. It's of the `HH:MM` format in UTC time zone.
        """
        pulumi.set(__self__, "member_name", member_name)
        pulumi.set(__self__, "workload_group_id", workload_group_id)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if importance is not None:
            pulumi.set(__self__, "importance", importance)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="memberName")
    def member_name(self) -> pulumi.Input[_builtins.str]:
        """
        The workload classifier member name used to classified against.
        """
        return pulumi.get(self, "member_name")

    @member_name.setter
    def member_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "member_name", value)

    @_builtins.property
    @pulumi.getter(name="workloadGroupId")
    def workload_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Synapse SQL Pool Workload Group. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        """
        return pulumi.get(self, "workload_group_id")

    @workload_group_id.setter
    def workload_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workload_group_id", value)

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the session context value that a request can be classified against.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "context", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workload classifier end time for classification. It's of the `HH:MM` format in UTC time zone.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter
    def importance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workload classifier importance. The allowed values are `low`, `below_normal`, `normal`, `above_normal` and `high`.
        """
        return pulumi.get(self, "importance")

    @importance.setter
    def importance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "importance", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the label value that a request can be classified against.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Synapse SQL Pool Workload Classifier. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workload classifier start time for classification. It's of the `HH:MM` format in UTC time zone.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class _SqlPoolWorkloadClassifierState:
    def __init__(__self__, *,
                 context: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 importance: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 member_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlPoolWorkloadClassifier resources.
        :param pulumi.Input[_builtins.str] context: Specifies the session context value that a request can be classified against.
        :param pulumi.Input[_builtins.str] end_time: The workload classifier end time for classification. It's of the `HH:MM` format in UTC time zone.
        :param pulumi.Input[_builtins.str] importance: The workload classifier importance. The allowed values are `low`, `below_normal`, `normal`, `above_normal` and `high`.
        :param pulumi.Input[_builtins.str] label: Specifies the label value that a request can be classified against.
        :param pulumi.Input[_builtins.str] member_name: The workload classifier member name used to classified against.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Synapse SQL Pool Workload Classifier. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        :param pulumi.Input[_builtins.str] start_time: The workload classifier start time for classification. It's of the `HH:MM` format in UTC time zone.
        :param pulumi.Input[_builtins.str] workload_group_id: The ID of the Synapse SQL Pool Workload Group. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        """
        if context is not None:
            pulumi.set(__self__, "context", context)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if importance is not None:
            pulumi.set(__self__, "importance", importance)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if member_name is not None:
            pulumi.set(__self__, "member_name", member_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if workload_group_id is not None:
            pulumi.set(__self__, "workload_group_id", workload_group_id)

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the session context value that a request can be classified against.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "context", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workload classifier end time for classification. It's of the `HH:MM` format in UTC time zone.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter
    def importance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workload classifier importance. The allowed values are `low`, `below_normal`, `normal`, `above_normal` and `high`.
        """
        return pulumi.get(self, "importance")

    @importance.setter
    def importance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "importance", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the label value that a request can be classified against.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="memberName")
    def member_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workload classifier member name used to classified against.
        """
        return pulumi.get(self, "member_name")

    @member_name.setter
    def member_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Synapse SQL Pool Workload Classifier. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workload classifier start time for classification. It's of the `HH:MM` format in UTC time zone.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter(name="workloadGroupId")
    def workload_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Synapse SQL Pool Workload Group. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        """
        return pulumi.get(self, "workload_group_id")

    @workload_group_id.setter
    def workload_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_group_id", value)


@pulumi.type_token("azure:synapse/sqlPoolWorkloadClassifier:SqlPoolWorkloadClassifier")
class SqlPoolWorkloadClassifier(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 context: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 importance: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 member_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Synapse SQL Pool Workload Classifier.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_kind="BlobStorage",
            account_tier="Standard",
            account_replication_type="LRS")
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            })
        example_sql_pool = azure.synapse.SqlPool("example",
            name="example",
            synapse_workspace_id=example_workspace.id,
            sku_name="DW100c",
            create_mode="Default")
        example_sql_pool_workload_group = azure.synapse.SqlPoolWorkloadGroup("example",
            name="example",
            sql_pool_id=example_sql_pool.id,
            importance="normal",
            max_resource_percent=100,
            min_resource_percent=0,
            max_resource_percent_per_request=3,
            min_resource_percent_per_request=3,
            query_execution_timeout_in_seconds=0)
        example_sql_pool_workload_classifier = azure.synapse.SqlPoolWorkloadClassifier("example",
            name="example",
            workload_group_id=example_sql_pool_workload_group.id,
            context="example_context",
            end_time="14:00",
            importance="high",
            label="example_label",
            member_name="dbo",
            start_time="12:00")
        ```

        ## Import

        Synapse SQL Pool Workload Classifiers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/sqlPoolWorkloadClassifier:SqlPoolWorkloadClassifier example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Synapse/workspaces/workspace1/sqlPools/sqlPool1/workloadGroups/workloadGroup1/workloadClassifiers/workloadClassifier1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] context: Specifies the session context value that a request can be classified against.
        :param pulumi.Input[_builtins.str] end_time: The workload classifier end time for classification. It's of the `HH:MM` format in UTC time zone.
        :param pulumi.Input[_builtins.str] importance: The workload classifier importance. The allowed values are `low`, `below_normal`, `normal`, `above_normal` and `high`.
        :param pulumi.Input[_builtins.str] label: Specifies the label value that a request can be classified against.
        :param pulumi.Input[_builtins.str] member_name: The workload classifier member name used to classified against.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Synapse SQL Pool Workload Classifier. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        :param pulumi.Input[_builtins.str] start_time: The workload classifier start time for classification. It's of the `HH:MM` format in UTC time zone.
        :param pulumi.Input[_builtins.str] workload_group_id: The ID of the Synapse SQL Pool Workload Group. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlPoolWorkloadClassifierArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Synapse SQL Pool Workload Classifier.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_kind="BlobStorage",
            account_tier="Standard",
            account_replication_type="LRS")
        example_data_lake_gen2_filesystem = azure.storage.DataLakeGen2Filesystem("example",
            name="example",
            storage_account_id=example_account.id)
        example_workspace = azure.synapse.Workspace("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            storage_data_lake_gen2_filesystem_id=example_data_lake_gen2_filesystem.id,
            sql_administrator_login="sqladminuser",
            sql_administrator_login_password="H@Sh1CoR3!",
            identity={
                "type": "SystemAssigned",
            })
        example_sql_pool = azure.synapse.SqlPool("example",
            name="example",
            synapse_workspace_id=example_workspace.id,
            sku_name="DW100c",
            create_mode="Default")
        example_sql_pool_workload_group = azure.synapse.SqlPoolWorkloadGroup("example",
            name="example",
            sql_pool_id=example_sql_pool.id,
            importance="normal",
            max_resource_percent=100,
            min_resource_percent=0,
            max_resource_percent_per_request=3,
            min_resource_percent_per_request=3,
            query_execution_timeout_in_seconds=0)
        example_sql_pool_workload_classifier = azure.synapse.SqlPoolWorkloadClassifier("example",
            name="example",
            workload_group_id=example_sql_pool_workload_group.id,
            context="example_context",
            end_time="14:00",
            importance="high",
            label="example_label",
            member_name="dbo",
            start_time="12:00")
        ```

        ## Import

        Synapse SQL Pool Workload Classifiers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:synapse/sqlPoolWorkloadClassifier:SqlPoolWorkloadClassifier example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Synapse/workspaces/workspace1/sqlPools/sqlPool1/workloadGroups/workloadGroup1/workloadClassifiers/workloadClassifier1
        ```

        :param str resource_name: The name of the resource.
        :param SqlPoolWorkloadClassifierArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlPoolWorkloadClassifierArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 context: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 importance: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 member_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlPoolWorkloadClassifierArgs.__new__(SqlPoolWorkloadClassifierArgs)

            __props__.__dict__["context"] = context
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["importance"] = importance
            __props__.__dict__["label"] = label
            if member_name is None and not opts.urn:
                raise TypeError("Missing required property 'member_name'")
            __props__.__dict__["member_name"] = member_name
            __props__.__dict__["name"] = name
            __props__.__dict__["start_time"] = start_time
            if workload_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'workload_group_id'")
            __props__.__dict__["workload_group_id"] = workload_group_id
        super(SqlPoolWorkloadClassifier, __self__).__init__(
            'azure:synapse/sqlPoolWorkloadClassifier:SqlPoolWorkloadClassifier',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            context: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            importance: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            member_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            workload_group_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SqlPoolWorkloadClassifier':
        """
        Get an existing SqlPoolWorkloadClassifier resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] context: Specifies the session context value that a request can be classified against.
        :param pulumi.Input[_builtins.str] end_time: The workload classifier end time for classification. It's of the `HH:MM` format in UTC time zone.
        :param pulumi.Input[_builtins.str] importance: The workload classifier importance. The allowed values are `low`, `below_normal`, `normal`, `above_normal` and `high`.
        :param pulumi.Input[_builtins.str] label: Specifies the label value that a request can be classified against.
        :param pulumi.Input[_builtins.str] member_name: The workload classifier member name used to classified against.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Synapse SQL Pool Workload Classifier. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        :param pulumi.Input[_builtins.str] start_time: The workload classifier start time for classification. It's of the `HH:MM` format in UTC time zone.
        :param pulumi.Input[_builtins.str] workload_group_id: The ID of the Synapse SQL Pool Workload Group. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlPoolWorkloadClassifierState.__new__(_SqlPoolWorkloadClassifierState)

        __props__.__dict__["context"] = context
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["importance"] = importance
        __props__.__dict__["label"] = label
        __props__.__dict__["member_name"] = member_name
        __props__.__dict__["name"] = name
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["workload_group_id"] = workload_group_id
        return SqlPoolWorkloadClassifier(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def context(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the session context value that a request can be classified against.
        """
        return pulumi.get(self, "context")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The workload classifier end time for classification. It's of the `HH:MM` format in UTC time zone.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def importance(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The workload classifier importance. The allowed values are `low`, `below_normal`, `normal`, `above_normal` and `high`.
        """
        return pulumi.get(self, "importance")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the label value that a request can be classified against.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="memberName")
    def member_name(self) -> pulumi.Output[_builtins.str]:
        """
        The workload classifier member name used to classified against.
        """
        return pulumi.get(self, "member_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Synapse SQL Pool Workload Classifier. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The workload classifier start time for classification. It's of the `HH:MM` format in UTC time zone.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="workloadGroupId")
    def workload_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Synapse SQL Pool Workload Group. Changing this forces a new Synapse SQL Pool Workload Classifier to be created.
        """
        return pulumi.get(self, "workload_group_id")

