# generated by datamodel-codegen:
#   filename:  event-feed-array.json
#   timestamp: 2025-09-19T00:22:22+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field, RootModel, confloat, conint, constr


class Endpointssingularcontest(Enum):
    contest = "contest"
    judgement_types = "judgement-types"
    languages = "languages"
    problems = "problems"
    groups = "groups"
    organizations = "organizations"
    persons = "persons"
    accounts = "accounts"
    teams = "teams"
    state = "state"
    submissions = "submissions"
    judgements = "judgements"
    runs = "runs"
    clarifications = "clarifications"
    awards = "awards"
    commentary = "commentary"
    scoreboard = "scoreboard"
    event_feed = "event-feed"


class Identifier(RootModel[constr(pattern=r"^[A-Za-z0-9_]([A-Za-z0-9_\.-]{0,34}[A-Za-z0-9_-]|)")]):
    root: constr(pattern=r"^[A-Za-z0-9_]([A-Za-z0-9_\.-]{0,34}[A-Za-z0-9_-]|)")


class ScoreboardType(Enum):
    pass_fail = "pass-fail"
    score = "score"


class Abstime(
    RootModel[
        constr(
            pattern=r"^[12][0-9]{3}-[01][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9](\.[0-9]{3})?([+-][0-1][0-9](:[0-5][0-9])?|Z)$"
        )
    ]
):
    root: constr(
        pattern=r"^[12][0-9]{3}-[01][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9](\.[0-9]{3})?([+-][0-1][0-9](:[0-5][0-9])?|Z)$"
    )


class Posreltime(RootModel[constr(pattern=r"^([1-9][0-9]*)?[0-9]:[0-5][0-9]:[0-5][0-9](\.[0-9]{3})?$")]):
    root: constr(pattern=r"^([1-9][0-9]*)?[0-9]:[0-5][0-9]:[0-5][0-9](\.[0-9]{3})?$")


class Mime(Enum):
    image_png = "image/png"
    image_jpeg = "image/jpeg"
    image_svg_xml = "image/svg+xml"


class Fileref(BaseModel):
    href: str
    filename: Optional[str] = None
    hash: Optional[str] = None
    mime: str
    width: Optional[conint(ge=1)] = None
    height: Optional[conint(ge=1)] = None


class Location(BaseModel):
    latitude: confloat(ge=-90.0, le=90.0)
    longitude: confloat(ge=-180.0, le=180.0)


class Judgementtypeid(Enum):
    AC = "AC"
    RE = "RE"
    WA = "WA"
    TLE = "TLE"
    RTE = "RTE"
    CE = "CE"
    APE = "APE"
    OLE = "OLE"
    PE = "PE"
    EO = "EO"
    IO = "IO"
    NO = "NO"
    WTL = "WTL"
    ILE = "ILE"
    TCO = "TCO"
    TWA = "TWA"
    TPE = "TPE"
    TEO = "TEO"
    TIO = "TIO"
    TNO = "TNO"
    MLE = "MLE"
    SV = "SV"
    IF = "IF"
    RCO = "RCO"
    RWA = "RWA"
    RPE = "RPE"
    REO = "REO"
    RIO = "RIO"
    RNO = "RNO"
    CTL = "CTL"
    JE = "JE"
    SE = "SE"
    CS = "CS"


class Command(BaseModel):
    command: str
    args: Optional[str] = None
    version: Optional[str] = None
    version_command: Optional[str] = None


class Filerefsornull(RootModel[Optional[List[Fileref]]]):
    root: Optional[List[Fileref]]


class Location1(BaseModel):
    x: float
    y: float
    rotation: confloat(ge=0.0, le=360.0)


class Identifiers(RootModel[List[Identifier]]):
    root: List[Identifier]


class Sex(Enum):
    male = "male"
    female = "female"


class Role(Enum):
    contestant = "contestant"
    coach = "coach"
    staff = "staff"
    other = "other"


class Type(Enum):
    team = "team"
    judge = "judge"
    admin = "admin"
    analyst = "analyst"
    staff = "staff"


class Reltime(RootModel[constr(pattern=r"^-?([1-9][0-9]*)?[0-9]:[0-5][0-9]:[0-5][0-9](\.[0-9]{3})?$")]):
    root: constr(pattern=r"^-?([1-9][0-9]*)?[0-9]:[0-5][0-9]:[0-5][0-9](\.[0-9]{3})?$")


class Filerefs(RootModel[List[Fileref]]):
    root: List[Fileref]


class Judgementtypeidornull(RootModel[Optional[Judgementtypeid]]):
    root: Optional[Judgementtypeid]


class Reltimeornull(RootModel[Optional[Reltime]]):
    root: Optional[Reltime]


class Run(BaseModel):
    id: Identifier
    judgement_id: Identifier
    ordinal: int
    judgement_type_id: Judgementtypeid
    time: Abstime
    contest_time: Reltime
    run_time: Optional[confloat(ge=0.0, multiple_of=0.001)] = None


class Runs(RootModel[List[Run]]):
    root: List[Run] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: runs",
    )


class Identifierornull(RootModel[Optional[Identifier]]):
    root: Optional[Identifier]


class Abstimeornull(RootModel[Optional[Abstime]]):
    root: Optional[Abstime]


class Posreltimeornull(RootModel[Optional[Posreltime]]):
    root: Optional[Posreltime]


class Imageref(Fileref):
    mime: Optional[Mime] = None


class Locationornull(RootModel[Optional[Location]]):
    root: Optional[Location]


class JudgementType(BaseModel):
    id: Judgementtypeid
    name: str
    penalty: Optional[bool] = None
    solved: bool


class JudgementTypes(RootModel[List[JudgementType]]):
    root: List[JudgementType] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: judgement_types",
    )


class Commandornull(RootModel[Optional[Command]]):
    root: Optional[Command]


class Problem(BaseModel):
    id: Identifier
    uuid: Optional[constr(pattern=r"^[A-Fa-f0-9]{8}-([A-Fa-f0-9]{4}-){3}[A-Fa-f0-9]{12}$")] = None
    label: str
    name: str
    ordinal: int
    rgb: Optional[constr(pattern=r"^#[A-Fa-f0-9]{3}([A-Fa-f0-9]{3})?$")] = None
    color: Optional[str] = None
    time_limit: Optional[confloat(ge=0.0, multiple_of=0.001)] = None
    test_data_count: conint(ge=0)
    max_score: Optional[float] = None
    package: Optional[Filerefsornull] = None
    statement: Optional[Filerefsornull] = None


class Problems(RootModel[List[Problem]]):
    root: List[Problem] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: problems",
    )


class Group(BaseModel):
    id: Identifier
    icpc_id: Optional[str] = None
    name: str
    type: Optional[str] = None
    location: Optional[Locationornull] = None


class Groups(RootModel[List[Group]]):
    root: List[Group] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: groups",
    )


class Identifiersornull(RootModel[Optional[Identifiers]]):
    root: Optional[Identifiers]


class Account(BaseModel):
    id: Identifier
    username: str
    password: Optional[str] = None
    name: Optional[str] = None
    type: Optional[Type] = None
    ip: Optional[str] = None
    team_id: Optional[Identifierornull] = None
    person_id: Optional[Identifierornull] = None


class Accounts(RootModel[List[Account]]):
    root: List[Account] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: accounts",
    )


class State(BaseModel):
    started: Abstimeornull
    frozen: Optional[Abstimeornull] = None
    ended: Abstimeornull
    thawed: Optional[Abstimeornull] = None
    finalized: Abstimeornull
    end_of_updates: Abstimeornull


class Submission1(BaseModel):
    id: Identifier
    language_id: Identifier
    problem_id: Identifier
    team_id: Identifier
    time: Abstime
    contest_time: Reltime
    entry_point: Optional[str] = None
    files: Filerefs
    reaction: Optional[Filerefsornull] = None


class Submission2(BaseModel):
    id: Identifier
    language_id: Identifier
    problem_id: Identifier
    team_id: Identifier
    time: Abstime
    contest_time: Reltime
    entry_point: Optional[str] = None
    files: Filerefs
    reaction: Optional[Filerefsornull] = None


class Submission3(BaseModel):
    id: Identifier
    language_id: Identifier
    problem_id: Identifier
    team_id: Identifier
    time: Abstime
    contest_time: Reltime
    entry_point: None = None
    files: Filerefs
    reaction: Optional[Filerefsornull] = None


class Submission4(BaseModel):
    id: Identifier
    language_id: Identifier
    problem_id: Identifier
    team_id: Identifier
    time: Abstime
    contest_time: Reltime
    entry_point: Optional[str] = None
    files: Filerefs
    reaction: Optional[Filerefsornull] = None


class Submission(RootModel[Union[Submission1, Union[Submission2, Submission3], Submission4]]):
    root: Union[Submission1, Union[Submission2, Submission3], Submission4] = Field(
        ...,
        description="Definition of a single submission object",
        title="CLICS Contest API - submission",
    )


class Submissions(RootModel[List[Submission]]):
    root: List[Submission] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: submissions",
    )


class Judgement1(BaseModel):
    id: Identifier
    submission_id: Identifier
    judgement_type_id: Judgementtypeidornull
    score: Optional[confloat(ge=0.0)] = None
    start_time: Abstime
    start_contest_time: Reltime
    end_time: Abstimeornull
    end_contest_time: Reltimeornull
    max_run_time: Optional[confloat(ge=0.0, multiple_of=0.001)] = None


class Judgement2(BaseModel):
    id: Identifier
    submission_id: Identifier
    judgement_type_id: Optional[Judgementtypeidornull] = None
    score: Optional[confloat(ge=0.0)] = None
    start_time: Abstime
    start_contest_time: Reltime
    end_time: Optional[Abstimeornull] = None
    end_contest_time: Optional[Reltimeornull] = None
    max_run_time: Optional[confloat(ge=0.0, multiple_of=0.001)] = None


class Judgement(RootModel[Union[Judgement1, Judgement2]]):
    root: Union[Judgement1, Judgement2] = Field(
        ...,
        description="Definition of a single judgement object",
        title="CLICS Contest API - judgement",
    )


class Judgements(RootModel[List[Judgement]]):
    root: List[Judgement] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: judgements",
    )


class Clarification(BaseModel):
    id: Identifier
    from_team_id: Optional[Identifierornull] = None
    to_team_id: Optional[Identifierornull] = None
    reply_to_id: Optional[Identifierornull] = None
    problem_id: Optional[Identifierornull] = None
    text: str
    time: Abstime
    contest_time: Reltime


class Clarifications(RootModel[List[Clarification]]):
    root: List[Clarification] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: clarifications",
    )


class Award(BaseModel):
    id: Identifier
    citation: str
    team_ids: Optional[Identifiersornull] = None


class Awards(RootModel[List[Award]]):
    root: List[Award] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: awards",
    )


class Commentary(BaseModel):
    id: Identifier
    time: Abstime
    contest_time: Reltime
    message: str
    tags: List[str]
    source_id: Optional[Identifierornull] = None
    team_ids: Optional[Identifiersornull] = None
    problem_ids: Optional[Identifiersornull] = None
    submission_ids: Optional[Identifiersornull] = None


class Commentaries(RootModel[List[Commentary]]):
    root: List[Commentary] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: commentary",
    )


class Imagerefsornull(RootModel[Optional[List[Imageref]]]):
    root: Optional[List[Imageref]]


class Language(BaseModel):
    id: Identifier
    name: str
    entry_point_required: bool
    entry_point_name: Optional[str] = None
    extensions: List[str]
    compiler: Optional[Commandornull] = None
    runner: Optional[Commandornull] = None


class Languages(RootModel[List[Language]]):
    root: List[Language] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: languages",
    )


class Organization(BaseModel):
    id: Identifier
    icpc_id: Optional[str] = None
    name: str
    formal_name: Optional[str] = None
    country: Optional[constr(pattern=r"^[A-Z]{3}$")] = None
    country_flag: Optional[Imagerefsornull] = None
    url: Optional[str] = None
    twitter_hashtag: Optional[str] = None
    twitter_account: Optional[str] = None
    location: Optional[Locationornull] = None
    logo: Optional[Imagerefsornull] = None


class Organizations(RootModel[List[Organization]]):
    root: List[Organization] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: organizations",
    )


class Team(BaseModel):
    id: Identifier
    icpc_id: Optional[str] = None
    name: str
    label: str
    display_name: Optional[str] = None
    organization_id: Optional[Identifierornull] = None
    group_ids: Optional[Identifiersornull] = None
    hidden: Optional[bool] = None
    location: Optional[Location1] = None
    photo: Optional[Imagerefsornull] = None
    video: Optional[Filerefsornull] = None
    backup: Optional[Filerefsornull] = None
    key_log: Optional[Filerefsornull] = None
    tool_data: Optional[Filerefsornull] = None
    desktop: Optional[Filerefsornull] = None
    webcam: Optional[Filerefsornull] = None
    audio: Optional[Filerefsornull] = None


class Teams(RootModel[List[Team]]):
    root: List[Team] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: teams",
    )


class Person(BaseModel):
    id: Identifier
    icpc_id: Optional[str] = None
    team_ids: Optional[Identifiers] = None
    name: str
    title: Optional[str] = None
    email: Optional[str] = None
    sex: Optional[Sex] = None
    role: Role
    photo: Optional[Imagerefsornull] = None


class Persons(RootModel[List[Person]]):
    root: List[Person] = Field(
        ...,
        description="JSON response of this API call",
        title="CLICS Contest API: persons",
    )


class Contest(BaseModel):
    id: Identifier
    name: str
    formal_name: Optional[str] = None
    start_time: Optional[Abstimeornull] = None
    countdown_pause_time: Optional[Posreltimeornull] = None
    duration: Posreltime
    scoreboard_freeze_duration: Optional[Posreltimeornull] = None
    scoreboard_type: ScoreboardType
    penalty_time: Optional[conint(ge=0)] = None
    banner: Optional[Imagerefsornull] = None
    logo: Optional[Imagerefsornull] = None
    location: Optional[Locationornull] = None


class EventFeed(BaseModel):
    type: Endpointssingularcontest
    id: Identifierornull
    data: Optional[
        Union[
            Contest,
            JudgementType,
            JudgementTypes,
            Language,
            Languages,
            Problem,
            Problems,
            Group,
            Groups,
            Organization,
            Organizations,
            Team,
            Teams,
            Person,
            Persons,
            Account,
            Accounts,
            State,
            Submission,
            Submissions,
            Judgement,
            Judgements,
            Run,
            Runs,
            Clarification,
            Clarifications,
            Award,
            Awards,
            Commentary,
            Commentaries,
        ]
    ] = None
    token: Optional[str] = None


class ClicsContestApiEventFeedArray(RootModel[List[EventFeed]]):
    root: List[EventFeed] = Field(
        ...,
        description="JSON array of responses of this NDJSON API call",
        title="CLICS Contest API: event-feed array",
    )
