---
hide:
    - navigation
    - toc
---
#
<div align='center'>
<img src="https://raw.githubusercontent.com/EuroEval/EuroEval/main/gfx/euroeval.png" height="500" width="372">
<h3>The robust European language model benchmark.</h3>
</div>

--------------------------

EuroEval is a language model benchmarking framework that supports evaluating all types
of language models out there: encoders, decoders, encoder-decoders, base models, and
instruction tuned models. EuroEval has been battle-tested for more than three years and
are the standard evaluation benchmark for many companies, universities and organisations
around Europe.

Check out the [leaderboards](/leaderboards) to see how different language models perform
on a wide range of tasks in various European languages. The leaderboards are updated
regularly with new models and new results. All benchmark results have been computed
using the associated [EuroEval Python package](/python-package), which you can use to
replicate all the results. It supports all models on the [Hugging Face
Hub](https://huggingface.co/models), as well as models accessible through 100+ different
APIs, including models you are hosting yourself via, e.g., [Ollama](https://ollama.com/)
or [LM Studio](https://lmstudio.ai/).

The idea of EuroEval grew out of the development of Danish language model RøBÆRTa in
2021, when we realised that there was no standard way to evaluate Danish language
models. It started as a hobby project including Danish, Swedish and Norwegian, but has
since grown to include 12+ European languages.

EuroEval is maintained by [Dan Saattrup Smart](https://www.saattrupdan.com/) from the
[Alexandra Institute](https://alexandra.dk), and is funded by the EU project
[TrustLLM](https://trustllm.eu/).
