# Copyright 2021 DeepMind Technologies Limited
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from absl.testing import absltest
from alphafold.model import prng
import jax


class PrngTest(absltest.TestCase):

  def test_key_reuse(self):

    init_key = jax.random.PRNGKey(42)
    safe_key = prng.SafeKey(init_key)
    _, safe_key = safe_key.split()

    raw_key = safe_key.get()

    self.assertFalse((raw_key == init_key).all())

    with self.assertRaises(RuntimeError):
      safe_key.get()

    with self.assertRaises(RuntimeError):
      safe_key.split()

    with self.assertRaises(RuntimeError):
      safe_key.duplicate()


if __name__ == '__main__':
  absltest.main()
