from evenage.core.system_tools import create_system_tools
from evenage.core.tooling import ToolRegistry, Tool


def test_system_tools_are_registered_with_explicit_names():
    # create tools dict (names -> callables)
    tools_map = create_system_tools(message_bus=None, storage_backend=None)

    # Simulate runtime registration using explicit names
    registry = ToolRegistry()
    for name, func in tools_map.items():
        desc = (func.__doc__ or "").strip().split("\n")[0]
        registry.register(Tool(name=name, func=func, description=desc))

    # Both prefixed and alias names should be present
    assert registry.has("system_split_document")
    assert registry.has("split_document")
    assert registry.has("system_delegate_parallel")
    assert registry.has("delegate_parallel")
