from pathlib import Path
from datetime import datetime
def create_crud_file(name: str):
    from pathlib import Path

    db_name = name.lower()
    schema_path = Path.cwd() / "schemas" / f"{db_name}.py"
    repo_path = Path.cwd() / "repositories" / f"{db_name}.py"

    if not schema_path.exists():
        print(f"❌ Schema file {schema_path} not found.")
        return

    class_name = "".join([part.capitalize() for part in db_name.split("_")]) + "Base"
    update_class_name = "".join([part.capitalize() for part in db_name.split("_")]) + "Update"
    create_class_name = "".join([part.capitalize() for part in db_name.split("_")]) + "Create"
    out_class_name = "".join([part.capitalize() for part in db_name.split("_")]) + "Out"

    crud_code = f'''
    
# ============================================================================
# {db_name.upper()} REPOSITORY
# ============================================================================
# This file was auto-generated on: {datetime.now().strftime('%Y-%m-%d %H:%M:%S WAT')}
# It contains asynchronous functions for managing access to the database
# in a MongoDB database using FastAPI.
#
# DO NOT EDIT THIS FILE MANUALLY - RE-RUN THE GENERATOR INSTEAD. OR IF YOU WANT TO EDIT JUST ADD LEAVE OTHER FUNCTIONS THE WAY YOU MET THEM
# ============================================================================

from pymongo import ReturnDocument
from core.database import db
from fastapi import HTTPException,status
from typing import List,Optional
from schemas.{db_name} import {update_class_name}, {create_class_name}, {out_class_name}

async def create_{db_name}({db_name}_data: {create_class_name}) -> {out_class_name}:
    {db_name}_dict = {db_name}_data.model_dump()
    result =await db.{db_name}s.insert_one({db_name}_dict)
    result = await db.{db_name}s.find_one(filter={{"_id":result.inserted_id}})
    returnable_result = {out_class_name}(**result)
    return returnable_result

async def get_{db_name}(filter_dict: dict) -> Optional[{out_class_name}]:
    try:
        result = await db.{db_name}s.find_one(filter_dict)

        if result is None:
            return None

        return {out_class_name}(**result)

    except Exception as e:
        raise HTTPException(
            status_code=status.HTTP_500_INTERNAL_SERVER_ERROR,
            detail=f"An error occurred while fetching {db_name}: {{str(e)}}"
        )
    
async def get_{db_name}s(filter_dict: dict = {{}}) -> List[{out_class_name}]:
    try:
        if filter_dict is None:
            filter_dict = {{}}

        cursor = db.{db_name}s.find(filter_dict)
        {db_name}_list = []

        async for doc in cursor:
            {db_name}_list.append({out_class_name}(**doc))

        return {db_name}_list

    except Exception as e:
        raise HTTPException(
            status_code=status.HTTP_500_INTERNAL_SERVER_ERROR,
            detail=f"An error occurred while fetching {db_name}s: {{str(e)}}"
        )
async def update_{db_name}(filter_dict: dict, {db_name}_data: {update_class_name}) -> {out_class_name}:
    result = await db.{db_name}s.find_one_and_update(
        filter_dict,
        {{"$set": {db_name}_data.model_dump()}},
        return_document=ReturnDocument.AFTER
    )
    returnable_result = {out_class_name}(**result)
    return returnable_result

async def delete_{db_name}(filter_dict: dict):
    return await db.{db_name}s.delete_one(filter_dict)
'''.strip()

    with open(repo_path, "w") as f:
        f.write(crud_code)

    print(f"✅ CRUD for '{db_name}' created in repository/{db_name}.py")
